/*
 * Decompiled with CFR 0.152.
 */
package cortana.core;

import cortana.core.Commands;
import cortana.core.EventManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class CommandManager {
    protected Map commands = new HashMap();

    protected SleepClosure getCommand(String name) {
        if (this.commands.containsKey(name)) {
            SleepClosure temp = (SleepClosure)this.commands.get(name);
            if (temp.getOwner().isLoaded()) {
                return temp;
            }
            this.commands.remove(name);
        }
        return null;
    }

    public List commandList(String filter) {
        Iterator i = this.commands.entrySet().iterator();
        LinkedList<String> res = new LinkedList<String>();
        while (i.hasNext()) {
            Map.Entry temp = i.next();
            String command = temp.getKey() + "";
            SleepClosure f = (SleepClosure)temp.getValue();
            if (filter != null && !command.startsWith(filter)) continue;
            if (f.getOwner().isLoaded()) {
                res.add(command);
                continue;
            }
            i.remove();
        }
        return res;
    }

    public Loadable getBridge() {
        return new Commands(this);
    }

    public void registerCommand(String command, SleepClosure c) {
        this.commands.put(command, c);
    }

    public boolean fireCommand(String command, String args) {
        Stack<Scalar> tokens = new Stack<Scalar>();
        StringBuffer token = new StringBuffer();
        for (int x = 0; x < args.length(); ++x) {
            char temp = args.charAt(x);
            if (temp == ' ') {
                if (token.length() > 0) {
                    tokens.add(0, SleepUtils.getScalar(token.toString()));
                }
                token = new StringBuffer();
                continue;
            }
            if (temp == '\"' && token.length() == 0) {
                ++x;
                while (x < args.length() && args.charAt(x) != '\"') {
                    token.append(args.charAt(x));
                    ++x;
                }
                tokens.add(0, SleepUtils.getScalar(token.toString()));
                token = new StringBuffer();
                continue;
            }
            token.append(temp);
        }
        if (token.length() > 0) {
            tokens.add(0, SleepUtils.getScalar(token.toString()));
        }
        tokens.pop();
        return this.fireCommand(command, args, tokens);
    }

    public boolean fireCommand(String command, String argz, Stack args) {
        SleepClosure c = this.getCommand(command);
        if (c == null) {
            return false;
        }
        SleepUtils.runCode(c, argz, null, EventManager.shallowCopy(args));
        return true;
    }
}

