/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import armitage.Activity;
import cortana.gui.MenuBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import msf.RpcConnection;
import ui.DraggableTabbedPane;
import ui.KeyBindings;
import ui.KeyHandler;
import ui.MultiFrame;
import ui.ScreenshotManager;

public class ArmitageApplication
extends JComponent {
    protected JTabbedPane tabs = null;
    protected JSplitPane split = null;
    protected JMenuBar menus = new JMenuBar();
    protected ScreenshotManager screens = null;
    protected KeyBindings keys = new KeyBindings();
    protected MenuBuilder builder = null;
    protected String title = "";
    protected MultiFrame window = null;
    protected JSplitPane split2 = null;
    protected ApplicationTab docked = null;
    protected LinkedList apptabs = new LinkedList();
    private static Image myicon = null;

    public KeyBindings getBindings() {
        return this.keys;
    }

    public void setTitle(String title) {
        this.title = title;
        this.window.setTitle(this, title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setIconImage(Image blah) {
        this.window.setIconImage(blah);
    }

    public void setScreenshotManager(ScreenshotManager m) {
        this.screens = m;
    }

    public void installMenu(MouseEvent ev, String key, Stack args) {
        if (this.builder == null) {
            System.err.println("Menu builder was never installed! " + key);
            return;
        }
        this.builder.installMenu(ev, key, args);
    }

    public void setupMenu(JComponent parent, String key, Stack args) {
        if (this.builder == null) {
            return;
        }
        this.builder.setupMenu(parent, key, args);
    }

    public void setMenuBuilder(MenuBuilder b) {
        this.builder = b;
    }

    public void bindKey(String description, KeyHandler b) {
        this.keys.bind(description, b);
    }

    public void addMenu(JMenuItem menu) {
        this.menus.add(menu);
    }

    public JMenuBar getJMenuBar() {
        return this.menus;
    }

    public void _removeTab(JComponent component) {
        this.tabs.remove(component);
        this.tabs.validate();
    }

    public void removeTab(final JComponent tab) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._removeTab(tab);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArmitageApplication.this._removeTab(tab);
                }
            });
        }
    }

    public void setTop(final JComponent top) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._setTop(top);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArmitageApplication.this._setTop(top);
                }
            });
        }
    }

    public void _setTop(JComponent top) {
        this.split.setTopComponent(top);
        this.split.setDividerLocation(0.5);
        this.split.setResizeWeight(0.5);
        this.split.revalidate();
    }

    public void nextTab() {
        this.tabs.setSelectedIndex((this.tabs.getSelectedIndex() + 1) % this.tabs.getTabCount());
    }

    public void previousTab() {
        if (this.tabs.getSelectedIndex() == 0) {
            this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        } else {
            this.tabs.setSelectedIndex((this.tabs.getSelectedIndex() - 1) % this.tabs.getTabCount());
        }
    }

    public void addTab(final String title, final JComponent tab, final ActionListener removeListener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._addTab(title, tab, removeListener, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArmitageApplication.this._addTab(title, tab, removeListener, null);
                }
            });
        }
    }

    public void addTab(final String title, final JComponent tab, final ActionListener removeListener, final String tooltip) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._addTab(title, tab, removeListener, tooltip);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArmitageApplication.this._addTab(title, tab, removeListener, tooltip);
                }
            });
        }
    }

    public void closeActiveTab() {
        JComponent tab = (JComponent)this.tabs.getSelectedComponent();
        if (tab != null) {
            this.removeAppTab(tab, null, new ActionEvent(tab, 0, "boo!"));
        }
    }

    public void openActiveTab() {
        JComponent tab = (JComponent)this.tabs.getSelectedComponent();
        if (tab != null) {
            this.popAppTab(tab);
        }
    }

    public void noDock() {
        if (this.docked != null) {
            if (this.docked.removeListener != null) {
                this.docked.removeListener.actionPerformed(new ActionEvent(this.docked.component, 0, "close"));
            }
            this.split2.setBottomComponent(null);
            this.split2.setDividerSize(0);
            this.split2.setResizeWeight(1.0);
            this.validate();
            this.docked = null;
        }
    }

    public void dockActiveTab() {
        JComponent tab = (JComponent)this.tabs.getSelectedComponent();
        if (tab != null) {
            this.dockAppTab(tab);
        }
    }

    public void snapActiveTab() {
        JComponent tab = (JComponent)this.tabs.getSelectedComponent();
        for (ApplicationTab t : this.apptabs) {
            if (t.component != tab) continue;
            this.snapAppTab(t.title, tab);
        }
    }

    public void addAppTab(String title, JComponent component, ActionListener removeListener) {
        ApplicationTab t = new ApplicationTab();
        t.title = title;
        t.component = component;
        t.removeListener = removeListener;
        this.apptabs.add(t);
    }

    public void disconnected() {
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ArmitageApplication.this.window.quit();
            }
        });
        JPanel announce = new JPanel();
        announce.setLayout(new BorderLayout());
        announce.setBackground(Color.RED);
        announce.add((Component)new JLabel("<html><body><strong>Disconnected from server</strong></body></html>"), "Center");
        announce.add((Component)close, "East");
        announce.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)announce, "South");
        this.revalidate();
    }

    private Image getMyIcon() {
        if (myicon != null) {
            return myicon;
        }
        try {
            String file = "resources/armitage-icon.gif";
            InputStream i = null;
            i = new File(file).exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream(file);
            myicon = ImageIO.read(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myicon;
    }

    public void popAppTab(Component tab) {
        Iterator i = this.apptabs.iterator();
        while (i.hasNext()) {
            final ApplicationTab t = (ApplicationTab)i.next();
            if (t.component != tab) continue;
            this.tabs.remove(t.component);
            i.remove();
            final JFrame r = new JFrame(t.title);
            r.setIconImage(this.getMyIcon());
            r.setLayout(new BorderLayout());
            r.add((Component)t.component, "Center");
            r.pack();
            t.component.validate();
            r.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    if (t.removeListener != null) {
                        t.removeListener.actionPerformed(new ActionEvent(ev.getSource(), 0, "close"));
                    }
                }

                @Override
                public void windowOpened(WindowEvent ev) {
                    r.setState(0);
                    t.component.requestFocusInWindow();
                }

                @Override
                public void windowActivated(WindowEvent ev) {
                    t.component.requestFocusInWindow();
                }
            });
            r.setState(1);
            r.setVisible(true);
        }
    }

    public void dockAppTab(Component tab) {
        Iterator i = this.apptabs.iterator();
        while (i.hasNext()) {
            ApplicationTab t = (ApplicationTab)i.next();
            if (t.component != tab) continue;
            this.tabs.remove(t.component);
            i.remove();
            Dimension size = new Dimension(100, 150);
            if (this.docked != null) {
                size = this.docked.component.getSize();
                if (this.docked.removeListener != null) {
                    this.docked.removeListener.actionPerformed(new ActionEvent(this.docked.component, 0, "close"));
                }
            }
            this.split2.setBottomComponent(t.component);
            this.split2.setDividerSize(10);
            this.split2.setResizeWeight(1.0);
            t.component.setPreferredSize(size);
            t.component.setSize(size);
            this.validate();
            this.docked = t;
        }
    }

    public void snapAppTab(String title, Component tab) {
        BufferedImage image = new BufferedImage(tab.getWidth(), tab.getHeight(), 6);
        Graphics g = image.getGraphics();
        tab.paint(g);
        g.dispose();
        if (this.screens != null) {
            this.screens.saveScreenshot(image, title);
        }
    }

    public void removeAppTab(Component tab, String title, ActionEvent ev) {
        String titleshort;
        Iterator i = this.apptabs.iterator();
        String string = titleshort = title != null ? title.split(" ")[0] : "%b%";
        while (i.hasNext()) {
            String tshort;
            ApplicationTab t = (ApplicationTab)i.next();
            String string2 = tshort = t.title != null ? t.title.split(" ")[0] : "%a%";
            if (t.component != tab && !tshort.equals(titleshort)) continue;
            this.tabs.remove(t.component);
            if (t.removeListener != null) {
                t.removeListener.actionPerformed(ev);
            }
            i.remove();
        }
    }

    public void _addTab(final String title, final JComponent tab, ActionListener removeListener, String tooltip) {
        final Component component = this.tabs.add("", tab);
        final JLabel label = new JLabel(title + "   ");
        JPanel control = new JPanel();
        control.setOpaque(false);
        control.setLayout(new BorderLayout());
        control.add((Component)label, "Center");
        if (tab instanceof Activity) {
            ((Activity)((Object)tab)).registerLabel(label);
        }
        JButton close = new JButton("X");
        close.setOpaque(false);
        close.setContentAreaFilled(false);
        close.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        control.add((Component)close, "East");
        if (tooltip != null) {
            close.setToolTipText(tooltip);
        }
        int index = this.tabs.indexOfComponent(component);
        this.tabs.setTabComponentAt(index, control);
        this.addAppTab(title, tab, removeListener);
        close.addMouseListener(new MouseAdapter(){

            public void check(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem a = new JMenuItem("Open in window", 79);
                    a.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ArmitageApplication.this.popAppTab(component);
                        }
                    });
                    JMenuItem b = new JMenuItem("Close like tabs", 67);
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ArmitageApplication.this.removeAppTab(null, title, ev);
                        }
                    });
                    JMenuItem c = new JMenuItem("Save screenshot", 83);
                    c.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ArmitageApplication.this.snapAppTab(title, tab);
                        }
                    });
                    JMenuItem dd = new JMenuItem("Send to bottom", 98);
                    dd.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            ArmitageApplication.this.dockAppTab(component);
                        }
                    });
                    JMenuItem d = new JMenuItem("Rename Tab", 82);
                    d.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            String text = JOptionPane.showInputDialog("Rename tab to:", (Object)(label.getText() + "").trim());
                            if (text != null) {
                                label.setText(text + "   ");
                            }
                        }
                    });
                    menu.add(a);
                    menu.add(c);
                    menu.add(dd);
                    menu.add(d);
                    menu.addSeparator();
                    menu.add(b);
                    menu.show((Component)ev.getSource(), ev.getX(), ev.getY());
                    ev.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                this.check(ev);
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                this.check(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.check(ev);
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if ((ev.getModifiers() & 2) == 2) {
                    ArmitageApplication.this.popAppTab(component);
                } else if ((ev.getModifiers() & 1) == 1) {
                    ArmitageApplication.this.removeAppTab(null, title, ev);
                } else {
                    ArmitageApplication.this.removeAppTab(component, null, ev);
                }
                System.gc();
            }
        });
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ev) {
                if (component instanceof Activity) {
                    ((Activity)((Object)component)).resetNotification();
                }
                component.requestFocusInWindow();
                System.gc();
            }
        });
        this.tabs.setSelectedIndex(index);
        component.requestFocusInWindow();
    }

    public void touch() {
        Component c = this.tabs.getSelectedComponent();
        if (c == null) {
            return;
        }
        if (c instanceof Activity) {
            ((Activity)((Object)c)).resetNotification();
        }
        c.requestFocusInWindow();
    }

    public ArmitageApplication(MultiFrame f, String details, RpcConnection conn) {
        this.window = f;
        this.tabs = new DraggableTabbedPane();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.add((Component)this.menus, "North");
        this.split2 = new JSplitPane(0, this.tabs, null);
        this.split2.setDividerSize(0);
        this.split2.setOneTouchExpandable(true);
        this.split = new JSplitPane(0, panel, this.split2);
        this.split.setOneTouchExpandable(true);
        this.add((Component)this.split, "Center");
        this.window.addButton(details, this, conn);
    }

    private static class ApplicationTab {
        public String title;
        public JComponent component;
        public ActionListener removeListener;

        private ApplicationTab() {
        }

        public String toString() {
            return this.title;
        }
    }
}

