# Generated by Django 5.0.6 on 2024-08-18 05:37

import uuid
import random
from django.db import migrations, models

from archivebox.base_models.abid import ABID


def rand_int_id():
    return random.getrandbits(32)


def update_archiveresult_ids(apps, schema_editor):
    ArchiveResult = apps.get_model("core", "ArchiveResult")
    num_total = ArchiveResult.objects.all().count()
    print(f'   Updating {num_total} ArchiveResult.id, ArchiveResult.uuid values in place... (may take an hour or longer for large collections...)')
    for idx, result in enumerate(ArchiveResult.objects.all().only('abid').iterator(chunk_size=500)):
        assert result.abid
        result.uuid = ABID.parse(result.abid).uuid
        result.save(update_fields=["uuid"])
        assert str(ABID.parse(result.abid).uuid) == str(result.uuid)
        if idx % 2500 == 0:
            print(f'Migrated {idx}/{num_total} ArchiveResult objects...')


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0033_rename_id_archiveresult_old_id'),
    ]

    operations = [
        migrations.AlterField(
            model_name='archiveresult',
            name='old_id',
            field=models.BigIntegerField(default=rand_int_id, serialize=False, verbose_name='ID'),
        ),
        migrations.RunPython(update_archiveresult_ids, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='archiveresult',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, unique=True),
        ),
    ]
