import os
import re
from core.actionModule import actionModule
from core.utils import Utils
from core.keystore import KeyStore as kb


class exploit_jexboss(actionModule):
    def __init__(self, config, display, lock):
        super(exploit_jexboss, self).__init__(config, display, lock)
        self.title = "Run JexBoss and look for vulnerabilities"
        self.shortName = "jexboss"
        self.description = "execute [jexboss.py -mode file-scan] on each web service"

        self.requirements = ["jexboss"]
        self.types = ["web"]

        self.safeLevel = 4

        self.triggers = ["newService_https", "newService_http"]

    def getTargets(self):
        self.targets = kb.get('service/http', 'service/https')
    
    def process(self):
        # load any targets we are interested in
        self.getTargets()

       # loop over each target
        for t in self.targets:
            # verify we have not tested this host before
            ports = kb.get('service/http/' + t + '/tcp')
            for port in ports:
                if not self.seentarget(t + str(port)):	
		    self.addseentarget(t+str(port))

                    outfile = self.config["proofsDir"] + self.shortName + "_" + t + "_" + str(port) + "_" + Utils.getRandStr(10) + ".txt"
                    command = "python " + self.config["jexboss"] + " -mode file-scan -out " + outfile + " -file <(echo \"http://" + t + ":" + str(port) + "\")"
                    result = Utils.execWait(command)
                    kb.add("host/" + t + "/files/" + self.shortName + "/" + outfile.replace("/", "%2F"    ))

                    contents = []
                    with open (outfile, "r") as myfile:
                        contents = myfile.readlines()
                        for line in contents:
                            m = re.match(r'^.*VULNERABLE TO (.*)\].*', line)
                            if (m):
                                vuln = m.group(1).strip()
                                self.addVuln(t, self.shortName + "-" + vuln, {"port": port, "output": outfile.replace("/", "%2F")})
            ports = kb.get('service/https/' + t + '/tcp')
            for port in ports:
                if not self.seentarget(t + str(port)):	
		    self.addseentarget(t+str(port))

                    outfile = self.config["proofsDir"] + self.shortName + "_" + t + "_" + str(port) + "_" + Utils.getRandStr(10) + ".txt"
                    command = "python " + self.config["jexboss"] + " -mode file-scan -out " + outfile + " -file <(echo \"https://" + t + ":" + str(port) + "\")"
                    result = Utils.execWait(command)
                    kb.add("host/" + t + "/files/" + self.shortName + "/" + outfile.replace("/", "%2F"    ))

                    contents = []
                    with open (outfile, "r") as myfile:
                        contents = myfile.readlines()
                        for line in contents:
                            m = re.match(r'^.*VULNERABLE TO (.*)\].*', line)
                            if (m):
                                vuln = m.group(1).strip()
                                self.addVuln(t, self.shortName + "-" + vuln, {"port": port, "output": outfile.replace("/", "%2F")})
        return
