/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSSLServer {
    static final int CHANGE_CIPHER_SPEC = 20;
    static final int ALERT = 21;
    static final int HANDSHAKE = 22;
    static final int APPLICATION = 23;
    static final int MAX_RECORD_LEN = 16384;
    private static final SecureRandom RNG = new SecureRandom();
    private static final byte[] SSL2_CLIENT_HELLO = new byte[]{-128, 46, 1, 0, 2, 0, 21, 0, 0, 0, 16, 1, 0, -128, 2, 0, -128, 3, 0, -128, 4, 0, -128, 5, 0, -128, 6, 0, 64, 7, 0, -64, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84};
    static Map<Integer, CipherSuite> CIPHER_SUITES = new TreeMap<Integer, CipherSuite>();
    static final int CLEAR = 0;
    static final int WEAK = 1;
    static final int MEDIUM = 2;
    static final int STRONG = 3;

    static void usage() {
        System.err.println("usage: TestSSLServer servername [ port ]");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        Object object;
        Iterator<Integer> iterator;
        Object object2;
        if (stringArray.length == 0 || stringArray.length > 2) {
            TestSSLServer.usage();
        }
        String string = stringArray[0];
        int n2 = 443;
        if (stringArray.length == 2) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                TestSSLServer.usage();
            }
            if (n2 <= 0 || n2 > 65535) {
                TestSSLServer.usage();
            }
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        boolean bl = false;
        for (int i = 768; i <= 771; ++i) {
            object2 = TestSSLServer.connect(inetSocketAddress, i, CIPHER_SUITES.keySet());
            if (object2 == null) continue;
            treeSet.add(((ServerHello)object2).protoVersion);
            if (((ServerHello)object2).compression != 1) continue;
            bl = true;
        }
        ServerHelloSSLv2 serverHelloSSLv2 = TestSSLServer.connectV2(inetSocketAddress);
        if (serverHelloSSLv2 != null) {
            treeSet.add(512);
        }
        if (treeSet.size() == 0) {
            System.out.println("No SSL/TLS server at " + inetSocketAddress);
            System.exit(1);
        }
        System.out.print("Supported versions:");
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            int n3 = (Integer)object2.next();
            System.out.print(" ");
            System.out.print(TestSSLServer.versionString(n3));
        }
        System.out.println();
        System.out.println("Deflate compression: " + (bl ? "YES" : "no"));
        System.out.println("Supported cipher suites (ORDER IS NOT SIGNIFICANT):");
        object2 = null;
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        if (serverHelloSSLv2 != null) {
            System.out.println("  " + TestSSLServer.versionString(512));
            iterator = new TreeSet();
            for (int n4 : serverHelloSSLv2.cipherSuites) {
                iterator.add(n4);
            }
            object = iterator.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                System.out.println("     " + TestSSLServer.cipherSuiteStringV2(n));
            }
            treeMap.put(512, iterator);
            if (serverHelloSSLv2.serverCertName != null) {
                treeSet2.add(serverHelloSSLv2.serverCertHash + ": " + serverHelloSSLv2.serverCertName);
            }
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (n5 == 512) continue;
            Set<Integer> set = TestSSLServer.supportedSuites(inetSocketAddress, n5, treeSet2);
            treeMap.put(n5, set);
            if (object2 == null || !object2.equals(set)) {
                System.out.println("  " + TestSSLServer.versionString(n5));
                for (int n4 : set) {
                    System.out.println("     " + TestSSLServer.cipherSuiteString(n4));
                }
                object2 = set;
                continue;
            }
            System.out.println("  (" + TestSSLServer.versionString(n5) + ": idem)");
        }
        System.out.println("----------------------");
        if (treeSet2.size() == 0) {
            System.out.println("No server certificate !");
        } else {
            System.out.println("Server certificate(s):");
            iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                System.out.println("  " + (String)object);
            }
        }
        System.out.println("----------------------");
        int n6 = 3;
        int n7 = 3;
        n = 0;
        Iterator iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            int n4;
            n4 = (Integer)iterator2.next();
            Set set = (Set)treeMap.get(n4);
            n6 = Math.min(TestSSLServer.maxStrength(set), n6);
            n7 = Math.min(TestSSLServer.minStrength(set), n7);
            if (n != 0) continue;
            n = TestSSLServer.testBEAST(inetSocketAddress, n4, set) ? 1 : 0;
        }
        System.out.println("Minimal encryption strength:     " + TestSSLServer.strengthString(n7));
        System.out.println("Achievable encryption strength:  " + TestSSLServer.strengthString(n6));
        System.out.println("BEAST status: " + (n != 0 ? "vulnerable" : "protected"));
        System.out.println("CRIME status: " + (bl ? "vulnerable" : "protected"));
    }

    static Set<Integer> supportedSuites(InetSocketAddress inetSocketAddress, int n, Set<String> set) {
        ServerHello serverHello;
        TreeSet<Integer> treeSet = new TreeSet<Integer>(CIPHER_SUITES.keySet());
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        while ((serverHello = TestSSLServer.connect(inetSocketAddress, n, treeSet)) != null) {
            if (!treeSet.contains(serverHello.cipherSuite)) {
                System.err.printf("[ERR: server wants to use cipher suite 0x%04X which client did not announce]", serverHello.cipherSuite);
                System.err.println();
                break;
            }
            treeSet.remove(serverHello.cipherSuite);
            treeSet2.add(serverHello.cipherSuite);
            if (serverHello.serverCertName == null) continue;
            set.add(serverHello.serverCertHash + ": " + serverHello.serverCertName);
        }
        return treeSet2;
    }

    static int minStrength(Set<Integer> set) {
        int n = 3;
        for (int n2 : set) {
            CipherSuite cipherSuite = CIPHER_SUITES.get(n2);
            if (cipherSuite == null || cipherSuite.strength >= n) continue;
            n = cipherSuite.strength;
        }
        return n;
    }

    static int maxStrength(Set<Integer> set) {
        int n = 0;
        for (int n2 : set) {
            CipherSuite cipherSuite = CIPHER_SUITES.get(n2);
            if (cipherSuite == null || cipherSuite.strength <= n) continue;
            n = cipherSuite.strength;
        }
        return n;
    }

    static boolean testBEAST(InetSocketAddress inetSocketAddress, int n, Set<Integer> set) {
        if (n < 768 || n > 769) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Object object = set.iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            CipherSuite cipherSuite = CIPHER_SUITES.get(n2);
            if (cipherSuite == null || cipherSuite.strength < 3) continue;
            if (cipherSuite.isCBC) {
                arrayList.add(n2);
                continue;
            }
            arrayList2.add(n2);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        object = new ArrayList(arrayList);
        object.addAll(arrayList2);
        ServerHello serverHello = TestSSLServer.connect(inetSocketAddress, n, (Collection<Integer>)object);
        return !arrayList2.contains(serverHello.cipherSuite);
    }

    static String versionString(int n) {
        if (n == 512) {
            return "SSLv2";
        }
        if (n == 768) {
            return "SSLv3";
        }
        if (n >>> 8 == 3) {
            return "TLSv1." + ((n & 0xFF) - 1);
        }
        return String.format("UNKNOWN_VERSION:0x%04X", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerHello connect(InetSocketAddress inetSocketAddress, int n, Collection<Integer> collection) {
        Socket socket = null;
        try {
            socket = new Socket();
            try {
                socket.connect(inetSocketAddress);
            }
            catch (IOException iOException) {
                System.err.println("could not connect to " + inetSocketAddress + ": " + iOException.toString());
                ServerHello serverHello = null;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return serverHello;
            }
            byte[] byArray = TestSSLServer.makeClientHello(n, collection);
            OutputRecord outputRecord = new OutputRecord(socket.getOutputStream());
            outputRecord.setType(22);
            outputRecord.setVersion(n);
            outputRecord.write(byArray);
            outputRecord.flush();
            ServerHello serverHello = new ServerHello(socket.getInputStream());
            return serverHello;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerHelloSSLv2 connectV2(InetSocketAddress inetSocketAddress) {
        Socket socket = null;
        try {
            socket = new Socket();
            try {
                socket.connect(inetSocketAddress);
            }
            catch (IOException iOException) {
                System.err.println("could not connect to " + inetSocketAddress + ": " + iOException.toString());
                ServerHelloSSLv2 serverHelloSSLv2 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return serverHelloSSLv2;
            }
            socket.getOutputStream().write(SSL2_CLIENT_HELLO);
            ServerHelloSSLv2 serverHelloSSLv2 = new ServerHelloSSLv2(socket.getInputStream());
            return serverHelloSSLv2;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    static final void enc16be(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    static final void enc24be(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 16);
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)n;
    }

    static final void enc32be(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    static final int dec16be(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static final int dec24be(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
    }

    static final int dec32be(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        TestSSLServer.readFully(inputStream, byArray, 0, byArray.length);
    }

    static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    static byte[] makeClientHello(int n, Collection<Integer> collection) {
        try {
            return TestSSLServer.makeClientHello0(n, collection);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static byte[] makeClientHello0(int n, Collection<Integer> collection) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(n >>> 8);
        byteArrayOutputStream.write(n);
        byte[] byArray = new byte[32];
        RNG.nextBytes(byArray);
        TestSSLServer.enc32be((int)(System.currentTimeMillis() / 1000L), byArray, 0);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(0);
        int n2 = collection.size();
        byte[] byArray2 = new byte[2 + n2 * 2];
        TestSSLServer.enc16be(n2 * 2, byArray2, 0);
        int n3 = 2;
        Object object = collection.iterator();
        while (object.hasNext()) {
            int n4 = object.next();
            TestSSLServer.enc16be(n4, byArray2, n3);
            n3 += 2;
        }
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(0);
        object = byteArrayOutputStream.toByteArray();
        TestSSLServer.enc24be(((Object)object).length - 4, (byte[])object, 1);
        return object;
    }

    static String doSHA1(byte[] byArray) {
        return TestSSLServer.doSHA1(byArray, 0, byArray.length);
    }

    static String doSHA1(byte[] byArray, int n, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray, n, n2);
            byte[] byArray2 = messageDigest.digest();
            Formatter formatter = new Formatter();
            for (byte by : byArray2) {
                formatter.format("%02x", by & 0xFF);
            }
            return formatter.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
    }

    static final String strengthString(int n) {
        switch (n) {
            case 0: {
                return "no encryption";
            }
            case 1: {
                return "weak encryption (40-bit)";
            }
            case 2: {
                return "medium encryption (56-bit)";
            }
            case 3: {
                return "strong encryption (96-bit or more)";
            }
        }
        throw new Error("strange strength: " + n);
    }

    static final String cipherSuiteString(int n) {
        CipherSuite cipherSuite = CIPHER_SUITES.get(n);
        if (cipherSuite == null) {
            return String.format("UNKNOWN_SUITE:0x%04X", cipherSuite);
        }
        return cipherSuite.name;
    }

    static final String cipherSuiteStringV2(int n) {
        CipherSuite cipherSuite = CIPHER_SUITES.get(n);
        if (cipherSuite == null) {
            return String.format("UNKNOWN_SUITE:%02X,%02X,%02X", n >> 16, n >> 8 & 0xFF, n & 0xFF);
        }
        return cipherSuite.name;
    }

    private static final void makeCS(int n, String string, boolean bl, int n2) {
        CipherSuite cipherSuite = new CipherSuite();
        cipherSuite.suite = n;
        cipherSuite.name = string;
        cipherSuite.isCBC = bl;
        cipherSuite.strength = n2;
        CIPHER_SUITES.put(n, cipherSuite);
        boolean bl2 = string.contains("_CBC_");
        int n3 = string.contains("_NULL_") ? 0 : (string.contains("DES40") || string.contains("_40_") || string.contains("EXPORT40") ? 1 : ((string.contains("_DES_") || string.contains("DES_64")) && !string.contains("DES_192") ? 2 : 3));
        if (n3 != n2 || bl2 != bl) {
            throw new RuntimeException("wrong classification: " + string);
        }
    }

    private static final void N(int n, String string) {
        TestSSLServer.makeCS(n, string, false, 0);
    }

    private static final void S4(int n, String string) {
        TestSSLServer.makeCS(n, string, false, 1);
    }

    private static final void S8(int n, String string) {
        TestSSLServer.makeCS(n, string, false, 3);
    }

    private static final void B4(int n, String string) {
        TestSSLServer.makeCS(n, string, true, 1);
    }

    private static final void B5(int n, String string) {
        TestSSLServer.makeCS(n, string, true, 2);
    }

    private static final void B8(int n, String string) {
        TestSSLServer.makeCS(n, string, true, 3);
    }

    static {
        TestSSLServer.S8(65664, "RC4_128_WITH_MD5");
        TestSSLServer.S4(131200, "RC4_128_EXPORT40_WITH_MD5");
        TestSSLServer.B8(196736, "RC2_128_CBC_WITH_MD5");
        TestSSLServer.B4(262272, "RC2_128_CBC_EXPORT40_WITH_MD5");
        TestSSLServer.B8(327808, "IDEA_128_CBC_WITH_MD5");
        TestSSLServer.B5(393280, "DES_64_CBC_WITH_MD5");
        TestSSLServer.B8(458944, "DES_192_EDE3_CBC_WITH_MD5");
        TestSSLServer.N(0, "NULL_WITH_NULL_NULL");
        TestSSLServer.N(1, "RSA_WITH_NULL_MD5");
        TestSSLServer.N(2, "RSA_WITH_NULL_SHA");
        TestSSLServer.S4(3, "RSA_EXPORT_WITH_RC4_40_MD5");
        TestSSLServer.S8(4, "RSA_WITH_RC4_128_MD5");
        TestSSLServer.S8(5, "RSA_WITH_RC4_128_SHA");
        TestSSLServer.B4(6, "RSA_EXPORT_WITH_RC2_CBC_40_MD5");
        TestSSLServer.B8(7, "RSA_WITH_IDEA_CBC_SHA");
        TestSSLServer.B4(8, "RSA_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(9, "RSA_WITH_DES_CBC_SHA");
        TestSSLServer.B8(10, "RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B4(11, "DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(12, "DH_DSS_WITH_DES_CBC_SHA");
        TestSSLServer.B8(13, "DH_DSS_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B4(14, "DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(15, "DH_RSA_WITH_DES_CBC_SHA");
        TestSSLServer.B8(16, "DH_RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B4(17, "DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(18, "DHE_DSS_WITH_DES_CBC_SHA");
        TestSSLServer.B8(19, "DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B4(20, "DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(21, "DHE_RSA_WITH_DES_CBC_SHA");
        TestSSLServer.B8(22, "DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.S4(23, "DH_anon_EXPORT_WITH_RC4_40_MD5");
        TestSSLServer.S8(24, "DH_anon_WITH_RC4_128_MD5");
        TestSSLServer.B4(25, "DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        TestSSLServer.B5(26, "DH_anon_WITH_DES_CBC_SHA");
        TestSSLServer.B8(27, "DH_anon_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.N(28, "FORTEZZA_KEA_WITH_NULL_SHA");
        TestSSLServer.B8(29, "FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA");
        TestSSLServer.B5(30, "KRB5_WITH_DES_CBC_SHA");
        TestSSLServer.B8(31, "KRB5_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.S8(32, "KRB5_WITH_RC4_128_SHA");
        TestSSLServer.B8(33, "KRB5_WITH_IDEA_CBC_SHA");
        TestSSLServer.B5(34, "KRB5_WITH_DES_CBC_MD5");
        TestSSLServer.B8(35, "KRB5_WITH_3DES_EDE_CBC_MD5");
        TestSSLServer.S8(36, "KRB5_WITH_RC4_128_MD5");
        TestSSLServer.B8(37, "KRB5_WITH_IDEA_CBC_MD5");
        TestSSLServer.B4(38, "KRB5_EXPORT_WITH_DES_CBC_40_SHA");
        TestSSLServer.B4(39, "KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
        TestSSLServer.S4(40, "KRB5_EXPORT_WITH_RC4_40_SHA");
        TestSSLServer.B4(41, "KRB5_EXPORT_WITH_DES_CBC_40_MD5");
        TestSSLServer.B4(42, "KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
        TestSSLServer.S4(43, "KRB5_EXPORT_WITH_RC4_40_MD5");
        TestSSLServer.N(44, "PSK_WITH_NULL_SHA");
        TestSSLServer.N(45, "DHE_PSK_WITH_NULL_SHA");
        TestSSLServer.N(46, "RSA_PSK_WITH_NULL_SHA");
        TestSSLServer.B8(47, "RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(48, "DH_DSS_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49, "DH_RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(50, "DHE_DSS_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(51, "DHE_RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(52, "DH_anon_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(53, "RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(54, "DH_DSS_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(55, "DH_RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(56, "DHE_DSS_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(57, "DHE_RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(58, "DH_anon_WITH_AES_256_CBC_SHA");
        TestSSLServer.N(59, "RSA_WITH_NULL_SHA256");
        TestSSLServer.B8(60, "RSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(61, "RSA_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(62, "DH_DSS_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(63, "DH_RSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(64, "DHE_DSS_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(103, "DHE_RSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(104, "DH_DSS_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(105, "DH_RSA_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(106, "DHE_DSS_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(107, "DHE_RSA_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(108, "DH_anon_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(109, "DH_anon_WITH_AES_256_CBC_SHA256");
        TestSSLServer.B8(65, "RSA_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(66, "DH_DSS_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(67, "DH_RSA_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(68, "DHE_DSS_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(69, "DHE_RSA_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(70, "DH_anon_WITH_CAMELLIA_128_CBC_SHA");
        TestSSLServer.B8(132, "RSA_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.B8(133, "DH_DSS_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.B8(134, "DH_RSA_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.B8(135, "DHE_DSS_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.B8(136, "DHE_RSA_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.B8(137, "DH_anon_WITH_CAMELLIA_256_CBC_SHA");
        TestSSLServer.S8(138, "TLS_PSK_WITH_RC4_128_SHA");
        TestSSLServer.B8(139, "TLS_PSK_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(140, "TLS_PSK_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(141, "TLS_PSK_WITH_AES_256_CBC_SHA");
        TestSSLServer.S8(142, "TLS_DHE_PSK_WITH_RC4_128_SHA");
        TestSSLServer.B8(143, "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(144, "TLS_DHE_PSK_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(145, "TLS_DHE_PSK_WITH_AES_256_CBC_SHA");
        TestSSLServer.S8(146, "TLS_RSA_PSK_WITH_RC4_128_SHA");
        TestSSLServer.B8(147, "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(148, "TLS_RSA_PSK_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(149, "TLS_RSA_PSK_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(150, "TLS_RSA_WITH_SEED_CBC_SHA");
        TestSSLServer.B8(151, "TLS_DH_DSS_WITH_SEED_CBC_SHA");
        TestSSLServer.B8(152, "TLS_DH_RSA_WITH_SEED_CBC_SHA");
        TestSSLServer.B8(153, "TLS_DHE_DSS_WITH_SEED_CBC_SHA");
        TestSSLServer.B8(154, "TLS_DHE_RSA_WITH_SEED_CBC_SHA");
        TestSSLServer.B8(155, "TLS_DH_anon_WITH_SEED_CBC_SHA");
        TestSSLServer.S8(156, "TLS_RSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(157, "TLS_RSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(158, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(159, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(160, "TLS_DH_RSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(161, "TLS_DH_RSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(162, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(163, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(164, "TLS_DH_DSS_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(165, "TLS_DH_DSS_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(166, "TLS_DH_anon_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(167, "TLS_DH_anon_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(168, "TLS_PSK_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(169, "TLS_PSK_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(170, "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(171, "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(172, "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(173, "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384");
        TestSSLServer.B8(174, "TLS_PSK_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(175, "TLS_PSK_WITH_AES_256_CBC_SHA384");
        TestSSLServer.N(176, "TLS_PSK_WITH_NULL_SHA256");
        TestSSLServer.N(177, "TLS_PSK_WITH_NULL_SHA384");
        TestSSLServer.B8(178, "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(179, "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384");
        TestSSLServer.N(180, "TLS_DHE_PSK_WITH_NULL_SHA256");
        TestSSLServer.N(181, "TLS_DHE_PSK_WITH_NULL_SHA384");
        TestSSLServer.B8(182, "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(183, "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384");
        TestSSLServer.N(184, "TLS_RSA_PSK_WITH_NULL_SHA256");
        TestSSLServer.N(185, "TLS_RSA_PSK_WITH_NULL_SHA384");
        TestSSLServer.B8(186, "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(187, "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(188, "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(189, "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(190, "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(191, "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(192, "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.B8(193, "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.B8(194, "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.B8(195, "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.B8(196, "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.B8(197, "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256");
        TestSSLServer.N(49153, "TLS_ECDH_ECDSA_WITH_NULL_SHA");
        TestSSLServer.S8(49154, "TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
        TestSSLServer.B8(49155, "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49156, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49157, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.N(49158, "TLS_ECDHE_ECDSA_WITH_NULL_SHA");
        TestSSLServer.S8(49159, "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
        TestSSLServer.B8(49160, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49161, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49162, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.N(49163, "TLS_ECDH_RSA_WITH_NULL_SHA");
        TestSSLServer.S8(49164, "TLS_ECDH_RSA_WITH_RC4_128_SHA");
        TestSSLServer.B8(49165, "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49166, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49167, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.N(49168, "TLS_ECDHE_RSA_WITH_NULL_SHA");
        TestSSLServer.S8(49169, "TLS_ECDHE_RSA_WITH_RC4_128_SHA");
        TestSSLServer.B8(49170, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49171, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49172, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.N(49173, "TLS_ECDH_anon_WITH_NULL_SHA");
        TestSSLServer.S8(49174, "TLS_ECDH_anon_WITH_RC4_128_SHA");
        TestSSLServer.B8(49175, "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49176, "TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49177, "TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(49178, "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49179, "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49180, "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49181, "TLS_SRP_SHA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49182, "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49183, "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49184, "TLS_SRP_SHA_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(49185, "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(49186, "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(49187, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(49188, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        TestSSLServer.B8(49189, "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(49190, "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
        TestSSLServer.B8(49191, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(49192, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        TestSSLServer.B8(49193, "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(49194, "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384");
        TestSSLServer.S8(49195, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(49196, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(49197, "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(49198, "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(49199, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(49200, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(49201, "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
        TestSSLServer.S8(49202, "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384");
        TestSSLServer.S8(49203, "TLS_ECDHE_PSK_WITH_RC4_128_SHA");
        TestSSLServer.B8(49204, "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA");
        TestSSLServer.B8(49205, "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA");
        TestSSLServer.B8(49206, "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA");
        TestSSLServer.B8(49207, "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256");
        TestSSLServer.B8(49208, "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384");
        TestSSLServer.N(49209, "TLS_ECDHE_PSK_WITH_NULL_SHA");
        TestSSLServer.N(49210, "TLS_ECDHE_PSK_WITH_NULL_SHA256");
        TestSSLServer.N(49211, "TLS_ECDHE_PSK_WITH_NULL_SHA384");
        TestSSLServer.B8(49212, "TLS_RSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49213, "TLS_RSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49214, "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49215, "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49216, "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49217, "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49218, "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49219, "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49220, "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49221, "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49222, "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49223, "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49224, "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49225, "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49226, "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49227, "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49228, "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49229, "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49230, "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49231, "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.S8(49232, "TLS_RSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49233, "TLS_RSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49234, "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49235, "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49236, "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49237, "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49238, "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49239, "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49240, "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49241, "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49242, "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49243, "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49244, "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49245, "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49246, "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49247, "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49248, "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49249, "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49250, "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49251, "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.B8(49252, "TLS_PSK_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49253, "TLS_PSK_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49254, "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49255, "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49256, "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49257, "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.S8(49258, "TLS_PSK_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49259, "TLS_PSK_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49260, "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49261, "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.S8(49262, "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256");
        TestSSLServer.S8(49263, "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384");
        TestSSLServer.B8(49264, "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256");
        TestSSLServer.B8(49265, "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384");
        TestSSLServer.B8(49266, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49267, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49268, "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49269, "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49270, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49271, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49272, "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49273, "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.S8(49274, "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49275, "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49276, "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49277, "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49278, "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49279, "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49280, "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49281, "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49282, "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49283, "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49284, "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49285, "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49286, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49287, "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49288, "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49289, "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49290, "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49291, "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49292, "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49293, "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49294, "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49295, "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49296, "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49297, "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.S8(49298, "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256");
        TestSSLServer.S8(49299, "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384");
        TestSSLServer.B8(49300, "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49301, "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49302, "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49303, "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49304, "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49305, "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.B8(49306, "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        TestSSLServer.B8(49307, "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        TestSSLServer.S8(49308, "TLS_RSA_WITH_AES_128_CCM");
        TestSSLServer.S8(49309, "TLS_RSA_WITH_AES_256_CCM");
        TestSSLServer.S8(49310, "TLS_DHE_RSA_WITH_AES_128_CCM");
        TestSSLServer.S8(49311, "TLS_DHE_RSA_WITH_AES_256_CCM");
        TestSSLServer.S8(49312, "TLS_RSA_WITH_AES_128_CCM_8");
        TestSSLServer.S8(49313, "TLS_RSA_WITH_AES_256_CCM_8");
        TestSSLServer.S8(49314, "TLS_DHE_RSA_WITH_AES_128_CCM_8");
        TestSSLServer.S8(49315, "TLS_DHE_RSA_WITH_AES_256_CCM_8");
        TestSSLServer.S8(49316, "TLS_PSK_WITH_AES_128_CCM");
        TestSSLServer.S8(49317, "TLS_PSK_WITH_AES_256_CCM");
        TestSSLServer.S8(49318, "TLS_DHE_PSK_WITH_AES_128_CCM");
        TestSSLServer.S8(49319, "TLS_DHE_PSK_WITH_AES_256_CCM");
        TestSSLServer.S8(49320, "TLS_PSK_WITH_AES_128_CCM_8");
        TestSSLServer.S8(49321, "TLS_PSK_WITH_AES_256_CCM_8");
        TestSSLServer.S8(49322, "TLS_PSK_DHE_WITH_AES_128_CCM_8");
        TestSSLServer.S8(49323, "TLS_PSK_DHE_WITH_AES_256_CCM_8");
    }

    static class CipherSuite {
        int suite;
        String name;
        boolean isCBC;
        int strength;

        CipherSuite() {
        }
    }

    static class ServerHelloSSLv2 {
        int[] cipherSuites;
        String serverCertName;
        String serverCertHash;

        ServerHelloSSLv2(InputStream inputStream) throws IOException {
            int n;
            int n2;
            byte[] byArray = new byte[2];
            TestSSLServer.readFully(inputStream, byArray);
            int n3 = TestSSLServer.dec16be(byArray, 0);
            if ((n3 & 0x8000) == 0) {
                throw new IOException("not a SSLv2 record");
            }
            if ((n3 &= Short.MAX_VALUE) < 11) {
                throw new IOException("not a SSLv2 server hello");
            }
            byArray = new byte[11];
            TestSSLServer.readFully(inputStream, byArray);
            if (byArray[0] != 4) {
                throw new IOException("not a SSLv2 server hello");
            }
            int n4 = TestSSLServer.dec16be(byArray, 5);
            if (n3 != 11 + n4 + (n2 = TestSSLServer.dec16be(byArray, 7)) + (n = TestSSLServer.dec16be(byArray, 9))) {
                throw new IOException("not a SSLv2 server hello");
            }
            if (n2 == 0 || n2 % 3 != 0) {
                throw new IOException("not a SSLv2 server hello");
            }
            byte[] byArray2 = new byte[n4];
            TestSSLServer.readFully(inputStream, byArray2);
            byte[] byArray3 = new byte[n2];
            TestSSLServer.readFully(inputStream, byArray3);
            byte[] byArray4 = new byte[n];
            TestSSLServer.readFully(inputStream, byArray4);
            this.cipherSuites = new int[n2 / 3];
            int n5 = 0;
            int n6 = 0;
            while (n5 < n2) {
                this.cipherSuites[n6] = TestSSLServer.dec24be(byArray3, n5);
                n5 += 3;
                ++n6;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                this.serverCertName = x509Certificate.getSubjectX500Principal().toString();
                this.serverCertHash = TestSSLServer.doSHA1(byArray2);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    static class ServerHello {
        int recordVersion;
        int protoVersion;
        long serverTime;
        int cipherSuite;
        int compression;
        String serverCertName;
        String serverCertHash;

        ServerHello(InputStream inputStream) throws IOException {
            InputRecord inputRecord = new InputRecord(inputStream);
            inputRecord.setExpectedType(22);
            byte[] byArray = new byte[4];
            TestSSLServer.readFully(inputRecord, byArray);
            this.recordVersion = inputRecord.getVersion();
            if (byArray[0] != 2) {
                throw new IOException("unexpected handshake message type: " + (byArray[0] & 0xFF));
            }
            byArray = new byte[TestSSLServer.dec24be(byArray, 1)];
            TestSSLServer.readFully(inputRecord, byArray);
            int n = 0;
            if (n + 2 > byArray.length) {
                throw new IOException("invalid ServerHello");
            }
            this.protoVersion = TestSSLServer.dec16be(byArray, 0);
            if ((n += 2) + 32 > byArray.length) {
                throw new IOException("invalid ServerHello");
            }
            this.serverTime = 1000L * ((long)TestSSLServer.dec32be(byArray, n) & 0xFFFFFFFFL);
            if ((n += 32) + 1 > byArray.length) {
                throw new IOException("invalid ServerHello");
            }
            if ((n += 1 + (byArray[n] & 0xFF)) + 3 > byArray.length) {
                throw new IOException("invalid ServerHello");
            }
            this.cipherSuite = TestSSLServer.dec16be(byArray, n);
            this.compression = byArray[n + 2] & 0xFF;
            while (true) {
                byArray = new byte[4];
                TestSSLServer.readFully(inputRecord, byArray);
                int n2 = byArray[0] & 0xFF;
                byArray = new byte[TestSSLServer.dec24be(byArray, 1)];
                TestSSLServer.readFully(inputRecord, byArray);
                switch (n2) {
                    case 11: {
                        this.processCertificate(byArray);
                        return;
                    }
                    case 14: {
                        return;
                    }
                }
            }
        }

        private void processCertificate(byte[] byArray) {
            if (byArray.length <= 6) {
                return;
            }
            int n = TestSSLServer.dec24be(byArray, 0);
            if (n != byArray.length - 3) {
                return;
            }
            int n2 = TestSSLServer.dec24be(byArray, 3);
            if (n2 > byArray.length - 6) {
                return;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 6, byArray2, 0, n2);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
                this.serverCertName = x509Certificate.getSubjectX500Principal().toString();
                this.serverCertHash = TestSSLServer.doSHA1(byArray2);
            }
            catch (CertificateException certificateException) {
                return;
            }
        }
    }

    static class InputRecord
    extends InputStream {
        private InputStream in;
        private byte[] buffer = new byte[16389];
        private int ptr;
        private int end;
        private int version;
        private int type;
        private int expectedType;

        InputRecord(InputStream inputStream) {
            this.in = inputStream;
            this.ptr = 0;
            this.end = 0;
        }

        void setExpectedType(int n) {
            this.expectedType = n;
        }

        int getVersion() {
            return this.version;
        }

        private void refill() throws IOException {
            block1: {
                do {
                    TestSSLServer.readFully(this.in, this.buffer, 0, 5);
                    this.type = this.buffer[0] & 0xFF;
                    this.version = TestSSLServer.dec16be(this.buffer, 1);
                    this.end = TestSSLServer.dec16be(this.buffer, 3);
                    TestSSLServer.readFully(this.in, this.buffer, 0, this.end);
                    this.ptr = 0;
                    if (this.type == this.expectedType) break block1;
                } while (this.type == 21);
                throw new IOException("unexpected record type: " + this.type);
            }
        }

        public int read() throws IOException {
            while (this.ptr == this.end) {
                this.refill();
            }
            return this.buffer[this.ptr++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            while (this.ptr == this.end) {
                this.refill();
            }
            int n3 = Math.min(this.end - this.ptr, n2);
            System.arraycopy(this.buffer, this.ptr, byArray, n, n3);
            this.ptr += n3;
            return n3;
        }
    }

    static class OutputRecord
    extends OutputStream {
        private OutputStream out;
        private byte[] buffer = new byte[16389];
        private int ptr;
        private int version;
        private int type;

        OutputRecord(OutputStream outputStream) {
            this.out = outputStream;
            this.ptr = 5;
        }

        void setType(int n) {
            this.type = n;
        }

        void setVersion(int n) {
            this.version = n;
        }

        public void flush() throws IOException {
            this.buffer[0] = (byte)this.type;
            TestSSLServer.enc16be(this.version, this.buffer, 1);
            TestSSLServer.enc16be(this.ptr - 5, this.buffer, 3);
            this.out.write(this.buffer, 0, this.ptr);
            this.out.flush();
            this.ptr = 5;
        }

        public void write(int n) throws IOException {
            this.buffer[this.ptr++] = (byte)n;
            if (this.ptr == this.buffer.length) {
                this.flush();
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Math.min(this.buffer.length - this.ptr, n2);
                System.arraycopy(byArray, n, this.buffer, this.ptr, n3);
                this.ptr += n3;
                n += n3;
                n2 -= n3;
                if (this.ptr != this.buffer.length) continue;
                this.flush();
            }
        }
    }
}

