/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.format;

import com.android.ide.eclipse.gltrace.GLProtoBuf;

public class GLDataTypeSpec {
    private final String mCType;
    private final GLProtoBuf.GLMessage.DataType.Type mType;
    private final String mName;
    private final boolean mIsPointer;

    public GLDataTypeSpec(String type, String name) {
        this.mCType = type;
        this.mName = name;
        this.mType = this.getDataType(type);
        this.mIsPointer = type.contains("*");
    }

    private GLProtoBuf.GLMessage.DataType.Type getDataType(String type) {
        if ((type = type.toLowerCase()).contains("boolean")) {
            return GLProtoBuf.GLMessage.DataType.Type.BOOL;
        }
        if (type.contains("enum")) {
            return GLProtoBuf.GLMessage.DataType.Type.ENUM;
        }
        if (type.contains("float") || type.contains("clampf")) {
            return GLProtoBuf.GLMessage.DataType.Type.FLOAT;
        }
        if (type.contains("void")) {
            return GLProtoBuf.GLMessage.DataType.Type.VOID;
        }
        if (type.contains("char")) {
            return GLProtoBuf.GLMessage.DataType.Type.CHAR;
        }
        return GLProtoBuf.GLMessage.DataType.Type.INT;
    }

    public GLProtoBuf.GLMessage.DataType.Type getDataType() {
        return this.mType;
    }

    public String getCType() {
        return this.mCType;
    }

    public String getArgName() {
        return this.mName;
    }

    public boolean isPointer() {
        return this.mIsPointer;
    }
}

