/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshot;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Screenshot {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String envSerial;
        boolean device = false;
        boolean emulator = false;
        String serial = null;
        String filepath = null;
        boolean landscape = false;
        if (args.length == 0) {
            Screenshot.printUsageAndQuit();
        }
        int index = 0;
        do {
            String argument;
            if ("-d".equals(argument = args[index++])) {
                if (emulator || serial != null) {
                    Screenshot.printAndExit("-d conflicts with -e and -s", false);
                }
                device = true;
                continue;
            }
            if ("-e".equals(argument)) {
                if (device || serial != null) {
                    Screenshot.printAndExit("-e conflicts with -d and -s", false);
                }
                emulator = true;
                continue;
            }
            if ("-s".equals(argument)) {
                if (index == args.length) {
                    Screenshot.printAndExit("Missing serial number after -s", false);
                }
                if (device || emulator) {
                    Screenshot.printAndExit("-s conflicts with -d and -e", false);
                }
                serial = args[index++];
                continue;
            }
            if ("-l".equals(argument)) {
                landscape = true;
                continue;
            }
            filepath = argument;
            if (index >= args.length) continue;
            Screenshot.printAndExit("Too many arguments!", false);
        } while (index < args.length);
        if (!device && !emulator && serial == null && (envSerial = System.getenv("ANDROID_SERIAL")) != null) {
            serial = envSerial;
        }
        if (filepath == null) {
            Screenshot.printUsageAndQuit();
        }
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(logLevel.getStringValue() + ":" + tag + ":" + message);
            }

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(logLevel.getStringValue() + ":" + tag + ":" + message);
            }
        });
        String adbLocation = Screenshot.getAdbLocation();
        AndroidDebugBridge.init((boolean)false);
        try {
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (count <= 100) continue;
                System.err.println("Timeout getting device list!");
                return;
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                Screenshot.printAndExit("No devices found!", true);
            }
            IDevice target = null;
            if (emulator || device) {
                for (IDevice d : devices) {
                    if (d.isEmulator() != emulator) continue;
                    if (target != null) {
                        if (emulator) {
                            Screenshot.printAndExit("Error: more than one emulator launched!", true);
                        } else {
                            Screenshot.printAndExit("Error: more than one device connected!", true);
                        }
                    }
                    target = d;
                }
            } else if (serial != null) {
                for (IDevice d : devices) {
                    if (!serial.equals(d.getSerialNumber())) continue;
                    target = d;
                    break;
                }
            } else {
                if (devices.length > 1) {
                    Screenshot.printAndExit("Error: more than one emulator or device available!", true);
                }
                target = devices[0];
            }
            if (target != null) {
                try {
                    System.out.println("Taking screenshot from: " + target.getSerialNumber());
                    Screenshot.getDeviceImage(target, filepath, landscape);
                    System.out.println("Success.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Screenshot.printAndExit("Could not find matching device/emulator.", true);
            }
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private static String getAdbLocation() {
        String adbLocation;
        String toolsDir = System.getProperty("com.android.screenshot.bindir");
        if (toolsDir == null) {
            return null;
        }
        File sdk = new File(toolsDir).getParentFile();
        File platformTools = new File(sdk, "platform-tools");
        File adb = new File(platformTools, SdkConstants.FN_ADB);
        if (adb.exists()) {
            return adb.getAbsolutePath();
        }
        adb = new File(toolsDir, SdkConstants.FN_ADB);
        if (adb.exists()) {
            return adb.getAbsolutePath();
        }
        String androidOut = System.getenv("ANDROID_HOST_OUT");
        if (androidOut != null && new File(adbLocation = androidOut + File.separator + "bin" + File.separator + SdkConstants.FN_ADB).exists()) {
            return adbLocation;
        }
        return null;
    }

    private static void getDeviceImage(IDevice device, String filepath, boolean landscape) throws IOException {
        RawImage rawImage;
        try {
            rawImage = device.getScreenshot();
        }
        catch (TimeoutException e) {
            Screenshot.printAndExit("Unable to get frame buffer: timeout", true);
            return;
        }
        catch (Exception ioe) {
            Screenshot.printAndExit("Unable to get frame buffer: " + ioe.getMessage(), true);
            return;
        }
        if (rawImage == null) {
            return;
        }
        if (landscape) {
            rawImage = rawImage.getRotated();
        }
        BufferedImage image = new BufferedImage(rawImage.width, rawImage.height, 2);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                image.setRGB(x, y, value);
            }
        }
        if (!ImageIO.write((RenderedImage)image, "png", new File(filepath))) {
            throw new IOException("Failed to find png writer");
        }
    }

    private static void printUsageAndQuit() {
        System.out.println("Usage: screenshot2 [-d | -e | -s SERIAL] [-l] OUT_FILE");
        System.out.println("");
        System.out.println("    -d      Uses the first device found.");
        System.out.println("    -e      Uses the first emulator found.");
        System.out.println("    -s      Targets the device by serial number.");
        System.out.println("");
        System.out.println("    -l      Rotate images for landscape mode.");
        System.out.println("");
        System.exit(1);
    }

    private static void printAndExit(String message, boolean terminate) {
        System.out.println(message);
        if (terminate) {
            AndroidDebugBridge.terminate();
        }
        System.exit(1);
    }
}

