/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.felix.scr.Component;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentContextImpl;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.impl.ReadOnlyDictionary;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class ServiceComponentProp
implements Component,
PrivilegedExceptionAction {
    public ServiceRegistration registration;
    public String name;
    public ServiceComponent serviceComponent;
    public Hashtable properties;
    public Vector instances = new Vector(2);
    public BundleContext bc;
    public Vector references;
    protected boolean isComponentFactory = false;
    private int state = 4;
    protected Vector delayActivateSCPNames;
    private SCRManager mgr;
    private ReadOnlyDictionary readOnlyProps;
    private static long componentid = 0L;
    boolean locked = false;
    int waiting = 0;
    Bundle bundle;
    Object inst;

    public ServiceComponentProp(ServiceComponent serviceComponent, Dictionary configProperties, SCRManager mgr) {
        this.serviceComponent = serviceComponent;
        this.name = serviceComponent.name;
        this.bc = serviceComponent.bc;
        this.properties = this.initProperties(configProperties, null);
        this.isComponentFactory = serviceComponent.factory != null;
        this.mgr = mgr;
    }

    public void dispose(int deactivateReason) {
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.dispose(): " + this.name, null);
        }
        try {
            while (!this.instances.isEmpty()) {
                ComponentInstanceImpl current = (ComponentInstanceImpl)this.instances.firstElement();
                this.dispose(current, deactivateReason);
                current.dispose();
            }
        }
        finally {
            this.setState(4);
        }
    }

    public Dictionary getProperties() {
        if (this.readOnlyProps == null) {
            this.readOnlyProps = new ReadOnlyDictionary(this.properties != null ? this.properties : this.serviceComponent.properties);
        } else {
            this.readOnlyProps.updateDelegate(this.properties != null ? this.properties : this.serviceComponent.properties);
        }
        return this.readOnlyProps;
    }

    public void activate(Bundle usingBundle, ComponentInstanceImpl componentInstance) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ServiceComponentProp.activate(): name: " + this.name, null);
            Activator.log.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ServiceComponentProp.activate(): using bundle: " + (usingBundle != null ? usingBundle.getSymbolicName() : null), null);
            Activator.log.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ServiceComponentProp.activate(): instance: " + componentInstance.toString(), null);
        }
        this.serviceComponent.activate(componentInstance.getInstance(), componentInstance.getComponentContext());
    }

    private void deactivate(ComponentInstanceImpl componentInstance, int deactivateReason) {
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.deactivate(): " + this.name, null);
        }
        this.serviceComponent.deactivate(componentInstance.getInstance(), componentInstance.getComponentContext(), deactivateReason);
    }

    public void modify(Dictionary newProps) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ServiceComponentProp.modify(): name: " + this.name, null);
        }
        Hashtable oldProperties = null;
        if (this.references != null && this.references.size() > 0) {
            oldProperties = (Hashtable)this.properties.clone();
        }
        this.properties = this.initProperties(newProps, (Long)this.properties.get("component.id"));
        int i = 0;
        while (i < this.instances.size()) {
            ComponentInstanceImpl componentInstance = (ComponentInstanceImpl)this.instances.elementAt(i);
            Activator.log.debug("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ServiceComponentProp.modify(): instance: " + componentInstance.toString(), null);
            this.serviceComponent.modified(componentInstance.getInstance(), componentInstance.getComponentContext());
            ++i;
        }
        if (oldProperties != null) {
            this.handleBoundServicesUpdate(oldProperties, this.properties);
        }
        if (this.registration != null) {
            this.registration.setProperties((Dictionary)this.getPublicServiceProperties());
        }
    }

    public boolean bind(ComponentInstance componentInstance) throws Exception {
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                Reference ref = (Reference)this.references.elementAt(i);
                ClassCircularityError ccError = null;
                if (ref.reference.bind != null) {
                    try {
                        this.bindReference(ref, componentInstance);
                    }
                    catch (ClassCircularityError cce) {
                        ccError = cce;
                        Activator.log(this.bc, 1, NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)ref.reference), cce);
                    }
                    if (ref.reference.bindMethod == null || ccError != null || !ref.isBound()) {
                        Activator.log(null, 1, "Could not bind a reference of component " + this.name + ". The reference is: " + ref.reference, null);
                        if (ccError != null) {
                            int j = i - 1;
                            while (j >= 0) {
                                ref = (Reference)this.references.elementAt(j);
                                if (ref.reference.unbind != null) {
                                    this.unbindReference(ref, componentInstance);
                                }
                                --j;
                            }
                            throw ccError;
                        }
                    }
                } else if (Activator.DEBUG) {
                    Activator.log.debug("ServiceComponentProp.bind(): the folowing reference doesn't specify bind method: " + ref.reference.name, null);
                }
                ++i;
            }
        }
        return true;
    }

    public void unbind(ComponentInstance componentInstance) {
        if (this.references != null) {
            int i = this.references.size() - 1;
            while (i >= 0) {
                Reference ref = (Reference)this.references.elementAt(i);
                if (ref.reference.unbind != null) {
                    this.unbindReference(ref, componentInstance);
                }
                --i;
            }
        }
    }

    public Object createInstance() throws Exception {
        this.assertCreateSingleInstance();
        return this.serviceComponent.createInstance();
    }

    synchronized void lock(Bundle usingBundle, Object instance) {
        while (this.locked) {
            try {
                ++this.waiting;
                this.wait();
            }
            catch (Exception exception) {}
            --this.waiting;
        }
        this.locked = true;
        this.bundle = usingBundle;
        this.inst = instance;
    }

    synchronized void unlock() {
        this.locked = false;
        this.bundle = null;
        this.inst = null;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }

    public Object run() throws Exception {
        Bundle b = this.bundle;
        Object instance = this.inst;
        this.unlock();
        return this.build(b, instance, false);
    }

    public ComponentInstanceImpl build(Bundle usingBundle, Object instance, boolean security) throws Exception {
        if (this.getState() == 256) {
            if (Activator.DEBUG) {
                Activator.log.debug("Cannot build component, because it is already disposed: " + this, null);
            }
            return null;
        }
        if (security) {
            this.lock(usingBundle, instance);
            try {
                return (ComponentInstanceImpl)AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {}
        }
        ComponentInstanceImpl componentInstance = null;
        if (instance == null) {
            if (!this.serviceComponent.serviceFactory) {
                if (this.instances.isEmpty()) {
                    instance = this.createInstance();
                } else {
                    componentInstance = (ComponentInstanceImpl)this.instances.firstElement();
                }
            } else {
                instance = this.createInstance();
            }
        }
        if (componentInstance == null) {
            componentInstance = new ComponentInstanceImpl(instance, this);
            componentInstance.setComponentContext(new ComponentContextImpl(this, usingBundle, componentInstance, this.mgr));
            this.instances.addElement(componentInstance);
            if (this.bind(componentInstance)) {
                try {
                    this.activate(usingBundle, componentInstance);
                }
                catch (Exception e) {
                    InstanceProcess.resolver.removeFromSatisfiedList(this);
                    if (this.instances.removeElement(componentInstance)) {
                        this.unbind(componentInstance);
                    }
                    throw e;
                }
            } else {
                InstanceProcess.resolver.removeFromSatisfiedList(this);
                this.instances.removeElement(componentInstance);
                throw new ComponentException(NLS.bind((String)Messages.COMPONENT_WAS_NOT_BUILT, (Object)this.serviceComponent));
            }
        }
        this.setState(16);
        return componentInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeObj(Object obj, int deactivateReason) {
        ComponentInstanceImpl ci = null;
        Vector vector = this.instances;
        synchronized (vector) {
            int i = 0;
            while (i < this.instances.size()) {
                ci = (ComponentInstanceImpl)this.instances.elementAt(i);
                if (ci.getInstance() == obj) break;
                ci = null;
                ++i;
            }
        }
        if (ci != null) {
            this.dispose(ci, deactivateReason);
            return;
        }
        throw new RuntimeException(NLS.bind((String)Messages.INVALID_OBJECT, (Object)obj, (Object)this.name));
    }

    public void dispose(ComponentInstanceImpl componentInstance, int deactivateReason) {
        if (!this.instances.removeElement(componentInstance)) {
            return;
        }
        this.deactivate(componentInstance, deactivateReason);
        this.unbind(componentInstance);
        if (this.instances.isEmpty()) {
            this.setState(32);
        }
    }

    public void bindReference(Reference reference, ComponentInstance componentInstance) throws Exception {
        block13: {
            block14: {
                ServiceReference[] serviceReferences;
                block15: {
                    if (Activator.DEBUG) {
                        Activator.log.debug("ServiceComponentProp.bindReference(): component " + this.serviceComponent.name + " -> " + reference.reference, null);
                    }
                    serviceReferences = null;
                    try {
                        serviceReferences = this.bc.getServiceReferences(reference.reference.interfaceName, reference.getTarget());
                    }
                    catch (Exception e) {
                        Activator.log(this.bc, 1, NLS.bind((String)Messages.CANNOT_GET_REFERENCES, (Object)reference.reference.interfaceName), e);
                        throw e;
                    }
                    if (serviceReferences == null || serviceReferences.length <= 0) break block14;
                    if (reference.reference.bind == null) break block15;
                    block1 : switch (reference.reference.cardinality) {
                        case 0: 
                        case 2: {
                            int i = 0;
                            while (i < serviceReferences.length) {
                                ServiceReference oldBoundService = reference.reference.policy_option == 1 && reference.reference.serviceReferences.size() > 0 ? (ServiceReference)reference.reference.serviceReferences.keys().nextElement() : null;
                                boolean bound = reference.reference.bind(reference, componentInstance, serviceReferences[i]);
                                if (bound) {
                                    if (oldBoundService != null) {
                                        reference.reference.unbind(reference, componentInstance, oldBoundService);
                                        break block1;
                                    }
                                    break block13;
                                }
                                ++i;
                            }
                            break block13;
                        }
                        case 1: 
                        case 3: {
                            int i = 0;
                            while (i < serviceReferences.length) {
                                reference.reference.bind(reference, componentInstance, serviceReferences[i]);
                                ++i;
                            }
                            break block1;
                        }
                    }
                    break block13;
                }
                if (reference.reference.policy == 0) {
                    reference.setBoundServiceReferences(serviceReferences);
                }
                break block13;
            }
            if (Activator.DEBUG) {
                Activator.log.debug("ServiceComponentProp.bindReference(): The service is not yet registered, but it is already instantiated", null);
            }
        }
    }

    private void handleBoundServicesUpdate(Hashtable oldProps, Dictionary newProps) {
        String key;
        Enumeration keys = oldProps.keys();
        Vector<String> checkedFilters = new Vector<String>();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.endsWith(".target")) continue;
            checkedFilters.addElement(key);
            String newFilter = (String)newProps.get(key);
            Reference reference = null;
            String refName = key.substring(0, key.length() - ".target".length());
            int i = 0;
            while (i < this.references.size()) {
                reference = (Reference)this.references.elementAt(i);
                if (reference.reference.name.equals(refName)) break;
                reference = null;
                ++i;
            }
            if (reference == null || reference.reference.policy != 1) continue;
            if (newFilter != null) {
                if (newFilter.equals(oldProps.get(key))) continue;
                this.processReferenceBoundServices(reference, newFilter);
                continue;
            }
            this.processReferenceBoundServices(reference, "(objectClass=" + reference.reference.interfaceName + ")");
        }
        keys = newProps.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.endsWith(".target") || checkedFilters.contains(key)) continue;
            Reference reference = null;
            String refName = key.substring(0, key.length() - ".target".length());
            int i = 0;
            while (i < this.references.size()) {
                reference = (Reference)this.references.elementAt(i);
                if (reference.reference.name.equals(refName)) break;
                reference = null;
                ++i;
            }
            if (reference == null || reference.reference.policy != 1) continue;
            this.processReferenceBoundServices(reference, (String)newProps.get(key));
        }
    }

    private void processReferenceBoundServices(Reference reference, String newTargetFilter) {
        block19: {
            ServiceReference[] refs;
            block18: {
                reference.setTarget(newTargetFilter);
                refs = null;
                try {
                    refs = this.bc.getServiceReferences(reference.reference.interfaceName, newTargetFilter);
                }
                catch (InvalidSyntaxException e) {
                    Activator.log(this.bc, 2, "[SCR] " + NLS.bind((String)Messages.INVALID_TARGET_FILTER, (Object)newTargetFilter), e);
                    return;
                }
                if (refs != null) break block18;
                if (reference.reference.bind == null || reference.reference.serviceReferences.size() <= 0) break block19;
                int i = 0;
                while (i < this.instances.size()) {
                    ComponentInstance componentInstance = (ComponentInstance)this.instances.elementAt(i);
                    this.unbindReference(reference, componentInstance);
                    ++i;
                }
                break block19;
            }
            if (reference.reference.bind != null) {
                boolean found;
                Vector servicesToUnbind = new Vector();
                Enumeration keys = reference.reference.serviceReferences.keys();
                while (keys.hasMoreElements()) {
                    Object serviceRef = keys.nextElement();
                    found = false;
                    int i = 0;
                    while (i < refs.length) {
                        if (refs[i] == serviceRef) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) continue;
                    servicesToUnbind.addElement(serviceRef);
                }
                if ((reference.reference.cardinality == 1 || reference.reference.cardinality == 3) && reference.reference.serviceReferences.size() - servicesToUnbind.size() < refs.length) {
                    int i = 0;
                    while (i < refs.length) {
                        keys = reference.reference.serviceReferences.keys();
                        found = false;
                        while (keys.hasMoreElements()) {
                            Object serviceRef = keys.nextElement();
                            if (serviceRef != refs[i]) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            int j = 0;
                            while (j < this.instances.size()) {
                                ComponentInstance componentInstance = (ComponentInstance)this.instances.elementAt(j);
                                try {
                                    reference.reference.bind(reference, componentInstance, refs[i]);
                                }
                                catch (Exception e) {
                                    Activator.log(null, 1, NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)reference), e);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < servicesToUnbind.size()) {
                    int j = 0;
                    while (j < this.instances.size()) {
                        ComponentInstance componentInstance = (ComponentInstance)this.instances.elementAt(j);
                        try {
                            this.unbindDynamicReference(reference, componentInstance, (ServiceReference)servicesToUnbind.elementAt(i));
                        }
                        catch (Exception e) {
                            Activator.log(null, 1, NLS.bind((String)Messages.ERROR_UNBINDING_REFERENCE2, (Object)reference), e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void unbindReference(Reference reference, ComponentInstance componentInstance) {
        if (reference.reference.unbind == null) {
            return;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.unbindReference(): component " + this.serviceComponent.name + " <- " + reference.reference, null);
        }
        Enumeration serviceReferences = reference.reference.serviceReferences.keys();
        while (serviceReferences.hasMoreElements()) {
            reference.reference.unbind(reference, componentInstance, (ServiceReference)serviceReferences.nextElement());
        }
    }

    public void unbindDynamicReference(Reference ref, ComponentInstance instance, ServiceReference serviceReference) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.unbindDynamicReference(): component = " + this.name + ", reference = " + ref.reference.name, null);
        }
        switch (ref.reference.cardinality) {
            case 0: 
            case 2: {
                if (ref.reference.bind == null) break;
                this.bindReference(ref, instance);
            }
        }
        ref.reference.unbind(ref, instance, serviceReference);
    }

    public void updatedReference(Reference ref, ComponentInstance instance, ServiceReference serviceReference) {
        if (Activator.DEBUG) {
            Activator.log.debug("ServiceComponentProp.updatedReference(): component = " + this.name + ", reference = " + ref.reference.name, null);
        }
        ref.reference.updated(ref, instance, serviceReference);
    }

    private Hashtable initProperties(Dictionary configProperties, Long componentId) {
        Hashtable<String, Object> result = null;
        Properties propertyDescriptions = this.serviceComponent.properties;
        if (propertyDescriptions != null && !propertyDescriptions.isEmpty()) {
            result = (Hashtable<String, Object>)propertyDescriptions.clone();
        }
        if (result == null) {
            result = new Hashtable<String, Object>(7);
        }
        if (this.serviceComponent.references != null) {
            int i = 0;
            while (i < this.serviceComponent.references.size()) {
                ComponentReference ref = (ComponentReference)this.serviceComponent.references.elementAt(i);
                if (ref.target != null) {
                    result.put(String.valueOf(ref.name) + ".target", ref.target);
                }
                ++i;
            }
        }
        if (configProperties != null && !configProperties.isEmpty()) {
            Enumeration keys = configProperties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object val = configProperties.get(key);
                result.put((String)key, val);
            }
        }
        Long nextId = componentId == null ? new Long(ServiceComponentProp.getNewComponentID()) : componentId;
        result.put("component.id", nextId);
        result.put("component.name", this.serviceComponent.name);
        if (this.serviceComponent.provides != null) {
            String[] provides = new String[this.serviceComponent.provides.length];
            System.arraycopy(this.serviceComponent.provides, 0, provides, 0, provides.length);
            result.put("objectClass", provides);
        }
        return result;
    }

    private void assertCreateSingleInstance() {
        if (!this.serviceComponent.serviceFactory && !this.instances.isEmpty()) {
            throw new ComponentException(NLS.bind((String)Messages.INSTANCE_ALREADY_CREATED, (Object)this.name));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ServiceComponentProp[");
        buffer.append("\n\tname = ").append(this.name);
        buffer.append("\n\tstate = ").append(SCRUtil.getStateStringRepresentation(this.state));
        StringBuffer buf = new StringBuffer(200);
        if (this.properties != null) {
            buf.append('{');
            Enumeration keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                buf.append(key).append('=').append(SCRUtil.getStringRepresentation(this.properties.get(key)));
                if (!keys.hasMoreElements()) continue;
                buf.append(", ");
            }
            buf.append('}');
        }
        buffer.append("\n\tproperties = ").append(((Object)buf).toString());
        buffer.append("]");
        return ((Object)buffer).toString();
    }

    public void setRegistration(ServiceRegistration reg) {
        this.registration = reg;
    }

    public Hashtable getPublicServiceProperties() {
        Hashtable publicProps = (Hashtable)this.properties.clone();
        Enumeration keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(".")) continue;
            publicProps.remove(key);
        }
        return publicProps;
    }

    public void setDelayActivateSCPName(String scpName) {
        if (Activator.DEBUG) {
            Activator.log.debug("Setting delay activate SCP: " + scpName, null);
        }
        if (this.delayActivateSCPNames == null) {
            this.delayActivateSCPNames = new Vector(1);
            this.delayActivateSCPNames.addElement(scpName);
        } else if (!this.delayActivateSCPNames.contains(scpName)) {
            this.delayActivateSCPNames.addElement(scpName);
        }
    }

    public Vector getDelayActivateSCPNames() {
        return this.delayActivateSCPNames;
    }

    public boolean isComponentFactory() {
        return this.isComponentFactory;
    }

    public void setComponentFactory(boolean isComponentFactory) {
        this.isComponentFactory = isComponentFactory;
    }

    static synchronized long getNewComponentID() {
        return componentid++;
    }

    public boolean isKindOfFactory() {
        return this.serviceComponent.serviceFactory;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public void disable() {
        if (this.getState() == 256) {
            throw new IllegalStateException(Messages.COMPONENT_DISPOSED);
        }
        if (this.getState() != 1) {
            this.mgr.disableComponent(this.serviceComponent.name, this.serviceComponent.bundle);
        }
    }

    public void enable() {
        if (this.getState() == 256) {
            throw new IllegalStateException(Messages.COMPONENT_DISPOSED);
        }
        if (this.getState() == 1) {
            this.mgr.enableComponent(this.serviceComponent.name, this.serviceComponent.bundle);
        }
    }

    public String getActivate() {
        return this.serviceComponent.activateMethodName;
    }

    public Bundle getBundle() {
        return this.serviceComponent.bundle;
    }

    public String getClassName() {
        return this.serviceComponent.implementation;
    }

    public ComponentInstance getComponentInstance() {
        if (!this.instances.isEmpty()) {
            return (ComponentInstance)this.instances.firstElement();
        }
        return null;
    }

    public String getConfigurationPolicy() {
        return this.serviceComponent.configurationPolicy;
    }

    public String getDeactivate() {
        return this.serviceComponent.deactivateMethodName;
    }

    public String getFactory() {
        return this.serviceComponent.factory;
    }

    public long getId() {
        return (Long)this.properties.get("component.id");
    }

    public String getModified() {
        if (!this.serviceComponent.isNamespaceAtLeast11()) {
            return null;
        }
        return this.serviceComponent.modifyMethodName;
    }

    public String getName() {
        return this.serviceComponent.name;
    }

    public org.apache.felix.scr.Reference[] getReferences() {
        if (this.references != null && !this.references.isEmpty()) {
            Object[] res = new org.apache.felix.scr.Reference[this.references.size()];
            this.references.copyInto(res);
            return res;
        }
        return null;
    }

    public String[] getServices() {
        return this.serviceComponent.provides;
    }

    public boolean isActivateDeclared() {
        if (!this.serviceComponent.isNamespaceAtLeast11()) {
            return false;
        }
        return this.serviceComponent.activateMethodDeclared;
    }

    public boolean isDeactivateDeclared() {
        if (!this.serviceComponent.isNamespaceAtLeast11()) {
            return false;
        }
        return this.serviceComponent.deactivateMethodDeclared;
    }

    public boolean isDefaultEnabled() {
        return this.serviceComponent.autoenable;
    }

    public boolean isImmediate() {
        return this.serviceComponent.isImmediate();
    }

    public boolean isServiceFactory() {
        return this.serviceComponent.serviceFactory;
    }

    public boolean isBuilt() {
        return this.state == 8 || this.state == 16 || this.state == 64 || this.state == 32;
    }

    public boolean isUnsatisfied() {
        return this.state == 4 || this.state == 128 || this.state == 1 || this.state == 2048 || this.state == 256;
    }
}

