/*
 * Decompiled with CFR 0.152.
 */
package com.android.xml;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.xml.AndroidXPathFactory;
import com.google.common.io.Closeables;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.InputSource;

public final class AndroidManifest {
    public static final String NODE_MANIFEST = "manifest";
    public static final String NODE_APPLICATION = "application";
    public static final String NODE_ACTIVITY = "activity";
    public static final String NODE_ACTIVITY_ALIAS = "activity-alias";
    public static final String NODE_SERVICE = "service";
    public static final String NODE_RECEIVER = "receiver";
    public static final String NODE_PROVIDER = "provider";
    public static final String NODE_INTENT = "intent-filter";
    public static final String NODE_ACTION = "action";
    public static final String NODE_CATEGORY = "category";
    public static final String NODE_USES_SDK = "uses-sdk";
    public static final String NODE_PERMISSION = "permission";
    public static final String NODE_PERMISSION_TREE = "permission-tree";
    public static final String NODE_PERMISSION_GROUP = "permission-group";
    public static final String NODE_USES_PERMISSION = "uses-permission";
    public static final String NODE_INSTRUMENTATION = "instrumentation";
    public static final String NODE_USES_LIBRARY = "uses-library";
    public static final String NODE_SUPPORTS_SCREENS = "supports-screens";
    public static final String NODE_COMPATIBLE_SCREENS = "compatible-screens";
    public static final String NODE_USES_CONFIGURATION = "uses-configuration";
    public static final String NODE_USES_FEATURE = "uses-feature";
    public static final String NODE_METADATA = "meta-data";
    public static final String NODE_DATA = "data";
    public static final String NODE_GRANT_URI_PERMISSION = "grant-uri-permission";
    public static final String NODE_PATH_PERMISSION = "path-permission";
    public static final String NODE_SUPPORTS_GL_TEXTURE = "supports-gl-texture";
    public static final String ATTRIBUTE_PACKAGE = "package";
    public static final String ATTRIBUTE_VERSIONCODE = "versionCode";
    public static final String ATTRIBUTE_VERSIONNAME = "versionName";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_MIME_TYPE = "mimeType";
    public static final String ATTRIBUTE_PORT = "port";
    public static final String ATTRIBUTE_REQUIRED = "required";
    public static final String ATTRIBUTE_GLESVERSION = "glEsVersion";
    public static final String ATTRIBUTE_PROCESS = "process";
    public static final String ATTRIBUTE_DEBUGGABLE = "debuggable";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_MIN_SDK_VERSION = "minSdkVersion";
    public static final String ATTRIBUTE_TARGET_SDK_VERSION = "targetSdkVersion";
    public static final String ATTRIBUTE_TARGET_PACKAGE = "targetPackage";
    public static final String ATTRIBUTE_FUNCTIONAL_TEST = "functionalTest";
    public static final String ATTRIBUTE_HANDLE_PROFILING = "handleProfiling";
    public static final String ATTRIBUTE_INSTRUMENTATION_LABEL = "label";
    public static final String ATTRIBUTE_TARGET_ACTIVITY = "targetActivity";
    public static final String ATTRIBUTE_MANAGE_SPACE_ACTIVITY = "manageSpaceActivity";
    public static final String ATTRIBUTE_EXPORTED = "exported";
    public static final String ATTRIBUTE_RESIZEABLE = "resizeable";
    public static final String ATTRIBUTE_ANYDENSITY = "anyDensity";
    public static final String ATTRIBUTE_SMALLSCREENS = "smallScreens";
    public static final String ATTRIBUTE_NORMALSCREENS = "normalScreens";
    public static final String ATTRIBUTE_LARGESCREENS = "largeScreens";
    public static final String ATTRIBUTE_REQ_5WAYNAV = "reqFiveWayNav";
    public static final String ATTRIBUTE_REQ_NAVIGATION = "reqNavigation";
    public static final String ATTRIBUTE_REQ_HARDKEYBOARD = "reqHardKeyboard";
    public static final String ATTRIBUTE_REQ_KEYBOARDTYPE = "reqKeyboardType";
    public static final String ATTRIBUTE_REQ_TOUCHSCREEN = "reqTouchScreen";
    public static final String ATTRIBUTE_THEME = "theme";
    public static final String ATTRIBUTE_BACKUP_AGENT = "backupAgent";
    public static final String ATTRIBUTE_PARENT_ACTIVITY_NAME = "parentActivityName";
    public static final String ATTRIBUTE_SUPPORTS_RTL = "supportsRtl";
    public static final String ATTRIBUTE_UI_OPTIONS = "uiOptions";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_EXTRACT_NATIVE_LIBS = "extractNativeLibs";
    public static final String ATTRIBUTE_SPLIT = "split";
    public static final String VALUE_PARENT_ACTIVITY = "android.support.PARENT_ACTIVITY";

    public static IAbstractFile getManifest(IAbstractFolder projectFolder) {
        IAbstractFile file = projectFolder.getFile("AndroidManifest.xml");
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static String getPackage(IAbstractFolder projectFolder) throws StreamException {
        IAbstractFile file = AndroidManifest.getManifest(projectFolder);
        if (file != null) {
            return AndroidManifest.getPackage(file);
        }
        return null;
    }

    public static String getPackage(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getPackageXPath());
    }

    public static String getPackageXPath() {
        return "/manifest/@package";
    }

    public static String getSplit(IAbstractFolder projectFolder) throws StreamException {
        IAbstractFile file = AndroidManifest.getManifest(projectFolder);
        if (file != null) {
            return AndroidManifest.getSplit(file);
        }
        return null;
    }

    public static String getSplit(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getSplitXPath());
    }

    public static String getSplitXPath() {
        return "/manifest/@split";
    }

    public static boolean getDebuggable(IAbstractFile manifestFile) throws StreamException {
        String value = AndroidManifest.getStringValue(manifestFile, "/manifest/application/@android:debuggable");
        return Boolean.parseBoolean(value);
    }

    public static int getVersionCode(IAbstractFile manifestFile) throws StreamException {
        String result = AndroidManifest.getStringValue(manifestFile, AndroidManifest.getVersionCodeXPath());
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getVersionCodeXPath() {
        return "/manifest/@android:versionCode";
    }

    public static boolean hasVersionCode(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getVersionCode(manifestFile) != -1;
    }

    public static String getVersionNameXPath() {
        return "/manifest/@android:versionName";
    }

    public static Object getMinSdkVersion(IAbstractFile manifestFile) throws StreamException {
        String result = AndroidManifest.getStringValue(manifestFile, AndroidManifest.getMinSdkVersionXPath());
        try {
            return Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return !result.isEmpty() ? result : null;
        }
    }

    public static String getMinSdkVersionXPath() {
        return "/manifest/uses-sdk/@android:minSdkVersion";
    }

    public static Object getTargetSdkVersion(IAbstractFile manifestFile) throws StreamException {
        String result = AndroidManifest.getStringValue(manifestFile, AndroidManifest.getTargetSdkVersionXPath());
        try {
            return Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return !result.isEmpty() ? result : null;
        }
    }

    public static String getTargetSdkVersionXPath() {
        return "/manifest/uses-sdk/@android:targetSdkVersion";
    }

    public static String getExtractNativeLibsXPath() {
        return "/manifest/application/@android:extractNativeLibs";
    }

    public static String getApplicationIcon(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, "/manifest/application/@android:icon");
    }

    public static String getApplicationLabel(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, "/manifest/application/@android:label");
    }

    public static boolean getSupportsRtl(IAbstractFile manifestFile) throws StreamException {
        String value = AndroidManifest.getStringValue(manifestFile, "/manifest/application/@android:supportsRtl");
        return Boolean.parseBoolean(value);
    }

    public static String getTestInstrumentationRunner(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getInstrumentationRunnerXPath());
    }

    public static String getInstrumentationRunnerXPath() {
        return "/manifest/instrumentation/@android:name";
    }

    public static String getTestTargetPackage(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getTestTargetPackageXPath());
    }

    public static String getTestTargetPackageXPath() {
        return "/manifest/instrumentation/@android:targetPackage";
    }

    public static String getTestFunctionalTest(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getTestFunctionalTestXPath());
    }

    public static String getTestFunctionalTestXPath() {
        return "/manifest/instrumentation/@android:functionalTest";
    }

    public static String getTestHandleProfiling(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getTestHandleProfilingXPath());
    }

    public static String getTestHandleProfilingXPath() {
        return "/manifest/instrumentation/@android:handleProfiling";
    }

    public static String getTestLabel(IAbstractFile manifestFile) throws StreamException {
        return AndroidManifest.getStringValue(manifestFile, AndroidManifest.getTestLabelXPath());
    }

    public static String getTestLabelXPath() {
        return "/manifest/instrumentation/@android:label";
    }

    public static String combinePackageAndClassName(String javaPackage, String className) {
        boolean hasDot;
        if (className == null || className.isEmpty()) {
            return javaPackage;
        }
        if (javaPackage == null || javaPackage.isEmpty()) {
            return className;
        }
        boolean startWithDot = className.charAt(0) == '.';
        boolean bl = hasDot = className.indexOf(46) != -1;
        if (startWithDot || !hasDot) {
            if (startWithDot) {
                return javaPackage + className;
            }
            return javaPackage + '.' + className;
        }
        return className;
    }

    public static String extractActivityName(String fullActivityName, String packageName) {
        String name;
        if (packageName != null && fullActivityName != null && !packageName.isEmpty() && fullActivityName.startsWith(packageName) && !(name = fullActivityName.substring(packageName.length())).isEmpty() && name.charAt(0) == '.') {
            return name;
        }
        return fullActivityName;
    }

    private static String getStringValue(IAbstractFile file, String xPath) throws StreamException {
        XPath xpath = AndroidXPathFactory.newXPath();
        InputStream is = null;
        try {
            is = file.getContents();
            String string = xpath.evaluate(xPath, new InputSource(is));
            return string;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Malformed XPath expression when reading the attribute from the manifest,exp = " + xPath, e);
        }
        finally {
            Closeables.closeQuietly(is);
        }
    }
}

