/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrozenSet;
import org.python.core.PyFrozenSetDerived;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PySetDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSet
extends PyObject
implements Set {
    protected Set<PyObject> _set;

    protected BaseSet(PyType type, Set<PyObject> set) {
        super(type);
        this._set = set;
    }

    protected void _update(PyObject data) {
        BaseSet._update(this._set, data);
    }

    protected static Set<PyObject> _update(Set<PyObject> set, PyObject data) {
        if (data == null) {
            return set;
        }
        if (data instanceof BaseSet) {
            set.addAll(((BaseSet)data)._set);
            return set;
        }
        for (PyObject item : data.asIterable()) {
            set.add(item);
        }
        return set;
    }

    @Override
    public PyObject __or__(PyObject other) {
        return this.baseset___or__(other);
    }

    final PyObject baseset___or__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_union(other);
    }

    @Override
    public PyObject __and__(PyObject other) {
        return this.baseset___and__(other);
    }

    final PyObject baseset___and__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_intersection(other);
    }

    @Override
    public PyObject __sub__(PyObject other) {
        return this.baseset___sub__(other);
    }

    final PyObject baseset___sub__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_difference(other);
    }

    public PyObject difference(PyObject other) {
        return this.baseset_difference(other);
    }

    final PyObject baseset_difference(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        Set<PyObject> set = bs._set;
        BaseSet o = BaseSet.makeNewSet(this.getType());
        for (PyObject p : this._set) {
            if (set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    @Override
    public PyObject __xor__(PyObject other) {
        return this.baseset___xor__(other);
    }

    final PyObject baseset___xor__(PyObject other) {
        if (!(other instanceof BaseSet)) {
            return null;
        }
        return this.baseset_symmetric_difference(other);
    }

    public PyObject symmetric_difference(PyObject other) {
        return this.baseset_symmetric_difference(other);
    }

    final PyObject baseset_symmetric_difference(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        BaseSet o = BaseSet.makeNewSet(this.getType());
        for (PyObject p : this._set) {
            if (bs._set.contains(p)) continue;
            o._set.add(p);
        }
        for (PyObject p : bs._set) {
            if (this._set.contains(p)) continue;
            o._set.add(p);
        }
        return o;
    }

    @Override
    public abstract int hashCode();

    @Override
    public int __len__() {
        return this.baseset___len__();
    }

    final int baseset___len__() {
        return this._set.size();
    }

    @Override
    public boolean __nonzero__() {
        return !this._set.isEmpty();
    }

    @Override
    public PyObject __iter__() {
        return this.baseset___iter__();
    }

    final PyObject baseset___iter__() {
        return new PyIterator(){
            private int size;
            private Iterator<PyObject> iterator;
            {
                this.size = BaseSet.this.size();
                this.iterator = BaseSet.this._set.iterator();
            }

            public PyObject __iternext__() {
                if (this.size != BaseSet.this.size()) {
                    throw Py.RuntimeError("set changed size during iteration");
                }
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }
        };
    }

    @Override
    public boolean __contains__(PyObject other) {
        return this.baseset___contains__(other);
    }

    final boolean baseset___contains__(PyObject other) {
        try {
            return this._set.contains(other);
        }
        catch (PyException pye) {
            PyFrozenSet frozen = this.asFrozen(pye, other);
            return this._set.contains(frozen);
        }
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.baseset___cmp__(other);
    }

    final int baseset___cmp__(PyObject other) {
        throw Py.TypeError("cannot compare sets using cmp()");
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.baseset___eq__(other);
    }

    final PyObject baseset___eq__(PyObject other) {
        if (other instanceof BaseSet) {
            return Py.newBoolean(((Object)this._set).equals(((BaseSet)other)._set));
        }
        return Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.baseset___ne__(other);
    }

    final PyObject baseset___ne__(PyObject other) {
        if (other instanceof BaseSet) {
            return Py.newBoolean(!((Object)this._set).equals(((BaseSet)other)._set));
        }
        return Py.True;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.baseset___le__(other);
    }

    final PyObject baseset___le__(PyObject other) {
        return this.baseset_issubset(this.asBaseSet(other));
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.baseset___ge__(other);
    }

    final PyObject baseset___ge__(PyObject other) {
        return this.baseset_issuperset(this.asBaseSet(other));
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.baseset___lt__(other);
    }

    final PyObject baseset___lt__(PyObject other) {
        BaseSet bs = this.asBaseSet(other);
        return Py.newBoolean(this.size() < bs.size() && this.baseset_issubset(other).__nonzero__());
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.baseset___gt__(other);
    }

    final PyObject baseset___gt__(PyObject other) {
        BaseSet bs = this.asBaseSet(other);
        return Py.newBoolean(this.size() > bs.size() && this.baseset_issuperset(other).__nonzero__());
    }

    @Override
    public PyObject __reduce__() {
        return this.baseset___reduce__();
    }

    final PyObject baseset___reduce__() {
        PyTuple args = new PyTuple(new PyList(this));
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), args, dict);
    }

    final PyObject baseset_union(PyObject other) {
        BaseSet result = BaseSet.makeNewSet(this.getType(), this);
        result._update(other);
        return result;
    }

    final PyObject baseset_intersection(PyObject other) {
        PyObject big;
        PyObject little;
        if (!(other instanceof BaseSet)) {
            other = new PySet(other);
        }
        if (this.size() <= __builtin__.len(other)) {
            little = this;
            big = other;
        } else {
            little = other;
            big = this;
        }
        PyObject common = __builtin__.filter(big.__getattr__("__contains__"), little);
        return BaseSet.makeNewSet(this.getType(), common);
    }

    final PyObject baseset_copy() {
        BaseSet copy2 = BaseSet.makeNewSet(this.getType(), this);
        return copy2;
    }

    final PyObject baseset_issubset(PyObject other) {
        BaseSet bs;
        BaseSet baseSet = bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        if (this.size() > bs.size()) {
            return Py.False;
        }
        for (PyObject p : this._set) {
            if (bs._set.contains(p)) continue;
            return Py.False;
        }
        return Py.True;
    }

    final PyObject baseset_issuperset(PyObject other) {
        BaseSet bs = other instanceof BaseSet ? (BaseSet)other : new PySet(other);
        return bs.baseset_issubset(this);
    }

    @Override
    public String toString() {
        return this.baseset_toString();
    }

    final String baseset_toString() {
        String name = this.getType().fastGetName();
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return name + "(...)";
        }
        StringBuilder buf = new StringBuilder(name).append("([");
        Iterator<PyObject> i = this._set.iterator();
        while (i.hasNext()) {
            buf.append(i.next().__repr__().toString());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("])");
        ts.exitRepr(this);
        return buf.toString();
    }

    protected final BaseSet asBaseSet(PyObject other) {
        if (other instanceof BaseSet) {
            return (BaseSet)other;
        }
        throw Py.TypeError("can only compare to a set");
    }

    protected final PyFrozenSet asFrozen(PyException pye, PyObject value) {
        if (!(value instanceof BaseSet) || !pye.match(Py.TypeError)) {
            throw pye;
        }
        PyFrozenSet tmp = new PyFrozenSet();
        tmp._set = ((BaseSet)value)._set;
        return tmp;
    }

    protected static BaseSet makeNewSet(PyType type) {
        return BaseSet.makeNewSet(type, null);
    }

    protected static BaseSet makeNewSet(PyType type, PyObject iterable) {
        BaseSet so;
        if (type == PySet.TYPE) {
            so = new PySet(iterable);
        } else if (type == PyFrozenSet.TYPE) {
            so = new PyFrozenSet(iterable);
        } else if (Py.isSubClass(type, PySet.TYPE)) {
            so = new PySetDerived(type);
            so._update(iterable);
        } else {
            so = new PyFrozenSetDerived(type, iterable);
        }
        return so;
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public boolean add(Object o) {
        return this._set.add(Py.java2py(o));
    }

    @Override
    public boolean contains(Object o) {
        return this._set.contains(Py.java2py(o));
    }

    @Override
    public boolean remove(Object o) {
        return this._set.remove(Py.java2py(o));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean added = false;
        for (Object object : c) {
            added |= this.add(object);
        }
        return added;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object object : c) {
            if (this._set.contains(Py.java2py(object))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean removed = false;
        for (Object object : c) {
            removed |= this._set.remove(Py.java2py(object));
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator<PyObject> real;
            {
                this.real = BaseSet.this._set.iterator();
            }

            public boolean hasNext() {
                return this.real.hasNext();
            }

            public Object next() {
                return Py.tojava(this.real.next(), Object.class);
            }

            public void remove() {
                this.real.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }
}

