/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Dependency;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.RevisionType;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.io.impl.FileSystemFileOp;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.installer.SdkInstallerUtil;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.android.sdklib.tool.TableFormatter;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SdkManagerCli {
    private static final String TOOLSDIR = "com.android.sdklib.toolsdir";
    private final Settings mSettings;
    private final AndroidSdkHandler mHandler;
    private final RepoManager mRepoManager;
    private final PrintStream mOut;
    private final BufferedReader mIn;
    private Downloader mDownloader;
    private final ProgressIndicator mProgress;

    public static void main(String[] args) {
        try {
            SdkManagerCli.main(Arrays.asList(args));
        }
        catch (CommandFailedException | UncheckedCommandFailedException e) {
            System.exit(1);
        }
    }

    private static void main(List<String> args) throws CommandFailedException {
        FileSystemFileOp fop = (FileSystemFileOp)FileOpUtils.create();
        Settings settings = Settings.createSettings(args, fop.getFileSystem());
        if (settings == null) {
            SdkManagerCli.usage(System.err);
            throw new CommandFailedException();
        }
        Path localPath = settings.getLocalPath();
        if (!Files.exists(localPath, new LinkOption[0])) {
            try {
                Files.createDirectories(localPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Failed to create SDK root dir: " + localPath);
                System.err.println(e.getMessage());
                throw new CommandFailedException();
            }
        }
        AndroidSdkHandler handler = AndroidSdkHandler.getInstance(localPath.toFile());
        new SdkManagerCli(settings, System.out, System.in, new LegacyDownloader((FileOp)fop, settings), handler).run();
        System.out.println("done");
    }

    public SdkManagerCli(Settings settings, PrintStream out, InputStream in, Downloader downloader, AndroidSdkHandler handler) {
        this.mSettings = settings;
        this.mOut = out;
        this.mIn = in == null ? null : new BufferedReader(new InputStreamReader(in));
        this.mDownloader = downloader;
        this.mProgress = settings.getProgressIndicator();
        this.mHandler = handler;
        this.mRepoManager = this.mHandler.getSdkManager(this.mProgress);
    }

    void run() throws CommandFailedException {
        if (this.mSettings == null) {
            throw new CommandFailedException();
        }
        if (this.mSettings.isList()) {
            this.listPackages();
        } else if (this.mSettings.islicenses()) {
            this.showLicenses();
        } else if (this.mSettings.isInstallAction()) {
            this.installPackages();
        } else {
            this.uninstallPackages();
        }
    }

    private void listPackages() {
        this.mRepoManager.loadSynchronously(0L, this.mProgress, this.mDownloader, (SettingsController)this.mSettings);
        RepositoryPackages packages = this.mRepoManager.getPackages();
        TreeSet<LocalPackage> locals = new TreeSet<LocalPackage>();
        TreeSet<LocalPackage> localObsoletes = new TreeSet<LocalPackage>();
        for (LocalPackage local : packages.getLocalPackages().values()) {
            if (local.obsolete()) {
                localObsoletes.add(local);
                continue;
            }
            locals.add(local);
        }
        TreeSet<RemotePackage> remotes = new TreeSet<RemotePackage>();
        TreeSet<RemotePackage> remoteObsoletes = new TreeSet<RemotePackage>();
        for (RemotePackage remote : packages.getRemotePackages().values()) {
            if (remote.obsolete()) {
                remoteObsoletes.add(remote);
                continue;
            }
            remotes.add(remote);
        }
        TreeSet<UpdatablePackage> updates = new TreeSet<UpdatablePackage>(packages.getUpdatedPkgs());
        if (this.mSettings.isVerbose()) {
            this.printListVerbose(locals, localObsoletes, remotes, remoteObsoletes, updates);
        } else {
            this.printList(locals, localObsoletes, remotes, remoteObsoletes, updates);
        }
    }

    private void printListVerbose(Collection<LocalPackage> locals, Collection<LocalPackage> localObsoletes, Collection<RemotePackage> remotes, Collection<RemotePackage> remoteObsoletes, Set<UpdatablePackage> updates) {
        if (!locals.isEmpty()) {
            this.mOut.println("Installed packages:");
            this.mOut.println("--------------------------------------");
            this.verboseListLocal(locals);
        }
        if (this.mSettings.includeObsolete() && !localObsoletes.isEmpty()) {
            this.mOut.println("Installed Obsolete Packages:");
            this.mOut.println("--------------------------------------");
            this.verboseListLocal(locals);
        }
        if (!remotes.isEmpty()) {
            this.mOut.println("Available Packages:");
            this.mOut.println("--------------------------------------");
            this.verboseListRemote(remotes);
        }
        if (this.mSettings.includeObsolete() && !remoteObsoletes.isEmpty()) {
            this.mOut.println();
            this.mOut.println("Available Obsolete Packages:");
            this.mOut.println("--------------------------------------");
            this.verboseListRemote(remoteObsoletes);
        }
        if (!updates.isEmpty()) {
            this.mOut.println("Available Updates:");
            this.mOut.println("--------------------------------------");
            for (UpdatablePackage update : updates) {
                this.mOut.println(update.getPath());
                this.mOut.println("    Local Version:  " + update.getLocal().getVersion());
                this.mOut.println("    Remote Version: " + update.getRemote().getVersion());
                if (!update.getRemote().obsolete()) continue;
                this.mOut.println("    (Obsolete)");
            }
        }
    }

    private void verboseListLocal(Collection<LocalPackage> locals) {
        for (LocalPackage local : locals) {
            this.mOut.println(local.getPath());
            this.mOut.println("    Description:        " + local.getDisplayName());
            this.mOut.println("    Version:            " + local.getVersion());
            this.mOut.println("    Installed Location: " + local.getLocation());
            this.mOut.println();
        }
    }

    private void verboseListRemote(Collection<RemotePackage> remotes) {
        for (RemotePackage remote : remotes) {
            this.mOut.println(remote.getPath());
            this.mOut.println("    Description:        " + remote.getDisplayName());
            this.mOut.println("    Version:            " + remote.getVersion());
            if (!remote.getAllDependencies().isEmpty()) {
                this.mOut.println("    Dependencies:");
                for (Dependency dependency : remote.getAllDependencies()) {
                    RevisionType minRevision = dependency.getMinRevision();
                    this.mOut.print("        " + dependency.getPath());
                    if (minRevision != null) {
                        this.mOut.println(" Revision " + minRevision.toRevision());
                        continue;
                    }
                    this.mOut.println();
                }
            }
            this.mOut.println();
        }
    }

    private void printList(Collection<LocalPackage> locals, Collection<LocalPackage> localObsoletes, Collection<RemotePackage> remotes, Collection<RemotePackage> remoteObsoletes, Set<UpdatablePackage> updates) {
        TableFormatter<LocalPackage> localTable = new TableFormatter<LocalPackage>();
        localTable.addColumn("Path", RepoPackage::getPath, 15, 15);
        localTable.addColumn("Version", p -> p.getVersion().toString(), 100, 0);
        localTable.addColumn("Description", RepoPackage::getDisplayName, 30, 0);
        localTable.addColumn("Location", p -> FileUtils.relativePossiblyNonExistingPath((File)p.getLocation(), (File)this.mRepoManager.getLocalPath()), 15, 15);
        if (!locals.isEmpty()) {
            this.mOut.println("Installed packages:");
            localTable.print(locals, this.mOut);
        }
        if (this.mSettings.includeObsolete() && !localObsoletes.isEmpty()) {
            this.mOut.println();
            this.mOut.println("Installed Obsolete Packages:");
            localTable.print(localObsoletes, this.mOut);
        }
        TableFormatter<RemotePackage> remoteTable = new TableFormatter<RemotePackage>();
        remoteTable.addColumn("Path", RepoPackage::getPath, 15, 15);
        remoteTable.addColumn("Version", p -> p.getVersion().toString(), 100, 0);
        remoteTable.addColumn("Description", RepoPackage::getDisplayName, 30, 0);
        if (!remotes.isEmpty()) {
            this.mOut.println();
            this.mOut.println("Available Packages:");
            remoteTable.print(remotes, this.mOut);
        }
        if (this.mSettings.includeObsolete() && !remoteObsoletes.isEmpty()) {
            this.mOut.println();
            this.mOut.println("Available Obsolete Packages:");
            remoteTable.print(remoteObsoletes, this.mOut);
        }
        if (!updates.isEmpty()) {
            this.mOut.println();
            this.mOut.println("Available Updates:");
            TableFormatter<UpdatablePackage> updateTable = new TableFormatter<UpdatablePackage>();
            updateTable.addColumn("ID", UpdatablePackage::getPath, 30, 30);
            updateTable.addColumn("Installed", p -> p.getLocal().getVersion().toString(), 20, 0);
            updateTable.addColumn("Available", p -> p.getRemote().getVersion().toString(), 20, 0);
            if (!this.mSettings.includeObsolete()) {
                updates.removeIf(updatable -> updatable.getRemote().obsolete());
            }
            updateTable.print(updates, this.mOut);
        }
    }

    private void installPackages() throws CommandFailedException {
        this.mRepoManager.loadSynchronously(0L, this.mProgress, this.mDownloader, (SettingsController)this.mSettings);
        List<Object> remotes = new ArrayList();
        for (String path : this.mSettings.getPaths(this.mRepoManager)) {
            RemotePackage p2 = (RemotePackage)this.mRepoManager.getPackages().getRemotePackages().get(path);
            if (p2 == null) {
                this.mProgress.logWarning("Failed to find package " + path);
                throw new CommandFailedException();
            }
            remotes.add(p2);
        }
        if ((remotes = InstallerUtil.computeRequiredPackages(remotes, (RepositoryPackages)this.mRepoManager.getPackages(), (ProgressIndicator)this.mProgress)) != null) {
            List<RemotePackage> acceptedRemotes = this.checkLicenses(remotes);
            if (!acceptedRemotes.equals(remotes)) {
                this.mOut.println("The following packages can not be installed since their licenses or those of the packages they depend on were not accepted:");
                remotes.stream().filter(p -> !acceptedRemotes.contains(p)).forEach(p -> this.mOut.println("  " + p.getPath()));
                if (!acceptedRemotes.isEmpty()) {
                    this.mOut.print("Continue installing the remaining packages? (y/N): ");
                    if (!this.askYesNo()) {
                        throw new CommandFailedException();
                    }
                }
                remotes = acceptedRemotes;
            }
            for (RemotePackage p2 : remotes) {
                Installer installer = SdkInstallerUtil.findBestInstallerFactory((RepoPackage)p2, this.mHandler).createInstaller(p2, this.mRepoManager, this.mDownloader, this.mHandler.getFileOp());
                if (this.applyPackageOperation((PackageOperation)installer)) continue;
                throw new CommandFailedException();
            }
        } else {
            this.mProgress.logWarning("Unable to compute a complete list of dependencies.");
            throw new CommandFailedException();
        }
    }

    private void showLicenses() throws CommandFailedException {
        this.mRepoManager.loadSynchronously(0L, this.mProgress, this.mDownloader, (SettingsController)this.mSettings);
        Set licenses = this.mRepoManager.getPackages().getRemotePackages().values().stream().map(RepoPackage::getLicense).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new));
        ImmutableList.Builder licensesNotYetAcceptedBuilder = ImmutableList.builder();
        for (License license : licenses) {
            boolean accepted = license.checkAccepted(this.mHandler.getLocation(), this.mHandler.getFileOp());
            if (!accepted) {
                licensesNotYetAcceptedBuilder.add((Object)license);
            }
            if (!this.mSettings.isVerbose()) continue;
            this.printLicense(license);
            this.mOut.format(accepted ? "Accepted%n%n" : "Not yet accepted%n%n", new Object[0]);
        }
        ImmutableList licensesNotYetAccepted = licensesNotYetAcceptedBuilder.build();
        if (licensesNotYetAccepted.isEmpty()) {
            this.mOut.println("All SDK package licenses accepted.");
            return;
        }
        this.mOut.format("%1$d of %2$d SDK package license%3$s not accepted.%nReview license%3$s that ha%4$s not been accepted (y/N)? ", licensesNotYetAccepted.size(), licenses.size(), licensesNotYetAccepted.size() == 1 ? "" : "s", licensesNotYetAccepted.size() == 1 ? "s" : "ve");
        if (!this.askYesNo()) {
            return;
        }
        int newlyAcceptedCount = 0;
        for (int i = 0; i < licensesNotYetAccepted.size(); ++i) {
            this.mOut.format("%n%1$d/%2$d: ", i + 1, licensesNotYetAccepted.size());
            License license = (License)licensesNotYetAccepted.get(i);
            if (!this.askForLicense(license)) continue;
            license.setAccepted(this.mRepoManager.getLocalPath(), this.mHandler.getFileOp());
            ++newlyAcceptedCount;
        }
        if (newlyAcceptedCount == licensesNotYetAccepted.size()) {
            this.mOut.println("All SDK package licenses accepted");
        } else {
            int notAccepted = licensesNotYetAccepted.size() - newlyAcceptedCount;
            this.mOut.format("%1$d license%2$s not accepted%n", notAccepted, notAccepted == 1 ? "" : "s");
        }
    }

    private List<RemotePackage> checkLicenses(List<RemotePackage> remotes) {
        HashMultimap unacceptedLicenses = HashMultimap.create();
        remotes.forEach(arg_0 -> this.lambda$checkLicenses$23((Multimap)unacceptedLicenses, arg_0));
        for (License l : new TreeSet(unacceptedLicenses.keySet())) {
            if (!this.askForLicense(l)) continue;
            unacceptedLicenses.removeAll((Object)l);
            l.setAccepted(this.mRepoManager.getLocalPath(), this.mHandler.getFileOp());
        }
        if (!unacceptedLicenses.isEmpty()) {
            ArrayList<RemotePackage> acceptedPackages = new ArrayList<RemotePackage>(remotes);
            HashSet<RemotePackage> problemPackages = new HashSet<RemotePackage>(unacceptedLicenses.values());
            this.mOut.println("Skipping following packages as the license is not accepted:");
            problemPackages.forEach(problem -> this.mOut.println(problem.getDisplayName()));
            acceptedPackages.removeAll(problemPackages);
            Iterator acceptedIter = acceptedPackages.iterator();
            while (acceptedIter.hasNext()) {
                RemotePackage accepted = (RemotePackage)acceptedIter.next();
                List required = InstallerUtil.computeRequiredPackages(Collections.singletonList(accepted), (RepositoryPackages)this.mRepoManager.getPackages(), (ProgressIndicator)this.mProgress);
                if (Collections.disjoint(required, problemPackages)) continue;
                acceptedIter.remove();
                problemPackages.add(accepted);
            }
            remotes = acceptedPackages;
        }
        return remotes;
    }

    private boolean askForLicense(License license) {
        this.printLicense(license);
        this.mOut.print("Accept? (y/N): ");
        return this.askYesNo();
    }

    private void printLicense(License license) {
        this.mOut.printf("License %s:%n", license.getId());
        this.mOut.println("---------------------------------------");
        this.mOut.println(license.getValue());
        this.mOut.println("---------------------------------------");
    }

    private boolean askYesNo() {
        try {
            String result = this.mIn.readLine();
            return result != null && (result.equalsIgnoreCase("y") || result.equalsIgnoreCase("yes"));
        }
        catch (IOException e) {
            return false;
        }
    }

    private void uninstallPackages() throws CommandFailedException {
        this.mRepoManager.loadSynchronously(0L, this.mProgress, null, (SettingsController)this.mSettings);
        for (String path : this.mSettings.getPaths(this.mRepoManager)) {
            LocalPackage p = (LocalPackage)this.mRepoManager.getPackages().getLocalPackages().get(path);
            if (p == null) {
                this.mProgress.logWarning("Unable to find package " + path);
                continue;
            }
            Uninstaller uninstaller = SdkInstallerUtil.findBestInstallerFactory((RepoPackage)p, this.mHandler).createUninstaller(p, this.mRepoManager, this.mHandler.getFileOp());
            if (this.applyPackageOperation((PackageOperation)uninstaller)) continue;
            throw new CommandFailedException();
        }
    }

    private boolean applyPackageOperation(PackageOperation operation) {
        return operation.prepare(this.mProgress) && operation.complete(this.mProgress);
    }

    private static void usage(PrintStream out) {
        out.println("Usage: ");
        out.println("  sdkmanager [--uninstall] [<common args>] [--package_file <file>] [<packages>...]");
        out.println("  sdkmanager --update [<common args>]");
        out.println("  sdkmanager --list [<common args>]");
        out.println("  sdkmanager --licenses [<common args>]");
        out.println();
        out.println("In its first form, installs, or uninstalls, or updates packages.");
        out.println("    By default, the listed packages are installed or (if already installed)");
        out.println("    updated to the latest version.");
        out.println();
        out.println("    --uninstall: uninstalled listed packages.");
        out.println();
        out.println("    <package> is a sdk-style path (e.g. \"build-tools;23.0.0\" or");
        out.println("             \"platforms;android-23\").");
        out.println("    <package-file> is a text file where each line is a sdk-style path");
        out.println("                   of a package to install or uninstall.");
        out.println("    Multiple --package_file arguments may be specified in combination");
        out.println("    with explicit paths.");
        out.println();
        out.println("In its second form (with --update), all installed packages are");
        out.println("    updated to the latest version.");
        out.println();
        out.println("In its third form, all installed and available packages are printed");
        out.println("    out.");
        out.println();
        out.println("In its fourth form (with --licenses), show and offer the option to");
        out.println("     accept licenses for all available packages that have not already been");
        out.println("     accepted.");
        out.println();
        out.println("Common Arguments:");
        out.println("    --sdk_root=<sdkRootPath>: Use the specified SDK root instead of the SDK ");
        out.println("                              containing this tool");
        out.println();
        out.println("    --channel=<channelId>: Include packages in channels up to <channelId>.");
        out.println("                           Common channels are:");
        out.println("                           0 (Stable), 1 (Beta), 2 (Dev), and 3 (Canary).");
        out.println();
        out.println("    --include_obsolete: With --list, show obsolete packages in the");
        out.println("                        package listing. With --update, update obsolete");
        out.println("                        packages as well as non-obsolete.");
        out.println();
        out.println("    --no_https: Force all connections to use http rather than https.");
        out.println();
        out.println("    --proxy=<http | socks>: Connect via a proxy of the given type.");
        out.println();
        out.println("    --proxy_host=<IP or DNS address>: IP or DNS address of the proxy to use.");
        out.println();
        out.println("    --proxy_port=<port #>: Proxy port to connect to.");
        out.println();
        out.println("* If the env var REPO_OS_OVERRIDE is set to \"windows\",\n  \"macosx\", or \"linux\", packages will be downloaded for that OS.");
    }

    private /* synthetic */ void lambda$checkLicenses$23(Multimap multimap, RemotePackage remote) {
        License l = remote.getLicense();
        if (l != null && !l.checkAccepted(this.mHandler.getLocation(), this.mHandler.getFileOp())) {
            multimap.put((Object)l, (Object)remote);
        }
    }

    public static final class UncheckedCommandFailedException
    extends RuntimeException {
    }

    public static final class CommandFailedException
    extends Exception {
    }

    @VisibleForTesting
    static class Settings
    implements SettingsController {
        private static final String CHANNEL_ARG = "--channel=";
        private static final String LICENSES_ARG = "--licenses";
        private static final String UNINSTALL_ARG = "--uninstall";
        private static final String UPDATE_ARG = "--update";
        private static final String PKG_FILE_ARG = "--package_file=";
        private static final String SDK_ROOT_ARG = "--sdk_root=";
        private static final String LIST_ARG = "--list";
        private static final String INCLUDE_OBSOLETE_ARG = "--include_obsolete";
        private static final String HELP_ARG = "--help";
        private static final String NO_HTTPS_ARG = "--no_https";
        private static final String VERBOSE_ARG = "--verbose";
        private static final String PROXY_TYPE_ARG = "--proxy=";
        private static final String PROXY_HOST_ARG = "--proxy_host=";
        private static final String PROXY_PORT_ARG = "--proxy_port=";
        private Path mLocalPath;
        private List<String> mPackages = new ArrayList<String>();
        private int mChannel = 0;
        private boolean mIsLicenses = false;
        private boolean mIsInstall = true;
        private boolean mIsUpdate = false;
        private boolean mIsList = false;
        private boolean mIncludeObsolete = false;
        private boolean mForceHttp = false;
        private boolean mVerbose = false;
        private Proxy.Type mProxyType;
        private SocketAddress mProxyHost;

        public static Settings createSettings(List<String> args, FileSystem fileSystem) {
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            Settings result = new Settings();
            String proxyHost = null;
            int proxyPort = -1;
            String toolsDir = System.getProperty(SdkManagerCli.TOOLSDIR);
            if (toolsDir != null) {
                result.mLocalPath = fileSystem.getPath(toolsDir, new String[0]).normalize().getParent();
            }
            for (String arg : args) {
                String value;
                if (arg.equals(HELP_ARG)) {
                    return null;
                }
                if (arg.equals(LICENSES_ARG)) {
                    result.mIsLicenses = true;
                    continue;
                }
                if (arg.equals(UNINSTALL_ARG)) {
                    result.mIsInstall = false;
                    continue;
                }
                if (arg.equals(NO_HTTPS_ARG)) {
                    result.setForceHttp(true);
                    continue;
                }
                if (arg.equals(UPDATE_ARG)) {
                    result.mIsUpdate = true;
                    continue;
                }
                if (arg.equals(LIST_ARG)) {
                    result.mIsList = true;
                    continue;
                }
                if (arg.equals(VERBOSE_ARG)) {
                    result.mVerbose = true;
                    continue;
                }
                if (arg.equals(INCLUDE_OBSOLETE_ARG)) {
                    result.mIncludeObsolete = true;
                    continue;
                }
                if (arg.startsWith(PROXY_HOST_ARG)) {
                    proxyHost = arg.substring(PROXY_HOST_ARG.length());
                    continue;
                }
                if (arg.startsWith(PROXY_PORT_ARG)) {
                    value = arg.substring(PROXY_PORT_ARG.length());
                    try {
                        proxyPort = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        progress.logWarning(String.format("Invalid port \"%s\"", value));
                        return null;
                    }
                }
                if (arg.startsWith(PROXY_TYPE_ARG)) {
                    String type = arg.substring(PROXY_TYPE_ARG.length());
                    if (type.equals("socks")) {
                        result.mProxyType = Proxy.Type.SOCKS;
                        continue;
                    }
                    if (type.equals("http")) {
                        result.mProxyType = Proxy.Type.HTTP;
                        continue;
                    }
                    progress.logWarning("Valid proxy types are \"socks\" and \"http\".");
                    return null;
                }
                if (arg.startsWith(CHANNEL_ARG)) {
                    value = arg.substring(CHANNEL_ARG.length());
                    try {
                        result.mChannel = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        progress.logWarning(String.format("Invalid channel id \"%s\"", value));
                        return null;
                    }
                }
                if (arg.startsWith(PKG_FILE_ARG)) {
                    String packageFile = arg.substring(PKG_FILE_ARG.length());
                    try {
                        result.mPackages.addAll(Files.readAllLines(fileSystem.getPath(packageFile, new String[0])));
                        continue;
                    }
                    catch (IOException e) {
                        progress.logWarning(String.format("Invalid package file \"%s\" threw exception:%n%s%n", packageFile, e));
                        return null;
                    }
                }
                if (arg.startsWith(SDK_ROOT_ARG)) {
                    result.mLocalPath = fileSystem.getPath(arg.substring(SDK_ROOT_ARG.length()), new String[0]);
                    continue;
                }
                if (arg.startsWith("--")) {
                    progress.logWarning(String.format("Unknown argument %s", arg));
                    return null;
                }
                result.mPackages.add(arg);
            }
            if (result.mLocalPath == null || !result.mPackages.isEmpty() == (result.mIsUpdate || result.mIsList || result.mIsLicenses)) {
                return null;
            }
            if (proxyHost == null ^ result.mProxyType == null || proxyPort == -1 ^ result.mProxyType == null) {
                progress.logWarning(String.format("All of %1$s, %2$s, and %3$s must be specified if any are.", PROXY_HOST_ARG, PROXY_PORT_ARG, PROXY_TYPE_ARG));
                return null;
            }
            if (result.mProxyType != null) {
                SocketAddress address = Settings.createAddress(proxyHost, proxyPort);
                if (address == null) {
                    return null;
                }
                result.mProxyHost = address;
            }
            return result;
        }

        private static SocketAddress createAddress(String host, int port) {
            try {
                InetAddress address = InetAddress.getByName(host);
                return new InetSocketAddress(address, port);
            }
            catch (UnknownHostException e) {
                new ConsoleProgressIndicator().logWarning("Failed to parse host " + host);
                return null;
            }
        }

        public Channel getChannel() {
            return Channel.create((int)this.mChannel);
        }

        public boolean getForceHttp() {
            return this.mForceHttp;
        }

        public void setForceHttp(boolean force) {
            this.mForceHttp = force;
        }

        public List<String> getPaths(RepoManager mgr) {
            if (this.mIsUpdate) {
                return mgr.getPackages().getUpdatedPkgs().stream().filter(p -> this.mIncludeObsolete || !p.getRemote().obsolete()).map(p -> p.getRepresentative().getPath()).collect(Collectors.toList());
            }
            return this.mPackages;
        }

        public Path getLocalPath() {
            return this.mLocalPath;
        }

        public boolean isInstallAction() {
            return this.mIsInstall;
        }

        private Settings() {
        }

        public boolean isList() {
            return this.mIsList;
        }

        public boolean islicenses() {
            return this.mIsLicenses;
        }

        public boolean isVerbose() {
            return this.mVerbose;
        }

        public boolean includeObsolete() {
            return this.mIncludeObsolete;
        }

        public ProgressIndicator getProgressIndicator() {
            return new ConsoleProgressIndicator(){

                public void logWarning(String s, Throwable e) {
                    if (mVerbose) {
                        super.logWarning(s, e);
                    } else {
                        super.logWarning(s, null);
                    }
                }

                public void logError(String s, Throwable e) {
                    if (mVerbose) {
                        super.logWarning(s, e);
                    } else {
                        super.logWarning(s, null);
                    }
                    throw new UncheckedCommandFailedException();
                }

                public void logInfo(String s) {
                    if (mVerbose) {
                        super.logInfo(s);
                    }
                }

                public void logVerbose(String s) {
                    if (mVerbose) {
                        super.logVerbose(s);
                    }
                }
            };
        }

        public Proxy getProxy() {
            return this.mProxyType == null ? Proxy.NO_PROXY : new Proxy(this.mProxyType, this.mProxyHost);
        }
    }
}

