/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

abstract class EcjPsiVariable
extends EcjPsiSourceElement
implements PsiVariable {
    protected final LocalDeclaration mVariable;
    private EcjPsiModifierList mModifierList;
    private PsiIdentifier mNameIdentifier;
    private PsiExpression mInitializer;
    private String mName;
    private PsiTypeElement mTypeElement;

    EcjPsiVariable(EcjPsiManager manager, LocalDeclaration variable) {
        super(manager, variable);
        this.mVariable = variable;
    }

    void setModifierList(EcjPsiModifierList modifierList) {
        this.mModifierList = modifierList;
    }

    void setNameIdentifier(PsiIdentifier nameIdentifier) {
        this.mNameIdentifier = nameIdentifier;
    }

    void setTypeElement(PsiTypeElement typeElement) {
        this.mTypeElement = typeElement;
    }

    @Override
    public String getName() {
        if (this.mName == null) {
            this.mName = new String(this.mVariable.name);
        }
        return this.mName;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.mNameIdentifier;
    }

    public PsiModifierList getModifierList() {
        return this.mModifierList;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.mModifierList != null && this.mModifierList.hasModifierProperty(s);
    }

    public boolean hasInitializer() {
        return this.mInitializer != null;
    }

    public PsiExpression getInitializer() {
        return this.mInitializer;
    }

    public void setInitializer(PsiExpression expression) throws IncorrectOperationException {
        this.mInitializer = expression;
    }

    public PsiType getType() {
        PsiType type = this.mManager.findType(this.mVariable.type);
        assert (type != null) : this;
        return type;
    }

    public PsiTypeElement getTypeElement() {
        return this.mTypeElement;
    }

    public Object computeConstantValue() {
        throw new UnimplementedLintPsiApiException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EcjPsiVariable)) {
            return false;
        }
        LocalVariableBinding binding = this.mVariable.binding;
        LocalVariableBinding otherBinding = ((EcjPsiVariable)o).mVariable.binding;
        if (binding == null || otherBinding == null) {
            return this.mVariable.equals(((EcjPsiVariable)o).mVariable);
        }
        return binding.equals(otherBinding);
    }

    public int hashCode() {
        return this.mVariable.binding != null ? this.mVariable.binding.hashCode() : 0;
    }

    LocalVariableBinding getVariableBinding() {
        return this.mVariable != null ? this.mVariable.binding : null;
    }
}

