/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiStatement;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.Statement;

class EcjPsiTryStatement
extends EcjPsiStatement
implements PsiTryStatement {
    private PsiCodeBlock mTryBlock;
    private PsiCodeBlock mFinallyBlock;
    private PsiResourceList mResourceList;
    private PsiCatchSection[] mCatchSections;

    EcjPsiTryStatement(EcjPsiManager manager, Statement statement) {
        super(manager, statement);
    }

    void setTryBlock(PsiCodeBlock tryBlock) {
        this.mTryBlock = tryBlock;
    }

    void setCatchSections(PsiCatchSection[] catchSections) {
        this.mCatchSections = catchSections;
    }

    void setFinallyBlock(PsiCodeBlock finallyBlock) {
        this.mFinallyBlock = finallyBlock;
    }

    void setResourceList(PsiResourceList resourceList) {
        this.mResourceList = resourceList;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTryStatement((PsiTryStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiCodeBlock getTryBlock() {
        return this.mTryBlock;
    }

    public PsiCodeBlock getFinallyBlock() {
        return this.mFinallyBlock;
    }

    public PsiResourceList getResourceList() {
        return this.mResourceList;
    }

    public PsiCodeBlock[] getCatchBlocks() {
        PsiCatchSection[] catchSections = this.getCatchSections();
        if (catchSections.length == 0) {
            return PsiCodeBlock.EMPTY_ARRAY;
        }
        boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
        PsiCodeBlock[] blocks = new PsiCodeBlock[lastIncomplete ? catchSections.length - 1 : catchSections.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = catchSections[i].getCatchBlock();
        }
        return blocks;
    }

    public PsiParameter[] getCatchBlockParameters() {
        PsiCatchSection[] catchSections = this.getCatchSections();
        if (catchSections.length == 0) {
            return PsiParameter.EMPTY_ARRAY;
        }
        boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
        int limit = lastIncomplete ? catchSections.length - 1 : catchSections.length;
        ArrayList<PsiParameter> parameters = new ArrayList<PsiParameter>();
        for (int i = 0; i < limit; ++i) {
            PsiParameter parameter = catchSections[i].getParameter();
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters.toArray(new PsiParameter[parameters.size()]);
    }

    public PsiCatchSection[] getCatchSections() {
        return this.mCatchSections;
    }
}

