/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiFunctionalExpression;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;

class EcjPsiMethodReferenceExpression
extends EcjPsiFunctionalExpression
implements PsiMethodReferenceExpression {
    private final ReferenceExpression mReferenceExp;
    private PsiExpression mQualifier;
    private PsiIdentifier mNameIdentifier;
    private PsiReferenceParameterList mParameterList;
    private String mQualifiedName;

    EcjPsiMethodReferenceExpression(EcjPsiManager manager, ReferenceExpression expression) {
        super(manager, expression);
        this.mReferenceExp = expression;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodReferenceExpression((PsiMethodReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    void setQualifier(PsiExpression qualifier) {
        this.mQualifier = qualifier;
    }

    void setReferenceNameElement(PsiIdentifier identifier) {
        this.mNameIdentifier = identifier;
    }

    void setParameterList(PsiReferenceParameterList parameterList) {
        this.mParameterList = parameterList;
    }

    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    public PsiExpression getQualifierExpression() {
        return this.mQualifier;
    }

    public boolean isExact() {
        return this.mReferenceExp.isExactMethodReference();
    }

    public PsiMember getPotentiallyApplicableMember() {
        throw new UnimplementedLintPsiApiException();
    }

    public boolean isConstructor() {
        return this.mReferenceExp.isConstructorReference();
    }

    public PsiElement getReferenceNameElement() {
        return this.mNameIdentifier;
    }

    public PsiReferenceParameterList getParameterList() {
        return this.mParameterList;
    }

    public PsiType[] getTypeParameters() {
        return this.mParameterList != null ? this.mParameterList.getTypeArguments() : PsiType.EMPTY_ARRAY;
    }

    public boolean isQualified() {
        return this.mQualifier != null;
    }

    public String getQualifiedName() {
        if (this.mQualifiedName == null) {
            if (this.mQualifier instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)this.mQualifier;
                this.mQualifiedName = referenceExpression.getQualifiedName() + '.' + this.getName();
            } else {
                this.mQualifiedName = this.getName();
            }
        }
        return this.mQualifiedName;
    }

    public PsiElement getQualifier() {
        return this.mQualifier;
    }

    public String getReferenceName() {
        return this.mNameIdentifier.getText();
    }

    public PsiElement getElement() {
        return this.mNameIdentifier;
    }

    public TextRange getRangeInElement() {
        return this.mNameIdentifier.getTextRange();
    }

    public String getCanonicalText() {
        return this.getText();
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        return this.mManager.findMethod(this.mReferenceExp.binding);
    }
}

