/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.EcjParser;
import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.psi.EcjPsiBinaryClass;
import com.android.tools.lint.psi.EcjPsiBinaryField;
import com.android.tools.lint.psi.EcjPsiBinaryMethod;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiClassType;
import com.android.tools.lint.psi.EcjPsiDisjunctionType;
import com.android.tools.lint.psi.EcjPsiPackage;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class EcjPsiManager {
    private static final boolean RESOLVE_TO_BINARY = false;
    private final LanguageLevel mLanguageLevel;
    private final Map<Binding, PsiElement> mElementMap;
    private final Map<ReferenceBinding, PsiType> mTypeMap;
    private final LintClient mClient;
    private final EcjParser.EcjResult mEcjResult;
    private ExternalAnnotationRepository mAnnotationRepository;
    private final Map<PackageBinding, String> mGroupCache = Maps.newHashMap();

    public EcjPsiManager(LintClient client, EcjParser.EcjResult ecjResult, long ecjLanguageLevel) {
        this.mClient = client;
        this.mEcjResult = ecjResult;
        this.mLanguageLevel = EcjPsiManager.toLanguageLevel(ecjLanguageLevel);
        this.mElementMap = new MapMaker().initialCapacity(1000).weakValues().concurrencyLevel(1).makeMap();
        this.mTypeMap = Maps.newHashMapWithExpectedSize((int)50);
    }

    public void clear() {
        this.mGroupCache.clear();
        this.mTypeMap.clear();
        this.mElementMap.clear();
        this.mGroupCache.clear();
    }

    String getJarFile(ReferenceBinding binding) {
        if (binding.fPackage == null || binding.compoundName == null) {
            return null;
        }
        String group = this.mGroupCache.get(binding.fPackage);
        if (group != null) {
            return group.isEmpty() ? null : group;
        }
        LookupEnvironment lookupEnvironment = this.mEcjResult.getLookupEnvironment();
        if (lookupEnvironment == null) {
            return null;
        }
        INameEnvironment nameEnvironment = lookupEnvironment.nameEnvironment;
        if (nameEnvironment instanceof FileSystem) {
            FileSystem fileSystem = (FileSystem)nameEnvironment;
            String packageName = EcjPsiManager.getInternalName(binding.fPackage.compoundName);
            try {
                FileSystem.Classpath[] classPaths;
                Field field = fileSystem.getClass().getDeclaredField("classpaths");
                field.setAccessible(true);
                for (FileSystem.Classpath cp : classPaths = (FileSystem.Classpath[])field.get(fileSystem)) {
                    if (!cp.isPackage(packageName)) continue;
                    String path = cp.getPath();
                    this.mGroupCache.put(binding.fPackage, path);
                    return path;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        this.mGroupCache.put(binding.fPackage, "");
        return null;
    }

    static String getInternalName(char[][] name) {
        StringBuilder sb = new StringBuilder(50);
        for (char[] segment : name) {
            if (sb.length() != 0) {
                sb.append('/');
            }
            for (char c : segment) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String getTypeName(char[][] name) {
        StringBuilder sb = new StringBuilder(50);
        for (char[] segment : name) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            for (char c : segment) {
                if (c == '$') {
                    c = '.';
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String getTypeName(char[] name) {
        StringBuilder sb = new StringBuilder(name.length);
        for (char c : name) {
            if (c == '$' || c == '/') {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getTypeName(TypeReference typeReference) {
        return EcjPsiManager.getTypeName(typeReference.getTypeName());
    }

    public static String getTypeName(ReferenceBinding binding) {
        String typeName = null;
        while (binding != null) {
            if (binding.compoundName == null) {
                if (binding instanceof WildcardBinding) {
                    binding = ((WildcardBinding)binding).genericType;
                    if (binding.compoundName == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            String prefix = EcjPsiManager.getTypeName(binding.compoundName);
            if (binding.compoundName.length >= 2 && !Character.isUpperCase(prefix.charAt(0))) {
                return prefix;
            }
            typeName = typeName == null ? prefix : (typeName.startsWith(".") ? prefix + typeName : prefix + "." + typeName);
            binding = binding.enclosingType();
        }
        return typeName;
    }

    public LintClient getClient() {
        return this.mClient;
    }

    private static LanguageLevel toLanguageLevel(long ecjLanguageLevel) {
        if (ecjLanguageLevel == 0x330000L) {
            return LanguageLevel.JDK_1_7;
        }
        if (ecjLanguageLevel == 0x320000L) {
            return LanguageLevel.JDK_1_6;
        }
        if (ecjLanguageLevel == 0x340000L) {
            return LanguageLevel.JDK_1_8;
        }
        if (ecjLanguageLevel == 0x310000L) {
            return LanguageLevel.JDK_1_5;
        }
        return LanguageLevel.JDK_1_7;
    }

    public PsiClass findClass(TypeReference typeReference) {
        if (typeReference == null) {
            return null;
        }
        TypeBinding resolvedType = typeReference.resolvedType;
        if (resolvedType instanceof ReferenceBinding) {
            ReferenceBinding type = (ReferenceBinding)resolvedType;
            return this.findClass(type);
        }
        return null;
    }

    public LanguageLevel getLanguageLevel() {
        return this.mLanguageLevel;
    }

    public PsiType findType(AbstractMethodDeclaration declaration) {
        if (declaration.isConstructor()) {
            MethodBinding binding = ((ConstructorDeclaration)declaration).binding;
            if (binding != null) {
                return this.findType(binding.declaringClass);
            }
            return null;
        }
        if (declaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)declaration;
            TypeReference type = methodDeclaration.returnType;
            return this.findType(type);
        }
        return null;
    }

    public PsiType findType(TypeReference type) {
        if (type != null) {
            if (type instanceof UnionTypeReference) {
                UnionTypeReference unionTypeReference = (UnionTypeReference)type;
                ArrayList types = Lists.newArrayListWithCapacity((int)unionTypeReference.typeReferences.length);
                for (TypeReference ref : unionTypeReference.typeReferences) {
                    PsiType t = this.findType(ref);
                    if (t == null) continue;
                    types.add(t);
                }
                PsiType leastUpperBound = this.findType(unionTypeReference.resolvedType);
                return new EcjPsiDisjunctionType(types, leastUpperBound);
            }
            return this.findType(type.resolvedType);
        }
        return null;
    }

    public PsiType findType(ReferenceBinding referenceBinding) {
        if (referenceBinding != null) {
            Object type = this.mTypeMap.get(referenceBinding);
            if (type == null) {
                type = new EcjPsiClassType(this, referenceBinding);
                this.mTypeMap.put(referenceBinding, (PsiType)type);
            }
            return type;
        }
        return null;
    }

    public PsiType findType(TypeBinding typeBinding) {
        if (typeBinding instanceof ReferenceBinding) {
            return this.findType((ReferenceBinding)typeBinding);
        }
        if (typeBinding instanceof BaseTypeBinding) {
            if (typeBinding == BaseTypeBinding.INT) {
                return PsiType.INT;
            }
            if (typeBinding == BaseTypeBinding.BOOLEAN) {
                return PsiType.BOOLEAN;
            }
            if (typeBinding == BaseTypeBinding.VOID) {
                return PsiType.VOID;
            }
            if (typeBinding == BaseTypeBinding.LONG) {
                return PsiType.LONG;
            }
            if (typeBinding == BaseTypeBinding.DOUBLE) {
                return PsiType.DOUBLE;
            }
            if (typeBinding == BaseTypeBinding.BYTE) {
                return PsiType.BYTE;
            }
            if (typeBinding == BaseTypeBinding.SHORT) {
                return PsiType.SHORT;
            }
            if (typeBinding == BaseTypeBinding.CHAR) {
                return PsiType.CHAR;
            }
            if (typeBinding == BaseTypeBinding.FLOAT) {
                return PsiType.FLOAT;
            }
            if (typeBinding == BaseTypeBinding.NULL) {
                return PsiType.NULL;
            }
        } else {
            if (typeBinding instanceof ArrayBinding) {
                ArrayBinding binding = (ArrayBinding)typeBinding;
                PsiType type = this.findType(binding.leafComponentType);
                if (type != null) {
                    for (int i = 0; i < binding.dimensions; ++i) {
                        type = type.createArrayType();
                    }
                }
                return type;
            }
            if (typeBinding instanceof PolyTypeBinding) {
                return null;
            }
        }
        return null;
    }

    public PsiClassType findClassType(ReferenceBinding binding) {
        if (binding == null) {
            return null;
        }
        PsiType type = this.findType(binding);
        if (type instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    public PsiClassType[] findClassTypes(ReferenceBinding[] referenceBindings) {
        if (referenceBindings == null || referenceBindings.length == 0) {
            return PsiClassType.EMPTY_ARRAY;
        }
        ArrayList types = Lists.newArrayListWithCapacity((int)referenceBindings.length);
        for (ReferenceBinding binding : referenceBindings) {
            PsiType type = this.findType(binding);
            if (!(type instanceof PsiClassType)) continue;
            types.add((PsiClassType)type);
        }
        return types.toArray(PsiClassType.EMPTY_ARRAY);
    }

    public PsiClassType getClassType(PsiClass psiClass) {
        if (psiClass instanceof EcjPsiClass) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)((EcjPsiClass)psiClass).getNativeNode();
            assert (typeDeclaration != null);
            return new EcjPsiClassType(this, typeDeclaration.binding);
        }
        if (psiClass instanceof EcjPsiBinaryClass) {
            ReferenceBinding binding = (ReferenceBinding)((EcjPsiBinaryClass)psiClass).getBinding();
            return new EcjPsiClassType(this, binding);
        }
        return null;
    }

    public PsiClassType[] getClassTypes(PsiClass[] classes) {
        if (classes != null && classes.length > 0) {
            ArrayList types = Lists.newArrayListWithCapacity((int)classes.length);
            for (PsiClass cls : classes) {
                PsiClassType classType = this.getClassType(cls);
                if (classType == null) continue;
                types.add(classType);
            }
            return types.toArray(PsiClassType.EMPTY_ARRAY);
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public PsiClass findClass(String fullyQualifiedName) {
        if (this.mEcjResult.getLookupEnvironment() != null) {
            String internal = ClassContext.getInternalName((String)fullyQualifiedName);
            ArrayList arrays = Lists.newArrayList();
            for (String segment : Splitter.on((char)'/').split((CharSequence)internal)) {
                arrays.add(segment.toCharArray());
            }
            char[][] compoundName = new char[arrays.size()][];
            int n = arrays.size();
            for (int i = 0; i < n; ++i) {
                compoundName[i] = (char[])arrays.get(i);
            }
            return this.findClass(compoundName);
        }
        return null;
    }

    public PsiClass findClass(char[][] compoundName) {
        ReferenceBinding type;
        LookupEnvironment lookupEnvironment = this.mEcjResult.getLookupEnvironment();
        if (lookupEnvironment != null && (type = lookupEnvironment.getType(compoundName)) != null && !(type instanceof ProblemReferenceBinding)) {
            return this.findClass(type);
        }
        return null;
    }

    public PsiClass findClass(Binding referenceBinding) {
        return (PsiClass)this.findElement(referenceBinding);
    }

    public PsiMethod findMethod(Binding binding) {
        return (PsiMethod)this.findElement(binding);
    }

    public PsiPackage findPackage(PackageBinding binding) {
        return (PsiPackage)this.findElement(binding);
    }

    public PsiClass[] findClasses(ReferenceBinding binding, ReferenceBinding[] bindings) {
        PsiClass cls;
        int count = 0;
        if (binding != null) {
            ++count;
        }
        if (bindings != null) {
            count += bindings.length;
        }
        if (count == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList classes = Lists.newArrayListWithCapacity((int)count);
        if (binding != null && (cls = this.findClass(binding)) != null) {
            classes.add(cls);
        }
        if (bindings != null) {
            for (ReferenceBinding b : bindings) {
                PsiClass cls2 = this.findClass(b);
                if (cls2 == null) continue;
                classes.add(cls2);
            }
        }
        return classes.toArray(PsiClass.EMPTY_ARRAY);
    }

    public PsiElement findElement(ASTNode node) {
        if (node instanceof NameReference) {
            NameReference ref = (NameReference)node;
            if (node instanceof QualifiedNameReference) {
                PsiElement element;
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)node;
                if (qualifiedNameReference.otherBindings != null && qualifiedNameReference.otherBindings.length > 0 && (element = this.findElement(qualifiedNameReference.otherBindings[qualifiedNameReference.otherBindings.length - 1])) != null) {
                    return element;
                }
            }
            return this.findElement(ref.binding);
        }
        if (node instanceof MessageSend) {
            return this.findMethod(((MessageSend)node).binding);
        }
        if (node instanceof TypeReference) {
            return this.findElement(((TypeReference)node).resolvedType);
        }
        if (node instanceof AllocationExpression) {
            return this.findMethod(((AllocationExpression)node).binding);
        }
        if (node instanceof FieldReference) {
            return this.findElement(((FieldReference)node).binding);
        }
        if (node instanceof ImportReference) {
            ImportReference ref = (ImportReference)node;
            if (ref.isStatic()) {
                int classTokenCount = ref.tokens.length - 1;
                char[][] className = new char[classTokenCount][];
                System.arraycopy(ref.tokens, 0, className, 0, classTokenCount);
                PsiClass cls = this.findClass(className);
                if (cls != null) {
                    String name = new String(ref.tokens[classTokenCount]);
                    PsiField field = cls.findFieldByName(name, false);
                    if (field != null) {
                        return field;
                    }
                    PsiMethod[] methods = cls.findMethodsByName(name, false);
                    if (methods.length == 1) {
                        return methods[0];
                    }
                    field = cls.findFieldByName(name, true);
                    if (field != null) {
                        return field;
                    }
                    methods = cls.findMethodsByName(name, true);
                    if (methods.length == 1) {
                        return methods[0];
                    }
                }
                return null;
            }
            return this.findClass(ref.tokens);
        }
        return null;
    }

    public PsiElement findElement(Binding binding) {
        PsiJavaFile file;
        ReferenceBinding declaringClass;
        if (binding == null) {
            return null;
        }
        PsiElement element = this.mElementMap.get(binding);
        if (element != null) {
            return element;
        }
        if (binding instanceof ProblemReferenceBinding) {
            if ((binding = ((ProblemReferenceBinding)binding).closestReferenceMatch()) != null) {
                return this.findElement(binding);
            }
            return null;
        }
        if (binding instanceof WildcardBinding) {
            return this.findElement(((WildcardBinding)binding).actualType());
        }
        if (binding instanceof ParameterizedTypeBinding) {
            TypeBinding typeBinding = ((ParameterizedTypeBinding)binding).original();
            element = this.mElementMap.get(typeBinding);
            if (element == null && typeBinding != null && typeBinding.actualType() instanceof SourceTypeBinding) {
                return null;
            }
            return this.findElement(typeBinding);
        }
        if (binding instanceof ParameterizedMethodBinding) {
            ParameterizedMethodBinding methodBinding = (ParameterizedMethodBinding)binding;
            element = this.mElementMap.get(binding = methodBinding.original());
            if (element == null && methodBinding.isConstructor() && methodBinding.declaringClass != null && methodBinding.declaringClass.actualType() instanceof SourceTypeBinding) {
                return null;
            }
            return this.findElement(binding);
        }
        if (binding instanceof ParameterizedFieldBinding) {
            ParameterizedFieldBinding fieldBinding = (ParameterizedFieldBinding)binding;
            element = this.mElementMap.get(binding = fieldBinding.original());
            if (element == null && fieldBinding.declaringClass != null && fieldBinding.declaringClass.actualType() instanceof SourceTypeBinding) {
                return null;
            }
            return this.findElement(binding);
        }
        if (binding instanceof FieldBinding ? (declaringClass = ((FieldBinding)binding).declaringClass) instanceof SourceTypeBinding && (file = this.mEcjResult.findFileContaining(declaringClass)) != null && (element = this.mElementMap.get(binding)) != null : binding instanceof MethodBinding && (declaringClass = ((MethodBinding)binding).declaringClass) instanceof SourceTypeBinding && (file = this.mEcjResult.findFileContaining(declaringClass)) != null && (element = this.mElementMap.get(binding)) != null) {
            return element;
        }
        if (binding instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)binding;
            if (methodBinding.isConstructor() && (methodBinding.parameters == null || methodBinding.parameters.length == 0)) {
                return new EcjPsiBinaryMethod(this, methodBinding);
            }
            if (methodBinding.declaringClass instanceof SourceTypeBinding) {
                return null;
            }
            return new EcjPsiBinaryMethod(this, methodBinding);
        }
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            if (referenceBinding.compoundName == null) {
                return null;
            }
            if (referenceBinding.isAnnotationType() && referenceBinding instanceof SourceTypeBinding && (file = this.mEcjResult.findFileContaining(referenceBinding)) != null && (element = this.mElementMap.get(binding)) != null) {
                return element;
            }
            return new EcjPsiBinaryClass(this, referenceBinding);
        }
        if (binding instanceof FieldBinding) {
            FieldBinding fieldBinding = (FieldBinding)binding;
            if (fieldBinding.declaringClass instanceof SourceTypeBinding) {
                return null;
            }
            return new EcjPsiBinaryField(this, fieldBinding);
        }
        if (binding instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding;
            EcjPsiPackage pkg = new EcjPsiPackage(this, packageBinding);
            this.registerElement(binding, pkg);
            return pkg;
        }
        if (binding instanceof LocalVariableBinding) {
            LocalVariableBinding lvb = (LocalVariableBinding)binding;
            Scope scope = lvb.declaringScope;
            while (scope != null) {
                PsiElement declaration;
                PsiElement method;
                MethodScope methodScope;
                MethodBinding methodBinding;
                if (scope instanceof MethodScope && (methodBinding = (methodScope = (MethodScope)scope).referenceMethodBinding()) != null && (method = this.mElementMap.get(methodBinding)) != null && (declaration = EcjPsiManager.findElementWithBinding(method, lvb)) != null) {
                    return declaration;
                }
                scope = scope.parent;
            }
        }
        return null;
    }

    private static PsiElement findElementWithBinding(PsiElement root, Binding variableBinding) {
        VariableDeclarationFinder finder = new VariableDeclarationFinder(variableBinding);
        root.accept((PsiElementVisitor)finder);
        return finder.getMatch();
    }

    public void registerElement(Binding binding, PsiElement element) {
        if (binding != null) {
            assert (!this.mElementMap.containsKey(binding));
            this.mElementMap.put(binding, element);
        }
    }

    public static PsiElement findElementAt(PsiElement element, int offset) {
        TextRange range = element.getTextRange();
        if (range == null) {
            return null;
        }
        if (!range.containsOffset(offset)) {
            return null;
        }
        PsiElement child = element.getLastChild();
        if (child == null) {
            return null;
        }
        while (child != null) {
            PsiElement match = EcjPsiManager.findElementAt(child, offset);
            if (match != null) {
                return match;
            }
            child = child.getPrevSibling();
        }
        return element;
    }

    static Object inlineConstants(Object value) {
        if (value instanceof Constant) {
            return EcjPsiManager.getConstantValue((Constant)value);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length > 0) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)array.length);
                for (Object element : array) {
                    list.add(EcjPsiManager.inlineConstants(element));
                }
                if (!list.isEmpty()) {
                    Object first = list.get(0);
                    if (first instanceof String) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (first instanceof java.lang.annotation.Annotation) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (first instanceof Class) {
                        return list.toArray(new Class[list.size()]);
                    }
                }
                return list.toArray();
            }
            return value;
        }
        return value;
    }

    static Object getConstantValue(Constant value) {
        if (value == null || value == Constant.NotAConstant) {
            return null;
        }
        if (value instanceof StringConstant) {
            return value.stringValue();
        }
        if (value instanceof IntConstant) {
            return value.intValue();
        }
        if (value instanceof BooleanConstant) {
            return value.booleanValue();
        }
        if (value instanceof FloatConstant) {
            return Float.valueOf(value.floatValue());
        }
        if (value instanceof LongConstant) {
            return value.longValue();
        }
        if (value instanceof DoubleConstant) {
            return value.doubleValue();
        }
        if (value instanceof ShortConstant) {
            return value.shortValue();
        }
        if (value instanceof CharConstant) {
            return Character.valueOf(value.charValue());
        }
        if (value instanceof ByteConstant) {
            return value.byteValue();
        }
        return null;
    }

    static MethodBinding findSuperMethodBinding(MethodBinding binding, boolean allowStatic, boolean allowPrivate) {
        if (binding.isConstructor()) {
            return null;
        }
        if (!allowPrivate && binding.isPrivate()) {
            return null;
        }
        if (!allowStatic && binding.isStatic()) {
            return null;
        }
        try {
            for (ReferenceBinding superclass = binding.declaringClass.superclass(); superclass != null; superclass = superclass.superclass()) {
                MethodBinding[] methods;
                for (MethodBinding method : methods = superclass.getMethods(binding.selector, binding.parameters.length)) {
                    if (method.isStatic() != binding.isStatic() || !method.areParameterErasuresEqual(binding)) continue;
                    if (method.isPrivate()) {
                        if (method.declaringClass.outermostEnclosingType() == binding.declaringClass.outermostEnclosingType()) {
                            return method;
                        }
                        return null;
                    }
                    return method;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    ExternalAnnotationRepository getAnnotationRepository() {
        if (this.mAnnotationRepository == null && this.mClient != null) {
            this.mAnnotationRepository = ExternalAnnotationRepository.get(this.mClient);
        }
        return this.mAnnotationRepository;
    }

    static PsiAnnotation[] ensureUnique(List<PsiAnnotation> list) {
        if (list.isEmpty()) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        if (list.size() == 1) {
            return new PsiAnnotation[]{list.get(0)};
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PsiAnnotation current = list.get(i);
            String currentName = current.getQualifiedName();
            if (currentName == null) continue;
            boolean hasDuplicate = false;
            for (int j = n - 1; j > i; --j) {
                PsiAnnotation later = list.get(j);
                String laterName = later.getQualifiedName();
                if (!currentName.equals(laterName)) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            result.add(current);
        }
        return result.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    private static class VariableDeclarationFinder
    extends JavaRecursiveElementVisitor {
        private PsiElement mMatch;
        private final Binding mTargetBinding;

        public VariableDeclarationFinder(Binding binding) {
            this.mTargetBinding = binding;
        }

        public PsiElement getMatch() {
            return this.mMatch;
        }

        public void visitParameter(PsiParameter parameter) {
            EcjPsiSourceElement element = (EcjPsiSourceElement)parameter;
            Object nativeNode = element.getNativeNode();
            if (nativeNode instanceof LocalDeclaration) {
                LocalDeclaration node = (LocalDeclaration)nativeNode;
                if (node.binding == this.mTargetBinding) {
                    this.mMatch = parameter;
                }
            }
            super.visitParameter(parameter);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            EcjPsiSourceElement element = (EcjPsiSourceElement)variable;
            Object nativeNode = element.getNativeNode();
            if (nativeNode instanceof LocalDeclaration) {
                LocalDeclaration node = (LocalDeclaration)nativeNode;
                if (node.binding == this.mTargetBinding) {
                    this.mMatch = variable;
                }
            }
            super.visitLocalVariable(variable);
        }
    }
}

