/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryClass;
import com.android.tools.lint.psi.EcjPsiBinaryField;
import com.android.tools.lint.psi.EcjPsiBinaryMethod;
import com.android.tools.lint.psi.EcjPsiBinaryParameter;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiClassType;
import com.android.tools.lint.psi.EcjPsiElement;
import com.android.tools.lint.psi.EcjPsiField;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMethod;
import com.android.tools.lint.psi.EcjPsiPackage;
import com.android.tools.lint.psi.EcjPsiParameter;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.EcjPsiTypeParameter;
import com.android.tools.lint.psi.EcjPsiVariable;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class EcjPsiJavaEvaluator
extends JavaEvaluator {
    private final EcjPsiManager mManager;

    public EcjPsiJavaEvaluator(EcjPsiManager manager) {
        this.mManager = manager;
    }

    public boolean extendsClass(PsiClass cls, String className, boolean strict) {
        ReferenceBinding binding;
        if (cls instanceof EcjPsiClass) {
            binding = ((EcjPsiClass)cls).getBinding();
        } else if (cls instanceof EcjPsiBinaryClass) {
            binding = ((EcjPsiBinaryClass)cls).getTypeBinding();
        } else if (cls instanceof EcjPsiTypeParameter) {
            binding = ((EcjPsiTypeParameter)cls).getBinding();
        } else {
            return false;
        }
        if (strict && binding != null) {
            try {
                binding = binding.superclass();
            }
            catch (AbortCompilation ignore) {
                return false;
            }
        }
        while (binding != null) {
            if (EcjPsiJavaEvaluator.equalsCompound(className, binding.compoundName)) {
                return true;
            }
            binding = binding.superclass();
        }
        return false;
    }

    public boolean implementsInterface(PsiClass cls, String interfaceName, boolean strict) {
        ReferenceBinding binding;
        if (cls instanceof EcjPsiClass) {
            binding = ((EcjPsiClass)cls).getBinding();
        } else if (cls instanceof EcjPsiBinaryClass) {
            binding = ((EcjPsiBinaryClass)cls).getTypeBinding();
        } else {
            return false;
        }
        if (strict && binding != null) {
            try {
                binding = binding.superclass();
            }
            catch (AbortCompilation ignore) {
                return false;
            }
        }
        return EcjPsiJavaEvaluator.isInheritor(binding, interfaceName);
    }

    public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
        return this.implementsInterface(cls, className, strict);
    }

    static boolean equalsCompound(String name, char[][] compoundName) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        int n = compoundName.length;
        for (int i = 0; i < n; ++i) {
            char[] o = compoundName[i];
            int m = o.length;
            for (int j = 0; j < m; ++j) {
                if (index == length) {
                    return false;
                }
                if (name.charAt(index) != o[j] && (o[j] != '$' || name.charAt(index) != '.')) {
                    return false;
                }
                ++index;
            }
            if (i >= n - 1) continue;
            if (index == length) {
                return false;
            }
            if (name.charAt(index) != '.') {
                return false;
            }
            if (++index != length) continue;
            return false;
        }
        return index == length;
    }

    private static boolean isInheritor(ReferenceBinding cls, String name) {
        while (cls != null) {
            ReferenceBinding[] interfaces;
            for (ReferenceBinding binding : interfaces = cls.superInterfaces()) {
                if (!EcjPsiJavaEvaluator.isInheritor(binding, name)) continue;
                return true;
            }
            if (EcjPsiJavaEvaluator.equalsCompound(name, cls.compoundName)) {
                return true;
            }
            try {
                cls = cls.superclass();
            }
            catch (AbortCompilation ignore) {
                break;
            }
        }
        return false;
    }

    public String getInternalName(PsiClass psiClass) {
        Object nativeNode;
        ReferenceBinding binding = null;
        if (psiClass instanceof EcjPsiClass) {
            Object nativeNode2 = ((EcjPsiClass)psiClass).getNativeNode();
            binding = ((EcjPsiClass)psiClass).getBinding();
            if (nativeNode2 instanceof TypeDeclaration) {
                binding = ((TypeDeclaration)nativeNode2).binding;
            }
        } else if (psiClass instanceof EcjPsiBinaryClass) {
            Binding binaryBinding = ((EcjPsiBinaryClass)psiClass).getBinding();
            if (binaryBinding instanceof ReferenceBinding) {
                binding = (ReferenceBinding)binaryBinding;
            }
        } else if (psiClass instanceof EcjPsiTypeParameter && (nativeNode = ((EcjPsiTypeParameter)psiClass).getNativeNode()) instanceof TypeParameter) {
            TypeVariableBinding b = ((TypeParameter)nativeNode).binding;
            if (b.superclass != null) {
                binding = b.superclass;
            }
        }
        if (binding == null) {
            return super.getInternalName(psiClass);
        }
        return EcjPsiManager.getInternalName(binding.compoundName);
    }

    public String getInternalName(PsiClassType psiClassType) {
        if (psiClassType instanceof EcjPsiClassType) {
            ReferenceBinding binding = ((EcjPsiClassType)psiClassType).getBinding();
            if (binding.compoundName != null) {
                return EcjPsiManager.getInternalName(binding.compoundName);
            }
        }
        return super.getInternalName(psiClassType);
    }

    public PsiClass findClass(String fullyQualifiedName) {
        return this.mManager.findClass(fullyQualifiedName);
    }

    public PsiClassType getClassType(PsiClass psiClass) {
        if (psiClass != null) {
            return this.mManager.getClassType(psiClass);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PsiAnnotation[] getAllAnnotations(PsiModifierListOwner owner, boolean inHierarchy) {
        int index;
        MethodBinding method;
        EcjPsiElement parameter;
        if (!inHierarchy) {
            return this.getDirectAnnotations(owner);
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return this.getDirectAnnotations(owner);
        }
        if (owner instanceof PsiMethod) {
            MethodBinding method2;
            if (owner instanceof EcjPsiMethod) {
                EcjPsiMethod psiMethod = (EcjPsiMethod)owner;
                AbstractMethodDeclaration declaration = (AbstractMethodDeclaration)psiMethod.getNativeNode();
                assert (declaration != null);
                method2 = declaration.binding;
            } else if (owner instanceof EcjPsiBinaryMethod) {
                method2 = ((EcjPsiBinaryMethod)owner).getBinding();
            } else {
                assert (false) : owner.getClass();
                return PsiAnnotation.EMPTY_ARRAY;
            }
            ArrayList all = Lists.newArrayListWithExpectedSize((int)2);
            ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
            while (method2 != null && method2.declaringClass != null) {
                Collection<PsiAnnotation> external;
                PsiMethod methodElement = this.mManager.findMethod(method2);
                if (methodElement instanceof EcjPsiMethod) {
                    PsiModifierList methodModifiers = methodElement.getModifierList();
                    Collections.addAll(all, methodModifiers.getAnnotations());
                } else {
                    AnnotationBinding[] annotations = method2.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        all = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null || annotation == null) continue;
                            EcjPsiBinaryAnnotation a = modifierList != null ? new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)modifierList, annotation) : new EcjPsiBinaryAnnotation(this.mManager, method2, annotation);
                            all.add(a);
                        }
                    }
                }
                if (manager != null && (external = manager.getAnnotations(method2)) != null) {
                    all.addAll(external);
                }
                method2 = EcjPsiManager.findSuperMethodBinding(method2, false, false);
                modifierList = null;
            }
            return EcjPsiManager.ensureUnique(all);
        }
        if (owner instanceof PsiClass) {
            ReferenceBinding cls;
            if (owner instanceof EcjPsiClass) {
                EcjPsiClass psiClass = (EcjPsiClass)owner;
                cls = psiClass.getBinding();
            } else if (owner instanceof EcjPsiBinaryClass) {
                cls = ((EcjPsiBinaryClass)owner).getTypeBinding();
            } else {
                assert (false) : owner.getClass();
                return PsiAnnotation.EMPTY_ARRAY;
            }
            ArrayList all = Lists.newArrayListWithExpectedSize((int)2);
            ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
            while (cls != null) {
                Collection<PsiAnnotation> external;
                PsiClass clsElement = this.mManager.findClass(cls);
                if (clsElement instanceof EcjPsiClass) {
                    PsiModifierList clsModifiers = clsElement.getModifierList();
                    if (clsModifiers != null) {
                        Collections.addAll(all, clsModifiers.getAnnotations());
                    }
                } else {
                    AnnotationBinding[] annotations = cls.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        all = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null) continue;
                            EcjPsiBinaryAnnotation a = modifierList != null ? new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)modifierList, annotation) : new EcjPsiBinaryAnnotation(this.mManager, cls, annotation);
                            all.add(a);
                        }
                    }
                }
                if (manager != null && (external = manager.getAnnotations(cls)) != null) {
                    all.addAll(external);
                }
                try {
                    cls = cls.superclass();
                    modifierList = null;
                }
                catch (AbortCompilation ignore) {
                    return EcjPsiManager.ensureUnique(all);
                }
            }
            return EcjPsiManager.ensureUnique(all);
        }
        if (!(owner instanceof PsiParameter)) return this.getDirectAnnotations(owner);
        if (owner instanceof EcjPsiBinaryParameter) {
            parameter = (EcjPsiBinaryParameter)owner;
            method = ((EcjPsiBinaryParameter)parameter).getOwnerMethod().getBinding();
            index = ((EcjPsiBinaryParameter)parameter).getIndex();
        } else if (owner instanceof EcjPsiParameter) {
            parameter = (EcjPsiParameter)owner;
            if (!(((EcjPsiSourceElement)parameter).getParent() instanceof PsiParameterList)) return this.getDirectAnnotations(owner);
            EcjPsiMethod psiMethod = (EcjPsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((EcjPsiSourceElement)parameter).getParent(), PsiMethod.class, (boolean)true);
            if (psiMethod == null) {
                return this.getDirectAnnotations(owner);
            }
            index = ((PsiParameterList)((EcjPsiSourceElement)parameter).getParent()).getParameterIndex((PsiParameter)parameter);
            AbstractMethodDeclaration declaration = (AbstractMethodDeclaration)psiMethod.getNativeNode();
            assert (declaration != null);
            method = declaration.binding;
        } else {
            assert (false) : owner.getClass();
            return this.getDirectAnnotations(owner);
        }
        ArrayList all = Lists.newArrayListWithExpectedSize((int)2);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        while (method != null && method.declaringClass != null) {
            Collection<PsiAnnotation> external;
            PsiMethod methodElement = this.mManager.findMethod(method);
            if (methodElement instanceof EcjPsiMethod) {
                PsiModifierList parameterModifiers;
                PsiParameter[] parameters = methodElement.getParameterList().getParameters();
                if (index < parameters.length && (parameterModifiers = parameters[index].getModifierList()) != null) {
                    Collections.addAll(all, parameterModifiers.getAnnotations());
                }
            } else {
                AnnotationBinding[] annotations;
                int count;
                AnnotationBinding[][] parameterAnnotations = method.getParameterAnnotations();
                if (parameterAnnotations != null && index < parameterAnnotations.length && (count = (annotations = parameterAnnotations[index]).length) > 0) {
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null || annotation == null) continue;
                        EcjPsiBinaryAnnotation a = modifierList != null ? new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)modifierList, annotation) : new EcjPsiBinaryAnnotation(this.mManager, method, annotation);
                        all.add(a);
                    }
                }
            }
            if (manager != null && (external = manager.getParameterAnnotations(method, index)) != null) {
                all.addAll(external);
            }
            method = EcjPsiManager.findSuperMethodBinding(method, false, false);
            modifierList = null;
        }
        return EcjPsiManager.ensureUnique(all);
    }

    private PsiAnnotation[] getDirectAnnotations(PsiModifierListOwner owner) {
        PsiModifierList modifierList;
        ExternalAnnotationRepository repository = this.mManager.getAnnotationRepository();
        Collection<PsiAnnotation> annotations = null;
        if (repository != null) {
            EcjPsiSourceElement parent;
            EcjPsiElement parameter;
            Binding binding;
            if (owner instanceof EcjPsiMethod) {
                binding = ((EcjPsiMethod)owner).getBinding();
                if (binding != null) {
                    annotations = repository.getAnnotations((MethodBinding)binding);
                }
            } else if (owner instanceof EcjPsiBinaryMethod) {
                binding = ((EcjPsiBinaryMethod)owner).getBinding();
                annotations = repository.getAnnotations((MethodBinding)binding);
            } else if (owner instanceof EcjPsiClass) {
                binding = ((EcjPsiClass)owner).getBinding();
                if (binding != null) {
                    annotations = repository.getAnnotations((ReferenceBinding)binding);
                }
            } else if (owner instanceof EcjPsiBinaryClass) {
                binding = ((EcjPsiBinaryClass)owner).getTypeBinding();
                annotations = repository.getAnnotations((ReferenceBinding)binding);
            } else if (owner instanceof EcjPsiField) {
                binding = ((EcjPsiField)owner).getFieldBinding();
                if (binding != null) {
                    annotations = repository.getAnnotations((FieldBinding)binding);
                }
            } else if (owner instanceof EcjPsiParameter) {
                parameter = (EcjPsiParameter)owner;
                parent = ((EcjPsiSourceElement)parameter).getParent();
                LocalVariableBinding binding2 = ((EcjPsiVariable)parameter).getVariableBinding();
                if (parent instanceof PsiParameterList && binding2 != null) {
                    int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)parameter);
                    MethodBinding enclosingMethod = binding2.getEnclosingMethod();
                    if (enclosingMethod != null && index != -1) {
                        annotations = repository.getParameterAnnotations(enclosingMethod, index);
                    }
                }
            } else if (owner instanceof EcjPsiBinaryParameter) {
                int index;
                parameter = (EcjPsiBinaryParameter)owner;
                parent = ((EcjPsiBinaryParameter)parameter).getParent();
                EcjPsiBinaryMethod method = ((EcjPsiBinaryParameter)parameter).getOwnerMethod();
                MethodBinding enclosingMethod = method.getBinding();
                if (parent instanceof PsiParameterList && (index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)parameter)) != -1) {
                    annotations = repository.getParameterAnnotations(enclosingMethod, index);
                }
            } else if (owner instanceof EcjPsiBinaryField) {
                binding = ((EcjPsiBinaryField)owner).getBinding();
                if (binding != null) {
                    annotations = repository.getAnnotations((FieldBinding)binding);
                }
            } else if (owner instanceof EcjPsiPackage && (binding = ((EcjPsiPackage)owner).getPackageBinding()) != null) {
                annotations = repository.getAnnotations((PackageBinding)binding);
            }
        }
        if ((modifierList = owner.getModifierList()) != null) {
            Object[] modifierAnnotations = modifierList.getAnnotations();
            if (modifierAnnotations.length > 0) {
                if (annotations != null && !annotations.isEmpty()) {
                    ArrayList combined = Lists.newArrayList((Object[])modifierAnnotations);
                    combined.addAll(annotations);
                    return combined.toArray(PsiAnnotation.EMPTY_ARRAY);
                }
                return modifierAnnotations;
            }
            if (annotations != null && !annotations.isEmpty()) {
                return annotations.toArray(PsiAnnotation.EMPTY_ARRAY);
            }
            return modifierAnnotations;
        }
        if (annotations != null && !annotations.isEmpty()) {
            return annotations.toArray(PsiAnnotation.EMPTY_ARRAY);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, String ... annotationNames) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
        throw new UnimplementedLintPsiApiException();
    }

    public String findJarPath(PsiElement element) {
        while (true) {
            PsiElement cls;
            if ((cls = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)true)) == null) {
                ReferenceBinding binding;
                String jarFile;
                if (!(element instanceof EcjPsiBinaryClass) || (jarFile = this.mManager.getJarFile(binding = ((EcjPsiBinaryClass)element).getTypeBinding())) == null) break;
                return jarFile;
            }
            element = cls;
        }
        return null;
    }

    public PsiPackage getPackage(PsiElement node) {
        ReferenceBinding binding;
        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)node, PsiClass.class, (boolean)false);
        if (cls instanceof EcjPsiClass) {
            EcjPsiClass ecjPsiClass = (EcjPsiClass)cls;
            binding = ecjPsiClass.getBinding();
        } else if (cls instanceof EcjPsiBinaryClass) {
            EcjPsiBinaryClass ecjPsiClass = (EcjPsiBinaryClass)cls;
            binding = ecjPsiClass.getTypeBinding();
        } else {
            return null;
        }
        return binding != null ? this.mManager.findPackage(binding.fPackage) : null;
    }
}

