/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiBinaryField;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMember;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

class EcjPsiField
extends EcjPsiMember
implements PsiField {
    protected final FieldDeclaration mDeclaration;
    private PsiExpression mInitializer;
    private PsiModifierList mModifierList;
    private PsiIdentifier mIdentifier;
    private String mName;
    private PsiTypeElement mTypeElement;

    EcjPsiField(EcjPsiManager manager, EcjPsiClass containingClass, FieldDeclaration field) {
        super(manager, containingClass, null);
        this.setRange(field.declarationSourceStart, field.declarationSourceEnd + 1);
        this.mDeclaration = field;
        this.mNativeNode = this.mDeclaration;
        this.mManager.registerElement(field.binding, this);
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField((PsiField)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    void setModifierList(EcjPsiModifierList modifierList) {
        this.mModifierList = modifierList;
    }

    void setIdentifier(PsiIdentifier identifier) {
        this.mIdentifier = identifier;
    }

    void setTypeElement(PsiTypeElement typeElement) {
        this.mTypeElement = typeElement;
    }

    void setFieldInitializer(PsiExpression initializer) {
        this.mInitializer = initializer;
    }

    public PsiModifierList getModifierList() {
        return this.mModifierList;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.mModifierList.hasModifierProperty(s);
    }

    @Override
    public String getName() {
        if (this.mName == null) {
            this.mName = new String(this.mDeclaration.name);
        }
        return this.mName;
    }

    public PsiExpression getInitializer() {
        return this.mInitializer;
    }

    public boolean hasInitializer() {
        return this.mInitializer != null;
    }

    public PsiType getType() {
        PsiType type = this.mManager.findType(this.mDeclaration.type);
        if (type == null) {
            type = PsiType.NULL;
        }
        return type;
    }

    public PsiTypeElement getTypeElement() {
        return this.mTypeElement;
    }

    public Object computeConstantValue() {
        return EcjPsiManager.getConstantValue(this.mDeclaration.binding.constant());
    }

    public PsiIdentifier getNameIdentifier() {
        return this.mIdentifier;
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return this.mDeclaration.binding != null && (this.mDeclaration.binding.modifiers & 0x100000) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        FieldBinding binding = this.mDeclaration.binding;
        FieldBinding otherBinding = null;
        if (o instanceof EcjPsiField) {
            otherBinding = ((EcjPsiField)o).mDeclaration.binding;
        } else if (o instanceof EcjPsiBinaryField) {
            otherBinding = ((EcjPsiBinaryField)o).getBinding();
        }
        return binding != null && otherBinding != null && binding.equals(otherBinding);
    }

    public int hashCode() {
        return this.mDeclaration.binding != null ? this.mDeclaration.binding.hashCode() : 0;
    }

    FieldBinding getFieldBinding() {
        return this.mDeclaration.binding;
    }
}

