/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiBinaryMethod;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EcjPsiBinaryParameter
extends EcjPsiBinaryElement
implements PsiParameter,
PsiModifierList {
    private boolean mVarArgs;
    private final int mIndex;
    private final EcjPsiBinaryMethod mMethod;

    public EcjPsiBinaryParameter(EcjPsiManager manager, TypeBinding binding, EcjPsiBinaryMethod method, int index) {
        super(manager, binding);
        this.mMethod = method;
        this.mIndex = index;
    }

    void setVarArgs(boolean varArgs) {
        this.mVarArgs = varArgs;
    }

    EcjPsiBinaryMethod getOwnerMethod() {
        return this.mMethod;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isVarArgs() {
        return this.mVarArgs;
    }

    public PsiType getType() {
        PsiType type = this.mManager.findType((TypeBinding)this.mBinding);
        if (type == null) {
            type = PsiType.NULL;
        }
        return type;
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public String getName() {
        return null;
    }

    public PsiModifierList getModifierList() {
        return this;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.hasExplicitModifier(s);
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return this.mBinding instanceof ReferenceBinding && EcjPsiModifierList.hasModifier(((ReferenceBinding)this.mBinding).modifiers, s);
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.findAnnotations(false);
    }

    private PsiAnnotation[] findAnnotations(boolean includeSuper) {
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        MethodBinding binding = this.mMethod.getBinding();
        while (binding != null) {
            Collection<PsiAnnotation> external;
            AnnotationBinding[] annotations;
            AnnotationBinding[][] parameterAnnotations;
            if (binding.declaringClass != null && (parameterAnnotations = binding.getParameterAnnotations()) != null && this.mIndex < parameterAnnotations.length && (annotations = parameterAnnotations[this.mIndex]) != null && annotations.length > 0) {
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
                }
            }
            if (manager != null && (external = manager.getParameterAnnotations(binding, this.mIndex)) != null) {
                all.addAll(external);
            }
            if (includeSuper && ((binding = EcjPsiManager.findSuperMethodBinding(binding, false, false)) == null || !binding.isPrivate())) continue;
            break;
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }
}

