/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiBinaryParameter;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMethod;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.ExternalPsiReferenceExpressionMemberValue;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class EcjPsiBinaryMethod
extends EcjPsiBinaryElement
implements PsiMethod,
PsiParameterList,
PsiModifierList {
    private final MethodBinding mMethodBinding;
    private String mName;
    private EcjPsiBinaryParameter[] mParameters;

    EcjPsiBinaryMethod(EcjPsiManager manager, MethodBinding binding) {
        super(manager, binding);
        this.mMethodBinding = binding;
    }

    @Override
    public MethodBinding getBinding() {
        return this.mMethodBinding;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void acceptChildren(PsiElementVisitor visitor) {
    }

    @Override
    public PsiElement getParent() {
        if (this.mMethodBinding.declaringClass != null) {
            return this.mManager.findClass(this.mMethodBinding.declaringClass);
        }
        return null;
    }

    public String getName() {
        if (this.mName == null) {
            if (this.mMethodBinding.isConstructor()) {
                ReferenceBinding cls;
                for (cls = this.mMethodBinding.declaringClass; cls != null && cls.isAnonymousType(); cls = cls.superclass()) {
                }
                if (cls != null) {
                    char[][] compoundName = cls.compoundName;
                    this.mName = new String(compoundName[compoundName.length - 1]);
                    return this.mName;
                }
            }
            this.mName = new String(this.mMethodBinding.selector);
        }
        return this.mName;
    }

    public PsiType getReturnType() {
        return this.mManager.findType(this.mMethodBinding.returnType);
    }

    @Override
    public PsiReference getReference() {
        throw new UnimplementedLintPsiApiException();
    }

    @Override
    public PsiReference[] getReferences() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiTypeElement getReturnTypeElement() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiReferenceList getThrowsList() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isConstructor() {
        return this.mMethodBinding.isConstructor();
    }

    public boolean isVarArgs() {
        return this.mMethodBinding.isVarargs();
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiMethod[] findSuperMethods() {
        return this.getSuperMethods(true);
    }

    private PsiMethod[] getSuperMethods(boolean checkAccess) {
        PsiMethod method;
        MethodBinding superBinding = EcjPsiManager.findSuperMethodBinding(this.mMethodBinding, false, checkAccess);
        if (superBinding != null && (method = this.mManager.findMethod(superBinding)) != null) {
            return new PsiMethod[]{method};
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return this.getSuperMethods(checkAccess);
    }

    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod findDeepestSuperMethod() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findDeepestSuperMethods() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return (this.mMethodBinding.modifiers & 0x100000) != 0;
    }

    public boolean hasTypeParameters() {
        return this.mMethodBinding.typeVariables != null && this.mMethodBinding.typeVariables.length > 0;
    }

    public PsiTypeParameterList getTypeParameterList() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiTypeParameter[] getTypeParameters() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClass getContainingClass() {
        return this.mManager.findClass(this.mMethodBinding.declaringClass);
    }

    public PsiParameterList getParameterList() {
        return this;
    }

    public PsiParameter[] getParameters() {
        if (this.mParameters == null) {
            TypeBinding[] parameters = this.mMethodBinding.parameters;
            this.mParameters = new EcjPsiBinaryParameter[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.mParameters[i] = new EcjPsiBinaryParameter(this.mManager, parameters[i], this, i);
            }
            if (this.mMethodBinding.isVarargs() && parameters.length > 0) {
                this.mParameters[parameters.length - 1].setVarArgs(true);
            }
        }
        return this.mParameters;
    }

    public int getParameterIndex(PsiParameter psiParameter) {
        PsiParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != psiParameter) continue;
            return i;
        }
        return -1;
    }

    public int getParametersCount() {
        return this.getParameters().length;
    }

    public PsiModifierList getModifierList() {
        return this;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.hasExplicitModifier(s);
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return EcjPsiModifierList.hasModifier(this.mMethodBinding.modifiers, s);
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.findAnnotations(false);
    }

    private PsiAnnotation[] findAnnotations(boolean includeSuper) {
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        MethodBinding binding = this.mMethodBinding;
        while (binding != null) {
            Collection<PsiAnnotation> external;
            AnnotationBinding[] annotations;
            int count;
            if (binding.declaringClass != null && (count = (annotations = binding.getAnnotations()).length) > 0) {
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
                }
            }
            if (manager != null && (external = manager.getAnnotations(binding)) != null) {
                all.addAll(external);
            }
            if (includeSuper && ((binding = EcjPsiManager.findSuperMethodBinding(binding, false, false)) == null || !binding.isPrivate())) continue;
            break;
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        MethodBinding binding = this.mMethodBinding;
        if (o instanceof EcjPsiMethod) {
            MethodBinding otherBinding = ((EcjPsiMethod)o).getBinding();
            return binding != null && otherBinding != null && binding.equals(otherBinding);
        }
        if (o instanceof EcjPsiBinaryMethod) {
            MethodBinding otherBinding = ((EcjPsiBinaryMethod)o).getBinding();
            return binding != null && otherBinding != null && binding.equals(otherBinding);
        }
        if (o instanceof ExternalPsiReferenceExpressionMemberValue) {
            String fqn;
            String signature = ((ExternalPsiReferenceExpressionMemberValue)o).getQualifiedName();
            PsiClass containingClass = this.getContainingClass();
            if (containingClass != null && (fqn = containingClass.getQualifiedName()) != null && signature.startsWith(fqn) && signature.endsWith(this.getName()) && signature.length() == fqn.length() + this.getName().length() + 1) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mMethodBinding.hashCode();
    }
}

