/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiField;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

class EcjPsiBinaryField
extends EcjPsiBinaryElement
implements PsiField,
PsiModifierList {
    private final FieldBinding mBinding;
    private String mName;

    EcjPsiBinaryField(EcjPsiManager manager, FieldBinding binding) {
        super(manager, binding);
        this.mBinding = binding;
    }

    @Override
    FieldBinding getBinding() {
        return this.mBinding;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField((PsiField)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void acceptChildren(PsiElementVisitor visitor) {
    }

    @Override
    public PsiElement getParent() {
        if (this.mBinding.declaringClass != null) {
            return this.mManager.findClass(this.mBinding.declaringClass);
        }
        return null;
    }

    public String getName() {
        if (this.mName == null) {
            this.mName = new String(this.mBinding.name);
        }
        return this.mName;
    }

    public PsiType getType() {
        PsiType type = this.mManager.findType(this.mBinding.type);
        if (type == null) {
            type = PsiType.NULL;
        }
        return type;
    }

    public PsiTypeElement getTypeElement() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    @Override
    public PsiReference getReference() {
        throw new UnimplementedLintPsiApiException();
    }

    @Override
    public PsiReference[] getReferences() {
        throw new UnimplementedLintPsiApiException();
    }

    public Object computeConstantValue() {
        return EcjPsiManager.getConstantValue(this.mBinding.constant());
    }

    public PsiIdentifier getNameIdentifier() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return (this.mBinding.modifiers & 0x100000) != 0;
    }

    public PsiClass getContainingClass() {
        return this.mManager.findClass(this.mBinding.declaringClass);
    }

    public PsiModifierList getModifierList() {
        return this;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.hasExplicitModifier(s);
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return EcjPsiModifierList.hasModifier(this.mBinding.modifiers, s);
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        Collection<PsiAnnotation> external;
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        AnnotationBinding[] annotations = this.mBinding.getAnnotations();
        int count = annotations.length;
        if (count > 0) {
            for (AnnotationBinding annotation : annotations) {
                if (annotation == null) continue;
                all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
            }
        }
        if (manager != null && (external = manager.getAnnotations(this.mBinding)) != null) {
            all.addAll(external);
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        FieldBinding binding = this.mBinding;
        FieldBinding otherBinding = null;
        if (o instanceof EcjPsiField) {
            otherBinding = ((EcjPsiField)o).mDeclaration.binding;
        } else if (o instanceof EcjPsiBinaryField) {
            otherBinding = ((EcjPsiBinaryField)o).getBinding();
        }
        return binding != null && otherBinding != null && binding.equals(otherBinding);
    }

    public int hashCode() {
        return this.mBinding.hashCode();
    }
}

