/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.EcjParser;
import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiBinaryField;
import com.android.tools.lint.psi.EcjPsiBinaryMethod;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiJavaEvaluator;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

class EcjPsiBinaryClass
extends EcjPsiBinaryElement
implements PsiClass,
PsiModifierList {
    private final String mQualifiedName;
    private final String mName;
    private final ReferenceBinding mTypeBinding;

    EcjPsiBinaryClass(EcjPsiManager manager, ReferenceBinding typeBinding) {
        super(manager, typeBinding);
        this.mTypeBinding = typeBinding;
        char[][] symbols = this.mTypeBinding.compoundName;
        this.mQualifiedName = EcjPsiManager.getTypeName(symbols);
        this.mName = this.mQualifiedName.substring(this.mQualifiedName.length() - symbols[symbols.length - 1].length);
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void acceptChildren(PsiElementVisitor visitor) {
        for (PsiMethod psiMethod : this.getMethods()) {
            psiMethod.accept(visitor);
        }
        for (PsiMethod psiMethod : this.getFields()) {
            psiMethod.accept(visitor);
        }
        for (PsiMethod psiMethod : this.getInnerClasses()) {
            psiMethod.accept(visitor);
        }
    }

    ReferenceBinding getTypeBinding() {
        return this.mTypeBinding;
    }

    public String getName() {
        return this.mName;
    }

    public String getQualifiedName() {
        return this.mQualifiedName;
    }

    public boolean isInterface() {
        return this.mTypeBinding.isInterface();
    }

    public boolean isAnnotationType() {
        return this.mTypeBinding.isAnnotationType();
    }

    public boolean isEnum() {
        return this.mTypeBinding.isEnum();
    }

    public PsiReferenceList getExtendsList() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiReferenceList getImplementsList() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClassType[] getExtendsListTypes() {
        PsiClassType classType = this.mManager.findClassType(this.mTypeBinding.superclass());
        assert (classType != null);
        return new PsiClassType[]{classType};
    }

    public PsiClassType[] getImplementsListTypes() {
        return this.mManager.findClassTypes(this.mTypeBinding.superInterfaces());
    }

    public PsiClass getSuperClass() {
        return this.mManager.findClass(this.mTypeBinding.superclass());
    }

    public PsiClass[] getInterfaces() {
        return this.mManager.findClasses(null, this.mTypeBinding.superInterfaces());
    }

    public PsiClass[] getSupers() {
        return this.mManager.findClasses(this.mTypeBinding.superclass(), this.mTypeBinding.superInterfaces());
    }

    public PsiClassType[] getSuperTypes() {
        PsiClass[] supers = this.getSupers();
        ArrayList types = Lists.newArrayListWithCapacity((int)supers.length);
        for (PsiClass cls : supers) {
            PsiClassType type = this.mManager.getClassType(cls);
            if (type == null) continue;
            types.add(type);
        }
        return types.toArray(PsiClassType.EMPTY_ARRAY);
    }

    public PsiField[] getAllFields() {
        return this.getFields(true);
    }

    public PsiField[] getFields() {
        return this.getFields(false);
    }

    private PsiField[] getFields(boolean includeInherited) {
        if (this.mBinding instanceof ReferenceBinding) {
            ReferenceBinding cls;
            if (includeInherited) {
                List result = null;
                for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    int count;
                    FieldBinding[] fields = cls.fields();
                    if (fields == null || (count = fields.length) <= 0) continue;
                    if (result == null) {
                        result = Lists.newArrayListWithExpectedSize((int)count);
                    }
                    for (FieldBinding field : fields) {
                        if ((field.modifiers & 2) != 0 && cls != this.mBinding) continue;
                        boolean masked = false;
                        for (EcjPsiBinaryField f : result) {
                            FieldBinding mb = f.getBinding();
                            if (!Arrays.equals(mb.readableName(), field.readableName())) continue;
                            masked = true;
                            break;
                        }
                        if (masked) continue;
                        result.add(new EcjPsiBinaryField(this.mManager, field));
                    }
                }
                return result != null ? result.toArray(PsiField.EMPTY_ARRAY) : PsiField.EMPTY_ARRAY;
            }
            FieldBinding[] fields = cls.fields();
            if (fields != null) {
                int count = fields.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (FieldBinding field : fields) {
                    result.add(new EcjPsiBinaryField(this.mManager, field));
                }
                return result.toArray(PsiField.EMPTY_ARRAY);
            }
        }
        return PsiField.EMPTY_ARRAY;
    }

    public PsiMethod[] getMethods() {
        return this.findMethods(null, false, true);
    }

    public PsiMethod[] getConstructors() {
        ReferenceBinding cls;
        MethodBinding[] methods;
        if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(TypeConstants.INIT)) != null) {
            int count = methods.length;
            ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
            for (MethodBinding method : methods) {
                if (!method.isConstructor()) continue;
                result.add(new EcjPsiBinaryMethod(this.mManager, method));
            }
            return result.toArray(PsiMethod.EMPTY_ARRAY);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiClass[] getInnerClasses() {
        ReferenceBinding[] referenceBindings = this.mTypeBinding.memberTypes();
        if (referenceBindings.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] result = new PsiClass[referenceBindings.length];
        for (int i = 0; i < referenceBindings.length; ++i) {
            result[i] = new EcjPsiBinaryClass(this.mManager, referenceBindings[i]);
        }
        return result;
    }

    public PsiClassInitializer[] getInitializers() {
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiMethod[] getAllMethods() {
        return this.findMethods(null, true, true);
    }

    public PsiClass[] getAllInnerClasses() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        if (this.mBinding instanceof ReferenceBinding) {
            for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                FieldBinding[] fields = cls.fields();
                if (fields != null) {
                    for (FieldBinding field : fields) {
                        if ((field.modifiers & 2) != 0 && cls != this.mBinding || !EcjParser.sameChars(name, field.name)) continue;
                        return new EcjPsiBinaryField(this.mManager, field);
                    }
                }
                if (!checkBases) break;
            }
        }
        return null;
    }

    private PsiMethod[] findMethods(String name, boolean includeInherited, boolean includeConstructors) {
        if (this.mBinding instanceof ReferenceBinding) {
            MethodBinding[] methods;
            ReferenceBinding cls;
            if (includeInherited) {
                List result = null;
                for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    int count;
                    MethodBinding[] methods2;
                    MethodBinding[] methodBindingArray = methods2 = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                    if (methods2 == null || (count = methods2.length) <= 0) continue;
                    if (result == null) {
                        result = Lists.newArrayListWithExpectedSize((int)count);
                    }
                    for (MethodBinding method : methods2) {
                        if ((method.modifiers & 2) != 0 && cls != this.mBinding || !includeConstructors && method.isConstructor()) continue;
                        boolean masked = false;
                        for (PsiMethod m : result) {
                            MethodBinding mb = ((EcjPsiBinaryMethod)m).getBinding();
                            if (!mb.areParameterErasuresEqual(method)) continue;
                            masked = true;
                            break;
                        }
                        if (masked) continue;
                        result.add(new EcjPsiBinaryMethod(this.mManager, method));
                    }
                }
                return result != null ? result.toArray(PsiMethod.EMPTY_ARRAY) : PsiMethod.EMPTY_ARRAY;
            }
            MethodBinding[] methodBindingArray = methods = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
            if (methods != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (!includeConstructors && method.isConstructor()) continue;
                    result.add(new EcjPsiBinaryMethod(this.mManager, method));
                }
                return result.toArray(PsiMethod.EMPTY_ARRAY);
            }
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiMethod findMethodBySignature(PsiMethod psiMethod, boolean b) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findMethodsBySignature(PsiMethod psiMethod, boolean b) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        return this.findMethods(name, checkBases, false);
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String s, boolean b) {
        throw new UnimplementedLintPsiApiException();
    }

    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiElement getLBrace() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiElement getRBrace() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiElement getScope() {
        return this.getContainingFile();
    }

    public boolean isInheritor(PsiClass baseClass, boolean checkDeep) {
        String qualifiedName = baseClass.getQualifiedName();
        return qualifiedName != null && new EcjPsiJavaEvaluator(this.mManager).inheritsFrom(this, qualifiedName, false);
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiClass getContainingClass() {
        if (this.mTypeBinding.enclosingType() != null) {
            return this.mManager.findClass(this.mTypeBinding.enclosingType());
        }
        return null;
    }

    @Override
    public PsiElement getParent() {
        if (this.mTypeBinding.enclosingType() != null) {
            return this.mManager.findClass(this.mTypeBinding.enclosingType());
        }
        if (this.mTypeBinding.fPackage != null) {
            return this.mManager.findPackage(this.mTypeBinding.fPackage);
        }
        return null;
    }

    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return (this.mTypeBinding.modifiers & 0x100000) != 0;
    }

    public boolean hasTypeParameters() {
        return this.mTypeBinding.isGenericType();
    }

    public PsiTypeParameterList getTypeParameterList() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiTypeParameter[] getTypeParameters() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiModifierList getModifierList() {
        return this;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.hasExplicitModifier(s);
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return EcjPsiModifierList.hasModifier(this.mTypeBinding.modifiers, s);
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.findAnnotations(false);
    }

    private PsiAnnotation[] findAnnotations(boolean includeSuper) {
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        if (this.mBinding instanceof ReferenceBinding) {
            for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                Collection<PsiAnnotation> external;
                AnnotationBinding[] annotations;
                try {
                    annotations = cls.getAnnotations();
                }
                catch (AbortCompilation e) {
                    annotations = new AnnotationBinding[]{};
                }
                int count = annotations.length;
                if (count > 0) {
                    all = Lists.newArrayListWithExpectedSize((int)count);
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null) continue;
                        all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
                    }
                }
                if (manager != null && (external = manager.getAnnotations(cls)) != null) {
                    all.addAll(external);
                }
                if (!includeSuper) break;
            }
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        ReferenceBinding binding = this.mTypeBinding;
        if (o instanceof EcjPsiClass) {
            ReferenceBinding otherBinding = ((EcjPsiClass)o).getBinding();
            return binding != null && otherBinding != null && binding.equals(otherBinding);
        }
        if (o instanceof EcjPsiBinaryClass) {
            ReferenceBinding otherBinding = ((EcjPsiBinaryClass)o).getTypeBinding();
            return binding != null && binding.equals(otherBinding);
        }
        return false;
    }

    public int hashCode() {
        return this.mTypeBinding != null ? this.mTypeBinding.hashCode() : 0;
    }
}

