/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.EcjParser;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintCliXmlParser;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Beta
public class LintCliClient
extends LintClient {
    protected final List<Warning> warnings = new ArrayList<Warning>();
    protected boolean hasErrors;
    protected int errorCount;
    protected int warningCount;
    protected IssueRegistry registry;
    protected LintDriver driver;
    protected final LintCliFlags flags;
    private Configuration configuration;
    private boolean validatedIds;
    private final Map<File, CharSequence> mFileContents = new HashMap<File, CharSequence>(100);
    private Map<Project, LintClient.ClassPathInfo> mProjectInfo;
    private static Set<File> sAlreadyWarned;

    public LintCliClient() {
        super("cli");
        this.flags = new LintCliFlags();
        TextReporter reporter = new TextReporter(this, this.flags, new PrintWriter(System.out, true), false);
        this.flags.getReporters().add(reporter);
    }

    public LintCliClient(LintCliFlags flags, String clientName) {
        super(clientName);
        this.flags = flags;
    }

    public int run(IssueRegistry registry, List<File> files) throws IOException {
        assert (!this.flags.getReporters().isEmpty());
        this.registry = registry;
        this.driver = new LintDriver(registry, (LintClient)this);
        this.driver.setAbbreviating(!this.flags.isShowEverything());
        File baselineFile = this.flags.getBaselineFile();
        LintBaseline baseline = null;
        if (baselineFile != null) {
            baseline = new LintBaseline((LintClient)this, baselineFile);
            this.driver.setBaseline(baseline);
            if (this.flags.isRemoveFixedBaselineIssues()) {
                baseline.setWriteOnClose(true);
                baseline.setRemoveFixed(true);
            }
        }
        this.addProgressPrinter();
        this.driver.addLintListener((driver, type, context) -> {
            if (type == LintListener.EventType.SCANNING_PROJECT && !this.validatedIds) {
                this.validateIssueIds(context != null ? context.getProject() : null);
            }
        });
        this.driver.analyze(this.createLintRequest(files));
        Collections.sort(this.warnings);
        int baselineErrorCount = 0;
        int baselineWarningCount = 0;
        int fixedCount = 0;
        if (baseline != null) {
            baselineErrorCount = baseline.getFoundErrorCount();
            baselineWarningCount = baseline.getFoundWarningCount();
            fixedCount = baseline.getFixedCount();
        }
        Reporter.Stats stats = new Reporter.Stats(this.errorCount, this.warningCount, baselineErrorCount, baselineWarningCount, fixedCount);
        boolean hasConsoleOutput = false;
        for (Reporter reporter : this.flags.getReporters()) {
            reporter.write(stats, this.warnings);
            if (!(reporter instanceof TextReporter) || !((TextReporter)reporter).isWriteToConsole()) continue;
            hasConsoleOutput = true;
        }
        if (!this.flags.isQuiet() && !hasConsoleOutput) {
            System.out.print(String.format("Lint found %1$s", LintUtils.describeCounts((int)this.errorCount, (int)this.warningCount, (boolean)true)));
            if (baselineErrorCount > 0 || baselineWarningCount > 0) {
                System.out.print(String.format(" (%1$s filtered by baseline %2$s)", LintUtils.describeCounts((int)stats.baselineErrorCount, (int)stats.baselineWarningCount, (boolean)true), this.flags.getBaselineFile().getName()));
            }
            System.out.println();
        }
        if (baselineFile != null && !baselineFile.exists() && this.flags.isWriteBaselineIfMissing()) {
            File dir = baselineFile.getParentFile();
            boolean ok = true;
            if (dir != null && !dir.isDirectory()) {
                ok = dir.mkdirs();
            }
            if (!ok) {
                System.err.println("Couldn't create baseline folder " + dir);
            } else {
                Reporter reporter = Reporter.createXmlReporter(this, baselineFile, true);
                reporter.write(stats, this.warnings);
                String message = "Created baseline file " + baselineFile + "\n" + "\n" + "Also breaking the build in case this was not intentional. If you\n" + "deliberately created the baseline file, re-run the build and this\n" + "time it should succeed without warnings.\n" + "\n" + "If not, investigate the baseline path in the lintOptions config\n" + "or verify that the baseline file has been checked into version\n" + "control.\n";
                System.err.println(message);
                return 6;
            }
        }
        return this.flags.isSetExitCode() ? (this.hasErrors ? 1 : 0) : 0;
    }

    protected void addProgressPrinter() {
        if (!this.flags.isQuiet()) {
            this.driver.addLintListener((LintListener)new ProgressPrinter());
        }
    }

    protected LintRequest createLintRequest(List<File> files) {
        return new LintRequest((LintClient)this, files);
    }

    public void log(Severity severity, Throwable exception, String format, Object ... args) {
        System.out.flush();
        if (!this.flags.isQuiet()) {
            System.err.println();
        }
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public XmlParser getXmlParser() {
        return new LintCliXmlParser();
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        return new CliConfiguration(this.getConfiguration(), project, this.flags.isFatalOnly());
    }

    private CharSequence getContents(File file) {
        return this.mFileContents.computeIfAbsent(file, k -> this.readFile(file));
    }

    public JavaParser getJavaParser(Project project) {
        return new EcjParser(this, project);
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format) {
        File file;
        assert (context.isEnabled(issue) || issue == IssueRegistry.LINT_ERROR);
        if (severity.isError()) {
            this.hasErrors = true;
            ++this.errorCount;
        } else {
            ++this.warningCount;
        }
        message = format.convertTo(message, TextFormat.RAW);
        Warning warning = new Warning(issue, message, severity, context.getProject());
        this.warnings.add(warning);
        if (location == null) {
            this.log(Severity.ERROR, null, "No location provided for issue " + issue, new Object[0]);
            return;
        }
        warning.location = location;
        warning.file = file = location.getFile();
        warning.path = this.getDisplayPath(context.getProject(), file);
        Position startPosition = location.getStart();
        if (startPosition != null) {
            int line;
            warning.line = line = startPosition.getLine();
            warning.offset = startPosition.getOffset();
            Position endPosition = location.getEnd();
            if (endPosition != null) {
                warning.endOffset = endPosition.getOffset();
            }
            if (line >= 0) {
                if (context.file == location.getFile()) {
                    warning.fileContents = context.getContents();
                }
                if (warning.fileContents == null) {
                    warning.fileContents = this.getContents(location.getFile());
                }
                if (this.flags.isShowSourceLines()) {
                    warning.errorLine = LintCliClient.getLine(warning.fileContents, line);
                    if (warning.errorLine != null) {
                        warning.errorLine = warning.errorLine.replace('\t', ' ');
                        int column = startPosition.getColumn();
                        if (column < 0) {
                            column = 0;
                            int i = 0;
                            while (i < warning.errorLine.length() && Character.isWhitespace(warning.errorLine.charAt(i))) {
                                ++i;
                                ++column;
                            }
                        }
                        StringBuilder sb = new StringBuilder(100);
                        sb.append(warning.errorLine);
                        sb.append('\n');
                        for (int i = 0; i < column; ++i) {
                            sb.append(' ');
                        }
                        boolean displayCaret = true;
                        if (endPosition != null) {
                            int endLine = endPosition.getLine();
                            int endColumn = endPosition.getColumn();
                            if (endLine == line && endColumn > column) {
                                for (int i = column; i < endColumn; ++i) {
                                    sb.append('~');
                                }
                                displayCaret = false;
                            }
                        }
                        if (displayCaret) {
                            sb.append('^');
                        }
                        sb.append('\n');
                        warning.errorLine = sb.toString();
                    }
                }
            }
        }
    }

    static String getLine(CharSequence contents, int line) {
        int index = LintCliClient.getLineOffset(contents, line);
        if (index != -1) {
            return LintCliClient.getLineOfOffset(contents, index);
        }
        return null;
    }

    static String getLineOfOffset(CharSequence contents, int offset) {
        int end = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
        if (end == -1) {
            end = CharSequences.indexOf((CharSequence)contents, (char)'\r', (int)offset);
        }
        return contents.subSequence(offset, end != -1 ? end : contents.length()).toString();
    }

    static int getLineOffset(CharSequence contents, int line) {
        int index = 0;
        for (int i = 0; i < line; ++i) {
            if ((index = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)index)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    public CharSequence readFile(File file) {
        try {
            return LintUtils.getEncodedString((LintClient)this, (File)file, (boolean)false);
        }
        catch (IOException e) {
            return "";
        }
    }

    boolean isCheckingSpecificIssues() {
        return this.flags.getExactCheckedIds() != null;
    }

    protected LintClient.ClassPathInfo getClassPath(Project project) {
        LintClient.ClassPathInfo info;
        LintClient.ClassPathInfo classPath = super.getClassPath(project);
        List sources = this.flags.getSourcesOverride();
        List classes = this.flags.getClassesOverride();
        List libraries = this.flags.getLibrariesOverride();
        if (classes == null && sources == null && libraries == null) {
            return classPath;
        }
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            if (sources == null) {
                sources = classPath.getSourceFolders();
            }
            if (classes == null) {
                classes = classPath.getClassFolders();
            }
            if (libraries == null) {
                libraries = classPath.getLibraries(true);
            }
            info = new LintClient.ClassPathInfo(sources, classes, libraries, classPath.getLibraries(false), classPath.getTestSourceFolders(), classPath.getTestLibraries());
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    public List<File> getResourceFolders(Project project) {
        List<File> resources = this.flags.getResourcesOverride();
        if (resources == null) {
            return super.getResourceFolders(project);
        }
        return resources;
    }

    private void validateIssueIds(Project project) {
        if (this.driver != null) {
            IssueRegistry registry = this.driver.getRegistry();
            if (!registry.isIssueId(HardcodedValuesDetector.ISSUE.getId())) {
                return;
            }
            this.validatedIds = true;
            this.validateIssueIds(project, registry, this.flags.getExactCheckedIds());
            this.validateIssueIds(project, registry, this.flags.getEnabledIds());
            this.validateIssueIds(project, registry, this.flags.getSuppressedIds());
            this.validateIssueIds(project, registry, this.flags.getSeverityOverrides().keySet());
        }
    }

    private void validateIssueIds(Project project, IssueRegistry registry, Collection<String> ids) {
        if (ids != null) {
            for (String id : ids) {
                if (registry.getIssue(id) != null) continue;
                this.reportNonExistingIssueId(project, id);
            }
        }
    }

    protected void reportNonExistingIssueId(Project project, String id) {
        String message = String.format("Unknown issue id \"%1$s\"", id);
        if (this.driver != null && project != null) {
            Location location = Location.create((File)project.getDir());
            if (!this.isSuppressed(IssueRegistry.LINT_ERROR)) {
                this.report(new Context(this.driver, project, project, project.getDir()), IssueRegistry.LINT_ERROR, project.getConfiguration(this.driver).getSeverity(IssueRegistry.LINT_ERROR), location, message, TextFormat.RAW);
            }
        } else {
            this.log(Severity.ERROR, null, "Lint: %1$s", message);
        }
    }

    static String getCleanPath(File file) {
        String path = file.getPath();
        StringBuilder sb = new StringBuilder(path.length());
        if (path.startsWith(File.separator)) {
            sb.append(File.separator);
        }
        block0: for (String element : Splitter.on((char)File.separatorChar).omitEmptyStrings().split((CharSequence)path)) {
            if (element.equals(".")) continue;
            if (element.equals("..") && sb.length() > 0) {
                for (int i = sb.length() - 1; i >= 0; --i) {
                    char c = sb.charAt(i);
                    if (c != File.separatorChar) continue;
                    sb.setLength(i == 0 ? 1 : i);
                    continue block0;
                }
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 1) {
                sb.append(File.separatorChar);
            } else if (sb.length() > 0 && sb.charAt(0) != File.separatorChar) {
                sb.append(File.separatorChar);
            }
            sb.append(element);
        }
        if (path.endsWith(File.separator) && sb.length() > 0 && sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        return sb.toString();
    }

    String getDisplayPath(Project project, File file) {
        return LintCliClient.getDisplayPath(project, file, this.flags.isFullPath());
    }

    static String getDisplayPath(Project project, File file, boolean fullPath) {
        String path = file.getPath();
        if (!fullPath && path.startsWith(project.getReferenceDir().getPath())) {
            int chop = project.getReferenceDir().getPath().length();
            if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                ++chop;
            }
            if ((path = path.substring(chop)).isEmpty()) {
                path = file.getName();
            }
        } else if (fullPath) {
            path = LintCliClient.getCleanPath(file.getAbsoluteFile());
        }
        return path;
    }

    boolean isAllEnabled() {
        return this.flags.isCheckAllWarnings();
    }

    IssueRegistry getRegistry() {
        return this.registry;
    }

    LintDriver getDriver() {
        return this.driver;
    }

    protected Configuration getConfiguration() {
        File configFile;
        if (this.configuration == null && (configFile = this.flags.getDefaultConfiguration()) != null) {
            if (!configFile.exists()) {
                if (sAlreadyWarned == null || !sAlreadyWarned.contains(configFile)) {
                    this.log(Severity.ERROR, null, "Warning: Configuration file %1$s does not exist", configFile);
                }
                if (sAlreadyWarned == null) {
                    sAlreadyWarned = Sets.newHashSet();
                }
                sAlreadyWarned.add(configFile);
            }
            this.configuration = this.createConfigurationFromFile(configFile);
        }
        return this.configuration;
    }

    boolean isSuppressed(Issue issue) {
        return this.flags.getSuppressedIds().contains(issue.getId());
    }

    public Configuration createConfigurationFromFile(File file) {
        return new CliConfiguration(file, this.flags.isFatalOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientRevision() {
        File file = this.findResource("tools" + File.separator + "source.properties");
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(input);
                String revision = properties.getProperty("Pkg.Revision");
                if (revision != null && !revision.isEmpty()) {
                    String string = revision;
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    Closeables.close((Closeable)input, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public LintCliFlags getFlags() {
        return this.flags;
    }

    public boolean haveErrors() {
        return this.errorCount > 0;
    }

    public void reset() {
        this.warnings.clear();
        this.errorCount = 0;
        this.warningCount = 0;
        this.projectDirs = Sets.newHashSet();
        this.dirToProject = null;
    }

    private static class ProgressPrinter
    implements LintListener {
        private ProgressPrinter() {
        }

        public void update(LintDriver lint, LintListener.EventType type, Context context) {
            switch (type) {
                case SCANNING_PROJECT: {
                    String name;
                    String string = name = context != null ? context.getProject().getName() : "?";
                    if (lint.getPhase() > 1) {
                        System.out.print(String.format("\nScanning %1$s (Phase %2$d): ", name, lint.getPhase()));
                        break;
                    }
                    System.out.print(String.format("\nScanning %1$s: ", name));
                    break;
                }
                case SCANNING_LIBRARY_PROJECT: {
                    String name = context != null ? context.getProject().getName() : "?";
                    System.out.print(String.format("\n         - %1$s: ", name));
                    break;
                }
                case SCANNING_FILE: {
                    System.out.print('.');
                    break;
                }
                case NEW_PHASE: {
                    break;
                }
                case CANCELED: 
                case COMPLETED: {
                    System.out.println();
                    break;
                }
            }
        }
    }

    protected class CliConfiguration
    extends DefaultConfiguration {
        private final boolean mFatalOnly;

        protected CliConfiguration(Configuration parent, Project project, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, project, parent);
            this.mFatalOnly = fatalOnly;
        }

        protected CliConfiguration(File lintFile, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, null, null, lintFile);
            this.mFatalOnly = fatalOnly;
        }

        protected CliConfiguration(File lintFile, Configuration parent, Project project, boolean fatalOnly) {
            super((LintClient)LintCliClient.this, project, parent, lintFile);
            this.mFatalOnly = fatalOnly;
        }

        public Severity getSeverity(Issue issue) {
            Severity severity = this.computeSeverity(issue);
            if (this.mFatalOnly && severity != Severity.FATAL) {
                return Severity.IGNORE;
            }
            if (LintCliClient.this.flags.isWarningsAsErrors() && severity == Severity.WARNING) {
                if (issue == IssueRegistry.BASELINE) {
                    return severity;
                }
                severity = Severity.ERROR;
            }
            if (LintCliClient.this.flags.isIgnoreWarnings() && severity == Severity.WARNING) {
                severity = Severity.IGNORE;
            }
            return severity;
        }

        protected Severity getDefaultSeverity(Issue issue) {
            if (LintCliClient.this.flags.isCheckAllWarnings()) {
                return issue.getDefaultSeverity();
            }
            return super.getDefaultSeverity(issue);
        }

        private Severity computeSeverity(Issue issue) {
            Severity severity = super.getSeverity(issue);
            String id = issue.getId();
            Set<String> suppress = LintCliClient.this.flags.getSuppressedIds();
            if (suppress.contains(id)) {
                return Severity.IGNORE;
            }
            Severity manual = LintCliClient.this.flags.getSeverityOverrides().get(id);
            if (manual != null) {
                if (this.severity != null && (this.severity.containsKey(id) || this.severity.containsKey("all"))) {
                    return Severity.min((Severity)severity, (Severity)manual);
                }
                return manual;
            }
            Set<String> enabled = LintCliClient.this.flags.getEnabledIds();
            Set<String> check = LintCliClient.this.flags.getExactCheckedIds();
            if (enabled.contains(id) || check != null && check.contains(id)) {
                if (severity == Severity.IGNORE && (severity = issue.getDefaultSeverity()) == Severity.IGNORE) {
                    severity = Severity.WARNING;
                }
                return severity;
            }
            if (check != null && issue != IssueRegistry.LINT_ERROR && issue != IssueRegistry.PARSER_ERROR && issue != IssueRegistry.BASELINE) {
                return Severity.IGNORE;
            }
            return severity;
        }
    }
}

