/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.EcjSourceFile;
import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.psi.EcjPsiBuilder;
import com.android.tools.lint.psi.EcjPsiJavaEvaluator;
import com.android.tools.lint.psi.EcjPsiJavaFile;
import com.android.tools.lint.psi.EcjPsiManager;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import lombok.ast.Catch;
import lombok.ast.CompilationUnit;
import lombok.ast.Identifier;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.Try;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MagicLiteral;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjParser
extends JavaParser {
    private static final boolean DEBUG_DUMP_PARSE_ERRORS = false;
    public static boolean skipComputingEcjErrors = true;
    private static final boolean PARSE_LIBRARY_SOURCES = true;
    private static final boolean KEEP_LOOKUP_ENVIRONMENT;
    private final LintClient client;
    private final Project project;
    private Map<File, EcjSourceFile> sourceUnits;
    @Deprecated
    private Map<String, TypeDeclaration> typeUnits;
    private Parser parser;
    protected EcjResult ecjResult;
    private EcjPsiJavaEvaluator resolver;

    public EcjParser(LintCliClient client, Project project) {
        this.client = client;
        this.project = project;
        this.parser = this.getParser();
    }

    private static void checkEcjVersion() {
        Locale locale = Locale.getDefault();
        try {
            ResourceBundle bundle = Main.ResourceBundleFactory.getBundle(locale);
            String v = bundle.getString("compiler.version");
            if (!v.startsWith("v2016")) {
                System.err.println("WARNING: Using the wrong version of the Eclipse compiler (" + v + ")\n" + "\n" + "this typically means that your project is using some custom Gradle\n" + "plugin which pulls in an older version of the ECJ library, and Gradle\n" + "placed it on the classpath earlier than the one needed by lint\n" + "(v20160829-0950, 3.12.1)).");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public EcjPsiJavaEvaluator getEvaluator() {
        return this.resolver;
    }

    public File getFile(PsiFile file) {
        if (file instanceof EcjPsiJavaFile) {
            EcjPsiJavaFile javaFile = (EcjPsiJavaFile)file;
            return javaFile.getIoFile();
        }
        return null;
    }

    public CharSequence getFileContents(PsiFile file) {
        if (file instanceof EcjPsiJavaFile) {
            EcjPsiJavaFile javaFile = (EcjPsiJavaFile)file;
            return CharBuffer.wrap(javaFile.getFileContents());
        }
        return super.getFileContents(file);
    }

    public static CompilerOptions createCompilerOptions() {
        long languageLevel;
        CompilerOptions options = new CompilerOptions(){

            @Override
            public int getSeverity(int irritant) {
                return 256;
            }

            @Override
            public String getSeverityString(int irritant) {
                return "ignore";
            }

            @Override
            public boolean isAnyEnabled(IrritantSet irritants) {
                return false;
            }
        };
        options.complianceLevel = languageLevel = 0x340000L;
        options.sourceLevel = languageLevel;
        options.targetJDK = languageLevel;
        options.originalComplianceLevel = languageLevel;
        options.originalSourceLevel = languageLevel;
        options.inlineJsrBytecode = true;
        options.parseLiteralExpressionsAsConstants = true;
        options.analyseResourceLeaks = false;
        options.docCommentSupport = false;
        options.defaultEncoding = "UTF-8";
        options.suppressOptionalErrors = true;
        options.generateClassFiles = false;
        options.isAnnotationBasedNullAnalysisEnabled = false;
        options.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        options.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
        options.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
        options.reportUnusedParameterIncludeDocCommentReference = false;
        options.reportUnusedParameterWhenImplementingAbstract = false;
        options.reportUnusedParameterWhenOverridingConcrete = false;
        options.suppressWarnings = true;
        options.processAnnotations = true;
        options.storeAnnotations = true;
        options.verbose = false;
        return options;
    }

    public static long getLanguageLevel(int major, int minor) {
        assert (major == 1);
        switch (minor) {
            case 5: {
                return 0x310000L;
            }
            case 6: {
                return 0x320000L;
            }
            case 8: {
                return 0x340000L;
            }
        }
        return 0x340000L;
    }

    private Parser getParser() {
        if (this.parser == null) {
            CompilerOptions options = EcjParser.createCompilerOptions();
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, new EcjProblemFactory());
            this.parser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
            this.parser.javadocParser.checkDocComment = false;
        }
        return this.parser;
    }

    public boolean prepareJavaParse(List<JavaContext> contexts) {
        if (this.project == null || contexts.isEmpty()) {
            return true;
        }
        ArrayList sources = Lists.newArrayListWithExpectedSize((int)contexts.size());
        this.sourceUnits = Maps.newHashMapWithExpectedSize((int)sources.size());
        for (JavaContext context : contexts) {
            CharSequence contents = context.getContents();
            if (contents == null) continue;
            File file = context.file;
            EcjSourceFile unit = EcjSourceFile.create(contents, file);
            sources.add(unit);
            this.sourceUnits.put(file, unit);
        }
        for (Project libraryProject : this.project.getAllLibraries()) {
            List javaSourceFolders = libraryProject.getJavaSourceFolders();
            if (javaSourceFolders.isEmpty()) continue;
            for (File folder : javaSourceFolders) {
                File parentFile = folder.getParentFile();
                if (parentFile != null && parentFile.getName().equals("r")) continue;
                this.gatherJavaFiles(sources, folder);
            }
        }
        List<String> classPath = this.computeClassPath(contexts);
        try {
            this.ecjResult = EcjParser.parse(EcjParser.createCompilerOptions(), sources, classPath, this.client);
            this.resolver = new EcjPsiJavaEvaluator(this.ecjResult.psiManager);
            return !this.ecjResult.hasErrors();
        }
        catch (Throwable t) {
            this.client.log(t, "ECJ compiler crashed", new Object[0]);
            return false;
        }
    }

    private static String describeError(boolean isError, int id, char[] fileName, int sourceLineNumber, String message) {
        return "";
    }

    private void gatherJavaFiles(List<EcjSourceFile> sources, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".java")) {
                    try {
                        CharSequence contents = LintUtils.getEncodedString((LintClient)this.client, (File)file, (boolean)false);
                        EcjSourceFile unit = EcjSourceFile.create(contents, file);
                        sources.add(unit);
                        this.sourceUnits.put(file, unit);
                    }
                    catch (IOException e) {
                        this.client.log(Severity.ERROR, (Throwable)e, "Couldn't read %1$s", new Object[]{file});
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.gatherJavaFiles(sources, file);
            }
        }
    }

    public static EcjResult parse(CompilerOptions options, List<EcjSourceFile> sourceUnits, List<String> classPath, LintClient client) {
        HashMap outputMap = Maps.newHashMapWithExpectedSize((int)sourceUnits.size());
        FileSystem environment = new FileSystem(classPath.toArray(new String[classPath.size()]), new String[0], options.defaultEncoding);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        EcjProblemFactory problemFactory = new EcjProblemFactory();
        ICompilerRequestor requestor = result -> {};
        NonGeneratingCompiler compiler = new NonGeneratingCompiler((INameEnvironment)environment, policy, options, requestor, (IProblemFactory)problemFactory, outputMap);
        try {
            compiler.compile(sourceUnits.toArray(new ICompilationUnit[sourceUnits.size()]));
        }
        catch (OutOfMemoryError e) {
            environment.cleanup();
            compiler = null;
            environment = null;
            requestor = null;
            problemFactory = null;
            policy = null;
            String msg = "Ran out of memory analyzing .java sources with ECJ: Some lint checks may not be accurate (missing type information from the compiler)";
            if (client != null) {
                client.log(null, msg, new Object[0]);
            } else {
                System.out.println(msg);
            }
        }
        catch (Throwable t) {
            if (client != null) {
                CompilationUnitDeclaration currentUnit = compiler.getCurrentUnit();
                if (currentUnit == null || currentUnit.getFileName() == null) {
                    client.log(t, "ECJ compiler crashed", new Object[0]);
                } else {
                    client.log(t, "ECJ compiler crashed processing %1$s", new Object[]{new String(currentUnit.getFileName())});
                }
            } else {
                t.printStackTrace();
            }
            environment.cleanup();
            environment = null;
        }
        LookupEnvironment lookupEnvironment = compiler != null ? compiler.lookupEnvironment : null;
        EcjResult ecjResult = new EcjResult(environment, lookupEnvironment, outputMap, problemFactory == null || problemFactory.hasErrors());
        EcjPsiManager psiManager = new EcjPsiManager(client, ecjResult, options.sourceLevel);
        ecjResult.setPsiManager(psiManager);
        return ecjResult;
    }

    private List<String> computeClassPath(List<JavaContext> contexts) {
        String bootClassPath;
        assert (this.project != null);
        ArrayList classPath = Lists.newArrayList();
        IAndroidTarget compileTarget = this.project.getBuildTarget();
        if (compileTarget != null) {
            String androidJar = compileTarget.getPath(1);
            if (androidJar != null && new File(androidJar).exists()) {
                classPath.add(androidJar);
            }
        } else if (!this.project.isAndroidProject() && (bootClassPath = System.getProperty("sun.boot.class.path")) != null) {
            for (Object path : Splitter.on((char)File.pathSeparatorChar).split((CharSequence)bootClassPath)) {
                if (!new File((String)path).isFile()) continue;
                classPath.add(path);
            }
        }
        HashSet libraries = Sets.newHashSet();
        HashSet names = Sets.newHashSet();
        for (File library : this.project.getJavaLibraries(true)) {
            libraries.add(library);
            names.add(EcjParser.getLibraryName(library));
        }
        for (Project libraryProject : this.project.getAllLibraries()) {
            for (File library : libraryProject.getJavaLibraries(true)) {
                String name = EcjParser.getLibraryName(library);
                if (names.contains(name)) continue;
                libraries.add(library);
                names.add(name);
            }
        }
        for (File file : libraries) {
            if (!file.exists()) continue;
            classPath.add(file.getPath());
        }
        EnumSet scope = contexts.get(0).getScope();
        if (!scope.contains(Scope.ALL_JAVA_FILES)) {
            for (File dir : this.project.getJavaClassFolders()) {
                if (!dir.exists()) continue;
                classPath.add(dir.getPath());
            }
        }
        for (File dir : this.project.getTestLibraries()) {
            if (!dir.exists()) continue;
            classPath.add(dir.getPath());
        }
        return classPath;
    }

    private static String getLibraryName(File library) {
        int begin;
        String name = library.getName();
        String path = library.getPath();
        int index = path.indexOf("exploded-aar");
        if (index != -1) {
            return path.substring(index + 13);
        }
        index = path.indexOf("m2repository");
        if (index != -1) {
            return path.substring(index + 13);
        }
        index = path.indexOf("output");
        if (index > 1 && (begin = path.lastIndexOf(File.separatorChar, index - 2)) != -1) {
            return path.substring(begin + 1);
        }
        index = path.indexOf("build-cache");
        if (index != -1) {
            return path.substring(index);
        }
        return name;
    }

    public PsiJavaFile parseJavaToPsi(JavaContext context) {
        EcjSourceFile sourceUnit;
        if (this.sourceUnits != null && this.ecjResult != null && (sourceUnit = this.sourceUnits.get(context.file)) != null) {
            try {
                return this.ecjResult.findFile(sourceUnit);
            }
            catch (Throwable t) {
                this.client.log(t, "Failed converting ECJ parse tree to PSI for file %1$s", new Object[]{context.file.getPath()});
                return null;
            }
        }
        return null;
    }

    public Node parseJava(JavaContext context) {
        CharSequence code = context.getContents();
        if (code == null) {
            return null;
        }
        CompilationUnitDeclaration unit = this.getParsedUnit(context, code);
        try {
            EcjTreeConverter converter = new EcjTreeConverter();
            converter.visit(code.toString(), (ASTNode)unit);
            List nodes = converter.getAll();
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!(node instanceof CompilationUnit)) continue;
                    return node;
                }
            }
            return null;
        }
        catch (Throwable t) {
            this.client.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    private CompilationUnitDeclaration getParsedUnit(JavaContext context, CharSequence code) {
        CompilationUnitDeclaration unit;
        EcjSourceFile sourceUnit = null;
        if (this.sourceUnits != null && this.ecjResult != null && (sourceUnit = this.sourceUnits.get(context.file)) != null && (unit = this.ecjResult.getCompilationUnit(sourceUnit)) != null) {
            return unit;
        }
        if (sourceUnit == null) {
            sourceUnit = EcjSourceFile.create(code, context.file);
        }
        try {
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
            return this.getParser().parse(sourceUnit, compilationResult);
        }
        catch (AbortCompilation e) {
            return null;
        }
    }

    public Location getLocation(JavaContext context, Node node) {
        lombok.ast.Position position = node.getPosition();
        while (position == lombok.ast.Position.UNPLACED && (node = node.getParent()) != null) {
            position = node.getPosition();
        }
        return Location.create((File)context.file, (CharSequence)context.getContents(), (int)position.getStart(), (int)position.getEnd());
    }

    public Location getRangeLocation(JavaContext context, Node from, int fromDelta, Node to, int toDelta) {
        CharSequence contents = context.getContents();
        int start = Math.max(0, from.getPosition().getStart() + fromDelta);
        int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), to.getPosition().getEnd() + toDelta);
        return Location.create((File)context.file, (CharSequence)contents, (int)start, (int)end);
    }

    public Location getNameLocation(JavaContext context, Node node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)node;
            Identifier identifier = declaration.astMethodName();
            Location location = this.getLocation(context, (Node)identifier);
            Position start = location.getStart();
            Position end = location.getEnd();
            int methodNameLength = identifier.astValue().length();
            if (start != null && end != null && end.getOffset() - start.getOffset() > methodNameLength) {
                end = new DefaultPosition(start.getLine(), start.getColumn() + methodNameLength, start.getOffset() + methodNameLength);
                return Location.create((File)location.getFile(), (Position)start, (Position)end);
            }
            return location;
        }
        return super.getNameLocation(context, node);
    }

    public PsiElement findElementAt(JavaContext context, int offset) {
        PsiJavaFile javaFile = context.getJavaFile();
        return javaFile != null ? EcjPsiManager.findElementAt((PsiElement)javaFile, offset) : null;
    }

    public Location.Handle createLocationHandle(JavaContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    public void dispose(JavaContext context, PsiJavaFile compilationUnit) {
        if (this.sourceUnits != null) {
            this.sourceUnits.remove(context.file);
        }
    }

    public void dispose(JavaContext context, Node compilationUnit) {
        EcjSourceFile sourceUnit;
        if (this.sourceUnits != null && (sourceUnit = this.sourceUnits.get(context.file)) != null) {
            CompilationUnitDeclaration unit;
            this.sourceUnits.remove(context.file);
            if (this.ecjResult != null && (unit = this.ecjResult.getCompilationUnit(sourceUnit)) != null) {
                if (unit.types != null) {
                    for (TypeDeclaration type : unit.types) {
                        if (EcjParser.isAnnotationType(type)) {
                            return;
                        }
                        if (type.memberTypes == null) continue;
                        for (TypeDeclaration member : type.memberTypes) {
                            if (!EcjParser.isAnnotationType(member)) continue;
                            return;
                        }
                    }
                }
                this.ecjResult.removeCompilationUnit(sourceUnit);
            }
        }
    }

    private static boolean isAnnotationType(TypeDeclaration type) {
        return TypeDeclaration.kind(type.modifiers) == 4;
    }

    public void dispose() {
        if (this.ecjResult != null) {
            this.ecjResult.dispose();
            this.ecjResult = null;
        }
        this.sourceUnits = null;
        this.typeUnits = null;
    }

    public void disposePsi() {
        if (this.ecjResult != null) {
            EcjPsiManager psiManager = this.ecjResult.psiManager;
            if (psiManager != null) {
                psiManager.clear();
            }
            this.ecjResult.psiMap = null;
        }
    }

    private static Object getNativeNode(Node node) {
        Node parent;
        StrictListAccessor variables;
        Object nativeNode = node.getNativeNode();
        if (nativeNode != null) {
            return nativeNode;
        }
        if (node instanceof VariableDeclaration) {
            node = ((VariableDeclaration)node).astDefinition();
        }
        if (node instanceof VariableDefinition && (variables = ((VariableDefinition)node).astVariables()).size() == 1) {
            node = variables.first();
        }
        if (node instanceof VariableDefinitionEntry) {
            VariableDefinitionEntry entry = (VariableDefinitionEntry)node;
            String name = entry.astName().astValue();
            for (Node parent2 = node.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                Object parentNativeNode = parent2.getNativeNode();
                if (parentNativeNode == null) continue;
                if (parentNativeNode instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration method = (AbstractMethodDeclaration)parentNativeNode;
                    for (Argument argument : method.arguments) {
                        if (!EcjParser.sameChars(name, argument.name)) continue;
                        return argument;
                    }
                    for (Statement statement : method.statements) {
                        if (!(statement instanceof LocalDeclaration)) continue;
                        LocalDeclaration declaration = (LocalDeclaration)statement;
                        if (!EcjParser.sameChars(name, declaration.name)) continue;
                        return declaration;
                    }
                } else if (parentNativeNode instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)parentNativeNode;
                    for (FieldDeclaration fieldDeclaration : typeDeclaration.fields) {
                        if (!EcjParser.sameChars(name, fieldDeclaration.name)) continue;
                        return fieldDeclaration;
                    }
                } else {
                    if (!(parentNativeNode instanceof Block)) break;
                    Block block = (Block)parentNativeNode;
                    for (Statement statement : block.statements) {
                        if (!(statement instanceof LocalDeclaration)) continue;
                        LocalDeclaration declaration = (LocalDeclaration)statement;
                        if (!EcjParser.sameChars(name, declaration.name)) continue;
                        return declaration;
                    }
                }
                break;
            }
        }
        if ((parent = node.getParent()) != null && (nativeNode = parent.getNativeNode()) != null) {
            return nativeNode;
        }
        return null;
    }

    public JavaParser.ResolvedNode resolve(JavaContext context, Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof NameReference) {
            return this.resolve(((NameReference)nativeNode).binding);
        }
        if (nativeNode instanceof TypeReference) {
            return this.resolve(((TypeReference)nativeNode).resolvedType);
        }
        if (nativeNode instanceof MessageSend) {
            return this.resolve(((MessageSend)nativeNode).binding);
        }
        if (nativeNode instanceof AllocationExpression) {
            return this.resolve(((AllocationExpression)nativeNode).binding);
        }
        if (nativeNode instanceof TypeDeclaration) {
            return this.resolve(((TypeDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof ExplicitConstructorCall) {
            return this.resolve(((ExplicitConstructorCall)nativeNode).binding);
        }
        if (nativeNode instanceof Annotation) {
            AnnotationBinding compilerAnnotation = ((Annotation)nativeNode).getCompilerAnnotation();
            if (compilerAnnotation != null) {
                return new EcjResolvedAnnotation(compilerAnnotation);
            }
            return this.resolve(((Annotation)nativeNode).resolvedType);
        }
        if (nativeNode instanceof AbstractMethodDeclaration) {
            return this.resolve(((AbstractMethodDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof AbstractVariableDeclaration) {
            if (nativeNode instanceof LocalDeclaration) {
                return this.resolve(((LocalDeclaration)nativeNode).binding);
            }
            if (nativeNode instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)nativeNode;
                if (fieldDeclaration.initialization instanceof AllocationExpression) {
                    AllocationExpression allocation = (AllocationExpression)fieldDeclaration.initialization;
                    if (allocation.binding != null) {
                        return new EcjResolvedMethod(allocation.binding);
                    }
                }
                return this.resolve(fieldDeclaration.binding);
            }
        }
        return null;
    }

    private JavaParser.ResolvedNode resolve(Binding binding) {
        if (binding == null || binding instanceof ProblemBinding) {
            return null;
        }
        if (binding instanceof TypeBinding) {
            TypeBinding tb = (TypeBinding)binding;
            return new EcjResolvedClass(tb);
        }
        if (binding instanceof MethodBinding) {
            MethodBinding mb = (MethodBinding)binding;
            if (mb instanceof ProblemMethodBinding) {
                return null;
            }
            if (mb.declaringClass != null) {
                return new EcjResolvedMethod(mb);
            }
        } else if (binding instanceof LocalVariableBinding) {
            LocalVariableBinding lvb = (LocalVariableBinding)binding;
            if (lvb.type != null) {
                return new EcjResolvedVariable(lvb);
            }
        } else if (binding instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)binding;
            if (fb instanceof ProblemFieldBinding) {
                return null;
            }
            if (fb.type != null && fb.declaringClass != null) {
                return new EcjResolvedField(fb);
            }
        }
        return null;
    }

    @Deprecated
    private TypeDeclaration findTypeDeclaration(String signature) {
        if (this.typeUnits == null) {
            Collection<CompilationUnitDeclaration> units = this.ecjResult.getCompilationUnits();
            this.typeUnits = Maps.newHashMapWithExpectedSize((int)units.size());
            for (CompilationUnitDeclaration unit : units) {
                if (unit.types == null) continue;
                for (TypeDeclaration typeDeclaration : unit.types) {
                    this.addTypeDeclaration(typeDeclaration);
                }
            }
        }
        return this.typeUnits.get(signature);
    }

    @Deprecated
    private void addTypeDeclaration(TypeDeclaration typeDeclaration) {
        String type = new String(typeDeclaration.binding.readableName());
        this.typeUnits.put(type, typeDeclaration);
        if (typeDeclaration.memberTypes != null) {
            for (TypeDeclaration member : typeDeclaration.memberTypes) {
                this.addTypeDeclaration(member);
            }
        }
    }

    public JavaParser.TypeDescriptor getType(JavaContext context, Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof MessageSend) {
            nativeNode = ((MessageSend)nativeNode).binding;
        } else if (nativeNode instanceof AllocationExpression) {
            nativeNode = ((AllocationExpression)nativeNode).resolvedType;
        } else if (nativeNode instanceof NameReference) {
            nativeNode = ((NameReference)nativeNode).resolvedType;
        } else if (nativeNode instanceof Expression) {
            if (nativeNode instanceof Literal) {
                if (nativeNode instanceof StringLiteral) {
                    return EcjParser.getTypeDescriptor("java.lang.String");
                }
                if (nativeNode instanceof NumberLiteral) {
                    if (nativeNode instanceof IntLiteral) {
                        return EcjParser.getTypeDescriptor("int");
                    }
                    if (nativeNode instanceof LongLiteral) {
                        return EcjParser.getTypeDescriptor("long");
                    }
                    if (nativeNode instanceof CharLiteral) {
                        return EcjParser.getTypeDescriptor("char");
                    }
                    if (nativeNode instanceof FloatLiteral) {
                        return EcjParser.getTypeDescriptor("float");
                    }
                    if (nativeNode instanceof DoubleLiteral) {
                        return EcjParser.getTypeDescriptor("double");
                    }
                } else if (nativeNode instanceof MagicLiteral) {
                    if (nativeNode instanceof TrueLiteral || nativeNode instanceof FalseLiteral) {
                        return EcjParser.getTypeDescriptor("boolean");
                    }
                    if (nativeNode instanceof NullLiteral) {
                        return EcjParser.getTypeDescriptor("null");
                    }
                }
            }
            nativeNode = ((Expression)nativeNode).resolvedType;
        } else if (nativeNode instanceof TypeDeclaration) {
            nativeNode = ((TypeDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof AbstractMethodDeclaration) {
            nativeNode = ((AbstractMethodDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof FieldDeclaration) {
            nativeNode = ((FieldDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof LocalDeclaration) {
            nativeNode = ((LocalDeclaration)nativeNode).binding;
        }
        if (nativeNode instanceof Binding) {
            Binding binding = (Binding)nativeNode;
            if (binding instanceof TypeBinding) {
                TypeBinding tb = (TypeBinding)binding;
                return this.getTypeDescriptor(tb);
            }
            if (binding instanceof LocalVariableBinding) {
                LocalVariableBinding lvb = (LocalVariableBinding)binding;
                if (lvb.type != null) {
                    return this.getTypeDescriptor(lvb.type);
                }
            } else if (binding instanceof FieldBinding) {
                FieldBinding fb = (FieldBinding)binding;
                if (fb.type != null) {
                    return this.getTypeDescriptor(fb.type);
                }
            } else {
                if (binding instanceof MethodBinding) {
                    return this.getTypeDescriptor(((MethodBinding)binding).returnType);
                }
                if (binding instanceof ProblemBinding) {
                    return null;
                }
            }
        }
        return null;
    }

    public JavaParser.ResolvedClass findClass(JavaContext context, String fullyQualifiedName) {
        ReferenceBinding type;
        String internal = ClassContext.getInternalName((String)fullyQualifiedName);
        ArrayList arrays = Lists.newArrayList();
        for (String segment : Splitter.on((char)'/').split((CharSequence)internal)) {
            arrays.add(segment.toCharArray());
        }
        char[][] compoundName = new char[arrays.size()][];
        int n = arrays.size();
        for (int i = 0; i < n; ++i) {
            compoundName[i] = (char[])arrays.get(i);
        }
        LookupEnvironment lookup = this.ecjResult.lookupEnvironment;
        if (lookup != null && (type = lookup.getType(compoundName)) != null && !(type instanceof ProblemReferenceBinding)) {
            return new EcjResolvedClass(type);
        }
        return null;
    }

    public List<JavaParser.TypeDescriptor> getCatchTypes(JavaContext context, Catch catchBlock) {
        Object nativeNode;
        Try aTry = catchBlock.upToTry();
        if (aTry != null && (nativeNode = EcjParser.getNativeNode((Node)aTry)) instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)nativeNode;
            Argument[] catchArguments = tryStatement.catchArguments;
            Argument argument = null;
            if (catchArguments.length > 1) {
                int index = 0;
                for (Catch aCatch : aTry.astCatches()) {
                    if (aCatch == catchBlock && index < catchArguments.length) {
                        argument = catchArguments[index];
                        break;
                    }
                    ++index;
                }
            } else {
                argument = catchArguments[0];
            }
            if (argument != null) {
                if (argument.type instanceof UnionTypeReference) {
                    UnionTypeReference typeRef = (UnionTypeReference)argument.type;
                    ArrayList types = Lists.newArrayListWithCapacity((int)typeRef.typeReferences.length);
                    for (TypeReference typeReference : typeRef.typeReferences) {
                        TypeBinding binding = typeReference.resolvedType;
                        if (binding == null) continue;
                        types.add(new EcjTypeDescriptor(binding));
                    }
                    return types;
                }
                if (argument.type.resolvedType != null) {
                    EcjTypeDescriptor t = new EcjTypeDescriptor(argument.type.resolvedType);
                    return Collections.singletonList(t);
                }
            }
        }
        return super.getCatchTypes(context, catchBlock);
    }

    private JavaParser.TypeDescriptor getTypeDescriptor(TypeBinding resolvedType) {
        if (resolvedType == null) {
            return null;
        }
        return new EcjTypeDescriptor(resolvedType);
    }

    private static JavaParser.TypeDescriptor getTypeDescriptor(String fqn) {
        return new JavaParser.DefaultTypeDescriptor(fqn);
    }

    private static MethodBinding findSuperMethodBinding(MethodBinding binding) {
        try {
            for (ReferenceBinding superclass = binding.declaringClass.superclass(); superclass != null; superclass = superclass.superclass()) {
                MethodBinding[] methods;
                for (MethodBinding method : methods = superclass.getMethods(binding.selector, binding.parameters.length)) {
                    if (!method.areParameterErasuresEqual(binding)) continue;
                    if (method.isPrivate()) {
                        if (method.declaringClass.outermostEnclosingType() == binding.declaringClass.outermostEnclosingType()) {
                            return method;
                        }
                        return null;
                    }
                    return method;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Collection<JavaParser.ResolvedAnnotation> merge(Collection<JavaParser.ResolvedAnnotation> first, Collection<JavaParser.ResolvedAnnotation> second) {
        if (first == null || first.isEmpty()) {
            if (second == null) {
                return Collections.emptyList();
            }
            return second;
        }
        if (second == null || second.isEmpty()) {
            return first;
        }
        int size = first.size() + second.size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)size);
        merged.addAll(first);
        merged.addAll(second);
        return merged;
    }

    static List<JavaParser.ResolvedAnnotation> ensureUnique(List<JavaParser.ResolvedAnnotation> list) {
        if (list.size() < 2) {
            return list;
        }
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            JavaParser.ResolvedAnnotation current = list.get(i);
            String currentName = current.getName();
            for (int j = n - 1; j > i; --j) {
                JavaParser.ResolvedAnnotation later = list.get(j);
                String laterName = later.getName();
                if (!currentName.equals(laterName)) continue;
                list.remove(j);
                --n;
            }
        }
        return list;
    }

    private static String stripTypeVariables(String name) {
        if (name.indexOf(60) != -1) {
            StringBuilder sb = new StringBuilder(name.length());
            int depth = 0;
            int n = name.length();
            for (int i = 0; i < n; ++i) {
                char c = name.charAt(i);
                if (c == '<') {
                    ++depth;
                    continue;
                }
                if (c == '>') {
                    --depth;
                    continue;
                }
                if (depth != 0) continue;
                sb.append(c);
            }
            name = sb.toString();
        }
        return name;
    }

    private Object getConstantValue(Object value) {
        if (value instanceof Constant) {
            if (value == Constant.NotAConstant) {
                return null;
            }
            if (value instanceof StringConstant) {
                return ((StringConstant)value).stringValue();
            }
            if (value instanceof IntConstant) {
                return ((IntConstant)value).intValue();
            }
            if (value instanceof BooleanConstant) {
                return ((BooleanConstant)value).booleanValue();
            }
            if (value instanceof FloatConstant) {
                return Float.valueOf(((FloatConstant)value).floatValue());
            }
            if (value instanceof LongConstant) {
                return ((LongConstant)value).longValue();
            }
            if (value instanceof DoubleConstant) {
                return ((DoubleConstant)value).doubleValue();
            }
            if (value instanceof ShortConstant) {
                return ((ShortConstant)value).shortValue();
            }
            if (value instanceof CharConstant) {
                return Character.valueOf(((CharConstant)value).charValue());
            }
            if (value instanceof ByteConstant) {
                return ((ByteConstant)value).byteValue();
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length > 0) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)array.length);
                for (Object element : array) {
                    list.add(this.getConstantValue(element));
                }
                if (!list.isEmpty()) {
                    Object first = list.get(0);
                    if (first instanceof String) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (first instanceof java.lang.annotation.Annotation) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (first instanceof Class) {
                        return list.toArray(new Class[list.size()]);
                    }
                }
                return list.toArray();
            }
        } else {
            if (value instanceof AnnotationBinding) {
                return new EcjResolvedAnnotation((AnnotationBinding)value);
            }
            if (value instanceof FieldBinding) {
                return new EcjResolvedField((FieldBinding)value);
            }
        }
        return value;
    }

    public static boolean sameChars(String str, char[] chars) {
        int length = str.length();
        if (chars.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (chars[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean startsWithCompound(String name, char[][] compoundName) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        int n = compoundName.length;
        for (int i = 0; i < n; ++i) {
            char[] o = compoundName[i];
            int m = o.length;
            for (int j = 0; j < m; ++j) {
                if (index == length) {
                    return false;
                }
                if (name.charAt(index) != o[j] && (o[j] != '$' || name.charAt(index) != '.')) {
                    return false;
                }
                ++index;
            }
            if (i >= n - 1) continue;
            if (index == length) {
                return true;
            }
            if (name.charAt(index) != '.') {
                return false;
            }
            if (++index != length) continue;
            return true;
        }
        return index == length;
    }

    static boolean equalsCompound(String name, char[][] compoundName) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        int n = compoundName.length;
        for (int i = 0; i < n; ++i) {
            char[] o = compoundName[i];
            int m = o.length;
            for (int j = 0; j < m; ++j) {
                if (index == length) {
                    return false;
                }
                if (name.charAt(index) != o[j] && (o[j] != '$' || name.charAt(index) != '.')) {
                    return false;
                }
                ++index;
            }
            if (i >= n - 1) continue;
            if (index == length) {
                return false;
            }
            if (name.charAt(index) != '.') {
                return false;
            }
            if (++index != length) continue;
            return false;
        }
        return index == length;
    }

    private static boolean isInheritor(ReferenceBinding cls, String name) {
        while (cls != null) {
            ReferenceBinding[] interfaces;
            for (ReferenceBinding binding : interfaces = cls.superInterfaces()) {
                if (!EcjParser.isInheritor(binding, name)) continue;
                return true;
            }
            if (EcjParser.equalsCompound(name, cls.compoundName)) {
                return true;
            }
            cls = cls.superclass();
        }
        return false;
    }

    static {
        if (Boolean.getBoolean("lint.check-ecj-version")) {
            EcjParser.checkEcjVersion();
        }
        KEEP_LOOKUP_ENVIRONMENT = !Boolean.getBoolean("lint.reset.ecj");
    }

    private class EcjResolvedAnnotation
    extends JavaParser.ResolvedAnnotation {
        private final AnnotationBinding binding;
        private final String name;

        private EcjResolvedAnnotation(AnnotationBinding binding) {
            this.binding = binding;
            this.name = new String(this.binding.getAnnotationType().readableName());
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(String name) {
            return name.equals(this.name);
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(this.binding.getAnnotationType());
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public JavaParser.ResolvedClass getClassType() {
            ReferenceBinding annotationType = this.binding.getAnnotationType();
            return new EcjResolvedClass(annotationType){

                @Override
                public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
                    AnnotationBinding[] annotations = this.mBinding.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null) continue;
                            char[] readableName = annotation.getAnnotationType().readableName();
                            if (EcjParser.sameChars("android.support.annotation.IntDef", readableName) || EcjParser.sameChars("android.support.annotation.StringDef", readableName)) {
                                TypeDeclaration typeDeclaration = EcjParser.this.findTypeDeclaration(this.getName());
                                if (typeDeclaration == null || typeDeclaration.annotations == null) continue;
                                Annotation astAnnotation = null;
                                for (Annotation a : typeDeclaration.annotations) {
                                    if (a.resolvedType == null || !EcjParser.sameChars("android.support.annotation.IntDef", a.resolvedType.readableName()) && !EcjParser.sameChars("android.support.annotation.StringDef", a.resolvedType.readableName())) continue;
                                    astAnnotation = a;
                                    break;
                                }
                                if (astAnnotation != null) {
                                    result.add(new EcjAstAnnotation(annotation, astAnnotation));
                                    continue;
                                }
                            }
                            result.add(new EcjResolvedAnnotation(annotation));
                        }
                        return result;
                    }
                    return Collections.emptyList();
                }
            };
        }

        public List<JavaParser.ResolvedAnnotation.Value> getValues() {
            ElementValuePair[] pairs = this.binding.getElementValuePairs();
            if (pairs != null && pairs.length > 0) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)pairs.length);
                for (ElementValuePair pair : pairs) {
                    values.add(new JavaParser.ResolvedAnnotation.Value(new String(pair.getName()), this.getPairValue(pair)));
                }
            }
            return Collections.emptyList();
        }

        public Object getValue(String name) {
            ElementValuePair[] pairs = this.binding.getElementValuePairs();
            if (pairs != null) {
                for (ElementValuePair pair : pairs) {
                    if (!EcjParser.sameChars(name, pair.getName())) continue;
                    return this.getPairValue(pair);
                }
            }
            return null;
        }

        private Object getPairValue(ElementValuePair pair) {
            return EcjParser.this.getConstantValue(pair.getValue());
        }

        public String getSignature() {
            return this.name;
        }

        public int getModifiers() {
            return 0;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ArrayList compiled = null;
            AnnotationBinding[] annotations = this.binding.getAnnotationType().getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                compiled = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    compiled.add(new EcjResolvedAnnotation(annotation));
                }
            }
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.client);
            Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
            return EcjParser.merge(compiled, external);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedAnnotation that = (EcjResolvedAnnotation)((Object)o);
            return !(this.binding != null ? !this.binding.equals(that.binding) : that.binding != null);
        }

        public int hashCode() {
            return this.binding != null ? this.binding.hashCode() : 0;
        }

        private class EcjAstAnnotation
        extends EcjResolvedAnnotation {
            private final Annotation mAstAnnotation;
            private List<JavaParser.ResolvedAnnotation.Value> mValues;

            public EcjAstAnnotation(AnnotationBinding binding, Annotation astAnnotation) {
                super(binding);
                this.mAstAnnotation = astAnnotation;
            }

            @Override
            public List<JavaParser.ResolvedAnnotation.Value> getValues() {
                if (this.mValues == null) {
                    MemberValuePair[] memberValuePairs = this.mAstAnnotation.memberValuePairs();
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)memberValuePairs.length);
                    for (MemberValuePair pair : memberValuePairs) {
                        Expression expression = pair.value;
                        Object[] value = null;
                        if (expression instanceof ArrayInitializer) {
                            ArrayInitializer initializer = (ArrayInitializer)expression;
                            Expression[] expressions = initializer.expressions;
                            ArrayList values = Lists.newArrayList();
                            for (Expression e : expressions) {
                                if (e instanceof NameReference) {
                                    JavaParser.ResolvedNode resolved = EcjParser.this.resolve(((NameReference)e).binding);
                                    if (resolved == null) continue;
                                    values.add(resolved);
                                    continue;
                                }
                                if (e instanceof IntLiteral) {
                                    values.add(((IntLiteral)e).value);
                                    continue;
                                }
                                if (e instanceof StringLiteral) {
                                    values.add(String.valueOf(((StringLiteral)e).source()));
                                    continue;
                                }
                                values.add(e.toString());
                            }
                            value = values.toArray();
                        } else if (expression instanceof IntLiteral) {
                            IntLiteral intLiteral = (IntLiteral)expression;
                            value = intLiteral.value;
                        } else if (expression instanceof TrueLiteral) {
                            value = true;
                        } else if (expression instanceof FalseLiteral) {
                            value = false;
                        } else if (expression instanceof StringLiteral) {
                            value = String.valueOf(((StringLiteral)expression).source());
                        }
                        result.add(new JavaParser.ResolvedAnnotation.Value(new String(pair.name), (Object)value));
                    }
                    this.mValues = result;
                }
                return this.mValues;
            }

            @Override
            public Object getValue(String name) {
                for (JavaParser.ResolvedAnnotation.Value value : this.getValues()) {
                    if (!name.equals(value.name)) continue;
                    return value.value;
                }
                return null;
            }
        }
    }

    private class EcjResolvedVariable
    extends JavaParser.ResolvedVariable {
        private final VariableBinding mBinding;

        private EcjResolvedVariable(VariableBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public int getModifiers() {
            return this.mBinding.modifiers;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    result.add(new EcjResolvedAnnotation(annotation));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedVariable that = (EcjResolvedVariable)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedField
    extends JavaParser.ResolvedField {
        private final FieldBinding mBinding;

        private EcjResolvedField(FieldBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass(this.mBinding.declaringClass);
        }

        public Object getValue() {
            return EcjParser.this.getConstantValue(this.mBinding.constant());
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ArrayList compiled = null;
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                compiled = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    compiled.add(new EcjResolvedAnnotation(annotation));
                }
            }
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.client);
            Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
            return EcjParser.merge(compiled, external);
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.declaringClass.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public Node findAstNode() {
            JavaParser.ResolvedClass containingClass = this.getContainingClass();
            TypeDeclaration typeDeclaration = EcjParser.this.findTypeDeclaration(containingClass.getName());
            if (typeDeclaration != null) {
                for (FieldDeclaration field : typeDeclaration.fields) {
                    if (field.binding != this.mBinding) continue;
                    EcjTreeConverter converter = new EcjTreeConverter();
                    converter.visit(null, (ASTNode)field);
                    List nodes = converter.getAll();
                    if (nodes.size() != 1) break;
                    return (Node)nodes.get(0);
                }
            }
            return super.findAstNode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedField that = (EcjResolvedField)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedPackage
    extends JavaParser.ResolvedPackage {
        private final PackageBinding mBinding;

        public EcjResolvedPackage(PackageBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public String getSignature() {
            return this.getName();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ExternalAnnotationRepository manager;
            Collection<JavaParser.ResolvedAnnotation> external;
            List<Object> all = Lists.newArrayListWithExpectedSize((int)2);
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count == 0) {
                Binding pkgInfo = this.mBinding.getTypeOrPackage(TypeConstants.PACKAGE_INFO_NAME);
                if (pkgInfo != null) {
                    annotations = pkgInfo.getAnnotations();
                }
                count = annotations.length;
            }
            if (count > 0) {
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    all.add((Object)new EcjResolvedAnnotation(annotation));
                }
            }
            if ((external = (manager = ExternalAnnotationRepository.get(EcjParser.this.client)).getAnnotations(this)) != null) {
                all.addAll(external);
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public JavaParser.ResolvedPackage getParentPackage() {
            char[][] compoundName = this.mBinding.compoundName;
            if (compoundName.length == 1) {
                return null;
            }
            PackageBinding defaultPackage = this.mBinding.environment.defaultPackage;
            PackageBinding packageBinding = (PackageBinding)defaultPackage.getTypeOrPackage(compoundName[0]);
            if (packageBinding == null || packageBinding instanceof ProblemPackageBinding) {
                return null;
            }
            int packageLength = compoundName.length - 1;
            for (int i = 1; i < packageLength; ++i) {
                Binding next = packageBinding.getTypeOrPackage(compoundName[i]);
                if (next == null) {
                    return null;
                }
                if (!(next instanceof PackageBinding)) continue;
                if (next instanceof ProblemPackageBinding) {
                    return null;
                }
                packageBinding = (PackageBinding)next;
            }
            return new EcjResolvedPackage(packageBinding);
        }

        public int getModifiers() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedPackage that = (EcjResolvedPackage)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedClass
    extends JavaParser.ResolvedClass {
        protected final TypeBinding mBinding;

        private EcjResolvedClass(TypeBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            String name = new String(this.mBinding.readableName());
            if (name.indexOf(46) == -1 && this.mBinding.enclosingType() != null) {
                name = new String(this.mBinding.enclosingType().readableName()) + '.' + name;
            }
            return EcjParser.stripTypeVariables(name);
        }

        public String getSimpleName() {
            return EcjParser.stripTypeVariables(new String(this.mBinding.sourceName()));
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.ResolvedClass getSuperClass() {
            ReferenceBinding superClass = this.mBinding.superclass();
            if (superClass != null) {
                return new EcjResolvedClass(superClass);
            }
            return null;
        }

        public Iterable<JavaParser.ResolvedClass> getInterfaces() {
            ReferenceBinding[] interfaces = this.mBinding.superInterfaces();
            if (interfaces.length == 0) {
                return Collections.emptyList();
            }
            ArrayList classes = Lists.newArrayListWithExpectedSize((int)interfaces.length);
            for (ReferenceBinding binding : interfaces) {
                classes.add(new EcjResolvedClass(binding));
            }
            return classes;
        }

        public boolean isInterface() {
            return this.mBinding.isInterface();
        }

        public boolean isEnum() {
            return this.mBinding.isEnum();
        }

        public JavaParser.ResolvedClass getContainingClass() {
            if (this.mBinding instanceof NestedTypeBinding) {
                NestedTypeBinding ntb = (NestedTypeBinding)this.mBinding;
                if (ntb.enclosingType != null) {
                    return new EcjResolvedClass(ntb.enclosingType);
                }
            }
            return null;
        }

        public boolean isSubclassOf(String name, boolean strict) {
            ReferenceBinding cls = (ReferenceBinding)this.mBinding;
            if (strict) {
                cls = cls.superclass();
            }
            while (cls != null) {
                if (EcjParser.equalsCompound(name, cls.compoundName)) {
                    return true;
                }
                cls = cls.superclass();
            }
            return false;
        }

        public boolean isImplementing(String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                return EcjParser.isInheritor(cls, name);
            }
            return false;
        }

        public boolean isInheritingFrom(String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                return EcjParser.isInheritor(cls, name);
            }
            return false;
        }

        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            ReferenceBinding cls;
            MethodBinding[] methods;
            if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(TypeConstants.INIT)) != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (!method.isConstructor()) continue;
                    result.add(new EcjResolvedMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(String name, boolean includeInherited) {
            return this.findMethods(name, includeInherited);
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(boolean includeInherited) {
            return this.findMethods(null, includeInherited);
        }

        private Iterable<JavaParser.ResolvedMethod> findMethods(String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                MethodBinding[] methods;
                ReferenceBinding cls;
                if (includeInherited) {
                    ArrayList result = null;
                    for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                        int count;
                        MethodBinding[] methods2;
                        MethodBinding[] methodBindingArray = methods2 = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                        if (methods2 == null || (count = methods2.length) <= 0) continue;
                        if (result == null) {
                            result = Lists.newArrayListWithExpectedSize((int)count);
                        }
                        for (MethodBinding method : methods2) {
                            if ((method.modifiers & 2) != 0 && cls != this.mBinding || method.isConstructor()) continue;
                            boolean masked = false;
                            for (JavaParser.ResolvedMethod m : result) {
                                MethodBinding mb = ((EcjResolvedMethod)m).mBinding;
                                if (!mb.areParameterErasuresEqual(method)) continue;
                                masked = true;
                                break;
                            }
                            if (masked) continue;
                            result.add(new EcjResolvedMethod(method));
                        }
                    }
                    return result != null ? result : Collections.emptyList();
                }
                MethodBinding[] methodBindingArray = methods = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                if (methods != null) {
                    int count = methods.length;
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                    for (MethodBinding method : methods) {
                        if (method.isConstructor()) continue;
                        result.add(new EcjResolvedMethod(method));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)2);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.client);
            if (this.mBinding instanceof ReferenceBinding) {
                for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    Collection<JavaParser.ResolvedAnnotation> external;
                    AnnotationBinding[] annotations = cls.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        all = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null) continue;
                            all.add((Object)new EcjResolvedAnnotation(annotation));
                        }
                    }
                    if ((external = manager.getAnnotations(new EcjResolvedClass(cls))) == null) continue;
                    all.addAll(external);
                }
            } else {
                Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
                if (external != null) {
                    all.addAll(external);
                }
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public Iterable<JavaParser.ResolvedField> getFields(boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls;
                if (includeInherited) {
                    ArrayList result = null;
                    for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                        int count;
                        FieldBinding[] fields = cls.fields();
                        if (fields == null || (count = fields.length) <= 0) continue;
                        if (result == null) {
                            result = Lists.newArrayListWithExpectedSize((int)count);
                        }
                        for (FieldBinding field : fields) {
                            if ((field.modifiers & 2) != 0 && cls != this.mBinding) continue;
                            boolean masked = false;
                            for (JavaParser.ResolvedField f : result) {
                                FieldBinding mb = ((EcjResolvedField)f).mBinding;
                                if (!Arrays.equals(mb.readableName(), field.readableName())) continue;
                                masked = true;
                                break;
                            }
                            if (masked) continue;
                            result.add(new EcjResolvedField(field));
                        }
                    }
                    return result != null ? result : Collections.emptyList();
                }
                FieldBinding[] fields = cls.fields();
                if (fields != null) {
                    int count = fields.length;
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                    for (FieldBinding field : fields) {
                        result.add(new EcjResolvedField(field));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public JavaParser.ResolvedField getField(String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    FieldBinding[] fields = cls.fields();
                    if (fields != null) {
                        for (FieldBinding field : fields) {
                            if ((field.modifiers & 2) != 0 && cls != this.mBinding || !EcjParser.sameChars(name, field.name)) continue;
                            return new EcjResolvedField(field);
                        }
                    }
                    if (!includeInherited) break;
                }
            }
            return null;
        }

        public JavaParser.ResolvedPackage getPackage() {
            return new EcjResolvedPackage(this.mBinding.getPackage());
        }

        public int getModifiers() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                return cls.getAccessFlags();
            }
            return 0;
        }

        public JavaParser.TypeDescriptor getType() {
            return new EcjTypeDescriptor(this.mBinding);
        }

        public String getSignature() {
            return this.getName();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedClass that = (EcjResolvedClass)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedMethod
    extends JavaParser.ResolvedMethod {
        private final MethodBinding mBinding;

        private EcjResolvedMethod(MethodBinding binding) {
            this.mBinding = binding;
            assert (this.mBinding.declaringClass != null);
        }

        public String getName() {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return new String(c);
        }

        public boolean matches(String name) {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return EcjParser.sameChars(name, c);
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass(this.mBinding.declaringClass);
        }

        public int getArgumentCount() {
            return this.mBinding.parameters != null ? this.mBinding.parameters.length : 0;
        }

        public JavaParser.TypeDescriptor getArgumentType(int index) {
            TypeBinding parameterType = this.mBinding.parameters[index];
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(parameterType);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public boolean argumentMatchesType(int index, String signature) {
            return EcjParser.sameChars(signature, this.mBinding.parameters[index].readableName());
        }

        public JavaParser.TypeDescriptor getReturnType() {
            return this.isConstructor() ? null : EcjParser.this.getTypeDescriptor(this.mBinding.returnType);
        }

        public boolean isConstructor() {
            return this.mBinding.isConstructor();
        }

        public JavaParser.ResolvedMethod getSuperMethod() {
            MethodBinding superBinding = EcjParser.findSuperMethodBinding(this.mBinding);
            if (superBinding != null) {
                return new EcjResolvedMethod(superBinding);
            }
            return null;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)4);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.client);
            MethodBinding binding = this.mBinding;
            while (binding != null) {
                Collection<JavaParser.ResolvedAnnotation> external;
                AnnotationBinding[] annotations = binding.getAnnotations();
                int count = annotations.length;
                if (count > 0) {
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null) continue;
                        all.add((Object)new EcjResolvedAnnotation(annotation));
                    }
                }
                if ((external = manager.getAnnotations(new EcjResolvedMethod(binding))) != null) {
                    all.addAll(external);
                }
                if ((binding = EcjParser.findSuperMethodBinding(binding)) == null || !binding.isPrivate()) continue;
                break;
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getParameterAnnotations(int index) {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)4);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.client);
            MethodBinding binding = this.mBinding;
            while (binding != null) {
                Collection<JavaParser.ResolvedAnnotation> external;
                AnnotationBinding[] annotations;
                int count;
                AnnotationBinding[][] parameterAnnotations = binding.getParameterAnnotations();
                if (parameterAnnotations != null && index >= 0 && index < parameterAnnotations.length && (count = (annotations = parameterAnnotations[index]).length) > 0) {
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null) continue;
                        all.add((Object)new EcjResolvedAnnotation(annotation));
                    }
                }
                if ((external = manager.getAnnotations(new EcjResolvedMethod(binding), index)) != null) {
                    all.addAll(external);
                }
                binding = EcjParser.findSuperMethodBinding(binding);
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.declaringClass.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedMethod that = (EcjResolvedMethod)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjTypeDescriptor
    extends JavaParser.TypeDescriptor {
        private final TypeBinding mBinding;

        private EcjTypeDescriptor(TypeBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matchesName(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public boolean matchesSignature(String signature) {
            return EcjParser.sameChars(signature, this.mBinding.readableName());
        }

        public boolean isPrimitive() {
            return this.mBinding.isPrimitiveType();
        }

        public boolean isArray() {
            return this.mBinding.isArrayType();
        }

        public String getSignature() {
            return this.getName();
        }

        public String getSimpleName() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding ref = (ReferenceBinding)this.mBinding;
                char[][] name = ref.compoundName;
                char[] lastSegment = name[name.length - 1];
                StringBuilder sb = new StringBuilder(lastSegment.length);
                for (char c : lastSegment) {
                    if (c == '$') {
                        c = '.';
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            return super.getSimpleName();
        }

        public String getInternalName() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding ref = (ReferenceBinding)this.mBinding;
                StringBuilder sb = new StringBuilder(100);
                char[][] name = ref.compoundName;
                if (name == null) {
                    return super.getInternalName();
                }
                for (char[] segment : name) {
                    if (sb.length() != 0) {
                        sb.append('/');
                    }
                    for (char c : segment) {
                        sb.append(c);
                    }
                }
                return sb.toString();
            }
            return super.getInternalName();
        }

        public JavaParser.ResolvedClass getTypeClass() {
            if (!this.mBinding.isPrimitiveType()) {
                return new EcjResolvedClass(this.mBinding);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjTypeDescriptor that = (EcjTypeDescriptor)((Object)o);
            return this.mBinding.equals(that.mBinding);
        }

        public int hashCode() {
            return this.mBinding.hashCode();
        }
    }

    private static class EcjProblemFactory
    extends DefaultProblemFactory {
        private boolean hasErrors;

        public EcjProblemFactory() {
            super(Locale.getDefault());
        }

        @Override
        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            boolean isError;
            boolean bl = isError = (severity & 1) != 0;
            if (problemId == 16777539) {
                isError = false;
            }
            this.hasErrors |= isError;
            if (skipComputingEcjErrors) {
                return new DefaultProblem(originatingFileName, "<not computed>", problemId, problemArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
            return super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
        }

        @Override
        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            boolean isError;
            boolean bl = isError = (severity & 1) != 0;
            if (problemId == 16777539) {
                isError = false;
            }
            this.hasErrors |= isError;
            if (skipComputingEcjErrors) {
                return new DefaultProblem(originatingFileName, "<not computed>", problemId, problemArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
            return super.createProblem(originatingFileName, problemId, problemArguments, elaborationId, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }
    }

    private static class NonGeneratingCompiler
    extends Compiler {
        private final Map<EcjSourceFile, CompilationUnitDeclaration> mUnits;
        private CompilationUnitDeclaration mCurrentUnit;

        public NonGeneratingCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, Map<EcjSourceFile, CompilationUnitDeclaration> units) {
            super(environment, policy, options, requestor, problemFactory, null, null);
            this.mUnits = units;
        }

        CompilationUnitDeclaration getCurrentUnit() {
            return this.mCurrentUnit;
        }

        @Override
        protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
            super.addCompilationUnit(sourceUnit, parsedUnit);
            this.mUnits.put((EcjSourceFile)sourceUnit, parsedUnit);
        }

        @Override
        public void process(CompilationUnitDeclaration unit, int unitNumber) {
            this.mCurrentUnit = this.lookupEnvironment.unitBeingCompleted = unit;
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            if (this.options.produceReferenceInfo && unit.scope != null) {
                unit.scope.storeDependencyInfo();
            }
            unit.finalizeProblems();
            unit.compilationResult.totalUnitsKnown = this.totalUnits;
            this.lookupEnvironment.unitBeingCompleted = null;
        }

        @Override
        public void reset() {
            if (KEEP_LOOKUP_ENVIRONMENT) {
                this.parser.scanner.source = null;
                this.unitsToProcess = null;
                if (DebugRequestor != null) {
                    DebugRequestor.reset();
                }
                this.problemReporter.reset();
            } else {
                super.reset();
            }
        }
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File mFile;
        private final Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        public Location resolve() {
            lombok.ast.Position pos = this.mNode.getPosition();
            return Location.create((File)this.mFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        public Object getClientData() {
            return this.mClientData;
        }
    }

    public static class EcjResult {
        private final INameEnvironment nameEnvironment;
        private final LookupEnvironment lookupEnvironment;
        private final Map<EcjSourceFile, CompilationUnitDeclaration> sourceToUnit;
        private Map<ICompilationUnit, PsiJavaFile> psiMap;
        private Map<CompilationUnitDeclaration, EcjSourceFile> unitToSource;
        Map<Binding, CompilationUnitDeclaration> mBindingToUnit;
        private EcjPsiManager psiManager;
        private final boolean hasErrors;

        public EcjResult(INameEnvironment nameEnvironment, LookupEnvironment lookupEnvironment, Map<EcjSourceFile, CompilationUnitDeclaration> sourceToUnit, boolean hasErrors) {
            this.nameEnvironment = nameEnvironment;
            this.lookupEnvironment = lookupEnvironment;
            this.sourceToUnit = sourceToUnit;
            this.hasErrors = hasErrors;
        }

        public LookupEnvironment getLookupEnvironment() {
            return this.lookupEnvironment;
        }

        public void setPsiManager(EcjPsiManager psiManager) {
            this.psiManager = psiManager;
        }

        public PsiJavaFile findFile(EcjSourceFile sourceUnit) {
            CompilationUnitDeclaration unit;
            if (this.psiMap != null) {
                PsiJavaFile file = this.psiMap.get(sourceUnit);
                if (file != null) {
                    return file;
                }
            } else {
                this.psiMap = new MapMaker().initialCapacity(this.sourceToUnit.size()).weakValues().concurrencyLevel(1).makeMap();
            }
            if ((unit = this.getCompilationUnit(sourceUnit)) != null) {
                EcjPsiJavaFile file = EcjPsiBuilder.create(this.psiManager, unit, sourceUnit);
                assert (this.psiMap != null);
                this.psiMap.put(sourceUnit, file);
                return file;
            }
            return null;
        }

        public PsiJavaFile findFileContaining(ReferenceBinding declaringClass) {
            if (this.unitToSource == null) {
                int size = this.sourceToUnit.size();
                this.unitToSource = Maps.newHashMapWithExpectedSize((int)size);
                this.mBindingToUnit = Maps.newHashMapWithExpectedSize((int)size);
                for (Map.Entry<EcjSourceFile, CompilationUnitDeclaration> entry : this.sourceToUnit.entrySet()) {
                    CompilationUnitDeclaration unit = entry.getValue();
                    EcjSourceFile sourceUnit = entry.getKey();
                    this.unitToSource.put(unit, sourceUnit);
                    if (unit.types == null) continue;
                    for (TypeDeclaration declaration : unit.types) {
                        EcjResult.recordTypeAssociation(this.mBindingToUnit, declaration, unit);
                    }
                }
            }
            assert (this.mBindingToUnit != null);
            while (declaringClass != null) {
                EcjSourceFile sourceUnit;
                CompilationUnitDeclaration unit = this.mBindingToUnit.get(declaringClass);
                if (unit != null && (sourceUnit = this.unitToSource.get(unit)) != null) {
                    return this.findFile(sourceUnit);
                }
                declaringClass = declaringClass.enclosingType();
            }
            return null;
        }

        private static void recordTypeAssociation(Map<Binding, CompilationUnitDeclaration> bindingMap, TypeDeclaration declaration, CompilationUnitDeclaration unit) {
            bindingMap.put(declaration.binding, unit);
            if (declaration.memberTypes != null) {
                for (TypeDeclaration d : declaration.memberTypes) {
                    EcjResult.recordTypeAssociation(bindingMap, d, unit);
                }
            }
        }

        public Collection<CompilationUnitDeclaration> getCompilationUnits() {
            return this.sourceToUnit.values();
        }

        public CompilationUnitDeclaration getCompilationUnit(EcjSourceFile sourceUnit) {
            return this.sourceToUnit.get(sourceUnit);
        }

        void removeCompilationUnit(EcjSourceFile sourceUnit) {
            this.sourceToUnit.remove(sourceUnit);
        }

        public void dispose() {
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            if (this.lookupEnvironment != null) {
                this.lookupEnvironment.reset();
            }
            this.sourceToUnit.clear();
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }
    }
}

