/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;

public class ToastDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"ShowToast", (String)"Toast created but not shown", (String)"`Toast.makeText()` creates a `Toast` but does *not* show it. You must call `show()` on the resulting object to actually make the `Toast` appear.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("makeText");
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        PsiMethod surroundingMethod;
        PsiExpression duration;
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, "android.widget.Toast")) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 3 && (duration = args[2]) instanceof PsiLiteral) {
            context.report(ISSUE, (PsiElement)duration, context.getLocation((PsiElement)duration), "Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported");
        }
        if ((surroundingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true)) == null) {
            return;
        }
        ShowFinder finder = new ShowFinder(call);
        surroundingMethod.accept((PsiElementVisitor)finder);
        if (!finder.isShowCalled()) {
            context.report(ISSUE, (PsiElement)call, context.getLocation((PsiElement)call.getMethodExpression()), "Toast created but not shown: did you forget to call `show()` ?");
        }
    }

    private static class ShowFinder
    extends JavaRecursiveElementVisitor {
        private final PsiMethodCallExpression mTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private ShowFinder(PsiMethodCallExpression target) {
            this.mTarget = target;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            super.visitMethodCallExpression(node);
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            } else {
                PsiReferenceExpression methodExpression = node.getMethodExpression();
                if ((this.mSeenTarget || methodExpression.getQualifier() == this.mTarget) && "show".equals(methodExpression.getReferenceName())) {
                    this.mFound = true;
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement node) {
            super.visitReturnStatement(node);
            if (node.getReturnValue() == this.mTarget) {
                this.mFound = true;
            }
        }

        boolean isShowCalled() {
            return this.mFound;
        }
    }
}

