/*
 * Decompiled with CFR 0.152.
 */
package org.clearsilver;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.clearsilver.HDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSUtil {
    public static final String HDF_LOADPATHS = "hdf.loadpaths";

    private CSUtil() {
    }

    public static List<String> getLoadPaths(HDF hdf) {
        return CSUtil.getLoadPaths(hdf, false);
    }

    public static List<String> getLoadPaths(HDF hdf, boolean allowEmpty) {
        LinkedList<String> list = new LinkedList<String>();
        HDF loadpathsHdf = hdf.getObj(HDF_LOADPATHS);
        if (loadpathsHdf == null) {
            if (allowEmpty) {
                return list;
            }
            throw new NullPointerException("No HDF loadpaths located in the specified HDF structure");
        }
        for (HDF lpHdf = loadpathsHdf.objChild(); lpHdf != null; lpHdf = lpHdf.objNext()) {
            list.add(lpHdf.objValue());
        }
        return list;
    }

    public static File locateFile(List<String> loadpaths, String filename) {
        if (filename == null) {
            throw new NullPointerException("No filename provided");
        }
        if (loadpaths == null) {
            throw new NullPointerException("No loadpaths provided.");
        }
        for (String path : loadpaths) {
            File file = new File(path, filename);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

