/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.log.event.EventDisplay;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DisplayLog
extends EventDisplay {
    private static final String PREFS_COL_DATE = "EventLogPanel.log.Col1";
    private static final String PREFS_COL_PID = "EventLogPanel.log.Col2";
    private static final String PREFS_COL_EVENTTAG = "EventLogPanel.log.Col3";
    private static final String PREFS_COL_VALUENAME = "EventLogPanel.log.Col4";
    private static final String PREFS_COL_VALUE = "EventLogPanel.log.Col5";
    private static final String PREFS_COL_TYPE = "EventLogPanel.log.Col6";

    public DisplayLog(String name) {
        super(name);
    }

    @Override
    void resetUI() {
        this.mLogTable.removeAll();
    }

    @Override
    void newEvent(EventContainer event, EventLogParser logParser) {
        this.addToLog(event, logParser);
    }

    @Override
    Control createComposite(Composite parent, EventLogParser logParser, EventDisplay.ILogColumnListener listener) {
        return this.createLogUI(parent, listener);
    }

    private void addToLog(EventContainer event, EventLogParser logParser) {
        ScrollBar bar = this.mLogTable.getVerticalBar();
        boolean scroll = bar.getMaximum() == bar.getSelection() + bar.getThumb();
        Calendar c = Calendar.getInstance();
        long msec = (long)event.sec * 1000L;
        c.setTimeInMillis(msec);
        String date = String.format("%1$tF %1$tT", c);
        String eventName = (String)logParser.getTagMap().get(event.mTag);
        String pidName = Integer.toString(event.pid);
        EventValueDescription[] valueDescription = (EventValueDescription[])logParser.getEventInfoMap().get(event.mTag);
        if (valueDescription != null) {
            int itemCount;
            for (int i = 0; i < valueDescription.length; ++i) {
                EventValueDescription description = valueDescription[i];
                try {
                    String value = event.getValueAsString(i);
                    this.logValue(date, pidName, eventName, description.getName(), value, description.getEventValueType(), description.getValueType());
                    continue;
                }
                catch (InvalidTypeException e) {
                    this.logValue(date, pidName, eventName, description.getName(), e.getMessage(), description.getEventValueType(), description.getValueType());
                }
            }
            if (scroll && (itemCount = this.mLogTable.getItemCount()) > 0) {
                this.mLogTable.showItem(this.mLogTable.getItem(itemCount - 1));
            }
        }
    }

    protected void addToLog(EventContainer event, EventLogParser logParser, ArrayList<EventDisplay.ValueDisplayDescriptor> valueDescriptors, ArrayList<EventDisplay.OccurrenceDisplayDescriptor> occurrenceDescriptors) {
        int itemCount;
        ScrollBar bar = this.mLogTable.getVerticalBar();
        boolean scroll = bar.getMaximum() == bar.getSelection() + bar.getThumb();
        Calendar c = Calendar.getInstance();
        long msec = (long)event.sec * 1000L;
        c.setTimeInMillis(msec);
        String date = String.format("%1$tF %1$tT", c);
        String eventName = (String)logParser.getTagMap().get(event.mTag);
        String pidName = Integer.toString(event.pid);
        if (valueDescriptors.size() > 0) {
            for (EventDisplay.ValueDisplayDescriptor descriptor : valueDescriptors) {
                this.logDescriptor(event, descriptor, date, pidName, eventName, logParser);
            }
        }
        if (scroll && (itemCount = this.mLogTable.getItemCount()) > 0) {
            this.mLogTable.showItem(this.mLogTable.getItem(itemCount - 1));
        }
    }

    private void logValue(String date, String pid, String event, String valueName, String value, EventContainer.EventValueType eventValueType, EventValueDescription.ValueType valueType) {
        TableItem item = new TableItem(this.mLogTable, 0);
        item.setText(0, date);
        item.setText(1, pid);
        item.setText(2, event);
        item.setText(3, valueName);
        item.setText(4, value);
        String type = valueType != EventValueDescription.ValueType.NOT_APPLICABLE ? String.format("%1$s, %2$s", eventValueType.toString(), valueType.toString()) : eventValueType.toString();
        item.setText(5, type);
    }

    private void logDescriptor(EventContainer event, EventDisplay.ValueDisplayDescriptor descriptor, String date, String pidName, String eventName, EventLogParser logParser) {
        String value;
        try {
            value = event.getValueAsString(descriptor.valueIndex);
        }
        catch (InvalidTypeException e) {
            value = e.getMessage();
        }
        EventValueDescription[] values = (EventValueDescription[])logParser.getEventInfoMap().get(event.mTag);
        EventValueDescription valueDescription = values[descriptor.valueIndex];
        this.logValue(date, pidName, eventName, descriptor.valueName, value, valueDescription.getEventValueType(), valueDescription.getValueType());
    }

    private Control createLogUI(Composite parent, final EventDisplay.ILogColumnListener listener) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        mainComp.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        mainComp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DisplayLog.this.mLogTable = null;
            }
        });
        Label l = new Label(mainComp, 0x1000000);
        l.setText(this.mName);
        l.setLayoutData((Object)new GridData(768));
        this.mLogTable = new Table(mainComp, 68098);
        this.mLogTable.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = DdmUiPreferences.getStore();
        TableColumn col = TableHelper.createTableColumn(this.mLogTable, "Time", 16384, "0000-00-00 00:00:00", PREFS_COL_DATE, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(0, (TableColumn)source);
                }
            }
        });
        col = TableHelper.createTableColumn(this.mLogTable, "pid", 16384, "0000", PREFS_COL_PID, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(1, (TableColumn)source);
                }
            }
        });
        col = TableHelper.createTableColumn(this.mLogTable, "Event", 16384, "abcdejghijklmno", PREFS_COL_EVENTTAG, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(2, (TableColumn)source);
                }
            }
        });
        col = TableHelper.createTableColumn(this.mLogTable, "Name", 16384, "Process Name", PREFS_COL_VALUENAME, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(3, (TableColumn)source);
                }
            }
        });
        col = TableHelper.createTableColumn(this.mLogTable, "Value", 16384, "0000000", PREFS_COL_VALUE, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(4, (TableColumn)source);
                }
            }
        });
        col = TableHelper.createTableColumn(this.mLogTable, "Type", 16384, "long, seconds", PREFS_COL_TYPE, store);
        col.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object source = e.getSource();
                if (source instanceof TableColumn) {
                    listener.columnResized(5, (TableColumn)source);
                }
            }
        });
        this.mLogTable.setHeaderVisible(true);
        this.mLogTable.setLinesVisible(true);
        return mainComp;
    }

    @Override
    void resizeColumn(int index, TableColumn sourceColumn) {
        TableColumn col;
        if (this.mLogTable != null && (col = this.mLogTable.getColumn(index)) != sourceColumn) {
            col.setWidth(sourceColumn.getWidth());
        }
    }

    @Override
    int getDisplayType() {
        return 0;
    }
}

