/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.Panel;
import com.android.ddmuilib.SyncProgressHelper;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.explorer.DeviceContentProvider;
import com.android.ddmuilib.explorer.FileLabelProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceExplorer
extends Panel {
    public static String COLUMN_NAME = "android.explorer.name";
    public static String COLUMN_SIZE = "android.explorer.size";
    public static String COLUMN_DATE = "android.explorer.data";
    public static String COLUMN_TIME = "android.explorer.time";
    public static String COLUMN_PERMISSIONS = "android.explorer.permissions";
    public static String COLUMN_INFO = "android.explorer.info";
    private Composite mParent;
    private TreeViewer mTreeViewer;
    private Tree mTree;
    private DeviceContentProvider mContentProvider;
    private ICommonAction mPushAction;
    private ICommonAction mPullAction;
    private ICommonAction mDeleteAction;
    private ICommonAction mCreateNewFolderAction;
    private Image mFileImage;
    private Image mFolderImage;
    private Image mPackageImage;
    private Image mOtherImage;
    private IDevice mCurrentDevice;
    private String mDefaultSave;

    public void setCustomImages(Image fileImage, Image folderImage, Image packageImage, Image otherImage) {
        this.mFileImage = fileImage;
        this.mFolderImage = folderImage;
        this.mPackageImage = packageImage;
        this.mOtherImage = otherImage;
    }

    public void setActions(ICommonAction pushAction, ICommonAction pullAction, ICommonAction deleteAction, ICommonAction createNewFolderAction) {
        this.mPushAction = pushAction;
        this.mPullAction = pullAction;
        this.mDeleteAction = deleteAction;
        this.mCreateNewFolderAction = createNewFolderAction;
    }

    @Override
    protected Control createControl(Composite parent) {
        this.mParent = parent;
        parent.setLayout((Layout)new FillLayout());
        ImageLoader loader = ImageLoader.getDdmUiLibLoader();
        if (this.mFileImage == null) {
            this.mFileImage = loader.loadImage("file.png", this.mParent.getDisplay());
        }
        if (this.mFolderImage == null) {
            this.mFolderImage = loader.loadImage("folder.png", this.mParent.getDisplay());
        }
        if (this.mPackageImage == null) {
            this.mPackageImage = loader.loadImage("android.png", this.mParent.getDisplay());
        }
        if (this.mOtherImage == null) {
            // empty if block
        }
        this.mTree = new Tree(parent, 0x10010002);
        this.mTree.setHeaderVisible(true);
        IPreferenceStore store = DdmUiPreferences.getStore();
        TableHelper.createTreeColumn(this.mTree, "Name", 16384, "0000drwxrwxrwx", COLUMN_NAME, store);
        TableHelper.createTreeColumn(this.mTree, "Size", 131072, "000000", COLUMN_SIZE, store);
        TableHelper.createTreeColumn(this.mTree, "Date", 16384, "2007-08-14", COLUMN_DATE, store);
        TableHelper.createTreeColumn(this.mTree, "Time", 16384, "20:54", COLUMN_TIME, store);
        TableHelper.createTreeColumn(this.mTree, "Permissions", 16384, "drwxrwxrwx", COLUMN_PERMISSIONS, store);
        TableHelper.createTreeColumn(this.mTree, "Info", 16384, "drwxrwxrwx", COLUMN_INFO, store);
        this.mTreeViewer = new TreeViewer(this.mTree);
        this.mContentProvider = new DeviceContentProvider();
        this.mTreeViewer.setContentProvider(this.mContentProvider);
        this.mTreeViewer.setLabelProvider(new FileLabelProvider(this.mFileImage, this.mFolderImage, this.mPackageImage, this.mOtherImage));
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel.isEmpty()) {
                    DeviceExplorer.this.mPullAction.setEnabled(false);
                    DeviceExplorer.this.mPushAction.setEnabled(false);
                    DeviceExplorer.this.mDeleteAction.setEnabled(false);
                    DeviceExplorer.this.mCreateNewFolderAction.setEnabled(false);
                    return;
                }
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object element = selection.getFirstElement();
                    if (element == null) {
                        return;
                    }
                    if (element instanceof FileListingService.FileEntry) {
                        DeviceExplorer.this.mPullAction.setEnabled(true);
                        DeviceExplorer.this.mPushAction.setEnabled(selection.size() == 1);
                        if (selection.size() == 1) {
                            FileListingService.FileEntry entry = (FileListingService.FileEntry)element;
                            DeviceExplorer.this.setDeleteEnabledState(entry);
                            DeviceExplorer.this.mCreateNewFolderAction.setEnabled(entry.isDirectory());
                        } else {
                            DeviceExplorer.this.mDeleteAction.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.mTreeViewer.addDropSupport(3, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter(this.mTreeViewer){

            @Override
            public boolean performDrop(Object data) {
                FileListingService.FileEntry target = (FileListingService.FileEntry)this.getCurrentTarget();
                if (target == null) {
                    return false;
                }
                if (!target.isDirectory()) {
                    target = target.getParent();
                }
                if (target == null) {
                    return false;
                }
                String[] files = (String[])data;
                DeviceExplorer.this.pushFiles(files, target);
                DeviceExplorer.this.refresh(target);
                return true;
            }

            @Override
            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                FileListingService.FileEntry targetEntry = (FileListingService.FileEntry)target;
                if (!targetEntry.isDirectory()) {
                    target = targetEntry.getParent();
                }
                return target != null;
            }
        });
        new Thread("Device Ls refresher"){

            @Override
            public void run() {
                block3: {
                    while (true) {
                        try {
                            3.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (DeviceExplorer.this.mTree == null || DeviceExplorer.this.mTree.isDisposed()) break block3;
                        Display display = DeviceExplorer.this.mTree.getDisplay();
                        if (display.isDisposed()) break;
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!DeviceExplorer.this.mTree.isDisposed()) {
                                    DeviceExplorer.this.mTreeViewer.refresh(true);
                                }
                            }
                        });
                    }
                    return;
                }
            }
        }.start();
        return this.mTree;
    }

    @Override
    protected void postCreation() {
    }

    @Override
    public void setFocus() {
        this.mTree.setFocus();
    }

    public void pullSelection() {
        String defaultPath;
        TreeItem[] items = this.mTree.getSelection();
        String filePullName = null;
        FileListingService.FileEntry singleEntry = null;
        if (items.length == 1 && (singleEntry = (FileListingService.FileEntry)items[0].getData()).getType() == 0) {
            filePullName = singleEntry.getName();
        }
        if ((defaultPath = this.mDefaultSave) == null) {
            defaultPath = System.getProperty("user.home");
        }
        if (filePullName != null) {
            FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 8192);
            fileDialog.setText("Get Device File");
            fileDialog.setFileName(filePullName);
            fileDialog.setFilterPath(defaultPath);
            String fileName = fileDialog.open();
            if (fileName != null) {
                this.mDefaultSave = fileDialog.getFilterPath();
                this.pullFile(singleEntry, fileName);
            }
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.mParent.getShell(), 8192);
            directoryDialog.setText("Get Device Files/Folders");
            directoryDialog.setFilterPath(defaultPath);
            String directoryName = directoryDialog.open();
            if (directoryName != null) {
                this.pullSelection(items, directoryName);
            }
        }
    }

    public void pushIntoSelection() {
        TreeItem[] items = this.mTree.getSelection();
        if (items.length == 0) {
            return;
        }
        FileDialog dlg = new FileDialog(this.mParent.getShell(), 4096);
        dlg.setText("Put File on Device");
        FileListingService.FileEntry entry = (FileListingService.FileEntry)items[0].getData();
        dlg.setFileName(entry.getName());
        String defaultPath = this.mDefaultSave;
        if (defaultPath == null) {
            defaultPath = System.getProperty("user.home");
        }
        dlg.setFilterPath(defaultPath);
        String fileName = dlg.open();
        if (fileName != null) {
            String remotePath;
            this.mDefaultSave = dlg.getFilterPath();
            FileListingService.FileEntry toRefresh = entry;
            if (entry.isDirectory()) {
                remotePath = entry.getFullPath();
            } else {
                toRefresh = entry.getParent();
                remotePath = toRefresh.getFullPath();
            }
            this.pushFile(fileName, remotePath);
            this.mTreeViewer.refresh(toRefresh);
        }
    }

    public void deleteSelection() {
        TreeItem[] items = this.mTree.getSelection();
        if (items.length != 1) {
            return;
        }
        FileListingService.FileEntry entry = (FileListingService.FileEntry)items[0].getData();
        final FileListingService.FileEntry parentEntry = entry.getParent();
        String command = "rm " + entry.getFullEscapedPath();
        try {
            this.mCurrentDevice.executeShellCommand(command, new IShellOutputReceiver(){

                public void addOutput(byte[] data, int offset, int length) {
                }

                public void flush() {
                    DeviceExplorer.this.mTreeViewer.refresh(parentEntry);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (IOException iOException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            // empty catch block
        }
    }

    public void createNewFolderInSelection() {
        TreeItem[] items = this.mTree.getSelection();
        if (items.length != 1) {
            return;
        }
        final FileListingService.FileEntry entry = (FileListingService.FileEntry)items[0].getData();
        if (entry.isDirectory()) {
            InputDialog inputDialog = new InputDialog(this.mTree.getShell(), "New Folder", "Please enter the new folder name", "New Folder", new IInputValidator(){

                @Override
                public String isValid(String newText) {
                    if (newText != null && newText.length() > 0 && newText.trim().length() > 0 && newText.indexOf(47) == -1 && newText.indexOf(92) == -1) {
                        return null;
                    }
                    return "Invalid name";
                }
            });
            inputDialog.open();
            String value = inputDialog.getValue();
            if (value != null) {
                String command = "mkdir " + entry.getFullEscapedPath() + "/" + FileListingService.FileEntry.escape((String)value);
                try {
                    this.mCurrentDevice.executeShellCommand(command, new IShellOutputReceiver(){

                        public boolean isCancelled() {
                            return false;
                        }

                        public void flush() {
                            DeviceExplorer.this.mTreeViewer.refresh(entry);
                        }

                        public void addOutput(byte[] data, int offset, int length) {
                            String errorMessage = data != null ? new String(data) : "";
                            Status status = new Status(4, "DeviceExplorer", 0, errorMessage, null);
                            ErrorDialog.openError(DeviceExplorer.this.mTree.getShell(), "New Folder Error", "New Folder Error", (IStatus)status);
                        }
                    });
                }
                catch (TimeoutException timeoutException) {
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void refresh() {
        this.mTreeViewer.refresh(true);
    }

    public void switchDevice(IDevice device) {
        if (device != this.mCurrentDevice) {
            this.mCurrentDevice = device;
            if (!this.mTree.isDisposed()) {
                Display d = this.mTree.getDisplay();
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!DeviceExplorer.this.mTree.isDisposed() && DeviceExplorer.this.mCurrentDevice != null) {
                            FileListingService fls = DeviceExplorer.this.mCurrentDevice.getFileListingService();
                            DeviceExplorer.this.mContentProvider.setListingService(fls);
                            DeviceExplorer.this.mTreeViewer.setInput(fls.getRoot());
                        }
                    }
                });
            }
        }
    }

    private void refresh(final FileListingService.FileEntry entry) {
        Display d = this.mTreeViewer.getTree().getDisplay();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                DeviceExplorer.this.mTreeViewer.refresh(entry);
            }
        });
    }

    private void pullSelection(TreeItem[] items, final String localDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                ArrayList<FileListingService.FileEntry> entries = new ArrayList<FileListingService.FileEntry>();
                for (TreeItem item : items) {
                    Object data = item.getData();
                    if (!(data instanceof FileListingService.FileEntry)) continue;
                    entries.add((FileListingService.FileEntry)data);
                }
                final FileListingService.FileEntry[] entryArray = entries.toArray(new FileListingService.FileEntry[entries.size()]);
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    @Override
                    public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                        sync.pull(entryArray, localDirectory, monitor);
                    }

                    @Override
                    public void close() {
                        sync.close();
                    }
                }, "Pulling file(s) from the device", this.mParent.getShell());
            }
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", e.getMessage()));
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pullFile(final FileListingService.FileEntry remote, final String local) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    @Override
                    public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                        sync.pullFile(remote, local, monitor);
                    }

                    @Override
                    public void close() {
                        sync.close();
                    }
                }, String.format("Pulling %1$s from the device", remote.getName()), this.mParent.getShell());
            }
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to pull selection: %1$s", e.getMessage()));
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to pull selection");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pushFiles(final String[] localFiles, final FileListingService.FileEntry remoteDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    @Override
                    public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                        sync.push(localFiles, remoteDirectory, monitor);
                    }

                    @Override
                    public void close() {
                        sync.close();
                    }
                }, "Pushing file(s) to the device", this.mParent.getShell());
            }
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to push selection: %1$s", e.getMessage()));
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to push the items");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    private void pushFile(final String local, String remoteDirectory) {
        try {
            final SyncService sync = this.mCurrentDevice.getSyncService();
            if (sync != null) {
                String[] segs = local.split(Pattern.quote(File.separator));
                String name = segs[segs.length - 1];
                final String remoteFile = remoteDirectory + "/" + name;
                SyncProgressHelper.run(new SyncProgressHelper.SyncRunnable(){

                    @Override
                    public void run(SyncService.ISyncProgressMonitor monitor) throws SyncException, IOException, TimeoutException {
                        sync.pushFile(local, remoteFile, monitor);
                    }

                    @Override
                    public void close() {
                        sync.close();
                    }
                }, String.format("Pushing %1$s to the device.", name), this.mParent.getShell());
            }
        }
        catch (SyncException e) {
            if (!e.wasCanceled()) {
                DdmConsole.printErrorToConsole(String.format("Failed to push selection: %1$s", e.getMessage()));
            }
        }
        catch (Exception e) {
            DdmConsole.printErrorToConsole("Failed to push the item(s).");
            DdmConsole.printErrorToConsole(e.getMessage());
        }
    }

    protected void setDeleteEnabledState(FileListingService.FileEntry element) {
        this.mDeleteAction.setEnabled(element.getType() == 0);
    }
}

