/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtil");
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Set<String> IGNORED_NAMES = ContainerUtil.newTroveSet("ignore", "ignore1", "ignore2", "ignore3", "ignore4", "ignore5", "ignored", "ignored1", "ignored2", "ignored3", "ignored4", "ignored5");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return PsiUtilCore.compareElementsByPosition(o1, o2);
        }
    };
    public static final PsiClass NULL_PSI_CLASS = new NullPsiClass();

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
        }
        ArrayList<PsiTypeParameter> result = null;
        for (PsiTypeParameterListOwner currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result == null) {
                    result = new ArrayList<PsiTypeParameter>(typeParameters.length);
                }
                for (int i = typeParameters.length - 1; i >= 0; --i) {
                    result.add(typeParameters[i]);
                }
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result == null) {
            EmptyIterable<PsiTypeParameter> emptyIterable = EmptyIterable.getInstance();
            if (emptyIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
            }
            return emptyIterable;
        }
        ArrayList<PsiTypeParameter> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
        }
        return arrayList;
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/psi/util/PsiUtil", "isRawSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/PsiUtil", "isRawSubstitutor"));
        }
        if (substitutor == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static void ensureValidType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/PsiUtil", "ensureValidType"));
        }
        PsiUtil.ensureValidType(type, null);
    }

    public static void ensureValidType(@NotNull PsiType type, @Nullable String customMessage) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/util/PsiUtil", "ensureValidType"));
        }
        if (!type.isValid()) {
            TimeoutUtil.sleep(1L);
            if (type.isValid()) {
                LOG.error("PsiType resurrected: " + type + " of " + type.getClass() + " " + customMessage);
                return;
            }
            if (type instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    throw customMessage == null ? e : new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type + " of class " + type.getClass() + " " + customMessage));
        }
    }

    public static class NullPsiClass
    extends PsiUtilCore.NullPsiElement
    implements PsiClass {
        @Override
        @Nullable
        public String getQualifiedName() {
            throw this.createException();
        }

        @Override
        public boolean isInterface() {
            throw this.createException();
        }

        @Override
        public boolean isAnnotationType() {
            throw this.createException();
        }

        @Override
        public boolean isEnum() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReferenceList getExtendsList() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReferenceList getImplementsList() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getExtendsListTypes() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getImplementsListTypes() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass getSuperClass() {
            throw this.createException();
        }

        @Override
        public PsiClass[] getInterfaces() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getSupers() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getSuperTypes() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiField[] getFields() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getMethods() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getConstructors() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getInnerClasses() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassInitializer[] getInitializers() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiField[] getAllFields() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getAllMethods() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getAllInnerClasses() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiField findFieldByName(@NonNls String name, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String name, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLBrace() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getRBrace() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiIdentifier getNameIdentifier() {
            throw this.createException();
        }

        @Override
        public PsiElement getScope() {
            throw this.createException();
        }

        @Override
        public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/util/PsiUtil$NullPsiClass", "isInheritor"));
            }
            throw this.createException();
        }

        @Override
        public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass getContainingClass() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
            throw this.createException();
        }
    }
}

