/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull CharSequence text, @NonNls @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtilRt", "endsWithIgnoreCase"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtilRt", "endsWithIgnoreCase"));
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtilRt", "lastIndexOf"));
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

