/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.annotations.NotNull;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    private static ProgressManager ourInstance;

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager result = ourInstance;
        if (result == null) {
            result = ServiceManager.getService(ProgressManager.class);
            if (result == null) {
                throw new AssertionError((Object)("ProgressManager is null; " + ApplicationManager.getApplication()));
            }
            ourInstance = result;
        }
        ProgressManager progressManager = result;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.getInstance().doCheckCanceled();
    }
}

