/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.Language");
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = ContainerUtil.newConcurrentMap();
    private static final Map<String, Language> ourRegisteredIDs = ContainerUtil.newConcurrentMap();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects;
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NotNull @NonNls String ID2) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/lang/Language", "<init>"));
        }
        this(ID2, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(@NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/lang/Language", "<init>"));
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mimeTypes", "com/intellij/lang/Language", "<init>"));
        }
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/lang/Language", "<init>"));
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mimeTypes", "com/intellij/lang/Language", "<init>"));
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            LOG.error("Language of '" + langClass + "' is already registered: " + prev);
            return;
        }
        prev = ourRegisteredIDs.put(ID2, this);
        if (prev != null) {
            LOG.error("Language with ID '" + ID2 + "' is already registered: " + prev.getClass());
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty(mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, mimeType, ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        Collection<Language> collection = Collections.unmodifiableCollection(new ArrayList<Language>(languages));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "getRegisteredLanguages"));
        }
        return collection;
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/lang/Language", "findInstance"));
        }
        return (T)ourRegisteredLanguages.get(klass);
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        Collection collection = result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "findInstancesByMimeType"));
        }
        return collection;
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    @NotNull
    public String[] getMimeTypes() {
        if (this.myMimeTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "getMimeTypes"));
        }
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "getID"));
        }
        return string;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return (LanguageFileType)fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return (LanguageFileType)fileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "getDisplayName"));
        }
        return string;
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull String anotherLanguageId) {
        if (anotherLanguageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherLanguageId", "com/intellij/lang/Language", "isKindOf"));
        }
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        List<Language> list = this.myDialects;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/Language", "getDialects"));
        }
        return list;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(@NotNull String ID2, boolean register) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/lang/Language", "<init>"));
        }
        this.myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myID = ID2;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }
}

