/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DurationMinimap
extends Canvas {
    private static final int DEFAULT_ALPHA = 255;
    private static final int VISIBLE_CALLS_HIGHLIGHT_ALPHA = 50;
    private static final long CALL_DURATION_CLAMP = 20000L;
    private static final String FONT_KEY = "default.font";
    private static final int MAX_DURATION_LENGTH_SCALE = 6;
    private List<GLCall> mCalls;
    private int mContextCount;
    private int mStartCallIndex;
    private int mEndCallIndex;
    private int mVisibleCallTopIndex;
    private int mVisibleCallBottomIndex;
    private Color mBackgroundColor;
    private Color mDurationLineColor;
    private Color mGlDrawColor;
    private Color mGlErrorColor;
    private Color mContextHeaderColor;
    private Color mVisibleCallsHighlightColor;
    private Color mMouseMarkerColor;
    private FontRegistry mFontRegistry;
    private int mFontWidth;
    private int mFontHeight;
    private Image mBackBufferImage;
    private GC mBackBufferGC;
    private boolean mMouseInSelf;
    private int mMouseY;
    private final PositionHelper mPositionHelper;
    private List<ICallSelectionListener> mListeners = new ArrayList<ICallSelectionListener>();

    public DurationMinimap(Composite parent, GLTrace trace) {
        super(parent, 262144);
        this.setInput(trace);
        this.initializeColors();
        this.initializeFonts();
        this.mPositionHelper = new PositionHelper(this.mFontHeight, this.mContextCount, this.mFontWidth * 6, 20000L);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DurationMinimap.this.draw(e.display, e.gc);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DurationMinimap.this.controlResized();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                DurationMinimap.this.mouseMoved(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DurationMinimap.this.mouseClicked(e);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                DurationMinimap.this.mMouseInSelf = false;
                DurationMinimap.this.redraw();
            }

            public void mouseEnter(MouseEvent e) {
                DurationMinimap.this.mMouseInSelf = true;
                DurationMinimap.this.redraw();
            }
        });
    }

    public void setInput(GLTrace trace) {
        if (trace != null) {
            this.mCalls = trace.getGLCalls();
            this.mContextCount = trace.getContexts().size();
        } else {
            this.mCalls = null;
            this.mContextCount = 1;
        }
    }

    public void dispose() {
        this.disposeColors();
        this.disposeBackBuffer();
        super.dispose();
    }

    private void initializeColors() {
        this.mBackgroundColor = new Color((Device)this.getDisplay(), 51, 51, 51);
        this.mDurationLineColor = new Color((Device)this.getDisplay(), 8, 81, 156);
        this.mGlDrawColor = new Color((Device)this.getDisplay(), 107, 174, 214);
        this.mContextHeaderColor = new Color((Device)this.getDisplay(), 209, 229, 240);
        this.mVisibleCallsHighlightColor = new Color((Device)this.getDisplay(), 204, 204, 204);
        this.mMouseMarkerColor = new Color((Device)this.getDisplay(), 170, 170, 170);
        this.mGlErrorColor = this.getDisplay().getSystemColor(3);
    }

    private void disposeColors() {
        this.mBackgroundColor.dispose();
        this.mDurationLineColor.dispose();
        this.mGlDrawColor.dispose();
        this.mContextHeaderColor.dispose();
        this.mVisibleCallsHighlightColor.dispose();
        this.mMouseMarkerColor.dispose();
    }

    private void initializeFonts() {
        this.mFontRegistry = new FontRegistry(this.getDisplay());
        this.mFontRegistry.put(FONT_KEY, new FontData[]{new FontData("Arial", 8, 0)});
        GC gc = new GC((Drawable)this.getDisplay());
        gc.setFont(this.mFontRegistry.get(FONT_KEY));
        this.mFontWidth = gc.getFontMetrics().getAverageCharWidth();
        this.mFontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
    }

    private void initializeBackBuffer() {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            this.mBackBufferImage = null;
            this.mBackBufferGC = null;
            return;
        }
        this.mBackBufferImage = new Image((Device)this.getDisplay(), clientArea.width, clientArea.height);
        this.mBackBufferGC = new GC((Drawable)this.mBackBufferImage);
    }

    private void disposeBackBuffer() {
        if (this.mBackBufferImage != null) {
            this.mBackBufferImage.dispose();
            this.mBackBufferImage = null;
        }
        if (this.mBackBufferGC != null) {
            this.mBackBufferGC.dispose();
            this.mBackBufferGC = null;
        }
    }

    private void mouseMoved(MouseEvent e) {
        this.mMouseY = e.y;
        this.redraw();
    }

    private void mouseClicked(MouseEvent e) {
        if (this.mMouseInSelf) {
            int selIndex = this.mPositionHelper.getCallAt(this.mMouseY);
            this.sendCallSelectedEvent(selIndex);
            this.redraw();
        }
    }

    private void draw(Display display, GC gc) {
        if (this.mBackBufferImage == null) {
            this.initializeBackBuffer();
        }
        if (this.mBackBufferImage == null) {
            return;
        }
        this.drawBackground(this.mBackBufferGC, this.mBackBufferImage.getBounds());
        this.drawContextHeaders(this.mBackBufferGC);
        this.drawCallDurations(this.mBackBufferGC);
        this.drawVisibleCallHighlights(this.mBackBufferGC);
        this.drawMouseMarkers(this.mBackBufferGC);
        int width = this.getClientArea().width;
        int height = this.getClientArea().height;
        gc.drawImage(this.mBackBufferImage, 0, 0, width, height, 0, 0, width, height);
    }

    private void drawBackground(GC gc, Rectangle bounds) {
        gc.setBackground(this.mBackgroundColor);
        gc.fillRectangle(bounds);
    }

    private void drawContextHeaders(GC gc) {
        if (this.mContextCount <= 1) {
            return;
        }
        gc.setForeground(this.mContextHeaderColor);
        gc.setFont(this.mFontRegistry.get(FONT_KEY));
        int i = 0;
        while (i < this.mContextCount) {
            Point p = this.mPositionHelper.getHeaderLocation(i);
            gc.drawText("CTX" + Integer.toString(i), p.x, p.y);
            ++i;
        }
    }

    private void drawCallDurations(GC gc) {
        if (this.mCalls == null || this.mCalls.size() < this.mEndCallIndex) {
            return;
        }
        gc.setBackground(this.mDurationLineColor);
        int callUnderScan = this.mPositionHelper.getCallUnderScanValue();
        int i = this.mStartCallIndex;
        while (i < this.mEndCallIndex) {
            boolean resetColor = false;
            GLCall c = this.mCalls.get(i);
            long duration = c.getWallDuration();
            if (c.hasErrors()) {
                gc.setBackground(this.mGlErrorColor);
                resetColor = true;
                duration = this.mPositionHelper.getMaxDuration();
            } else if (c.getFunction() == GLProtoBuf.GLMessage.Function.glDrawArrays || c.getFunction() == GLProtoBuf.GLMessage.Function.glDrawElements || c.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
                gc.setBackground(this.mGlDrawColor);
                resetColor = true;
                duration = this.mPositionHelper.getMaxDuration();
            }
            Rectangle bounds = this.mPositionHelper.getDurationBounds(i - this.mStartCallIndex, c.getContextId(), duration);
            gc.fillRectangle(bounds);
            if (resetColor) {
                gc.setBackground(this.mDurationLineColor);
            }
            i += callUnderScan;
        }
    }

    private void drawVisibleCallHighlights(GC gc) {
        gc.setAlpha(50);
        gc.setBackground(this.mVisibleCallsHighlightColor);
        gc.fillRectangle(this.mPositionHelper.getBoundsFramingCalls(this.mVisibleCallTopIndex - this.mStartCallIndex, this.mVisibleCallBottomIndex - this.mStartCallIndex));
        gc.setAlpha(255);
    }

    private void drawMouseMarkers(GC gc) {
        if (!this.mMouseInSelf) {
            return;
        }
        if (this.mPositionHelper.getCallAt(this.mMouseY) < 0) {
            return;
        }
        gc.setForeground(this.mMouseMarkerColor);
        gc.drawLine(0, this.mMouseY, this.getClientArea().width, this.mMouseY);
    }

    private void controlResized() {
        this.disposeBackBuffer();
        this.initializeBackBuffer();
        this.redraw();
    }

    public int getMinimumWidth() {
        return this.mPositionHelper.getMinimumWidth();
    }

    public void setCallRangeForCurrentFrame(int startCallIndex, int endCallIndex) {
        this.mStartCallIndex = startCallIndex;
        this.mEndCallIndex = endCallIndex;
        this.mPositionHelper.updateCallDensity(this.mEndCallIndex - this.mStartCallIndex, this.getClientArea().height);
        this.redraw();
    }

    public void setVisibleCallRange(int visibleTopIndex, int visibleBottomIndex) {
        this.mVisibleCallTopIndex = visibleTopIndex;
        this.mVisibleCallBottomIndex = visibleBottomIndex;
        this.redraw();
    }

    public void addCallSelectionListener(ICallSelectionListener l) {
        this.mListeners.add(l);
    }

    private void sendCallSelectedEvent(int selectedCall) {
        for (ICallSelectionListener l : this.mListeners) {
            l.callSelected(selectedCall);
        }
    }

    public static interface ICallSelectionListener {
        public void callSelected(int var1);
    }

    private static class PositionHelper {
        private static final int LEFT_MARGIN = 5;
        private static final int TOP_MARGIN = 5;
        private static final int CONTEXT_PADDING = 10;
        private final int mHeaderMargin;
        private final int mContextCount;
        private final int mMaxDurationLength;
        private final long mMaxDuration;
        private final double mScale;
        private int mCallCount;
        private int mNumCallsPerPixel = 1;

        public PositionHelper(int fontHeight, int contextCount, int maxDurationLength, long maxDuration) {
            this.mContextCount = contextCount;
            this.mMaxDurationLength = maxDurationLength;
            this.mMaxDuration = maxDuration;
            this.mScale = (double)maxDurationLength / (double)maxDuration;
            this.mHeaderMargin = this.mContextCount > 1 ? fontHeight * 3 : 0;
        }

        public int getMinimumWidth() {
            return 5 + (this.mMaxDurationLength + 10) * this.mContextCount;
        }

        public Rectangle getDurationBounds(int callIndex, int context, long duration) {
            if (duration <= 0L) {
                duration = 1L;
            } else if (duration > this.mMaxDuration) {
                duration = this.mMaxDuration;
            }
            int x = 5 + (this.mMaxDurationLength + 10) * context;
            int y = callIndex / this.mNumCallsPerPixel + 5 + this.mHeaderMargin;
            int w = (int)((double)duration * this.mScale);
            int h = 1;
            return new Rectangle(x, y, w, h);
        }

        public long getMaxDuration() {
            return this.mMaxDuration;
        }

        public Rectangle getBoundsFramingCalls(int startCallIndex, int endCallIndex) {
            if (startCallIndex >= 0 && endCallIndex >= startCallIndex && endCallIndex <= this.mCallCount) {
                int x = 5;
                int y = startCallIndex / this.mNumCallsPerPixel + 5 + this.mHeaderMargin;
                int w = (this.mMaxDurationLength + 10) * this.mContextCount;
                int h = (endCallIndex - startCallIndex) / this.mNumCallsPerPixel;
                return new Rectangle(x, y, w, h);
            }
            return new Rectangle(0, 0, 0, 0);
        }

        public Point getHeaderLocation(int context) {
            int x = 5 + (this.mMaxDurationLength + 10) * context;
            return new Point(x, 5);
        }

        public void updateCallDensity(int callCount, int displayHeight) {
            this.mCallCount = callCount;
            if (displayHeight <= 0) {
                displayHeight = callCount + 1;
            }
            this.mNumCallsPerPixel = callCount / displayHeight + 1;
        }

        public int getCallUnderScanValue() {
            return this.mNumCallsPerPixel;
        }

        public int getCallAt(int y) {
            if (!this.isWithinBounds(y)) {
                return -1;
            }
            Rectangle displayBounds = this.getBoundsFramingCalls(0, this.mCallCount);
            return (y - displayBounds.y) * this.mNumCallsPerPixel;
        }

        private boolean isWithinBounds(int y) {
            Rectangle displayBounds = this.getBoundsFramingCalls(0, this.mCallCount);
            if (y < displayBounds.y) {
                return false;
            }
            return y <= displayBounds.y + displayBounds.height;
        }
    }
}

