/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajpfuzzer;

import com.doyensec.ajp13.AjpMessage;
import com.doyensec.ajp13.AjpReader;
import com.doyensec.ajpfuzzer.AJPFuzzer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.apache.commons.io.HexDump;

public class Utils {
    protected static byte[] sendAndReceive(AJPFuzzer ajpsocket, byte[] data, String testCase, boolean verbose) throws UnsupportedEncodingException, IOException {
        if (verbose) {
            Utils.dumpRequest(data, testCase);
        }
        byte[] buffReply = new byte[8192];
        DataOutputStream os = new DataOutputStream(ajpsocket.getSocket().getOutputStream());
        DataInputStream is = new DataInputStream(ajpsocket.getSocket().getInputStream());
        try {
            os.write(data);
            os.flush();
            Thread.sleep(1200L);
            while (is.available() > 0) {
                int fullSize = is.read(buffReply);
                if (fullSize > 0) {
                    byte[] fullReply = new byte[fullSize];
                    System.arraycopy(buffReply, 0, fullReply, 0, fullReply.length);
                    ArrayList<Byte> replyBuffer = new ArrayList<Byte>();
                    for (int pc = 0; pc < fullReply.length; ++pc) {
                        if (pc + 1 < fullReply.length && fullReply[pc] == 65 && fullReply[pc + 1] == 66) {
                            if (!replyBuffer.isEmpty() && verbose) {
                                Utils.dumpResponse(Utils.fromArrayListToArray(replyBuffer));
                            }
                            replyBuffer = new ArrayList();
                        }
                        replyBuffer.add(fullReply[pc]);
                    }
                    if (!replyBuffer.isEmpty() && verbose) {
                        Utils.dumpResponse(Utils.fromArrayListToArray(replyBuffer));
                    }
                }
                Thread.sleep(1200L);
            }
        }
        catch (IOException ex) {
            System.out.println("[!] Socket read error\n");
            ajpsocket.disconnect();
            ajpsocket.reconnect();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return buffReply;
    }

    protected static void sendAndReceiveVerbose(AJPFuzzer ajpsocket, byte[] data, String testCase) throws UnsupportedEncodingException, IOException {
        Utils.sendAndReceive(ajpsocket, data, testCase, true);
    }

    private static void dumpRequest(byte[] data, String testCase) throws IOException {
        System.out.println("\n[*] Sending Test Case '" + testCase + "'");
        System.out.println("[*] " + new Timestamp(new Date().getTime()));
        System.out.println("\n");
        HexDump.dump(data, 0L, System.out, 0);
        System.out.println("\n");
    }

    private static void dumpResponse(byte[] data) throws IOException {
        AjpMessage parsed = AjpReader.parseMessage(data);
        System.out.println("[*] Received message type '" + (parsed == null ? "Unknown" : parsed.getName()) + "'");
        System.out.println("[*] Received message description '" + (parsed == null ? "Unknown" : parsed.getDescription()) + "'");
        System.out.println("[*] " + new Timestamp(new Date().getTime()));
        System.out.println("\n");
        HexDump.dump(data, 0L, System.out, 0);
        System.out.println("\n");
    }

    protected static byte[] flipBit(byte[] data) {
        Random rand = new Random();
        int rN = rand.nextInt(data.length);
        int rB = rand.nextInt(8) + 1;
        data[rN] = (byte)(data[rN] ^ 1 << rB);
        return data;
    }

    protected static byte[] sliceAll(byte[] data) {
        int stop;
        Random rand = new Random();
        int start = rand.nextInt(data.length);
        byte[] slice = start <= (stop = rand.nextInt(data.length)) ? Arrays.copyOfRange(data, start, stop) : Arrays.copyOfRange(data, stop, start);
        return slice;
    }

    protected static byte[] sliceFromBegin(byte[] data) {
        Random rand = new Random();
        int stop = rand.nextInt(data.length);
        byte[] slice = Arrays.copyOfRange(data, 0, stop);
        return slice;
    }

    protected static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("win");
    }

    private static byte[] fromArrayListToArray(ArrayList myList) {
        byte[] bytesArray = new byte[myList.size()];
        for (int i = 0; i < myList.size(); ++i) {
            bytesArray[i] = (Byte)myList.get(i);
        }
        return bytesArray;
    }
}

