// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ChangedServiceWorkerObjectsMask::ChangedServiceWorkerObjectsMask()
    : installing(),
      waiting(),
      active() {}

ChangedServiceWorkerObjectsMask::ChangedServiceWorkerObjectsMask(
    bool installing_in,
    bool waiting_in,
    bool active_in)
    : installing(std::move(installing_in)),
      waiting(std::move(waiting_in)),
      active(std::move(active_in)) {}

ChangedServiceWorkerObjectsMask::~ChangedServiceWorkerObjectsMask() = default;
size_t ChangedServiceWorkerObjectsMask::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->installing);
  seed = mojo::internal::Hash(seed, this->waiting);
  seed = mojo::internal::Hash(seed, this->active);
  return seed;
}

void ChangedServiceWorkerObjectsMask::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("installing", this->installing);
  value->SetBoolean("waiting", this->waiting);
  value->SetBoolean("active", this->active);
}

bool ChangedServiceWorkerObjectsMask::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerRegistrationObjectInfo::ServiceWorkerRegistrationObjectInfo()
    : registration_id(::blink::mojom::kInvalidServiceWorkerRegistrationId),
      scope(),
      update_via_cache(),
      host_remote(),
      receiver(),
      installing(),
      waiting(),
      active() {}

ServiceWorkerRegistrationObjectInfo::ServiceWorkerRegistrationObjectInfo(
    int64_t registration_id_in,
    const ::GURL& scope_in,
    ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache_in,
    ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote_in,
    ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr installing_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr waiting_in,
    ::blink::mojom::ServiceWorkerObjectInfoPtr active_in)
    : registration_id(std::move(registration_id_in)),
      scope(std::move(scope_in)),
      update_via_cache(std::move(update_via_cache_in)),
      host_remote(std::move(host_remote_in)),
      receiver(std::move(receiver_in)),
      installing(std::move(installing_in)),
      waiting(std::move(waiting_in)),
      active(std::move(active_in)) {}

ServiceWorkerRegistrationObjectInfo::~ServiceWorkerRegistrationObjectInfo() = default;

void ServiceWorkerRegistrationObjectInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("registration_id", base::NumberToString(this->registration_id));
  value->SetString("scope", base::trace_event::ValueToString(this->scope, "<value of type const ::GURL&>"));
  value->SetString("update_via_cache", base::trace_event::ValueToString(this->update_via_cache));
  value->SetBoolean("host_remote", this->host_remote.is_valid());
  value->SetBoolean("receiver", this->receiver.is_valid());
  if (this->installing.is_null()) {
    value->SetString("installing", "nullptr");
  } else {
    value->BeginDictionary("installing");
    this->installing->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->waiting.is_null()) {
    value->SetString("waiting", "nullptr");
  } else {
    value->BeginDictionary("waiting");
    this->waiting->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->active.is_null()) {
    value->SetString("active", "nullptr");
  } else {
    value->BeginDictionary("active");
    this->active->AsValueInto(value);
    value->EndDictionary();
  }
}

bool ServiceWorkerRegistrationObjectInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerRegistrationObjectHost::Name_[] = "blink.mojom.ServiceWorkerRegistrationObjectHost";

class ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::UpdateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::UpdateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback);
};

class ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::UnregisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::UnregisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback);
};

class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback);
};

class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback);
};

class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback(
      ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback);
};

ServiceWorkerRegistrationObjectHostProxy::ServiceWorkerRegistrationObjectHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerRegistrationObjectHostProxy::Update(
    ::blink::mojom::FetchClientSettingsObjectPtr in_outside_fetch_client_settings_object, UpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::Update", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_outside_fetch_client_settings_object.is_null()) {
        raw_value->SetString("outside_fetch_client_settings_object", "nullptr");
      } else {
        raw_value->BeginDictionary("outside_fetch_client_settings_object");
        in_outside_fetch_client_settings_object->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_Update_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->outside_fetch_client_settings_object)::BaseType::BufferWriter
      outside_fetch_client_settings_object_writer;
  mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
      in_outside_fetch_client_settings_object, buffer, &outside_fetch_client_settings_object_writer, &serialization_context);
  params->outside_fetch_client_settings_object.Set(
      outside_fetch_client_settings_object_writer.is_null() ? nullptr : outside_fetch_client_settings_object_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->outside_fetch_client_settings_object.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null outside_fetch_client_settings_object in ServiceWorkerRegistrationObjectHost.Update request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Update");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerRegistrationObjectHostProxy::Unregister(
    UnregisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_Unregister_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Unregister");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerRegistrationObjectHostProxy::EnableNavigationPreload(
    bool in_enable, EnableNavigationPreloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("enable", in_enable);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->enable = in_enable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("EnableNavigationPreload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerRegistrationObjectHostProxy::GetNavigationPreloadState(
    GetNavigationPreloadStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("GetNavigationPreloadState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceWorkerRegistrationObjectHostProxy::SetNavigationPreloadHeader(
    const std::string& in_value, SetNavigationPreloadHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("value", in_value);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->value)::BaseType::BufferWriter
      value_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_value, buffer, &value_writer, &serialization_context);
  params->value.Set(
      value_writer.is_null() ? nullptr : value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ServiceWorkerRegistrationObjectHost.SetNavigationPreloadHeader request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("SetNavigationPreloadHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::UpdateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerRegistrationObjectHost::UpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder);
};

bool ServiceWorkerRegistrationObjectHost_Update_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::UpdateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_Update_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::UpdateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      if (in_error_msg.has_value()) {
        raw_value->SetString("error_msg", in_error_msg.value());
      } else {
        raw_value->SetString("error_msg", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_Update_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  typename decltype(params->error_msg)::BaseType::BufferWriter
      error_msg_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, buffer, &error_msg_writer, &serialization_context);
  params->error_msg.Set(
      error_msg_writer.is_null() ? nullptr : error_msg_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::UpdateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Update");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::UnregisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerRegistrationObjectHost::UnregisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder);
};

bool ServiceWorkerRegistrationObjectHost_Unregister_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::UnregisterCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_Unregister_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::UnregisterCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      if (in_error_msg.has_value()) {
        raw_value->SetString("error_msg", in_error_msg.value());
      } else {
        raw_value->SetString("error_msg", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_Unregister_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  typename decltype(params->error_msg)::BaseType::BufferWriter
      error_msg_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, buffer, &error_msg_writer, &serialization_context);
  params->error_msg.Set(
      error_msg_writer.is_null() ? nullptr : error_msg_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::UnregisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("Unregister");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder);
};

bool ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      if (in_error_msg.has_value()) {
        raw_value->SetString("error_msg", in_error_msg.value());
      } else {
        raw_value->SetString("error_msg", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  typename decltype(params->error_msg)::BaseType::BufferWriter
      error_msg_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, buffer, &error_msg_writer, &serialization_context);
  params->error_msg.Set(
      error_msg_writer.is_null() ? nullptr : error_msg_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("EnableNavigationPreload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::NavigationPreloadStatePtr in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder);
};

bool ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ::blink::mojom::NavigationPreloadStatePtr p_state{};
  ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg), 
std::move(p_state));
  return true;
}

void ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg, ::blink::mojom::NavigationPreloadStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      if (in_error_msg.has_value()) {
        raw_value->SetString("error_msg", in_error_msg.value());
      } else {
        raw_value->SetString("error_msg", "base::nullopt");
      }
      if (in_state.is_null()) {
        raw_value->SetString("state", "nullptr");
      } else {
        raw_value->BeginDictionary("state");
        in_state->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  typename decltype(params->error_msg)::BaseType::BufferWriter
      error_msg_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, buffer, &error_msg_writer, &serialization_context);
  params->error_msg.Set(
      error_msg_writer.is_null() ? nullptr : error_msg_writer.data());
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::blink::mojom::NavigationPreloadStateDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("GetNavigationPreloadState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder {
 public:
  static ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder> proxy(
        new ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder);
};

bool ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::ServiceWorkerErrorType p_error{};
  base::Optional<std::string> p_error_msg{};
  ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadErrorMsg(&p_error_msg))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerRegistrationObjectHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_error_msg));
  return true;
}

void ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::Run(
    ::blink::mojom::ServiceWorkerErrorType in_error, const base::Optional<std::string>& in_error_msg) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      if (in_error_msg.has_value()) {
        raw_value->SetString("error_msg", in_error_msg.value());
      } else {
        raw_value->SetString("error_msg", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerErrorType>(
      in_error, &params->error);
  typename decltype(params->error_msg)::BaseType::BufferWriter
      error_msg_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_msg, buffer, &error_msg_writer, &serialization_context);
  params->error_msg.Set(
      error_msg_writer.is_null() ? nullptr : error_msg_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObjectHost::Name_);
  message.set_method_name("SetNavigationPreloadHeader");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerRegistrationObjectHostStubDispatch::Accept(
    ServiceWorkerRegistrationObjectHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerRegistrationObjectHost_Update_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObjectHost_Unregister_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerRegistrationObjectHostStubDispatch::AcceptWithResponder(
    ServiceWorkerRegistrationObjectHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerRegistrationObjectHost_Update_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::Update",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::Update");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::FetchClientSettingsObjectPtr p_outside_fetch_client_settings_object{};
      ServiceWorkerRegistrationObjectHost_Update_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOutsideFetchClientSettingsObject(&p_outside_fetch_client_settings_object))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 0, false);
        return false;
      }
      ServiceWorkerRegistrationObjectHost::UpdateCallback callback =
          ServiceWorkerRegistrationObjectHost_Update_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(
std::move(p_outside_fetch_client_settings_object), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerRegistrationObjectHost_Unregister_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::Unregister");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerRegistrationObjectHost_Unregister_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 1, false);
        return false;
      }
      ServiceWorkerRegistrationObjectHost::UnregisterCallback callback =
          ServiceWorkerRegistrationObjectHost_Unregister_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unregister(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::EnableNavigationPreload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_enable{};
      ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 2, false);
        return false;
      }
      ServiceWorkerRegistrationObjectHost::EnableNavigationPreloadCallback callback =
          ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableNavigationPreload(
std::move(p_enable), std::move(callback));
      return true;
    }
    case internal::kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::GetNavigationPreloadState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 3, false);
        return false;
      }
      ServiceWorkerRegistrationObjectHost::GetNavigationPreloadStateCallback callback =
          ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNavigationPreloadState(std::move(callback));
      return true;
    }
    case internal::kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeader");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_value{};
      ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObjectHost::Name_, 4, false);
        return false;
      }
      ServiceWorkerRegistrationObjectHost::SetNavigationPreloadHeaderCallback callback =
          ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNavigationPreloadHeader(
std::move(p_value), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerRegistrationObjectHostValidationInfo[] = {
    {internal::kServiceWorkerRegistrationObjectHost_Update_Name,
     {&internal::ServiceWorkerRegistrationObjectHost_Update_Params_Data::Validate,
      &internal::ServiceWorkerRegistrationObjectHost_Update_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerRegistrationObjectHost_Unregister_Name,
     {&internal::ServiceWorkerRegistrationObjectHost_Unregister_Params_Data::Validate,
      &internal::ServiceWorkerRegistrationObjectHost_Unregister_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Name,
     {&internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_Params_Data::Validate,
      &internal::ServiceWorkerRegistrationObjectHost_EnableNavigationPreload_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Name,
     {&internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_Params_Data::Validate,
      &internal::ServiceWorkerRegistrationObjectHost_GetNavigationPreloadState_ResponseParams_Data::Validate}},
    {internal::kServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Name,
     {&internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_Params_Data::Validate,
      &internal::ServiceWorkerRegistrationObjectHost_SetNavigationPreloadHeader_ResponseParams_Data::Validate}},
};

bool ServiceWorkerRegistrationObjectHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerRegistrationObjectHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerRegistrationObjectHostValidationInfo);
}

bool ServiceWorkerRegistrationObjectHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerRegistrationObjectHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerRegistrationObjectHostValidationInfo);

}
const char ServiceWorkerRegistrationObject::Name_[] = "blink.mojom.ServiceWorkerRegistrationObject";

ServiceWorkerRegistrationObjectProxy::ServiceWorkerRegistrationObjectProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerRegistrationObjectProxy::SetServiceWorkerObjects(
    ChangedServiceWorkerObjectsMaskPtr in_changed_mask, ::blink::mojom::ServiceWorkerObjectInfoPtr in_installing, ::blink::mojom::ServiceWorkerObjectInfoPtr in_waiting, ::blink::mojom::ServiceWorkerObjectInfoPtr in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_changed_mask.is_null()) {
        raw_value->SetString("changed_mask", "nullptr");
      } else {
        raw_value->BeginDictionary("changed_mask");
        in_changed_mask->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_installing.is_null()) {
        raw_value->SetString("installing", "nullptr");
      } else {
        raw_value->BeginDictionary("installing");
        in_installing->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_waiting.is_null()) {
        raw_value->SetString("waiting", "nullptr");
      } else {
        raw_value->BeginDictionary("waiting");
        in_waiting->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_active.is_null()) {
        raw_value->SetString("active", "nullptr");
      } else {
        raw_value->BeginDictionary("active");
        in_active->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->changed_mask)::BaseType::BufferWriter
      changed_mask_writer;
  mojo::internal::Serialize<::blink::mojom::ChangedServiceWorkerObjectsMaskDataView>(
      in_changed_mask, buffer, &changed_mask_writer, &serialization_context);
  params->changed_mask.Set(
      changed_mask_writer.is_null() ? nullptr : changed_mask_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->changed_mask.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null changed_mask in ServiceWorkerRegistrationObject.SetServiceWorkerObjects request");
  typename decltype(params->installing)::BaseType::BufferWriter
      installing_writer;
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_installing, buffer, &installing_writer, &serialization_context);
  params->installing.Set(
      installing_writer.is_null() ? nullptr : installing_writer.data());
  typename decltype(params->waiting)::BaseType::BufferWriter
      waiting_writer;
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_waiting, buffer, &waiting_writer, &serialization_context);
  params->waiting.Set(
      waiting_writer.is_null() ? nullptr : waiting_writer.data());
  typename decltype(params->active)::BaseType::BufferWriter
      active_writer;
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectInfoDataView>(
      in_active, buffer, &active_writer, &serialization_context);
  params->active.Set(
      active_writer.is_null() ? nullptr : active_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("SetServiceWorkerObjects");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerRegistrationObjectProxy::SetUpdateViaCache(
    ::blink::mojom::ServiceWorkerUpdateViaCache in_update_via_cache) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_via_cache", base::trace_event::ValueToString(in_update_via_cache));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObject_SetUpdateViaCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
      in_update_via_cache, &params->update_via_cache);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("SetUpdateViaCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerRegistrationObjectProxy::UpdateFound(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerRegistrationObject::UpdateFound");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerRegistrationObject_UpdateFound_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerRegistrationObject::Name_);
  message.set_method_name("UpdateFound");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerRegistrationObjectStubDispatch::Accept(
    ServiceWorkerRegistrationObject* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObject::SetServiceWorkerObjects");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ChangedServiceWorkerObjectsMaskPtr p_changed_mask{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_installing{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_waiting{};
      ::blink::mojom::ServiceWorkerObjectInfoPtr p_active{};
      ServiceWorkerRegistrationObject_SetServiceWorkerObjects_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChangedMask(&p_changed_mask))
        success = false;
      if (success && !input_data_view.ReadInstalling(&p_installing))
        success = false;
      if (success && !input_data_view.ReadWaiting(&p_waiting))
        success = false;
      if (success && !input_data_view.ReadActive(&p_active))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetServiceWorkerObjects(
std::move(p_changed_mask), 
std::move(p_installing), 
std::move(p_waiting), 
std::move(p_active));
      return true;
    }
    case internal::kServiceWorkerRegistrationObject_SetUpdateViaCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObject::SetUpdateViaCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ServiceWorkerUpdateViaCache p_update_via_cache{};
      ServiceWorkerRegistrationObject_SetUpdateViaCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateViaCache(&p_update_via_cache))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpdateViaCache(
std::move(p_update_via_cache));
      return true;
    }
    case internal::kServiceWorkerRegistrationObject_UpdateFound_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerRegistrationObject::UpdateFound",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerRegistrationObject::UpdateFound");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ServiceWorkerRegistrationObject_UpdateFound_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerRegistrationObject::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFound();
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerRegistrationObjectStubDispatch::AcceptWithResponder(
    ServiceWorkerRegistrationObject* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObject_SetUpdateViaCache_Name: {
      break;
    }
    case internal::kServiceWorkerRegistrationObject_UpdateFound_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerRegistrationObjectValidationInfo[] = {
    {internal::kServiceWorkerRegistrationObject_SetServiceWorkerObjects_Name,
     {&internal::ServiceWorkerRegistrationObject_SetServiceWorkerObjects_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerRegistrationObject_SetUpdateViaCache_Name,
     {&internal::ServiceWorkerRegistrationObject_SetUpdateViaCache_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerRegistrationObject_UpdateFound_Name,
     {&internal::ServiceWorkerRegistrationObject_UpdateFound_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerRegistrationObjectRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerRegistrationObject::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerRegistrationObjectValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ChangedServiceWorkerObjectsMask::DataView, ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr>::Read(
    ::blink::mojom::ChangedServiceWorkerObjectsMask::DataView input,
    ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr* output) {
  bool success = true;
  ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr result(::blink::mojom::ChangedServiceWorkerObjectsMask::New());
  
      if (success)
        result->installing = input.installing();
      if (success)
        result->waiting = input.waiting();
      if (success)
        result->active = input.active();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr>::Read(
    ::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView input,
    ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr result(::blink::mojom::ServiceWorkerRegistrationObjectInfo::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadUpdateViaCache(&result->update_via_cache))
        success = false;
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
      if (success && !input.ReadInstalling(&result->installing))
        success = false;
      if (success && !input.ReadWaiting(&result->waiting))
        success = false;
      if (success && !input.ReadActive(&result->active))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif