// third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ServiceWorkerObjectInfo::ServiceWorkerObjectInfo()
    : version_id(::blink::mojom::blink::kInvalidServiceWorkerVersionId),
      state(::blink::mojom::blink::ServiceWorkerState::kParsed),
      url(),
      host_remote(),
      receiver() {}

ServiceWorkerObjectInfo::ServiceWorkerObjectInfo(
    int64_t version_id_in,
    ::blink::mojom::blink::ServiceWorkerState state_in,
    const ::blink::KURL& url_in,
    ::mojo::PendingAssociatedRemote<ServiceWorkerObjectHost> host_remote_in,
    ::mojo::PendingAssociatedReceiver<ServiceWorkerObject> receiver_in)
    : version_id(std::move(version_id_in)),
      state(std::move(state_in)),
      url(std::move(url_in)),
      host_remote(std::move(host_remote_in)),
      receiver(std::move(receiver_in)) {}

ServiceWorkerObjectInfo::~ServiceWorkerObjectInfo() = default;

void ServiceWorkerObjectInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("version_id", base::NumberToString(this->version_id));
  value->SetString("state", base::trace_event::ValueToString(this->state));
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  value->SetBoolean("host_remote", this->host_remote.is_valid());
  value->SetBoolean("receiver", this->receiver.is_valid());
}

bool ServiceWorkerObjectInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerObjectHost::Name_[] = "blink.mojom.ServiceWorkerObjectHost";

class ServiceWorkerObjectHost_TerminateForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerObjectHost_TerminateForTesting_ForwardToCallback(
      ServiceWorkerObjectHost::TerminateForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerObjectHost::TerminateForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerObjectHost_TerminateForTesting_ForwardToCallback);
};

ServiceWorkerObjectHostProxy::ServiceWorkerObjectHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerObjectHostProxy::PostMessageToServiceWorker(
    ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerObjectHost::PostMessageToServiceWorker", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerObjectHost_PostMessageToServiceWorker_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerObjectHost_PostMessageToServiceWorker_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ServiceWorkerObjectHost.PostMessageToServiceWorker request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerObjectHost::Name_);
  message.set_method_name("PostMessageToServiceWorker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerObjectHostProxy::TerminateForTesting(
    TerminateForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ServiceWorkerObjectHost::TerminateForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerObjectHost_TerminateForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerObjectHost_TerminateForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerObjectHost::Name_);
  message.set_method_name("TerminateForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerObjectHost_TerminateForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder {
 public:
  static ServiceWorkerObjectHost::TerminateForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder> proxy(
        new ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorkerObjectHost::TerminateForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder);
};

bool ServiceWorkerObjectHost_TerminateForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ServiceWorkerObjectHost::TerminateForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ServiceWorkerObjectHost_TerminateForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerObjectHost_TerminateForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerObjectHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::ServiceWorkerObjectHost::TerminateForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerObjectHost_TerminateForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerObjectHost_TerminateForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ServiceWorkerObjectHost::TerminateForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerObjectHost::Name_);
  message.set_method_name("TerminateForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerObjectHostStubDispatch::Accept(
    ServiceWorkerObjectHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerObjectHost_PostMessageToServiceWorker_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerObjectHost::PostMessageToServiceWorker",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerObjectHost::PostMessageToServiceWorker");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerObjectHost_PostMessageToServiceWorker_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerObjectHost_PostMessageToServiceWorker_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_message{};
      ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerObjectHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToServiceWorker(
std::move(p_message));
      return true;
    }
    case internal::kServiceWorkerObjectHost_TerminateForTesting_Name: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerObjectHostStubDispatch::AcceptWithResponder(
    ServiceWorkerObjectHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerObjectHost_PostMessageToServiceWorker_Name: {
      break;
    }
    case internal::kServiceWorkerObjectHost_TerminateForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerObjectHost::TerminateForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerObjectHost::TerminateForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ServiceWorkerObjectHost_TerminateForTesting_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerObjectHost_TerminateForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ServiceWorkerObjectHost_TerminateForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerObjectHost::Name_, 1, false);
        return false;
      }
      ServiceWorkerObjectHost::TerminateForTestingCallback callback =
          ServiceWorkerObjectHost_TerminateForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TerminateForTesting(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerObjectHostValidationInfo[] = {
    {internal::kServiceWorkerObjectHost_PostMessageToServiceWorker_Name,
     {&internal::ServiceWorkerObjectHost_PostMessageToServiceWorker_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerObjectHost_TerminateForTesting_Name,
     {&internal::ServiceWorkerObjectHost_TerminateForTesting_Params_Data::Validate,
      &internal::ServiceWorkerObjectHost_TerminateForTesting_ResponseParams_Data::Validate}},
};

bool ServiceWorkerObjectHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ServiceWorkerObjectHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerObjectHostValidationInfo);
}

bool ServiceWorkerObjectHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ServiceWorkerObjectHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerObjectHostValidationInfo);

}
const char ServiceWorkerObject::Name_[] = "blink.mojom.ServiceWorkerObject";

ServiceWorkerObjectProxy::ServiceWorkerObjectProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerObjectProxy::StateChanged(
    ::blink::mojom::blink::ServiceWorkerState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerObject::StateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerObject_StateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerObject_StateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerState>(
      in_state, &params->state);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerObject::Name_);
  message.set_method_name("StateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerObjectStubDispatch::Accept(
    ServiceWorkerObject* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerObject_StateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerObject::StateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerObject::StateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerObject_StateChanged_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerObject_StateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ServiceWorkerState p_state{};
      ServiceWorkerObject_StateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerObject::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StateChanged(
std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerObjectStubDispatch::AcceptWithResponder(
    ServiceWorkerObject* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerObject_StateChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerObjectValidationInfo[] = {
    {internal::kServiceWorkerObject_StateChanged_Name,
     {&internal::ServiceWorkerObject_StateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerObjectRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ServiceWorkerObject::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerObjectValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerObjectInfo::DataView, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerObjectInfo::DataView input,
    ::blink::mojom::blink::ServiceWorkerObjectInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr result(::blink::mojom::blink::ServiceWorkerObjectInfo::New());
  
      if (success)
        result->version_id = input.version_id();
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif