// third_party/blink/public/mojom/font_access/font_access.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, FontEnumerationStatus value) {
  switch(value) {
    case FontEnumerationStatus::kOk:
      return os << "FontEnumerationStatus::kOk";
    case FontEnumerationStatus::kUnimplemented:
      return os << "FontEnumerationStatus::kUnimplemented";
    case FontEnumerationStatus::kUnexpectedError:
      return os << "FontEnumerationStatus::kUnexpectedError";
    case FontEnumerationStatus::kNeedsUserActivation:
      return os << "FontEnumerationStatus::kNeedsUserActivation";
    case FontEnumerationStatus::kNotVisible:
      return os << "FontEnumerationStatus::kNotVisible";
    case FontEnumerationStatus::kPermissionDenied:
      return os << "FontEnumerationStatus::kPermissionDenied";
    default:
      return os << "Unknown FontEnumerationStatus value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool FontAccessManager_EnumerateLocalFonts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_EnumerateLocalFonts_Params_Data* object = static_cast<const FontAccessManager_EnumerateLocalFonts_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

FontAccessManager_EnumerateLocalFonts_Params_Data::FontAccessManager_EnumerateLocalFonts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* object = static_cast<const FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::blink::mojom::internal::FontEnumerationStatus_Data
        ::Validate(object->enumeration_status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->enumeration_table, validation_context))
    return false;

  return true;
}

FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink