// services/network/public/mojom/url_loader.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/url_loader.mojom-params-data.h"
#include "services/network/public/mojom/url_loader.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
TrustedUrlRequestParams::TrustedUrlRequestParams()
    : isolation_info(),
      disable_secure_dns(),
      has_user_activation(),
      cookie_observer(),
      client_security_state() {}

TrustedUrlRequestParams::TrustedUrlRequestParams(
    const ::net::IsolationInfo& isolation_info_in,
    bool disable_secure_dns_in,
    bool has_user_activation_in,
    ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer_in,
    ::network::mojom::blink::ClientSecurityStatePtr client_security_state_in)
    : isolation_info(std::move(isolation_info_in)),
      disable_secure_dns(std::move(disable_secure_dns_in)),
      has_user_activation(std::move(has_user_activation_in)),
      cookie_observer(std::move(cookie_observer_in)),
      client_security_state(std::move(client_security_state_in)) {}

TrustedUrlRequestParams::~TrustedUrlRequestParams() = default;

void TrustedUrlRequestParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("isolation_info", base::trace_event::ValueToString(this->isolation_info, "<value of type const ::net::IsolationInfo&>"));
  value->SetBoolean("disable_secure_dns", this->disable_secure_dns);
  value->SetBoolean("has_user_activation", this->has_user_activation);
  value->SetBoolean("cookie_observer", this->cookie_observer.is_valid());
  if (this->client_security_state.is_null()) {
    value->SetString("client_security_state", "nullptr");
  } else {
    value->BeginDictionary("client_security_state");
    this->client_security_state->AsValueInto(value);
    value->EndDictionary();
  }
}

bool TrustedUrlRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequest::URLRequest()
    : method(),
      url(),
      site_for_cookies(),
      force_ignore_site_for_cookies(),
      update_first_party_url_on_redirect(),
      request_initiator(),
      navigation_redirect_chain(),
      isolated_world_origin(),
      referrer(),
      referrer_policy(),
      headers(),
      cors_exempt_headers(),
      load_flags(),
      resource_type(),
      priority(),
      should_reset_appcache(),
      is_external_request(),
      cors_preflight_policy(),
      originated_from_service_worker(),
      skip_service_worker(),
      corb_detachable(false),
      corb_excluded(false),
      mode(),
      credentials_mode(),
      redirect_mode(),
      fetch_integrity(),
      destination(),
      request_body(),
      keepalive(),
      has_user_gesture(),
      enable_load_timing(),
      enable_upload_progress(),
      do_not_prompt_for_login(),
      render_frame_id(),
      is_main_frame(),
      transition_type(),
      report_raw_headers(),
      previews_state(),
      upgrade_if_insecure(),
      is_revalidating(),
      throttling_profile_id(),
      fetch_window_id(),
      devtools_request_id(),
      is_signed_exchange_prefetch_cache_enabled(),
      obey_origin_policy(),
      original_destination(),
      trusted_params(),
      recursive_prefetch_token(),
      trust_token_params() {}

URLRequest::URLRequest(
    const WTF::String& method_in,
    const ::blink::KURL& url_in,
    const ::net::SiteForCookies& site_for_cookies_in,
    bool force_ignore_site_for_cookies_in,
    bool update_first_party_url_on_redirect_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& request_initiator_in,
    WTF::Vector<::blink::KURL> navigation_redirect_chain_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& isolated_world_origin_in,
    const ::blink::KURL& referrer_in,
    ::net::ReferrerPolicy referrer_policy_in,
    const ::net::HttpRequestHeaders& headers_in,
    const ::net::HttpRequestHeaders& cors_exempt_headers_in,
    int32_t load_flags_in,
    int32_t resource_type_in,
    ::net::RequestPriority priority_in,
    bool should_reset_appcache_in,
    bool is_external_request_in,
    ::network::mojom::blink::CorsPreflightPolicy cors_preflight_policy_in,
    bool originated_from_service_worker_in,
    bool skip_service_worker_in,
    bool corb_detachable_in,
    bool corb_excluded_in,
    ::network::mojom::blink::RequestMode mode_in,
    ::network::mojom::blink::CredentialsMode credentials_mode_in,
    ::network::mojom::blink::RedirectMode redirect_mode_in,
    const WTF::String& fetch_integrity_in,
    ::network::mojom::blink::RequestDestination destination_in,
    ::scoped_refptr<::network::ResourceRequestBody> request_body_in,
    bool keepalive_in,
    bool has_user_gesture_in,
    bool enable_load_timing_in,
    bool enable_upload_progress_in,
    bool do_not_prompt_for_login_in,
    int32_t render_frame_id_in,
    bool is_main_frame_in,
    int32_t transition_type_in,
    bool report_raw_headers_in,
    int32_t previews_state_in,
    bool upgrade_if_insecure_in,
    bool is_revalidating_in,
    const base::Optional<::base::UnguessableToken>& throttling_profile_id_in,
    const base::Optional<::base::UnguessableToken>& fetch_window_id_in,
    const WTF::String& devtools_request_id_in,
    bool is_signed_exchange_prefetch_cache_enabled_in,
    bool obey_origin_policy_in,
    ::network::mojom::blink::RequestDestination original_destination_in,
    const base::Optional<::network::ResourceRequest::TrustedParams>& trusted_params_in,
    const base::Optional<::base::UnguessableToken>& recursive_prefetch_token_in,
    ::network::mojom::blink::TrustTokenParamsPtr trust_token_params_in)
    : method(std::move(method_in)),
      url(std::move(url_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      force_ignore_site_for_cookies(std::move(force_ignore_site_for_cookies_in)),
      update_first_party_url_on_redirect(std::move(update_first_party_url_on_redirect_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      isolated_world_origin(std::move(isolated_world_origin_in)),
      referrer(std::move(referrer_in)),
      referrer_policy(std::move(referrer_policy_in)),
      headers(std::move(headers_in)),
      cors_exempt_headers(std::move(cors_exempt_headers_in)),
      load_flags(std::move(load_flags_in)),
      resource_type(std::move(resource_type_in)),
      priority(std::move(priority_in)),
      should_reset_appcache(std::move(should_reset_appcache_in)),
      is_external_request(std::move(is_external_request_in)),
      cors_preflight_policy(std::move(cors_preflight_policy_in)),
      originated_from_service_worker(std::move(originated_from_service_worker_in)),
      skip_service_worker(std::move(skip_service_worker_in)),
      corb_detachable(std::move(corb_detachable_in)),
      corb_excluded(std::move(corb_excluded_in)),
      mode(std::move(mode_in)),
      credentials_mode(std::move(credentials_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      fetch_integrity(std::move(fetch_integrity_in)),
      destination(std::move(destination_in)),
      request_body(std::move(request_body_in)),
      keepalive(std::move(keepalive_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      enable_load_timing(std::move(enable_load_timing_in)),
      enable_upload_progress(std::move(enable_upload_progress_in)),
      do_not_prompt_for_login(std::move(do_not_prompt_for_login_in)),
      render_frame_id(std::move(render_frame_id_in)),
      is_main_frame(std::move(is_main_frame_in)),
      transition_type(std::move(transition_type_in)),
      report_raw_headers(std::move(report_raw_headers_in)),
      previews_state(std::move(previews_state_in)),
      upgrade_if_insecure(std::move(upgrade_if_insecure_in)),
      is_revalidating(std::move(is_revalidating_in)),
      throttling_profile_id(std::move(throttling_profile_id_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      devtools_request_id(std::move(devtools_request_id_in)),
      is_signed_exchange_prefetch_cache_enabled(std::move(is_signed_exchange_prefetch_cache_enabled_in)),
      obey_origin_policy(std::move(obey_origin_policy_in)),
      original_destination(std::move(original_destination_in)),
      trusted_params(std::move(trusted_params_in)),
      recursive_prefetch_token(std::move(recursive_prefetch_token_in)),
      trust_token_params(std::move(trust_token_params_in)) {}

URLRequest::~URLRequest() = default;

void URLRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("method", this->method.Utf8());
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  value->SetString("site_for_cookies", base::trace_event::ValueToString(this->site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
  value->SetBoolean("force_ignore_site_for_cookies", this->force_ignore_site_for_cookies);
  value->SetBoolean("update_first_party_url_on_redirect", this->update_first_party_url_on_redirect);
  value->SetString("request_initiator", base::trace_event::ValueToString(this->request_initiator, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
  value->BeginArray("navigation_redirect_chain");
  for (const auto& item0 : this->navigation_redirect_chain) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::KURL&>"));
  }
  value->EndArray();
  value->SetString("isolated_world_origin", base::trace_event::ValueToString(this->isolated_world_origin, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
  value->SetString("referrer", base::trace_event::ValueToString(this->referrer, "<value of type const ::blink::KURL&>"));
  value->SetInteger("referrer_policy", static_cast<int>(this->referrer_policy));
  value->SetString("headers", base::trace_event::ValueToString(this->headers, "<value of type const ::net::HttpRequestHeaders&>"));
  value->SetString("cors_exempt_headers", base::trace_event::ValueToString(this->cors_exempt_headers, "<value of type const ::net::HttpRequestHeaders&>"));
  value->SetInteger("load_flags", this->load_flags);
  value->SetInteger("resource_type", this->resource_type);
  value->SetInteger("priority", static_cast<int>(this->priority));
  value->SetBoolean("should_reset_appcache", this->should_reset_appcache);
  value->SetBoolean("is_external_request", this->is_external_request);
  value->SetString("cors_preflight_policy", base::trace_event::ValueToString(this->cors_preflight_policy));
  value->SetBoolean("originated_from_service_worker", this->originated_from_service_worker);
  value->SetBoolean("skip_service_worker", this->skip_service_worker);
  value->SetBoolean("corb_detachable", this->corb_detachable);
  value->SetBoolean("corb_excluded", this->corb_excluded);
  value->SetString("mode", base::trace_event::ValueToString(this->mode));
  value->SetString("credentials_mode", base::trace_event::ValueToString(this->credentials_mode));
  value->SetString("redirect_mode", base::trace_event::ValueToString(this->redirect_mode));
  value->SetString("fetch_integrity", this->fetch_integrity.Utf8());
  value->SetString("destination", base::trace_event::ValueToString(this->destination));
  value->SetString("request_body", base::trace_event::ValueToString(this->request_body, "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"));
  value->SetBoolean("keepalive", this->keepalive);
  value->SetBoolean("has_user_gesture", this->has_user_gesture);
  value->SetBoolean("enable_load_timing", this->enable_load_timing);
  value->SetBoolean("enable_upload_progress", this->enable_upload_progress);
  value->SetBoolean("do_not_prompt_for_login", this->do_not_prompt_for_login);
  value->SetInteger("render_frame_id", this->render_frame_id);
  value->SetBoolean("is_main_frame", this->is_main_frame);
  value->SetInteger("transition_type", this->transition_type);
  value->SetBoolean("report_raw_headers", this->report_raw_headers);
  value->SetInteger("previews_state", this->previews_state);
  value->SetBoolean("upgrade_if_insecure", this->upgrade_if_insecure);
  value->SetBoolean("is_revalidating", this->is_revalidating);
  value->SetString("throttling_profile_id", base::trace_event::ValueToString(this->throttling_profile_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetString("fetch_window_id", base::trace_event::ValueToString(this->fetch_window_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetString("devtools_request_id", this->devtools_request_id.Utf8());
  value->SetBoolean("is_signed_exchange_prefetch_cache_enabled", this->is_signed_exchange_prefetch_cache_enabled);
  value->SetBoolean("obey_origin_policy", this->obey_origin_policy);
  value->SetString("original_destination", base::trace_event::ValueToString(this->original_destination));
  value->SetString("trusted_params", base::trace_event::ValueToString(this->trusted_params, "<value of type const base::Optional<::network::ResourceRequest::TrustedParams>&>"));
  value->SetString("recursive_prefetch_token", base::trace_event::ValueToString(this->recursive_prefetch_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  if (this->trust_token_params.is_null()) {
    value->SetString("trust_token_params", "nullptr");
  } else {
    value->BeginDictionary("trust_token_params");
    this->trust_token_params->AsValueInto(value);
    value->EndDictionary();
  }
}

bool URLRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLRequestBody::URLRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info(),
      allow_http1_for_streaming_upload() {}

URLRequestBody::URLRequestBody(
    WTF::Vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in,
    bool allow_http1_for_streaming_upload_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)),
      allow_http1_for_streaming_upload(std::move(allow_http1_for_streaming_upload_in)) {}

URLRequestBody::~URLRequestBody() = default;

void URLRequestBody::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("elements");
  for (const auto& item0 : this->elements) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::network::DataElement>"));
  }
  value->EndArray();
  value->SetString("identifier", base::NumberToString(this->identifier));
  value->SetBoolean("contains_sensitive_info", this->contains_sensitive_info);
  value->SetBoolean("allow_http1_for_streaming_upload", this->allow_http1_for_streaming_upload);
}

bool URLRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElement::DataElement()
    : type(),
      buf(),
      path(),
      blob_uuid(),
      data_pipe_getter(),
      chunked_data_pipe_getter(),
      offset(),
      length(),
      expected_modification_time() {}

DataElement::DataElement(
    DataElementType type_in,
    WTF::Vector<uint8_t> buf_in,
    const ::base::FilePath& path_in,
    const WTF::String& blob_uuid_in,
    ::mojo::PendingRemote<::network::mojom::blink::DataPipeGetter> data_pipe_getter_in,
    ::mojo::PendingRemote<::network::mojom::blink::ChunkedDataPipeGetter> chunked_data_pipe_getter_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time expected_modification_time_in)
    : type(std::move(type_in)),
      buf(std::move(buf_in)),
      path(std::move(path_in)),
      blob_uuid(std::move(blob_uuid_in)),
      data_pipe_getter(std::move(data_pipe_getter_in)),
      chunked_data_pipe_getter(std::move(chunked_data_pipe_getter_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      expected_modification_time(std::move(expected_modification_time_in)) {}

DataElement::~DataElement() = default;

void DataElement::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->BeginArray("buf");
  for (const auto& item0 : this->buf) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("path", base::trace_event::ValueToString(this->path, "<value of type const ::base::FilePath&>"));
  value->SetString("blob_uuid", this->blob_uuid.Utf8());
  value->SetBoolean("data_pipe_getter", this->data_pipe_getter.is_valid());
  value->SetBoolean("chunked_data_pipe_getter", this->chunked_data_pipe_getter.is_valid());
  value->SetString("offset", base::NumberToString(this->offset));
  value->SetString("length", base::NumberToString(this->length));
  value->SetString("expected_modification_time", base::trace_event::ValueToString(this->expected_modification_time, "<value of type ::base::Time>"));
}

bool DataElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderClientEndpoints::URLLoaderClientEndpoints()
    : url_loader(),
      url_loader_client() {}

URLLoaderClientEndpoints::URLLoaderClientEndpoints(
    ::mojo::PendingRemote<URLLoader> url_loader_in,
    ::mojo::PendingReceiver<URLLoaderClient> url_loader_client_in)
    : url_loader(std::move(url_loader_in)),
      url_loader_client(std::move(url_loader_client_in)) {}

URLLoaderClientEndpoints::~URLLoaderClientEndpoints() = default;

void URLLoaderClientEndpoints::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("url_loader", this->url_loader.is_valid());
  value->SetBoolean("url_loader_client", this->url_loader_client.is_valid());
}

bool URLLoaderClientEndpoints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char URLLoader::Name_[] = "network.mojom.URLLoader";
constexpr uint32_t URLLoader::kClientDisconnectReason;

URLLoaderProxy::URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderProxy::FollowRedirect(
    const WTF::Vector<WTF::String>& in_removed_headers, const ::net::HttpRequestHeaders& in_modified_headers, const ::net::HttpRequestHeaders& in_modified_cors_exempt_headers, const base::Optional<::blink::KURL>& in_new_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::FollowRedirect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("removed_headers");
      for (const auto& item0 : in_removed_headers) {
        raw_value->AppendString(item0.Utf8());
      }
      raw_value->EndArray();
      raw_value->SetString("modified_headers", base::trace_event::ValueToString(in_modified_headers, "<value of type const ::net::HttpRequestHeaders&>"));
      raw_value->SetString("modified_cors_exempt_headers", base::trace_event::ValueToString(in_modified_cors_exempt_headers, "<value of type const ::net::HttpRequestHeaders&>"));
      raw_value->SetString("new_url", base::trace_event::ValueToString(in_new_url, "<value of type const base::Optional<::blink::KURL>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_FollowRedirect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoader_FollowRedirect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->removed_headers)::BaseType::BufferWriter
      removed_headers_writer;
  const mojo::internal::ContainerValidateParams removed_headers_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_removed_headers, buffer, &removed_headers_writer, &removed_headers_validate_params,
      &serialization_context);
  params->removed_headers.Set(
      removed_headers_writer.is_null() ? nullptr : removed_headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->removed_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_headers in URLLoader.FollowRedirect request");
  typename decltype(params->modified_headers)::BaseType::BufferWriter
      modified_headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_headers, buffer, &modified_headers_writer, &serialization_context);
  params->modified_headers.Set(
      modified_headers_writer.is_null() ? nullptr : modified_headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_headers in URLLoader.FollowRedirect request");
  typename decltype(params->modified_cors_exempt_headers)::BaseType::BufferWriter
      modified_cors_exempt_headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_cors_exempt_headers, buffer, &modified_cors_exempt_headers_writer, &serialization_context);
  params->modified_cors_exempt_headers.Set(
      modified_cors_exempt_headers_writer.is_null() ? nullptr : modified_cors_exempt_headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_cors_exempt_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_cors_exempt_headers in URLLoader.FollowRedirect request");
  typename decltype(params->new_url)::BaseType::BufferWriter
      new_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_new_url, buffer, &new_url_writer, &serialization_context);
  params->new_url.Set(
      new_url_writer.is_null() ? nullptr : new_url_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("FollowRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::SetPriority(
    ::net::RequestPriority in_priority, int32_t in_intra_priority_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::SetPriority", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("priority", static_cast<int>(in_priority));
      raw_value->SetInteger("intra_priority_value", in_intra_priority_value);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_SetPriority_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoader_SetPriority_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::RequestPriority>(
      in_priority, &params->priority);
  params->intra_priority_value = in_intra_priority_value;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("SetPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::PauseReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::PauseReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_PauseReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoader_PauseReadingBodyFromNet_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("PauseReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::ResumeReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::ResumeReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoader_ResumeReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoader_ResumeReadingBodyFromNet_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("ResumeReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool URLLoaderStubDispatch::Accept(
    URLLoader* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::FollowRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::FollowRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_FollowRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoader_FollowRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_removed_headers{};
      ::net::HttpRequestHeaders p_modified_headers{};
      ::net::HttpRequestHeaders p_modified_cors_exempt_headers{};
      base::Optional<::blink::KURL> p_new_url{};
      URLLoader_FollowRedirect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRemovedHeaders(&p_removed_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedHeaders(&p_modified_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedCorsExemptHeaders(&p_modified_cors_exempt_headers))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FollowRedirect(
std::move(p_removed_headers), 
std::move(p_modified_headers), 
std::move(p_modified_cors_exempt_headers), 
std::move(p_new_url));
      return true;
    }
    case internal::kURLLoader_SetPriority_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::SetPriority",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::SetPriority");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_SetPriority_Params_Data* params =
          reinterpret_cast<internal::URLLoader_SetPriority_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RequestPriority p_priority{};
      int32_t p_intra_priority_value{};
      URLLoader_SetPriority_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success)
        p_intra_priority_value = input_data_view.intra_priority_value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriority(
std::move(p_priority), 
std::move(p_intra_priority_value));
      return true;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_PauseReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_PauseReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_PauseReadingBodyFromNet_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseReadingBodyFromNet();
      return true;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_ResumeReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_ResumeReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_ResumeReadingBodyFromNet_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeReadingBodyFromNet();
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderStubDispatch::AcceptWithResponder(
    URLLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
      break;
    }
    case internal::kURLLoader_SetPriority_Name: {
      break;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
      break;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderValidationInfo[] = {
    {internal::kURLLoader_FollowRedirect_Name,
     {&internal::URLLoader_FollowRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_SetPriority_Name,
     {&internal::URLLoader_SetPriority_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_PauseReadingBodyFromNet_Name,
     {&internal::URLLoader_PauseReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_ResumeReadingBodyFromNet_Name,
     {&internal::URLLoader_ResumeReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoader::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderValidationInfo);
}

const char URLLoaderClient::Name_[] = "network.mojom.URLLoaderClient";

class URLLoaderClient_OnUploadProgress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderClient_OnUploadProgress_ForwardToCallback(
      URLLoaderClient::OnUploadProgressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderClient::OnUploadProgressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ForwardToCallback);
};

URLLoaderClientProxy::URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderClientProxy::OnReceiveResponse(
    ::network::mojom::blink::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveResponse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_head.is_null()) {
        raw_value->SetString("head", "nullptr");
      } else {
        raw_value->BeginDictionary("head");
        in_head->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveResponse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnReceiveResponse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->head)::BaseType::BufferWriter
      head_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, buffer, &head_writer, &serialization_context);
  params->head.Set(
      head_writer.is_null() ? nullptr : head_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveResponse request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnReceiveRedirect(
    URLRequestRedirectInfoPtr in_redirect_info, ::network::mojom::blink::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveRedirect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("redirect_info", base::trace_event::ValueToString(in_redirect_info, "<value of type URLRequestRedirectInfoPtr>"));
      if (in_head.is_null()) {
        raw_value->SetString("head", "nullptr");
      } else {
        raw_value->BeginDictionary("head");
        in_head->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveRedirect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnReceiveRedirect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->redirect_info)::BaseType::BufferWriter
      redirect_info_writer;
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
      in_redirect_info, buffer, &redirect_info_writer, &serialization_context);
  params->redirect_info.Set(
      redirect_info_writer.is_null() ? nullptr : redirect_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info in URLLoaderClient.OnReceiveRedirect request");
  typename decltype(params->head)::BaseType::BufferWriter
      head_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, buffer, &head_writer, &serialization_context);
  params->head.Set(
      head_writer.is_null() ? nullptr : head_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveRedirect request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnUploadProgress(
    int64_t in_current_position, int64_t in_total_size, OnUploadProgressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnUploadProgress", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("current_position", base::NumberToString(in_current_position));
      raw_value->SetString("total_size", base::NumberToString(in_total_size));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnUploadProgress_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->current_position = in_current_position;
  params->total_size = in_total_size;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderClient_OnUploadProgress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderClientProxy::OnReceiveCachedMetadata(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveCachedMetadata", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::mojo_base::BigBuffer>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveCachedMetadata_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BufferWriter data_writer;
  data_writer.AllocateInline(buffer, &params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, buffer, &data_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in URLLoaderClient.OnReceiveCachedMetadata request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnTransferSizeUpdated(
    int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnTransferSizeUpdated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("transfer_size_diff", in_transfer_size_diff);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnTransferSizeUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->transfer_size_diff = in_transfer_size_diff;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnStartLoadingResponseBody(
    ::mojo::ScopedDataPipeConsumerHandle in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnStartLoadingResponseBody", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("body", in_body.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnStartLoadingResponseBody_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_body, &params->body, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->body),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid body in URLLoaderClient.OnStartLoadingResponseBody request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnStartLoadingResponseBody");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnComplete(
    URLLoaderCompletionStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnComplete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status, "<value of type URLLoaderCompletionStatusPtr>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnComplete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->status)::BaseType::BufferWriter
      status_writer;
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, buffer, &status_writer, &serialization_context);
  params->status.Set(
      status_writer.is_null() ? nullptr : status_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in URLLoaderClient.OnComplete request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class URLLoaderClient_OnUploadProgress_ProxyToResponder {
 public:
  static URLLoaderClient::OnUploadProgressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderClient_OnUploadProgress_ProxyToResponder> proxy(
        new URLLoaderClient_OnUploadProgress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderClient_OnUploadProgress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderClient_OnUploadProgress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderClient_OnUploadProgress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderClient::OnUploadProgressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ProxyToResponder);
};

bool URLLoaderClient_OnUploadProgress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderClient::OnUploadProgressCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  URLLoaderClient_OnUploadProgress_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void URLLoaderClient_OnUploadProgress_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderClientStubDispatch::Accept(
    URLLoaderClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveResponse_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveResponse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveResponse(
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLRequestRedirectInfoPtr p_redirect_info{};
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveRedirect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveRedirect(
std::move(p_redirect_info), 
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      URLLoaderClient_OnReceiveCachedMetadata_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveCachedMetadata(
std::move(p_data));
      return true;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_transfer_size_diff{};
      URLLoaderClient_OnTransferSizeUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTransferSizeUpdated(
std::move(p_transfer_size_diff));
      return true;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_body{};
      URLLoaderClient_OnStartLoadingResponseBody_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_body = input_data_view.TakeBody();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartLoadingResponseBody(
std::move(p_body));
      return true;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoaderCompletionStatusPtr p_status{};
      URLLoaderClient_OnComplete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderClientStubDispatch::AcceptWithResponder(
    URLLoaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnUploadProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnUploadProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderClient_OnUploadProgress_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderClient_OnUploadProgress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_current_position{};
      int64_t p_total_size{};
      URLLoaderClient_OnUploadProgress_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_current_position = input_data_view.current_position();
      if (success)
        p_total_size = input_data_view.total_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 2, false);
        return false;
      }
      URLLoaderClient::OnUploadProgressCallback callback =
          URLLoaderClient_OnUploadProgress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUploadProgress(
std::move(p_current_position), 
std::move(p_total_size), std::move(callback));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderClientValidationInfo[] = {
    {internal::kURLLoaderClient_OnReceiveResponse_Name,
     {&internal::URLLoaderClient_OnReceiveResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnReceiveRedirect_Name,
     {&internal::URLLoaderClient_OnReceiveRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnUploadProgress_Name,
     {&internal::URLLoaderClient_OnUploadProgress_Params_Data::Validate,
      &internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data::Validate}},
    {internal::kURLLoaderClient_OnReceiveCachedMetadata_Name,
     {&internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnTransferSizeUpdated_Name,
     {&internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnStartLoadingResponseBody_Name,
     {&internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnComplete_Name,
     {&internal::URLLoaderClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderClientValidationInfo);
}

bool URLLoaderClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::URLLoaderClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kURLLoaderClientValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::TrustedUrlRequestParams::DataView, ::network::mojom::blink::TrustedUrlRequestParamsPtr>::Read(
    ::network::mojom::blink::TrustedUrlRequestParams::DataView input,
    ::network::mojom::blink::TrustedUrlRequestParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::TrustedUrlRequestParamsPtr result(::network::mojom::blink::TrustedUrlRequestParams::New());
  
      if (success && !input.ReadIsolationInfo(&result->isolation_info))
        success = false;
      if (success)
        result->disable_secure_dns = input.disable_secure_dns();
      if (success)
        result->has_user_activation = input.has_user_activation();
      if (success) {
        result->cookie_observer =
            input.TakeCookieObserver<decltype(result->cookie_observer)>();
      }
      if (success && !input.ReadClientSecurityState(&result->client_security_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequest::DataView, ::network::mojom::blink::URLRequestPtr>::Read(
    ::network::mojom::blink::URLRequest::DataView input,
    ::network::mojom::blink::URLRequestPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestPtr result(::network::mojom::blink::URLRequest::New());
  
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success)
        result->force_ignore_site_for_cookies = input.force_ignore_site_for_cookies();
      if (success)
        result->update_first_party_url_on_redirect = input.update_first_party_url_on_redirect();
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadIsolatedWorldOrigin(&result->isolated_world_origin))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadCorsExemptHeaders(&result->cors_exempt_headers))
        success = false;
      if (success)
        result->load_flags = input.load_flags();
      if (success)
        result->resource_type = input.resource_type();
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success)
        result->should_reset_appcache = input.should_reset_appcache();
      if (success)
        result->is_external_request = input.is_external_request();
      if (success && !input.ReadCorsPreflightPolicy(&result->cors_preflight_policy))
        success = false;
      if (success)
        result->originated_from_service_worker = input.originated_from_service_worker();
      if (success)
        result->skip_service_worker = input.skip_service_worker();
      if (success)
        result->corb_detachable = input.corb_detachable();
      if (success)
        result->corb_excluded = input.corb_excluded();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadFetchIntegrity(&result->fetch_integrity))
        success = false;
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadRequestBody(&result->request_body))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->enable_load_timing = input.enable_load_timing();
      if (success)
        result->enable_upload_progress = input.enable_upload_progress();
      if (success)
        result->do_not_prompt_for_login = input.do_not_prompt_for_login();
      if (success)
        result->render_frame_id = input.render_frame_id();
      if (success)
        result->is_main_frame = input.is_main_frame();
      if (success)
        result->transition_type = input.transition_type();
      if (success)
        result->report_raw_headers = input.report_raw_headers();
      if (success)
        result->previews_state = input.previews_state();
      if (success)
        result->upgrade_if_insecure = input.upgrade_if_insecure();
      if (success)
        result->is_revalidating = input.is_revalidating();
      if (success && !input.ReadThrottlingProfileId(&result->throttling_profile_id))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success && !input.ReadDevtoolsRequestId(&result->devtools_request_id))
        success = false;
      if (success)
        result->is_signed_exchange_prefetch_cache_enabled = input.is_signed_exchange_prefetch_cache_enabled();
      if (success)
        result->obey_origin_policy = input.obey_origin_policy();
      if (success && !input.ReadOriginalDestination(&result->original_destination))
        success = false;
      if (success && !input.ReadTrustedParams(&result->trusted_params))
        success = false;
      if (success && !input.ReadRecursivePrefetchToken(&result->recursive_prefetch_token))
        success = false;
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLRequestBody::DataView, ::network::mojom::blink::URLRequestBodyPtr>::Read(
    ::network::mojom::blink::URLRequestBody::DataView input,
    ::network::mojom::blink::URLRequestBodyPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLRequestBodyPtr result(::network::mojom::blink::URLRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
      if (success)
        result->allow_http1_for_streaming_upload = input.allow_http1_for_streaming_upload();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DataElement::DataView, ::network::mojom::blink::DataElementPtr>::Read(
    ::network::mojom::blink::DataElement::DataView input,
    ::network::mojom::blink::DataElementPtr* output) {
  bool success = true;
  ::network::mojom::blink::DataElementPtr result(::network::mojom::blink::DataElement::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadBuf(&result->buf))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadBlobUuid(&result->blob_uuid))
        success = false;
      if (success) {
        result->data_pipe_getter =
            input.TakeDataPipeGetter<decltype(result->data_pipe_getter)>();
      }
      if (success) {
        result->chunked_data_pipe_getter =
            input.TakeChunkedDataPipeGetter<decltype(result->chunked_data_pipe_getter)>();
      }
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadExpectedModificationTime(&result->expected_modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::URLLoaderClientEndpoints::DataView, ::network::mojom::blink::URLLoaderClientEndpointsPtr>::Read(
    ::network::mojom::blink::URLLoaderClientEndpoints::DataView input,
    ::network::mojom::blink::URLLoaderClientEndpointsPtr* output) {
  bool success = true;
  ::network::mojom::blink::URLLoaderClientEndpointsPtr result(::network::mojom::blink::URLLoaderClientEndpoints::New());
  
      if (success) {
        result->url_loader =
            input.TakeUrlLoader<decltype(result->url_loader)>();
      }
      if (success) {
        result->url_loader_client =
            input.TakeUrlLoaderClient<decltype(result->url_loader_client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif