/* IndicatorManager.c generated by valac 0.56.0, the Vala compiler
 * generated from IndicatorManager.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wingpanel.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "config.h"
#include <gmodule.h>

enum  {
	WINGPANEL_INDICATOR_MANAGER_0_PROPERTY,
	WINGPANEL_INDICATOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* wingpanel_indicator_manager_properties[WINGPANEL_INDICATOR_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef WingpanelIndicator* (*WingpanelIndicatorManagerRegisterPluginFunction) (GModule* module, WingpanelIndicatorManagerServerType server_type);
typedef struct _Block2Data Block2Data;
enum  {
	WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL,
	WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL,
	WINGPANEL_INDICATOR_MANAGER_NUM_SIGNALS
};
static guint wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_NUM_SIGNALS] = {0};

struct _WingpanelIndicatorManagerPrivate {
	GeeHashSet* forbidden_indicators;
	GeeHashSet* allowed_indicators;
	GeeHashMap* indicators;
	GFileMonitor* monitor;
	GFileMonitor* root_restrictions_monitor;
	GFileMonitor* user_restrictions_monitor;
	WingpanelIndicatorManagerServerType server_type;
};

struct _Block1Data {
	int _ref_count_;
	WingpanelIndicatorManager* self;
	GFile* root_restrictions_folder;
	GFile* user_restrictions_folder;
};

struct _Block2Data {
	int _ref_count_;
	WingpanelIndicatorManager* self;
	GeeHashMap* deregister_map;
	WingpanelIndicator* indicator;
};

static gint WingpanelIndicatorManager_private_offset;
static gpointer wingpanel_indicator_manager_parent_class = NULL;
static WingpanelIndicatorManager* wingpanel_indicator_manager_indicator_manager;
static WingpanelIndicatorManager* wingpanel_indicator_manager_indicator_manager = NULL;

static WingpanelIndicatorManager* wingpanel_indicator_manager_new (void);
static WingpanelIndicatorManager* wingpanel_indicator_manager_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GFile* file,
                  GFile* trash,
                  GFileMonitorEvent event);
static void wingpanel_indicator_manager_reload_restrictions (WingpanelIndicatorManager* self,
                                                      GFile* root_restrictions_folder,
                                                      GFile* user_restrictions_folder);
static void ____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void ___lambda8_ (Block1Data* _data1_,
                  GFile* file,
                  GFile* trash,
                  GFileMonitorEvent event);
static void ____lambda8__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void wingpanel_indicator_manager_load_restrictions (WingpanelIndicatorManager* self,
                                                    GFile* restrictions_folder);
static void ___lambda9_ (WingpanelIndicatorManager* self,
                  GFile* file,
                  GFile* trash,
                  GFileMonitorEvent event);
static void wingpanel_indicator_manager_load (WingpanelIndicatorManager* self,
                                       const gchar* path);
static void ____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void wingpanel_indicator_manager_find_plugins (WingpanelIndicatorManager* self,
                                               GFile* base_folder);
static gboolean wingpanel_indicator_manager_check_forbidden_indicators (WingpanelIndicatorManager* self,
                                                                 const gchar* path);
static gboolean wingpanel_indicator_manager_check_allowed_indicators (WingpanelIndicatorManager* self,
                                                               const gchar* path);
static gboolean __lambda5_ (WingpanelIndicatorManager* self,
                     GeeMapEntry* entry);
static gboolean ___lambda5__gee_forall_func (gpointer g,
                                      gpointer self);
static gchar** wingpanel_indicator_manager_get_restrictions_from_file (WingpanelIndicatorManager* self,
                                                                GFile* file,
                                                                gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block2Data* _data2_,
                     GeeMapEntry* entry);
static gboolean ___lambda6__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda7_ (WingpanelIndicatorManager* self,
                     GeeMapEntry* entry);
static gboolean ___lambda7__gee_forall_func (gpointer g,
                                      gpointer self);
static void wingpanel_indicator_manager_finalize (GObject * obj);
static GType wingpanel_indicator_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
wingpanel_indicator_manager_get_instance_private (WingpanelIndicatorManager* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelIndicatorManager_private_offset);
}

/**
     * The type of the server displaying the indicator.
     */
gchar*
wingpanel_indicator_manager_server_type_restrictions_file_name (WingpanelIndicatorManagerServerType self)
{
	gchar* result;
	switch (self) {
		case WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("default");
			result = _tmp0_;
			return result;
		}
		case WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("greeter");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
wingpanel_indicator_manager_server_type_get_type_once (void)
{
	static const GEnumValue values[] = {{WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION, "WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION", "session"}, {WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER, "WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER", "greeter"}, {0, NULL, NULL}};
	GType wingpanel_indicator_manager_server_type_type_id;
	wingpanel_indicator_manager_server_type_type_id = g_enum_register_static ("WingpanelIndicatorManagerServerType", values);
	return wingpanel_indicator_manager_server_type_type_id;
}

GType
wingpanel_indicator_manager_server_type_get_type (void)
{
	static volatile gsize wingpanel_indicator_manager_server_type_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_indicator_manager_server_type_type_id__once)) {
		GType wingpanel_indicator_manager_server_type_type_id;
		wingpanel_indicator_manager_server_type_type_id = wingpanel_indicator_manager_server_type_get_type_once ();
		g_once_init_leave (&wingpanel_indicator_manager_server_type_type_id__once, wingpanel_indicator_manager_server_type_type_id);
	}
	return wingpanel_indicator_manager_server_type_type_id__once;
}

WingpanelIndicatorManager*
wingpanel_indicator_manager_get_default (void)
{
	WingpanelIndicatorManager* _tmp0_;
	WingpanelIndicatorManager* _tmp2_;
	WingpanelIndicatorManager* result;
	_tmp0_ = wingpanel_indicator_manager_indicator_manager;
	if (_tmp0_ == NULL) {
		WingpanelIndicatorManager* _tmp1_;
		_tmp1_ = wingpanel_indicator_manager_new ();
		_g_object_unref0 (wingpanel_indicator_manager_indicator_manager);
		wingpanel_indicator_manager_indicator_manager = _tmp1_;
	}
	_tmp2_ = wingpanel_indicator_manager_indicator_manager;
	result = _tmp2_;
	return result;
}

static WingpanelIndicatorManager*
wingpanel_indicator_manager_construct (GType object_type)
{
	WingpanelIndicatorManager * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	self = (WingpanelIndicatorManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WINGPANEL_TYPE_INDICATOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->indicators);
	self->priv->indicators = _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->forbidden_indicators);
	self->priv->forbidden_indicators = _tmp1_;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->allowed_indicators);
	self->priv->allowed_indicators = _tmp2_;
	return self;
}

static WingpanelIndicatorManager*
wingpanel_indicator_manager_new (void)
{
	return wingpanel_indicator_manager_construct (WINGPANEL_TYPE_INDICATOR_MANAGER);
}

/**
     * Run this method to initialize the indicator manager.
     *
     * @param server_type The server the indicators will be displayed on.
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WingpanelIndicatorManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->user_restrictions_folder);
		_g_object_unref0 (_data1_->root_restrictions_folder);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GFile* file,
             GFile* trash,
             GFileMonitorEvent event)
{
	WingpanelIndicatorManager* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = _data1_->root_restrictions_folder;
	_tmp1_ = _data1_->user_restrictions_folder;
	wingpanel_indicator_manager_reload_restrictions (self, _tmp0_, _tmp1_);
}

static void
____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda4_ (self, file, other_file, event_type);
}

static void
___lambda8_ (Block1Data* _data1_,
             GFile* file,
             GFile* trash,
             GFileMonitorEvent event)
{
	WingpanelIndicatorManager* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = _data1_->root_restrictions_folder;
	_tmp1_ = _data1_->user_restrictions_folder;
	wingpanel_indicator_manager_reload_restrictions (self, _tmp0_, _tmp1_);
}

static void
____lambda8__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda8_ (self, file, other_file, event_type);
}

static void
___lambda9_ (WingpanelIndicatorManager* self,
             GFile* file,
             GFile* trash,
             GFileMonitorEvent event)
{
	gchar* plugin_path = NULL;
	gchar* _tmp0_;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	plugin_path = _tmp0_;
	if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		const gchar* _tmp1_;
		_tmp1_ = plugin_path;
		wingpanel_indicator_manager_load (self, _tmp1_);
	} else {
		if (event == G_FILE_MONITOR_EVENT_DELETED) {
			WingpanelIndicator* indicator = NULL;
			GeeHashMap* _tmp2_;
			const gchar* _tmp3_;
			gpointer _tmp4_;
			WingpanelIndicator* _tmp5_;
			_tmp2_ = self->priv->indicators;
			_tmp3_ = plugin_path;
			_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
			indicator = (WingpanelIndicator*) _tmp4_;
			_tmp5_ = indicator;
			if (_tmp5_ != NULL) {
				const gchar* _tmp6_;
				WingpanelIndicator* _tmp7_;
				_tmp6_ = plugin_path;
				_tmp7_ = indicator;
				wingpanel_indicator_manager_deregister_indicator (self, _tmp6_, _tmp7_);
			}
			_g_object_unref0 (indicator);
		}
	}
	_g_free0 (plugin_path);
}

static void
____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda9_ ((WingpanelIndicatorManager*) self, file, other_file, event_type);
}

void
wingpanel_indicator_manager_initialize (WingpanelIndicatorManager* self,
                                        WingpanelIndicatorManagerServerType server_type)
{
	Block1Data* _data1_;
	GFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* base_folder = NULL;
	GFile* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	self->priv->server_type = server_type;
	_tmp0_ = g_file_new_for_path ("/etc/wingpanel.d/");
	_data1_->root_restrictions_folder = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "wingpanel.d", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_data1_->user_restrictions_folder = _tmp5_;
	{
		GFileMonitor* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		GFileMonitor* _tmp10_;
		GFileMonitor* _tmp11_ = NULL;
		GFile* _tmp12_;
		GFileMonitor* _tmp13_;
		GFileMonitor* _tmp14_;
		GFileMonitor* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp7_ = _data1_->root_restrictions_folder;
		_tmp8_ = g_file_monitor_directory (_tmp7_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (self->priv->root_restrictions_monitor);
		self->priv->root_restrictions_monitor = _tmp9_;
		_tmp10_ = self->priv->root_restrictions_monitor;
		g_signal_connect_data (_tmp10_, "changed", (GCallback) ____lambda4__g_file_monitor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp12_ = _data1_->user_restrictions_folder;
		_tmp13_ = g_file_monitor_directory (_tmp12_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->priv->user_restrictions_monitor);
		self->priv->user_restrictions_monitor = _tmp14_;
		_tmp15_ = self->priv->user_restrictions_monitor;
		g_signal_connect_data (_tmp15_, "changed", (GCallback) ____lambda8__g_file_monitor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp16_ = _data1_->root_restrictions_folder;
		wingpanel_indicator_manager_load_restrictions (self, _tmp16_);
		_tmp17_ = _data1_->user_restrictions_folder;
		wingpanel_indicator_manager_load_restrictions (self, _tmp17_);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_warning ("IndicatorManager.vala:114: Error while reading restrictions files: %s\n", _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = g_file_new_for_path (INDICATORS_DIR);
	base_folder = _tmp20_;
	{
		GFileMonitor* _tmp21_ = NULL;
		GFileMonitor* _tmp22_;
		GFileMonitor* _tmp23_;
		GFileMonitor* _tmp24_;
		_tmp22_ = g_file_monitor_directory (base_folder, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp21_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp23_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp23_;
		_tmp24_ = self->priv->monitor;
		g_signal_connect_object (_tmp24_, "changed", (GCallback) ____lambda9__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp21_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = g_file_get_path (base_folder);
		_tmp26_ = _tmp25_;
		_tmp27_ = _error_;
		_tmp28_ = _tmp27_->message;
		g_warning ("IndicatorManager.vala:139: Creating monitor for %s failed: %s\n", _tmp26_, _tmp28_);
		_g_free0 (_tmp26_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (base_folder);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	wingpanel_indicator_manager_find_plugins (self, base_folder);
	_g_object_unref0 (base_folder);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
wingpanel_indicator_manager_load (WingpanelIndicatorManager* self,
                                  const gchar* path)
{
	GModule* module = NULL;
	GModule* _tmp1_;
	GModule* _tmp2_;
	void* function = NULL;
	GModule* _tmp4_;
	void* _tmp5_ = NULL;
	gboolean _tmp6_;
	void* _tmp7_;
	WingpanelIndicatorManagerRegisterPluginFunction register_plugin = NULL;
	void* _tmp8_;
	WingpanelIndicator* indicator = NULL;
	WingpanelIndicatorManagerRegisterPluginFunction _tmp9_;
	GModule* _tmp10_;
	WingpanelIndicator* _tmp11_;
	WingpanelIndicator* _tmp12_;
	GModule* _tmp13_;
	WingpanelIndicator* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!g_module_supported ()) {
		g_error ("IndicatorManager.vala:147: Wingpanel is not supported by this system!");
	}
	if (!g_str_has_suffix (path, G_MODULE_SUFFIX)) {
		return;
	} else {
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->indicators;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, path)) {
			return;
		} else {
			if (wingpanel_indicator_manager_check_forbidden_indicators (self, path)) {
				g_debug ("IndicatorManager.vala:155: Indicator %s will not be loaded since it is" \
" explicitly forbidden", path);
				return;
			} else {
				if (!wingpanel_indicator_manager_check_allowed_indicators (self, path)) {
					g_debug ("IndicatorManager.vala:159: Indicator %s will not be loaded since it is" \
" not enabled", path);
					return;
				}
			}
		}
	}
	_tmp1_ = g_module_open (path, G_MODULE_BIND_LAZY);
	module = _tmp1_;
	_tmp2_ = module;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = g_module_error ();
		g_critical ("IndicatorManager.vala:167: %s", _tmp3_);
		_g_module_close0 (module);
		return;
	}
	_tmp4_ = module;
	_tmp6_ = g_module_symbol (_tmp4_, "get_indicator", &_tmp5_);
	function = _tmp5_;
	if (!_tmp6_) {
		_g_module_close0 (module);
		return;
	}
	_tmp7_ = function;
	if (_tmp7_ == NULL) {
		g_critical ("IndicatorManager.vala:179: get_indicator () not found in %s", path);
		_g_module_close0 (module);
		return;
	}
	_tmp8_ = function;
	register_plugin = (WingpanelIndicatorManagerRegisterPluginFunction) _tmp8_;
	_tmp9_ = register_plugin;
	_tmp10_ = module;
	_tmp11_ = _tmp9_ (_tmp10_, self->priv->server_type);
	indicator = _tmp11_;
	_tmp12_ = indicator;
	if (_tmp12_ == NULL) {
		g_debug ("IndicatorManager.vala:188: Unknown plugin type for %s or indicator is " \
"hidden on this server!", path);
		_g_object_unref0 (indicator);
		_g_module_close0 (module);
		return;
	}
	_tmp13_ = module;
	g_module_make_resident (_tmp13_);
	_tmp14_ = indicator;
	wingpanel_indicator_manager_register_indicator (self, path, _tmp14_);
	_g_object_unref0 (indicator);
	_g_module_close0 (module);
}

static void
wingpanel_indicator_manager_find_plugins (WingpanelIndicatorManager* self,
                                          GFile* base_folder)
{
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_folder != NULL);
	file_info = NULL;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (base_folder, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* file = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GFileInfo* _tmp10_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_file_get_child (base_folder, _tmp7_);
			file = _tmp8_;
			_tmp10_ = file_info;
			if (g_file_info_get_file_type (_tmp10_) == G_FILE_TYPE_REGULAR) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp9_ = g_content_type_equals (_tmp12_, "application/x-sharedlib");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GFile* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = file;
				_tmp14_ = g_file_get_path (_tmp13_);
				_tmp15_ = _tmp14_;
				wingpanel_indicator_manager_load (self, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				GFileInfo* _tmp16_;
				_tmp16_ = file_info;
				if (g_file_info_get_file_type (_tmp16_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp17_;
					_tmp17_ = file;
					wingpanel_indicator_manager_find_plugins (self, _tmp17_);
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = g_file_get_path (base_folder);
		_tmp19_ = _tmp18_;
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		g_warning ("IndicatorManager.vala:213: Unable to scan indicators folder %s: %s\n", _tmp19_, _tmp21_);
		_g_free0 (_tmp19_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_info);
}

static gboolean
wingpanel_indicator_manager_check_forbidden_indicators (WingpanelIndicatorManager* self,
                                                        const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	{
		GeeIterator* _indicator_file_name_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->forbidden_indicators;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_indicator_file_name_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gchar* indicator_file_name = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			const gchar* _tmp5_;
			_tmp2_ = _indicator_file_name_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _indicator_file_name_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			indicator_file_name = (gchar*) _tmp4_;
			_tmp5_ = indicator_file_name;
			if (g_str_has_suffix (path, _tmp5_)) {
				result = TRUE;
				_g_free0 (indicator_file_name);
				_g_object_unref0 (_indicator_file_name_it);
				return result;
			}
			_g_free0 (indicator_file_name);
		}
		_g_object_unref0 (_indicator_file_name_it);
	}
	result = FALSE;
	return result;
}

static gboolean
wingpanel_indicator_manager_check_allowed_indicators (WingpanelIndicatorManager* self,
                                                      const gchar* path)
{
	GeeHashSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->allowed_indicators;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = TRUE;
		return result;
	}
	{
		GeeIterator* _indicator_file_name_it = NULL;
		GeeHashSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = self->priv->allowed_indicators;
		_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp3_);
		_indicator_file_name_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* indicator_file_name = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = _indicator_file_name_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _indicator_file_name_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			indicator_file_name = (gchar*) _tmp7_;
			_tmp8_ = indicator_file_name;
			if (g_str_has_suffix (path, _tmp8_)) {
				result = TRUE;
				_g_free0 (indicator_file_name);
				_g_object_unref0 (_indicator_file_name_it);
				return result;
			}
			_g_free0 (indicator_file_name);
		}
		_g_object_unref0 (_indicator_file_name_it);
	}
	result = FALSE;
	return result;
}

static gboolean
__lambda5_ (WingpanelIndicatorManager* self,
            GeeMapEntry* entry)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	if (wingpanel_indicator_manager_check_forbidden_indicators (self, (const gchar*) _tmp1_)) {
		gconstpointer _tmp2_;
		gconstpointer _tmp3_;
		gconstpointer _tmp4_;
		gconstpointer _tmp5_;
		_tmp2_ = gee_map_entry_get_key (entry);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_map_entry_get_value (entry);
		_tmp5_ = _tmp4_;
		wingpanel_indicator_manager_deregister_indicator (self, (const gchar*) _tmp3_, (WingpanelIndicator*) _tmp5_);
	} else {
		gconstpointer _tmp6_;
		gconstpointer _tmp7_;
		_tmp6_ = gee_map_entry_get_key (entry);
		_tmp7_ = _tmp6_;
		if (!wingpanel_indicator_manager_check_allowed_indicators (self, (const gchar*) _tmp7_)) {
			gconstpointer _tmp8_;
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			gconstpointer _tmp11_;
			_tmp8_ = gee_map_entry_get_key (entry);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_map_entry_get_value (entry);
			_tmp11_ = _tmp10_;
			wingpanel_indicator_manager_deregister_indicator (self, (const gchar*) _tmp9_, (WingpanelIndicator*) _tmp11_);
		}
	}
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda5__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda5_ ((WingpanelIndicatorManager*) self, (GeeMapEntry*) g);
	return result;
}

static void
wingpanel_indicator_manager_reload_restrictions (WingpanelIndicatorManager* self,
                                                 GFile* root_restrictions_folder,
                                                 GFile* user_restrictions_folder)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashMap* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_restrictions_folder != NULL);
	g_return_if_fail (user_restrictions_folder != NULL);
	_tmp0_ = self->priv->forbidden_indicators;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->allowed_indicators;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	wingpanel_indicator_manager_load_restrictions (self, root_restrictions_folder);
	wingpanel_indicator_manager_load_restrictions (self, user_restrictions_folder);
	_tmp2_ = self->priv->indicators;
	gee_abstract_map_foreach ((GeeAbstractMap*) _tmp2_, ___lambda5__gee_forall_func, self);
	_tmp3_ = g_file_new_for_path (INDICATORS_DIR);
	_tmp4_ = _tmp3_;
	wingpanel_indicator_manager_find_plugins (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
wingpanel_indicator_manager_load_restrictions (WingpanelIndicatorManager* self,
                                               GFile* restrictions_folder)
{
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (restrictions_folder != NULL);
	if (!g_file_query_exists (restrictions_folder, NULL)) {
		return;
	}
	file_info = NULL;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (restrictions_folder, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			const gchar* file_name = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			GFile* file = NULL;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			const gchar* _tmp14_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			file_name = _tmp7_;
			_tmp8_ = file_name;
			_tmp9_ = wingpanel_indicator_manager_server_type_restrictions_file_name (self->priv->server_type);
			_tmp10_ = _tmp9_;
			_tmp11_ = !string_contains (_tmp8_, _tmp10_);
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				_g_object_unref0 (_tmp1_);
				continue;
			}
			_tmp12_ = file_name;
			_tmp13_ = g_file_get_child (restrictions_folder, _tmp12_);
			file = _tmp13_;
			_tmp14_ = file_name;
			if (g_str_has_suffix (_tmp14_, ".allowed")) {
				GFile* _tmp15_;
				gint _tmp16_ = 0;
				gchar** _tmp17_;
				_tmp15_ = file;
				_tmp17_ = wingpanel_indicator_manager_get_restrictions_from_file (self, _tmp15_, &_tmp16_);
				{
					gchar** entry_collection = NULL;
					gint entry_collection_length1 = 0;
					gint _entry_collection_size_ = 0;
					gint entry_it = 0;
					entry_collection = _tmp17_;
					entry_collection_length1 = _tmp16_;
					for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
						gchar* _tmp18_;
						gchar* entry = NULL;
						_tmp18_ = g_strdup (entry_collection[entry_it]);
						entry = _tmp18_;
						{
							GeeHashSet* _tmp19_;
							const gchar* _tmp20_;
							_tmp19_ = self->priv->allowed_indicators;
							_tmp20_ = entry;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
							_g_free0 (entry);
						}
					}
					entry_collection = (_vala_array_free (entry_collection, entry_collection_length1, (GDestroyNotify) g_free), NULL);
				}
			} else {
				const gchar* _tmp21_;
				_tmp21_ = file_name;
				if (g_str_has_suffix (_tmp21_, ".forbidden")) {
					GFile* _tmp22_;
					gint _tmp23_ = 0;
					gchar** _tmp24_;
					_tmp22_ = file;
					_tmp24_ = wingpanel_indicator_manager_get_restrictions_from_file (self, _tmp22_, &_tmp23_);
					{
						gchar** entry_collection = NULL;
						gint entry_collection_length1 = 0;
						gint _entry_collection_size_ = 0;
						gint entry_it = 0;
						entry_collection = _tmp24_;
						entry_collection_length1 = _tmp23_;
						for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
							gchar* _tmp25_;
							gchar* entry = NULL;
							_tmp25_ = g_strdup (entry_collection[entry_it]);
							entry = _tmp25_;
							{
								GeeHashSet* _tmp26_;
								const gchar* _tmp27_;
								_tmp26_ = self->priv->forbidden_indicators;
								_tmp27_ = entry;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
								_g_free0 (entry);
							}
						}
						entry_collection = (_vala_array_free (entry_collection, entry_collection_length1, (GDestroyNotify) g_free), NULL);
					}
				} else {
					const gchar* _tmp28_;
					_tmp28_ = file_name;
					if (g_str_has_suffix (_tmp28_, ".whitelist")) {
						GFile* _tmp29_;
						gint _tmp30_ = 0;
						gchar** _tmp31_;
						g_critical ("IndicatorManager.vala:286: Using .whitelist files is deprecated and wi" \
"ll be removed in next version, please use .allowed instead");
						_tmp29_ = file;
						_tmp31_ = wingpanel_indicator_manager_get_restrictions_from_file (self, _tmp29_, &_tmp30_);
						{
							gchar** entry_collection = NULL;
							gint entry_collection_length1 = 0;
							gint _entry_collection_size_ = 0;
							gint entry_it = 0;
							entry_collection = _tmp31_;
							entry_collection_length1 = _tmp30_;
							for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
								gchar* _tmp32_;
								gchar* entry = NULL;
								_tmp32_ = g_strdup (entry_collection[entry_it]);
								entry = _tmp32_;
								{
									GeeHashSet* _tmp33_;
									const gchar* _tmp34_;
									_tmp33_ = self->priv->allowed_indicators;
									_tmp34_ = entry;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
									_g_free0 (entry);
								}
							}
							entry_collection = (_vala_array_free (entry_collection, entry_collection_length1, (GDestroyNotify) g_free), NULL);
						}
					} else {
						const gchar* _tmp35_;
						_tmp35_ = file_name;
						if (g_str_has_suffix (_tmp35_, ".blacklist")) {
							GFile* _tmp36_;
							gint _tmp37_ = 0;
							gchar** _tmp38_;
							g_critical ("IndicatorManager.vala:291: Using .blacklist files is deprecated and wi" \
"ll be removed in next version, please use .forbidden instead");
							_tmp36_ = file;
							_tmp38_ = wingpanel_indicator_manager_get_restrictions_from_file (self, _tmp36_, &_tmp37_);
							{
								gchar** entry_collection = NULL;
								gint entry_collection_length1 = 0;
								gint _entry_collection_size_ = 0;
								gint entry_it = 0;
								entry_collection = _tmp38_;
								entry_collection_length1 = _tmp37_;
								for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
									gchar* _tmp39_;
									gchar* entry = NULL;
									_tmp39_ = g_strdup (entry_collection[entry_it]);
									entry = _tmp39_;
									{
										GeeHashSet* _tmp40_;
										const gchar* _tmp41_;
										_tmp40_ = self->priv->forbidden_indicators;
										_tmp41_ = entry;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
										_g_free0 (entry);
									}
								}
								entry_collection = (_vala_array_free (entry_collection, entry_collection_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = g_file_get_path (restrictions_folder);
		_tmp43_ = _tmp42_;
		_tmp44_ = _error_;
		_tmp45_ = _tmp44_->message;
		g_warning ("IndicatorManager.vala:298: Unable to scan restrictions folder %s: %s\n", _tmp43_, _tmp45_);
		_g_free0 (_tmp43_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_info);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
wingpanel_indicator_manager_get_restrictions_from_file (WingpanelIndicatorManager* self,
                                                        GFile* file,
                                                        gint* result_length1)
{
	gchar** restrictions = NULL;
	gchar** _tmp0_;
	gint restrictions_length1;
	gint _restrictions_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	restrictions = _tmp0_;
	restrictions_length1 = 0;
	_restrictions_size_ = restrictions_length1;
	if (g_file_query_exists (file, NULL)) {
		{
			GFileInputStream* _tmp1_ = NULL;
			GFileInputStream* _tmp2_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp3_;
			gchar* line = NULL;
			_tmp2_ = g_file_read (file, NULL, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
			dis = _tmp3_;
			line = NULL;
			while (TRUE) {
				gchar* _tmp4_ = NULL;
				GDataInputStream* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				_tmp5_ = dis;
				_tmp6_ = g_data_input_stream_read_line (_tmp5_, NULL, NULL, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp1_);
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_g_free0 (line);
				line = _tmp7_;
				_tmp8_ = line;
				if (!(_tmp8_ != NULL)) {
					_g_free0 (_tmp4_);
					break;
				}
				_tmp9_ = line;
				_tmp10_ = string_strip (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strcmp0 (_tmp11_, "") != 0;
				_g_free0 (_tmp11_);
				if (_tmp12_) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = line;
					_tmp14_ = g_strdup (_tmp13_);
					_vala_array_add1 (&restrictions, &restrictions_length1, &_restrictions_size_, _tmp14_);
				}
				_g_free0 (_tmp4_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GError* _tmp17_;
			const gchar* _tmp18_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = g_file_get_basename (file);
			_tmp16_ = _tmp15_;
			_tmp17_ = _error_;
			_tmp18_ = _tmp17_->message;
			g_warning ("IndicatorManager.vala:316: Unable to load restrictions file %s: %s\n", _tmp16_, _tmp18_);
			_g_free0 (_tmp16_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			restrictions = (_vala_array_free (restrictions, restrictions_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp19_ = restrictions;
	_tmp19__length1 = restrictions_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}

/**
     * Register a new indicator.
     *
     * @param path The path to the plugin file. (Used to identify the indicator)
     * @param indicator The indicator.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		WingpanelIndicatorManager* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->deregister_map);
		_g_object_unref0 (_data2_->indicator);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda6_ (Block2Data* _data2_,
            GeeMapEntry* entry)
{
	WingpanelIndicatorManager* self;
	WingpanelIndicator* val = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	WingpanelIndicator* _tmp2_;
	WingpanelIndicator* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_value (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((WingpanelIndicator*) _tmp1_);
	val = _tmp2_;
	_tmp3_ = val;
	_tmp4_ = wingpanel_indicator_get_code_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = wingpanel_indicator_get_code_name (_data2_->indicator);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
		WingpanelIndicator* _tmp10_;
		_tmp8_ = gee_map_entry_get_key (entry);
		_tmp9_ = _tmp8_;
		_tmp10_ = val;
		gee_abstract_map_set ((GeeAbstractMap*) _data2_->deregister_map, (const gchar*) _tmp9_, _tmp10_);
	}
	result = TRUE;
	_g_object_unref0 (val);
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda6__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda6_ (self, (GeeMapEntry*) g);
	return result;
}

static gboolean
__lambda7_ (WingpanelIndicatorManager* self,
            GeeMapEntry* entry)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_map_entry_get_value (entry);
	_tmp3_ = _tmp2_;
	wingpanel_indicator_manager_deregister_indicator (self, (const gchar*) _tmp1_, (WingpanelIndicator*) _tmp3_);
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda7__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda7_ ((WingpanelIndicatorManager*) self, (GeeMapEntry*) g);
	return result;
}

void
wingpanel_indicator_manager_register_indicator (WingpanelIndicatorManager* self,
                                                const gchar* path,
                                                WingpanelIndicator* indicator)
{
	Block2Data* _data2_;
	WingpanelIndicator* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (indicator != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (indicator);
	_g_object_unref0 (_data2_->indicator);
	_data2_->indicator = _tmp0_;
	_tmp1_ = wingpanel_indicator_get_code_name (_data2_->indicator);
	_tmp2_ = _tmp1_;
	g_debug ("IndicatorManager.vala:330: %s registered", _tmp2_);
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WINGPANEL_TYPE_INDICATOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data2_->deregister_map = _tmp3_;
	_tmp4_ = self->priv->indicators;
	gee_abstract_map_foreach ((GeeAbstractMap*) _tmp4_, ___lambda6__gee_forall_func, _data2_);
	gee_abstract_map_foreach ((GeeAbstractMap*) _data2_->deregister_map, ___lambda7__gee_forall_func, self);
	_tmp5_ = self->priv->indicators;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, path, _data2_->indicator);
	g_signal_emit (self, wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL], 0, _data2_->indicator);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
     * Deregisters an indicator.
     *
     * @param path The path to the plugin file. (Used to identify the indicator)
     * @param indicator The indicator.
     */
void
wingpanel_indicator_manager_deregister_indicator (WingpanelIndicatorManager* self,
                                                  const gchar* path,
                                                  WingpanelIndicator* indicator)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (indicator != NULL);
	_tmp0_ = wingpanel_indicator_get_code_name (indicator);
	_tmp1_ = _tmp0_;
	g_debug ("IndicatorManager.vala:359: %s deregistered", _tmp1_);
	_tmp2_ = self->priv->indicators;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, path)) {
		return;
	}
	_tmp3_ = self->priv->indicators;
	if (gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, path, NULL)) {
		g_signal_emit (self, wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL], 0, indicator);
	}
}

/**
     * Checks if indicators are loaded.
     *
     * @return True if there are any indicators loaded.
     */
gboolean
wingpanel_indicator_manager_has_indicators (WingpanelIndicatorManager* self)
{
	GeeHashMap* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->indicators;
	_tmp1_ = gee_map_get_is_empty ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}

/**
     * Gets the list of loaded indicators.
     *
     * @return a {@link Gee.Collection} containing the indicators.
     */
GeeCollection*
wingpanel_indicator_manager_get_indicators (WingpanelIndicatorManager* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indicators;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static void
wingpanel_indicator_manager_class_init (WingpanelIndicatorManagerClass * klass,
                                        gpointer klass_data)
{
	wingpanel_indicator_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelIndicatorManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = wingpanel_indicator_manager_finalize;
	/**
	     * Called when a new indicator was added.
	     */
	wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL] = g_signal_new ("indicator-added", WINGPANEL_TYPE_INDICATOR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WINGPANEL_TYPE_INDICATOR);
	/**
	     * Called when an indicator was removed.
	     */
	wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL] = g_signal_new ("indicator-removed", WINGPANEL_TYPE_INDICATOR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WINGPANEL_TYPE_INDICATOR);
}

static void
wingpanel_indicator_manager_instance_init (WingpanelIndicatorManager * self,
                                           gpointer klass)
{
	self->priv = wingpanel_indicator_manager_get_instance_private (self);
	self->priv->monitor = NULL;
	self->priv->root_restrictions_monitor = NULL;
	self->priv->user_restrictions_monitor = NULL;
}

static void
wingpanel_indicator_manager_finalize (GObject * obj)
{
	WingpanelIndicatorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_TYPE_INDICATOR_MANAGER, WingpanelIndicatorManager);
	_g_object_unref0 (self->priv->forbidden_indicators);
	_g_object_unref0 (self->priv->allowed_indicators);
	_g_object_unref0 (self->priv->indicators);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->root_restrictions_monitor);
	_g_object_unref0 (self->priv->user_restrictions_monitor);
	G_OBJECT_CLASS (wingpanel_indicator_manager_parent_class)->finalize (obj);
}

static GType
wingpanel_indicator_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelIndicatorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_indicator_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelIndicatorManager), 0, (GInstanceInitFunc) wingpanel_indicator_manager_instance_init, NULL };
	GType wingpanel_indicator_manager_type_id;
	wingpanel_indicator_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WingpanelIndicatorManager", &g_define_type_info, 0);
	WingpanelIndicatorManager_private_offset = g_type_add_instance_private (wingpanel_indicator_manager_type_id, sizeof (WingpanelIndicatorManagerPrivate));
	return wingpanel_indicator_manager_type_id;
}

GType
wingpanel_indicator_manager_get_type (void)
{
	static volatile gsize wingpanel_indicator_manager_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_indicator_manager_type_id__once)) {
		GType wingpanel_indicator_manager_type_id;
		wingpanel_indicator_manager_type_id = wingpanel_indicator_manager_get_type_once ();
		g_once_init_leave (&wingpanel_indicator_manager_type_id__once, wingpanel_indicator_manager_type_id);
	}
	return wingpanel_indicator_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

