/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.jcraft.jzlib.ZStream;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.InStream;

public class ZlibInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private InStream underlying;
    private int bufSize;
    private int offset;
    private ZStream zs;
    private int bytesIn;
    private int start;

    public ZlibInStream(int n) {
        this.bufSize = n;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.bytesIn = 0;
        this.start = 0;
        this.end = 0;
        this.ptr = 0;
        this.init();
    }

    public ZlibInStream() {
        this(16384);
    }

    public void setUnderlying(InStream inStream, int n) {
        this.underlying = inStream;
        this.bytesIn = n;
        this.ptr = this.end = this.start;
    }

    @Override
    public int pos() {
        return this.offset + this.ptr - this.start;
    }

    public void flushUnderlying() {
        this.ptr = this.end = this.start;
        while (this.bytesIn > 0) {
            this.decompress(true);
            this.end = this.start;
        }
        this.setUnderlying(null, 0);
    }

    public void reset() {
        this.deinit();
        this.init();
    }

    public void init() {
        assert (this.zs == null);
        this.zs = new ZStream();
        this.zs.next_in = null;
        this.zs.next_in_index = 0;
        this.zs.avail_in = 0;
        if (this.zs.inflateInit() != 0) {
            this.zs = null;
            throw new Exception("ZlinInStream: inflateInit failed");
        }
    }

    public void deinit() {
        assert (this.zs != null);
        this.setUnderlying(null, 0);
        this.zs.inflateEnd();
        this.zs = null;
    }

    @Override
    protected int overrun(int n, int n2, boolean bl) {
        if (n > this.bufSize) {
            throw new Exception("ZlibInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, this.start, this.end - this.ptr);
        }
        this.offset += this.ptr - this.start;
        this.end -= this.ptr - this.start;
        this.ptr = this.start;
        while (this.end - this.ptr < n) {
            if (this.decompress(bl)) continue;
            return 0;
        }
        int n3 = (this.end - this.ptr) / n;
        if (n3 < n2) {
            return n3;
        }
        return n2;
    }

    private boolean decompress(boolean bl) {
        int n;
        if (this.underlying == null) {
            throw new Exception("ZlibInStream overrun: no underlying stream");
        }
        this.zs.next_out = this.b;
        this.zs.next_out_index = this.end;
        this.zs.avail_out = this.start + this.bufSize - this.end;
        int n2 = this.underlying.check(1, 1, bl);
        if (n2 == 0) {
            return false;
        }
        this.zs.next_in = this.underlying.getbuf();
        this.zs.next_in_index = this.underlying.getptr();
        this.zs.avail_in = this.underlying.getend() - this.underlying.getptr();
        if (this.zs.avail_in > this.bytesIn) {
            this.zs.avail_in = this.bytesIn;
        }
        if ((n = this.zs.inflate(2)) != 0) {
            throw new Exception("ZlibInStream: inflate failed");
        }
        this.bytesIn -= this.zs.next_in_index - this.underlying.getptr();
        this.end = this.zs.next_out_index;
        this.underlying.setptr(this.zs.next_in_index);
        return true;
    }
}

