/* page.c generated by valac 0.56.0, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
enum  {
	PAGE_0_PROPERTY,
	PAGE_WIDTH_PROPERTY,
	PAGE_HEIGHT_PROPERTY,
	PAGE_IS_LANDSCAPE_PROPERTY,
	PAGE_DPI_PROPERTY,
	PAGE_DEPTH_PROPERTY,
	PAGE_COLOR_PROFILE_PROPERTY,
	PAGE_SCAN_WIDTH_PROPERTY,
	PAGE_SCAN_HEIGHT_PROPERTY,
	PAGE_ROWSTRIDE_PROPERTY,
	PAGE_N_CHANNELS_PROPERTY,
	PAGE_IS_SCANNING_PROPERTY,
	PAGE_HAS_DATA_PROPERTY,
	PAGE_SCAN_LINE_PROPERTY,
	PAGE_IS_COLOR_PROPERTY,
	PAGE_SCAN_DIRECTION_PROPERTY,
	PAGE_HAS_CROP_PROPERTY,
	PAGE_CROP_NAME_PROPERTY,
	PAGE_CROP_X_PROPERTY,
	PAGE_CROP_Y_PROPERTY,
	PAGE_CROP_WIDTH_PROPERTY,
	PAGE_CROP_HEIGHT_PROPERTY,
	PAGE_NUM_PROPERTIES
};
static GParamSpec* page_properties[PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
enum  {
	PAGE_PIXELS_CHANGED_SIGNAL,
	PAGE_SIZE_CHANGED_SIGNAL,
	PAGE_SCAN_LINE_CHANGED_SIGNAL,
	PAGE_SCAN_DIRECTION_CHANGED_SIGNAL,
	PAGE_CROP_CHANGED_SIGNAL,
	PAGE_SCAN_FINISHED_SIGNAL,
	PAGE_NUM_SIGNALS
};
static guint page_signals[PAGE_NUM_SIGNALS] = {0};

struct _Page {
	GObject parent_instance;
	PagePrivate * priv;
};

struct _PageClass {
	GObjectClass parent_class;
};

struct _PagePrivate {
	gint _dpi;
	gint expected_rows;
	gint _depth;
	gchar* _color_profile;
	gint _scan_width;
	gint _scan_height;
	gint _rowstride;
	gint _n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean _is_scanning;
	gboolean _has_data;
	gint _scan_line;
	ScanDirection scan_direction_;
	gboolean _has_crop;
	gchar* _crop_name;
	gint _crop_x;
	gint _crop_y;
	gint _crop_width;
	gint _crop_height;
};

struct _ScanPageInfo {
	GObject parent_instance;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GObjectClass parent_class;
};

struct _ScanLine {
	GObject parent_instance;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	Page* self;
	GFileOutputStream* stream;
};

static gint Page_private_offset;
static gpointer page_parent_class = NULL;

VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN Page* page_new (gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction);
VALA_EXTERN Page* page_construct (GType object_type,
                      gint width,
                      gint height,
                      gint dpi,
                      ScanDirection scan_direction);
static void page_set_scan_width (Page* self,
                          gint value);
static void page_set_scan_height (Page* self,
                           gint value);
static void page_set_dpi (Page* self,
                   gint value);
VALA_EXTERN void page_set_scan_direction (Page* self,
                              ScanDirection value);
VALA_EXTERN Page* page_new_from_data (gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          gint pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height);
VALA_EXTERN Page* page_construct_from_data (GType object_type,
                                gint scan_width,
                                gint scan_height,
                                gint rowstride,
                                gint n_channels,
                                gint depth,
                                gint dpi,
                                ScanDirection scan_direction,
                                const gchar* color_profile,
                                guchar* pixels,
                                gint pixels_length1,
                                gboolean has_crop,
                                const gchar* crop_name,
                                gint crop_x,
                                gint crop_y,
                                gint crop_width,
                                gint crop_height);
static void page_set_rowstride (Page* self,
                         gint value);
static void page_set_n_channels (Page* self,
                          gint value);
static void page_set_depth (Page* self,
                     gint value);
VALA_EXTERN void page_set_color_profile (Page* self,
                             const gchar* value);
static guchar* _vala_array_dup5 (guchar* self,
                          gssize length);
static void page_set_has_data (Page* self,
                        gboolean value);
static void page_set_has_crop (Page* self,
                        gboolean value);
static void page_set_crop_name (Page* self,
                         const gchar* value);
static void page_set_crop_x (Page* self,
                      gint value);
static void page_set_crop_y (Page* self,
                      gint value);
static void page_set_crop_width (Page* self,
                          gint value);
static void page_set_crop_height (Page* self,
                           gint value);
VALA_EXTERN GType scan_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanPageInfo, g_object_unref)
VALA_EXTERN void page_set_page_info (Page* self,
                         ScanPageInfo* info);
VALA_EXTERN gint page_get_scan_height (Page* self);
VALA_EXTERN gint page_get_scan_width (Page* self);
VALA_EXTERN gint page_get_depth (Page* self);
VALA_EXTERN gint page_get_n_channels (Page* self);
VALA_EXTERN gint page_get_rowstride (Page* self);
VALA_EXTERN void page_start (Page* self);
static void page_set_is_scanning (Page* self,
                           gboolean value);
VALA_EXTERN GType scan_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanLine, g_object_unref)
static void page_parse_line (Page* self,
                      ScanLine* line,
                      gint n,
                      gboolean* size_changed);
static void page_set_scan_line (Page* self,
                         gint value);
VALA_EXTERN void page_parse_scan_line (Page* self,
                           ScanLine* line);
VALA_EXTERN void page_finish (Page* self);
VALA_EXTERN gint page_get_scan_line (Page* self);
VALA_EXTERN void page_rotate_left (Page* self);
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN void page_rotate_right (Page* self);
VALA_EXTERN void page_set_no_crop (Page* self);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
VALA_EXTERN gint page_get_crop_width (Page* self);
VALA_EXTERN gint page_get_crop_height (Page* self);
VALA_EXTERN void page_set_named_crop (Page* self,
                          const gchar* name);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
VALA_EXTERN void page_rotate_crop (Page* self);
VALA_EXTERN gint page_get_crop_x (Page* self);
VALA_EXTERN gint page_get_crop_y (Page* self);
VALA_EXTERN guchar* page_get_pixels (Page* self,
                         gint* result_length1);
static guchar page_get_sample (Page* self,
                        guchar* pixels,
                        gint pixels_length1,
                        gint offset,
                        gint x,
                        gint depth,
                        gint n_channels,
                        gint channel);
static void page_get_pixel (Page* self,
                     gint x,
                     gint y,
                     guchar* pixel,
                     gint pixel_length1,
                     gint offset);
VALA_EXTERN GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
VALA_EXTERN gchar* page_get_icc_data_encoded (Page* self);
VALA_EXTERN const gchar* page_get_color_profile (Page* self);
VALA_EXTERN void page_copy_to_clipboard (Page* self,
                             GtkWindow* window);
VALA_EXTERN void page_save_png (Page* self,
                    GFile* file,
                    GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda21_ (Block5Data* _data5_,
                      guint8* buf,
                      gsize buf_length1,
                      GError** error);
static gboolean ___lambda21__gdk_pixbuf_save_func (guint8* buf,
                                            gsize count,
                                            GError** error,
                                            gpointer self);
VALA_EXTERN gboolean page_get_is_landscape (Page* self);
VALA_EXTERN gboolean page_get_is_scanning (Page* self);
VALA_EXTERN gboolean page_get_has_data (Page* self);
VALA_EXTERN gboolean page_get_is_color (Page* self);
static void page_finalize (GObject * obj);
static GType page_get_type_once (void);
static void _vala_page_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_page_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
scan_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
	GType scan_direction_type_id;
	scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
	return scan_direction_type_id;
}

GType
scan_direction_get_type (void)
{
	static volatile gsize scan_direction_type_id__once = 0;
	if (g_once_init_enter (&scan_direction_type_id__once)) {
		GType scan_direction_type_id;
		scan_direction_type_id = scan_direction_get_type_once ();
		g_once_init_leave (&scan_direction_type_id__once, scan_direction_type_id);
	}
	return scan_direction_type_id__once;
}

static inline gpointer
page_get_instance_private (Page* self)
{
	return G_STRUCT_MEMBER_P (self, Page_private_offset);
}

Page*
page_construct (GType object_type,
                gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction)
{
	Page * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (Page*) g_object_new (object_type, NULL);
	if (scan_direction == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = scan_direction == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	if (_tmp0_) {
		page_set_scan_width (self, width);
		page_set_scan_height (self, height);
	} else {
		page_set_scan_width (self, height);
		page_set_scan_height (self, width);
	}
	page_set_dpi (self, dpi);
	page_set_scan_direction (self, scan_direction);
	return self;
}

Page*
page_new (gint width,
          gint height,
          gint dpi,
          ScanDirection scan_direction)
{
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
}

static guchar*
_vala_array_dup5 (guchar* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guchar));
	}
	return NULL;
}

Page*
page_construct_from_data (GType object_type,
                          gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          gint pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height)
{
	Page * self = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (Page*) g_object_new (object_type, NULL);
	page_set_scan_width (self, scan_width);
	page_set_scan_height (self, scan_height);
	self->priv->expected_rows = scan_height;
	page_set_rowstride (self, rowstride);
	page_set_n_channels (self, n_channels);
	page_set_depth (self, depth);
	page_set_dpi (self, dpi);
	page_set_scan_direction (self, scan_direction);
	page_set_color_profile (self, color_profile);
	_tmp0_ = (pixels != NULL) ? _vala_array_dup5 (pixels, pixels_length1) : pixels;
	_tmp0__length1 = pixels_length1;
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
	self->priv->pixels = _tmp0_;
	self->priv->pixels_length1 = _tmp0__length1;
	self->priv->_pixels_size_ = self->priv->pixels_length1;
	page_set_has_data (self, pixels != NULL);
	page_set_has_crop (self, has_crop);
	page_set_crop_name (self, crop_name);
	page_set_crop_x (self, crop_x);
	page_set_crop_y (self, crop_y);
	if ((crop_x + crop_width) > scan_width) {
		_tmp1_ = scan_width;
	} else {
		_tmp1_ = crop_width;
	}
	page_set_crop_width (self, _tmp1_);
	if ((crop_y + crop_height) > scan_height) {
		_tmp2_ = scan_height;
	} else {
		_tmp2_ = crop_height;
	}
	page_set_crop_height (self, _tmp2_);
	return self;
}

Page*
page_new_from_data (gint scan_width,
                    gint scan_height,
                    gint rowstride,
                    gint n_channels,
                    gint depth,
                    gint dpi,
                    ScanDirection scan_direction,
                    const gchar* color_profile,
                    guchar* pixels,
                    gint pixels_length1,
                    gboolean has_crop,
                    const gchar* crop_name,
                    gint crop_x,
                    gint crop_y,
                    gint crop_width,
                    gint crop_height)
{
	return page_construct_from_data (TYPE_PAGE, scan_width, scan_height, rowstride, n_channels, depth, dpi, scan_direction, color_profile, pixels, pixels_length1, has_crop, crop_name, crop_x, crop_y, crop_width, crop_height);
}

void
page_set_page_info (Page* self,
                    ScanPageInfo* info)
{
	gint _tmp0_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guchar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	self->priv->expected_rows = info->height;
	page_set_dpi (self, (gint) info->dpi);
	page_set_scan_width (self, info->width);
	page_set_scan_height (self, info->height);
	_tmp0_ = self->priv->_scan_height;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->_scan_width;
		page_set_scan_height (self, _tmp1_ / 2);
	}
	page_set_depth (self, info->depth);
	page_set_n_channels (self, info->n_channels);
	_tmp2_ = self->priv->_scan_width;
	_tmp3_ = self->priv->_depth;
	_tmp4_ = self->priv->_n_channels;
	page_set_rowstride (self, (((_tmp2_ * _tmp3_) * _tmp4_) + 7) / 8);
	_tmp5_ = self->priv->_scan_height;
	_tmp6_ = self->priv->_rowstride;
	_tmp7_ = _tmp5_ * _tmp6_;
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp5_ * _tmp6_);
	(_tmp7_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp7_ - self->priv->pixels_length1)) : NULL;
	self->priv->pixels_length1 = _tmp7_;
	self->priv->_pixels_size_ = _tmp7_;
	_tmp8_ = self->priv->pixels;
	_tmp8__length1 = self->priv->pixels_length1;
	g_return_if_fail (_tmp8_ != NULL);
	_tmp9_ = self->priv->_depth;
	if (_tmp9_ == 1) {
		guchar* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = self->priv->pixels;
		_tmp10__length1 = self->priv->pixels_length1;
		_tmp11_ = self->priv->_scan_height;
		_tmp12_ = self->priv->_rowstride;
		memset (_tmp10_, 0x00, (gsize) (_tmp11_ * _tmp12_));
	} else {
		guchar* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = self->priv->pixels;
		_tmp13__length1 = self->priv->pixels_length1;
		_tmp14_ = self->priv->_scan_height;
		_tmp15_ = self->priv->_rowstride;
		memset (_tmp13_, 0xFF, (gsize) (_tmp14_ * _tmp15_));
	}
	g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_signals[PAGE_PIXELS_CHANGED_SIGNAL], 0);
}

void
page_start (Page* self)
{
	g_return_if_fail (self != NULL);
	page_set_is_scanning (self, TRUE);
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
}

static void
page_parse_line (Page* self,
                 ScanLine* line,
                 gint n,
                 gboolean* size_changed)
{
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	gint offset = 0;
	gint _tmp7_;
	gint line_offset = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	line_number = line->number + n;
	_vala_size_changed = FALSE;
	while (TRUE) {
		gint _tmp0_;
		gint rows = 0;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp0_ = self->priv->_scan_height;
		if (!(line_number >= _tmp0_)) {
			break;
		}
		_tmp1_ = self->priv->_scan_height;
		rows = _tmp1_;
		_tmp2_ = self->priv->_scan_width;
		page_set_scan_height (self, rows + (_tmp2_ / 2));
		_tmp3_ = self->priv->_scan_height;
		g_debug ("page.vala:267: Extending image from %d lines to %d lines", rows, _tmp3_);
		_tmp4_ = self->priv->_scan_height;
		_tmp5_ = self->priv->_rowstride;
		_tmp6_ = _tmp4_ * _tmp5_;
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp4_ * _tmp5_);
		(_tmp6_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp6_ - self->priv->pixels_length1)) : NULL;
		self->priv->pixels_length1 = _tmp6_;
		self->priv->_pixels_size_ = _tmp6_;
		_vala_size_changed = TRUE;
	}
	_tmp7_ = self->priv->_rowstride;
	offset = line_number * _tmp7_;
	line_offset = n * line->data_length;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				guchar* _tmp10_;
				gint _tmp10__length1;
				guchar* _tmp11_;
				gint _tmp11__length1;
				guchar _tmp12_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < line->data_length)) {
					break;
				}
				_tmp10_ = self->priv->pixels;
				_tmp10__length1 = self->priv->pixels_length1;
				_tmp11_ = line->data;
				_tmp11__length1 = line->data_length1;
				_tmp12_ = _tmp11_[line_offset + i];
				_tmp10_[offset + i] = _tmp12_;
			}
		}
	}
	page_set_scan_line (self, line_number);
	if (size_changed) {
		*size_changed = _vala_size_changed;
	}
}

void
page_parse_scan_line (Page* self,
                      ScanLine* line)
{
	gboolean size_has_changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	size_has_changed = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < line->n_lines)) {
					break;
				}
				page_parse_line (self, line, i, &_tmp2_);
				size_has_changed = _tmp2_;
			}
		}
	}
	page_set_has_data (self, TRUE);
	if (size_has_changed) {
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
	}
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_signals[PAGE_PIXELS_CHANGED_SIGNAL], 0);
}

void
page_finish (Page* self)
{
	gboolean size_has_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	size_has_changed = FALSE;
	if (self->priv->expected_rows < 0) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->_scan_line;
		_tmp2_ = self->priv->_scan_height;
		_tmp0_ = _tmp1_ != _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint rows = 0;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->_scan_height;
		rows = _tmp3_;
		_tmp4_ = self->priv->_scan_line;
		page_set_scan_height (self, _tmp4_);
		_tmp5_ = self->priv->_scan_height;
		_tmp6_ = self->priv->_rowstride;
		_tmp7_ = _tmp5_ * _tmp6_;
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp5_ * _tmp6_);
		(_tmp7_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp7_ - self->priv->pixels_length1)) : NULL;
		self->priv->pixels_length1 = _tmp7_;
		self->priv->_pixels_size_ = _tmp7_;
		_tmp8_ = self->priv->_scan_height;
		g_debug ("page.vala:307: Trimming page from %d lines to %d lines", rows, _tmp8_);
		size_has_changed = TRUE;
	}
	page_set_is_scanning (self, FALSE);
	if (size_has_changed) {
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
	}
	g_signal_emit (self, page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_signals[PAGE_SCAN_FINISHED_SIGNAL], 0);
}

void
page_rotate_left (Page* self)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_scan_direction (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
			break;
		}
		default:
		break;
	}
}

void
page_rotate_right (Page* self)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_scan_direction (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
			break;
		}
		default:
		break;
	}
}

void
page_set_no_crop (Page* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_has_crop;
	if (!_tmp0_) {
		return;
	}
	page_set_has_crop (self, FALSE);
	page_set_crop_name (self, NULL);
	page_set_crop_x (self, 0);
	page_set_crop_y (self, 0);
	page_set_crop_width (self, 0);
	page_set_crop_height (self, 0);
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
}

void
page_set_custom_crop (Page* self,
                      gint width,
                      gint height)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (width >= 1);
	g_return_if_fail (height >= 1);
	_tmp3_ = self->priv->_crop_name;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_has_crop;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_crop_width;
		_tmp1_ = _tmp5_ == width;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp6_;
		_tmp6_ = self->priv->_crop_height;
		_tmp0_ = _tmp6_ == height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	page_set_crop_name (self, NULL);
	page_set_has_crop (self, TRUE);
	page_set_crop_width (self, width);
	page_set_crop_height (self, height);
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
}

void
page_set_named_crop (Page* self,
                     const gchar* name)
{
	gdouble w = 0.0;
	gdouble h = 0.0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	gint pw = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint ph = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("A3")))) {
		switch (0) {
			default:
			{
				w = 11.7;
				h = 16.5;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("A4")))) {
		switch (0) {
			default:
			{
				w = 8.3;
				h = 11.7;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("A5")))) {
		switch (0) {
			default:
			{
				w = 5.8;
				h = 8.3;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("A6")))) {
		switch (0) {
			default:
			{
				w = 4.1;
				h = 5.8;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("letter")))) {
		switch (0) {
			default:
			{
				w = 8.5;
				h = (gdouble) 11;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("legal")))) {
		switch (0) {
			default:
			{
				w = 8.5;
				h = (gdouble) 14;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("4x6")))) {
		switch (0) {
			default:
			{
				w = (gdouble) 4;
				h = (gdouble) 6;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("page.vala:431: Unknown paper size '%s'", name);
				return;
			}
		}
	}
	page_set_crop_name (self, name);
	page_set_has_crop (self, TRUE);
	_tmp3_ = page_get_width (self);
	_tmp4_ = _tmp3_;
	pw = _tmp4_;
	_tmp5_ = page_get_height (self);
	_tmp6_ = _tmp5_;
	ph = _tmp6_;
	if (pw > ph) {
		gdouble t = 0.0;
		t = w;
		w = h;
		h = t;
	}
	_tmp7_ = self->priv->_dpi;
	page_set_crop_width (self, (gint) ((w * _tmp7_) + 0.5));
	_tmp8_ = self->priv->_dpi;
	page_set_crop_height (self, (gint) ((h * _tmp8_) + 0.5));
	_tmp9_ = self->priv->_crop_width;
	if (_tmp9_ < pw) {
		gint _tmp10_;
		_tmp10_ = self->priv->_crop_width;
		page_set_crop_x (self, (pw - _tmp10_) / 2);
	} else {
		page_set_crop_x (self, 0);
	}
	_tmp11_ = self->priv->_crop_height;
	if (_tmp11_ < ph) {
		gint _tmp12_;
		_tmp12_ = self->priv->_crop_height;
		page_set_crop_y (self, (ph - _tmp12_) / 2);
	} else {
		page_set_crop_y (self, 0);
	}
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
}

void
page_move_crop (Page* self,
                gint x,
                gint y)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x >= 0);
	g_return_if_fail (y >= 0);
	_tmp0_ = page_get_width (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (x < _tmp1_);
	_tmp2_ = page_get_height (self);
	_tmp3_ = _tmp2_;
	g_return_if_fail (y < _tmp3_);
	page_set_crop_x (self, x);
	page_set_crop_y (self, y);
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
}

void
page_rotate_crop (Page* self)
{
	gboolean _tmp0_;
	gint t = 0;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_has_crop;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_crop_width;
	t = _tmp1_;
	_tmp2_ = self->priv->_crop_height;
	page_set_crop_width (self, _tmp2_);
	page_set_crop_height (self, t);
	_tmp3_ = self->priv->_crop_name;
	if (_tmp3_ == NULL) {
		gint w = 0;
		gint _tmp4_;
		gint _tmp5_;
		gint h = 0;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp15_;
		_tmp4_ = page_get_width (self);
		_tmp5_ = _tmp4_;
		w = _tmp5_;
		_tmp6_ = page_get_height (self);
		_tmp7_ = _tmp6_;
		h = _tmp7_;
		_tmp8_ = self->priv->_crop_x;
		_tmp9_ = self->priv->_crop_width;
		if ((_tmp8_ + _tmp9_) > w) {
			gint _tmp10_;
			_tmp10_ = self->priv->_crop_width;
			page_set_crop_x (self, w - _tmp10_);
		}
		_tmp11_ = self->priv->_crop_x;
		if (_tmp11_ < 0) {
			page_set_crop_x (self, 0);
			page_set_crop_width (self, w);
		}
		_tmp12_ = self->priv->_crop_y;
		_tmp13_ = self->priv->_crop_height;
		if ((_tmp12_ + _tmp13_) > h) {
			gint _tmp14_;
			_tmp14_ = self->priv->_crop_height;
			page_set_crop_y (self, h - _tmp14_);
		}
		_tmp15_ = self->priv->_crop_y;
		if (_tmp15_ < 0) {
			page_set_crop_y (self, 0);
			page_set_crop_height (self, h);
		}
	}
	g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
}

guchar*
page_get_pixels (Page* self,
                 gint* result_length1)
{
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixels;
	_tmp0__length1 = self->priv->pixels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static guchar
page_get_sample (Page* self,
                 guchar* pixels,
                 gint pixels_length1,
                 gint offset,
                 gint x,
                 gint depth,
                 gint n_channels,
                 gint channel)
{
	guchar result;
	g_return_val_if_fail (self != NULL, '\0');
	result = (guchar) 0xFF;
	return result;
}

static void
page_get_pixel (Page* self,
                gint x,
                gint y,
                guchar* pixel,
                gint pixel_length1,
                gint offset)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	gint line_offset = 0;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_;
	guchar* _tmp35_;
	gint _tmp35__length1;
	gint _tmp36_;
	gint _tmp37_;
	guchar* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gint _tmp40_;
	guchar* _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_scan_direction (self);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			gint _tmp2_;
			gint _tmp3_;
			_tmp2_ = self->priv->_scan_width;
			x = (_tmp2_ - x) - 1;
			_tmp3_ = self->priv->_scan_height;
			y = (_tmp3_ - y) - 1;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			gint t = 0;
			gint _tmp4_;
			t = x;
			_tmp4_ = self->priv->_scan_width;
			x = (_tmp4_ - y) - 1;
			y = t;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			gint t = 0;
			gint _tmp5_;
			t = x;
			x = y;
			_tmp5_ = self->priv->_scan_height;
			y = (_tmp5_ - t) - 1;
			break;
		}
		default:
		break;
	}
	_tmp6_ = self->priv->_rowstride;
	line_offset = _tmp6_ * y;
	_tmp8_ = self->priv->_depth;
	if (_tmp8_ == 8) {
		gint _tmp9_;
		_tmp9_ = self->priv->_n_channels;
		_tmp7_ = _tmp9_ == 3;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint o = 0;
		gint _tmp10_;
		guchar* _tmp11_;
		gint _tmp11__length1;
		guchar _tmp12_;
		guchar* _tmp13_;
		gint _tmp13__length1;
		guchar _tmp14_;
		guchar* _tmp15_;
		gint _tmp15__length1;
		guchar _tmp16_;
		_tmp10_ = self->priv->_n_channels;
		o = line_offset + (x * _tmp10_);
		_tmp11_ = self->priv->pixels;
		_tmp11__length1 = self->priv->pixels_length1;
		_tmp12_ = _tmp11_[o];
		pixel[offset + 0] = _tmp12_;
		_tmp13_ = self->priv->pixels;
		_tmp13__length1 = self->priv->pixels_length1;
		_tmp14_ = _tmp13_[o + 1];
		pixel[offset + 1] = _tmp14_;
		_tmp15_ = self->priv->pixels;
		_tmp15__length1 = self->priv->pixels_length1;
		_tmp16_ = _tmp15_[o + 2];
		pixel[offset + 2] = _tmp16_;
		return;
	} else {
		gboolean _tmp17_ = FALSE;
		gint _tmp18_;
		_tmp18_ = self->priv->_depth;
		if (_tmp18_ == 8) {
			gint _tmp19_;
			_tmp19_ = self->priv->_n_channels;
			_tmp17_ = _tmp19_ == 1;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			guchar p = '\0';
			guchar* _tmp20_;
			gint _tmp20__length1;
			guchar _tmp21_;
			_tmp20_ = self->priv->pixels;
			_tmp20__length1 = self->priv->pixels_length1;
			_tmp21_ = _tmp20_[line_offset + x];
			p = _tmp21_;
			pixel[offset + 2] = p;
			pixel[offset + 1] = pixel[offset + 2];
			pixel[offset + 0] = pixel[offset + 1];
			return;
		} else {
			gboolean _tmp22_ = FALSE;
			gint _tmp23_;
			_tmp23_ = self->priv->_depth;
			if (_tmp23_ == 1) {
				gint _tmp24_;
				_tmp24_ = self->priv->_n_channels;
				_tmp22_ = _tmp24_ == 1;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				guchar p = '\0';
				guchar* _tmp25_;
				gint _tmp25__length1;
				guchar _tmp26_;
				gint _tmp27_ = 0;
				_tmp25_ = self->priv->pixels;
				_tmp25__length1 = self->priv->pixels_length1;
				_tmp26_ = _tmp25_[line_offset + (x / 8)];
				p = _tmp26_;
				if (((gint) (p & (0x80 >> (x % 8)))) != 0) {
					_tmp27_ = 0x00;
				} else {
					_tmp27_ = 0xFF;
				}
				pixel[offset + 2] = (guchar) _tmp27_;
				pixel[offset + 1] = pixel[offset + 2];
				pixel[offset + 0] = pixel[offset + 1];
				return;
			} else {
				gboolean _tmp28_ = FALSE;
				gint _tmp29_;
				_tmp29_ = self->priv->_depth;
				if (_tmp29_ == 2) {
					gint _tmp30_;
					_tmp30_ = self->priv->_n_channels;
					_tmp28_ = _tmp30_ == 1;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					gint block_shift[4] = {0};
					gint _tmp31_[4] = {0};
					guchar p = '\0';
					guchar* _tmp32_;
					gint _tmp32__length1;
					guchar _tmp33_;
					gint sample = 0;
					gint _tmp34_;
					_tmp31_[0] = 6;
					_tmp31_[1] = 4;
					_tmp31_[2] = 2;
					_tmp31_[3] = 0;
					memcpy (block_shift, _tmp31_, 4 * sizeof (gint));
					_tmp32_ = self->priv->pixels;
					_tmp32__length1 = self->priv->pixels_length1;
					_tmp33_ = _tmp32_[line_offset + (x / 4)];
					p = _tmp33_;
					_tmp34_ = block_shift[x % 4];
					sample = (p >> _tmp34_) & 0x3;
					sample = (sample * 255) / 3;
					pixel[offset + 2] = (guchar) sample;
					pixel[offset + 1] = pixel[offset + 2];
					pixel[offset + 0] = pixel[offset + 1];
					return;
				}
			}
		}
	}
	_tmp35_ = self->priv->pixels;
	_tmp35__length1 = self->priv->pixels_length1;
	_tmp36_ = self->priv->_depth;
	_tmp37_ = self->priv->_n_channels;
	pixel[offset + 0] = page_get_sample (self, _tmp35_, (gint) _tmp35__length1, line_offset, x, _tmp36_, _tmp37_, 0);
	_tmp38_ = self->priv->pixels;
	_tmp38__length1 = self->priv->pixels_length1;
	_tmp39_ = self->priv->_depth;
	_tmp40_ = self->priv->_n_channels;
	pixel[offset + 1] = page_get_sample (self, _tmp38_, (gint) _tmp38__length1, line_offset, x, _tmp39_, _tmp40_, 1);
	_tmp41_ = self->priv->pixels;
	_tmp41__length1 = self->priv->pixels_length1;
	_tmp42_ = self->priv->_depth;
	_tmp43_ = self->priv->_n_channels;
	pixel[offset + 2] = page_get_sample (self, _tmp41_, (gint) _tmp41__length1, line_offset, x, _tmp42_, _tmp43_, 2);
}

GdkPixbuf*
page_get_image (Page* self,
                gboolean apply_crop)
{
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp18_;
	guint8* image_pixels = NULL;
	GdkPixbuf* _tmp19_;
	guint8* _tmp20_;
	gint image_pixels_length1;
	gint _image_pixels_size_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (apply_crop) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_has_crop;
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp2_ = self->priv->_crop_x;
		l = _tmp2_;
		_tmp3_ = self->priv->_crop_width;
		r = l + _tmp3_;
		_tmp4_ = self->priv->_crop_y;
		t = _tmp4_;
		_tmp5_ = self->priv->_crop_height;
		b = t + _tmp5_;
		if (l < 0) {
			l = 0;
		}
		_tmp6_ = page_get_width (self);
		_tmp7_ = _tmp6_;
		if (r > _tmp7_) {
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = page_get_width (self);
			_tmp9_ = _tmp8_;
			r = _tmp9_;
		}
		if (t < 0) {
			t = 0;
		}
		_tmp10_ = page_get_height (self);
		_tmp11_ = _tmp10_;
		if (b > _tmp11_) {
			gint _tmp12_;
			gint _tmp13_;
			_tmp12_ = page_get_height (self);
			_tmp13_ = _tmp12_;
			b = _tmp13_;
		}
	} else {
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		l = 0;
		_tmp14_ = page_get_width (self);
		_tmp15_ = _tmp14_;
		r = _tmp15_;
		t = 0;
		_tmp16_ = page_get_height (self);
		_tmp17_ = _tmp16_;
		b = _tmp17_;
	}
	_tmp18_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, r - l, b - t);
	image = _tmp18_;
	_tmp19_ = image;
	_tmp20_ = gdk_pixbuf_get_pixels (_tmp19_);
	image_pixels = _tmp20_;
	image_pixels_length1 = -1;
	_image_pixels_size_ = image_pixels_length1;
	{
		gint y = 0;
		y = t;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint offset = 0;
				GdkPixbuf* _tmp23_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = y;
					y = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(y < b)) {
					break;
				}
				_tmp23_ = image;
				offset = gdk_pixbuf_get_rowstride (_tmp23_) * (y - t);
				{
					gint x = 0;
					x = l;
					{
						gboolean _tmp24_ = FALSE;
						_tmp24_ = TRUE;
						while (TRUE) {
							guint8* _tmp26_;
							gint _tmp26__length1;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = x;
								x = _tmp25_ + 1;
							}
							_tmp24_ = FALSE;
							if (!(x < r)) {
								break;
							}
							_tmp26_ = image_pixels;
							_tmp26__length1 = image_pixels_length1;
							page_get_pixel (self, x, y, _tmp26_, (gint) _tmp26__length1, offset + ((x - l) * 3));
						}
					}
				}
			}
		}
	}
	result = image;
	return result;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

gchar*
page_get_icc_data_encoded (Page* self)
{
	const gchar* _tmp0_;
	gchar* contents = NULL;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gchar* _tmp7_;
	guchar* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_color_profile;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->_color_profile;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("page.vala:642: failed to get icc profile data: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (contents);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = contents;
	_tmp7_ = string_to_utf8 (_tmp5_, &_tmp6_);
	_tmp8_ = (guchar*) _tmp7_;
	_tmp8__length1 = (_tmp6_ * sizeof (gchar)) / sizeof (guchar);
	_tmp9_ = g_base64_encode (_tmp8_, (gint) ((_tmp6_ * sizeof (gchar)) / sizeof (guchar)));
	_tmp10_ = _tmp9_;
	_tmp8_ = (g_free (_tmp8_), NULL);
	result = _tmp10_;
	_g_free0 (contents);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
page_copy_to_clipboard (Page* self,
                        GtkWindow* window)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = page_get_image (self, TRUE);
	image = _tmp4_;
	gtk_clipboard_set_image (clipboard, image);
	_g_object_unref0 (image);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Page* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->stream);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda21_ (Block5Data* _data5_,
             guint8* buf,
             gsize buf_length1,
             GError** error)
{
	Page* self;
	GFileOutputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = _data5_->stream;
	g_output_stream_write_all ((GOutputStream*) _tmp0_, buf, (gsize) buf_length1, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda21__gdk_pixbuf_save_func (guint8* buf,
                                   gsize count,
                                   GError** error,
                                   gpointer self)
{
	gboolean result;
	result = __lambda21_ (self, buf, count, error);
	return result;
}

void
page_save_png (Page* self,
               GFile* file,
               GError** error)
{
	Block5Data* _data5_;
	GFileOutputStream* _tmp0_;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp1_;
	gchar* icc_profile_data = NULL;
	const gchar* _tmp2_;
	gchar** keys = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint keys_length1;
	gint _keys_size_;
	gchar** values = NULL;
	gint _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp15_;
	GdkPixbuf* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
	_data5_->stream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp1_ = page_get_image (self, TRUE);
	image = _tmp1_;
	icc_profile_data = NULL;
	_tmp2_ = self->priv->_color_profile;
	if (_tmp2_ != NULL) {
		gchar* _tmp3_;
		_tmp3_ = page_get_icc_data_encoded (self);
		_g_free0 (icc_profile_data);
		icc_profile_data = _tmp3_;
	}
	_tmp4_ = g_strdup ("x-dpi");
	_tmp5_ = g_strdup ("y-dpi");
	_tmp6_ = g_strdup ("icc-profile");
	_tmp7_ = g_new0 (gchar*, 4 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	_tmp7_[3] = NULL;
	keys = _tmp7_;
	keys_length1 = 4;
	_keys_size_ = keys_length1;
	_tmp8_ = self->priv->_dpi;
	_tmp9_ = g_strdup_printf ("%d", _tmp8_);
	_tmp10_ = self->priv->_dpi;
	_tmp11_ = g_strdup_printf ("%d", _tmp10_);
	_tmp12_ = icc_profile_data;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = g_new0 (gchar*, 4 + 1);
	_tmp14_[0] = _tmp9_;
	_tmp14_[1] = _tmp11_;
	_tmp14_[2] = _tmp13_;
	_tmp14_[3] = NULL;
	values = _tmp14_;
	values_length1 = 4;
	_values_size_ = values_length1;
	_tmp15_ = icc_profile_data;
	if (_tmp15_ == NULL) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = keys;
		_tmp16__length1 = keys_length1;
		_g_free0 (_tmp16_[2]);
		_tmp16_[2] = NULL;
	}
	_tmp17_ = image;
	_tmp18_ = keys;
	_tmp18__length1 = keys_length1;
	_tmp19_ = values;
	_tmp19__length1 = values_length1;
	gdk_pixbuf_save_to_callbackv (_tmp17_, ___lambda21__gdk_pixbuf_save_func, _data5_, "png", _tmp18_, _tmp19_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (icc_profile_data);
		_g_object_unref0 (image);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (icc_profile_data);
	_g_object_unref0 (image);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

gint
page_get_width (Page* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = page_get_scan_direction (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		ScanDirection _tmp3_;
		ScanDirection _tmp4_;
		_tmp3_ = page_get_scan_direction (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	if (_tmp0_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_scan_width;
		result = _tmp5_;
		return result;
	} else {
		gint _tmp6_;
		_tmp6_ = self->priv->_scan_height;
		result = _tmp6_;
		return result;
	}
}

gint
page_get_height (Page* self)
{
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = page_get_scan_direction (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		ScanDirection _tmp3_;
		ScanDirection _tmp4_;
		_tmp3_ = page_get_scan_direction (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	if (_tmp0_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_scan_height;
		result = _tmp5_;
		return result;
	} else {
		gint _tmp6_;
		_tmp6_ = self->priv->_scan_width;
		result = _tmp6_;
		return result;
	}
}

gboolean
page_get_is_landscape (Page* self)
{
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = page_get_width (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_height (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ > _tmp3_;
	return result;
}

gint
page_get_dpi (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_dpi;
	return result;
}

static void
page_set_dpi (Page* self,
              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_dpi (self);
	if (old_value != value) {
		self->priv->_dpi = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_DPI_PROPERTY]);
	}
}

gint
page_get_depth (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_depth;
	return result;
}

static void
page_set_depth (Page* self,
                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_depth (self);
	if (old_value != value) {
		self->priv->_depth = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_DEPTH_PROPERTY]);
	}
}

const gchar*
page_get_color_profile (Page* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_color_profile;
	result = _tmp0_;
	return result;
}

void
page_set_color_profile (Page* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_color_profile (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_color_profile);
		self->priv->_color_profile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_COLOR_PROFILE_PROPERTY]);
	}
}

gint
page_get_scan_width (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scan_width;
	return result;
}

static void
page_set_scan_width (Page* self,
                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_scan_width (self);
	if (old_value != value) {
		self->priv->_scan_width = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_SCAN_WIDTH_PROPERTY]);
	}
}

gint
page_get_scan_height (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scan_height;
	return result;
}

static void
page_set_scan_height (Page* self,
                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_scan_height (self);
	if (old_value != value) {
		self->priv->_scan_height = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_SCAN_HEIGHT_PROPERTY]);
	}
}

gint
page_get_rowstride (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rowstride;
	return result;
}

static void
page_set_rowstride (Page* self,
                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_rowstride (self);
	if (old_value != value) {
		self->priv->_rowstride = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_ROWSTRIDE_PROPERTY]);
	}
}

gint
page_get_n_channels (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_channels;
	return result;
}

static void
page_set_n_channels (Page* self,
                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_n_channels (self);
	if (old_value != value) {
		self->priv->_n_channels = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_N_CHANNELS_PROPERTY]);
	}
}

gboolean
page_get_is_scanning (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_scanning;
	return result;
}

static void
page_set_is_scanning (Page* self,
                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_is_scanning (self);
	if (old_value != value) {
		self->priv->_is_scanning = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_IS_SCANNING_PROPERTY]);
	}
}

gboolean
page_get_has_data (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_data;
	return result;
}

static void
page_set_has_data (Page* self,
                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_has_data (self);
	if (old_value != value) {
		self->priv->_has_data = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_HAS_DATA_PROPERTY]);
	}
}

gint
page_get_scan_line (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_scan_line;
	return result;
}

static void
page_set_scan_line (Page* self,
                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_scan_line (self);
	if (old_value != value) {
		self->priv->_scan_line = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_SCAN_LINE_PROPERTY]);
	}
}

gboolean
page_get_is_color (Page* self)
{
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_n_channels;
	result = _tmp0_ > 1;
	return result;
}

ScanDirection
page_get_scan_direction (Page* self)
{
	ScanDirection result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->scan_direction_;
	return result;
}

void
page_set_scan_direction (Page* self,
                         ScanDirection value)
{
	gboolean size_has_changed = FALSE;
	gint left_steps = 0;
	gboolean _tmp0_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	if (self->priv->scan_direction_ == value) {
		return;
	}
	size_has_changed = FALSE;
	left_steps = (gint) (value - self->priv->scan_direction_);
	if (left_steps < 0) {
		left_steps += 4;
	}
	if (left_steps != 2) {
		size_has_changed = TRUE;
	}
	_tmp0_ = self->priv->_has_crop;
	if (_tmp0_) {
		switch (left_steps) {
			case 1:
			{
				gint t = 0;
				gint _tmp1_;
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp1_ = self->priv->_crop_x;
				t = _tmp1_;
				_tmp2_ = self->priv->_crop_y;
				page_set_crop_x (self, _tmp2_);
				_tmp3_ = page_get_width (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = self->priv->_crop_width;
				page_set_crop_y (self, _tmp4_ - (t + _tmp5_));
				_tmp6_ = self->priv->_crop_width;
				t = _tmp6_;
				_tmp7_ = self->priv->_crop_height;
				page_set_crop_width (self, _tmp7_);
				page_set_crop_height (self, t);
				break;
			}
			case 2:
			{
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				_tmp8_ = page_get_width (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->_crop_x;
				_tmp11_ = self->priv->_crop_width;
				page_set_crop_x (self, _tmp9_ - (_tmp10_ + _tmp11_));
				_tmp12_ = page_get_width (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = self->priv->_crop_y;
				_tmp15_ = self->priv->_crop_height;
				page_set_crop_y (self, _tmp13_ - (_tmp14_ + _tmp15_));
				break;
			}
			case 3:
			{
				gint t = 0;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp16_ = self->priv->_crop_y;
				t = _tmp16_;
				_tmp17_ = self->priv->_crop_x;
				page_set_crop_y (self, _tmp17_);
				_tmp18_ = page_get_height (self);
				_tmp19_ = _tmp18_;
				_tmp20_ = self->priv->_crop_height;
				page_set_crop_x (self, _tmp19_ - (t + _tmp20_));
				_tmp21_ = self->priv->_crop_width;
				t = _tmp21_;
				_tmp22_ = self->priv->_crop_height;
				page_set_crop_width (self, _tmp22_);
				page_set_crop_height (self, t);
				break;
			}
			default:
			break;
		}
	}
	self->priv->scan_direction_ = value;
	if (size_has_changed) {
		g_signal_emit (self, page_signals[PAGE_SIZE_CHANGED_SIGNAL], 0);
	}
	g_signal_emit (self, page_signals[PAGE_SCAN_DIRECTION_CHANGED_SIGNAL], 0);
	_tmp23_ = self->priv->_has_crop;
	if (_tmp23_) {
		g_signal_emit (self, page_signals[PAGE_CROP_CHANGED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_SCAN_DIRECTION_PROPERTY]);
}

gboolean
page_get_has_crop (Page* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_crop;
	return result;
}

static void
page_set_has_crop (Page* self,
                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_has_crop (self);
	if (old_value != value) {
		self->priv->_has_crop = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_HAS_CROP_PROPERTY]);
	}
}

const gchar*
page_get_crop_name (Page* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_crop_name;
	result = _tmp0_;
	return result;
}

static void
page_set_crop_name (Page* self,
                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_crop_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_crop_name);
		self->priv->_crop_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_CROP_NAME_PROPERTY]);
	}
}

gint
page_get_crop_x (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_x;
	return result;
}

static void
page_set_crop_x (Page* self,
                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_crop_x (self);
	if (old_value != value) {
		self->priv->_crop_x = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_CROP_X_PROPERTY]);
	}
}

gint
page_get_crop_y (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_y;
	return result;
}

static void
page_set_crop_y (Page* self,
                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_crop_y (self);
	if (old_value != value) {
		self->priv->_crop_y = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_CROP_Y_PROPERTY]);
	}
}

gint
page_get_crop_width (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_width;
	return result;
}

static void
page_set_crop_width (Page* self,
                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_crop_width (self);
	if (old_value != value) {
		self->priv->_crop_width = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_CROP_WIDTH_PROPERTY]);
	}
}

gint
page_get_crop_height (Page* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_height;
	return result;
}

static void
page_set_crop_height (Page* self,
                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_get_crop_height (self);
	if (old_value != value) {
		self->priv->_crop_height = value;
		g_object_notify_by_pspec ((GObject *) self, page_properties[PAGE_CROP_HEIGHT_PROPERTY]);
	}
}

static void
page_class_init (PageClass * klass,
                 gpointer klass_data)
{
	page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Page_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_WIDTH_PROPERTY, page_properties[PAGE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_HEIGHT_PROPERTY, page_properties[PAGE_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_IS_LANDSCAPE_PROPERTY, page_properties[PAGE_IS_LANDSCAPE_PROPERTY] = g_param_spec_boolean ("is-landscape", "is-landscape", "is-landscape", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_DPI_PROPERTY, page_properties[PAGE_DPI_PROPERTY] = g_param_spec_int ("dpi", "dpi", "dpi", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_DEPTH_PROPERTY, page_properties[PAGE_DEPTH_PROPERTY] = g_param_spec_int ("depth", "depth", "depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_COLOR_PROFILE_PROPERTY, page_properties[PAGE_COLOR_PROFILE_PROPERTY] = g_param_spec_string ("color-profile", "color-profile", "color-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_SCAN_WIDTH_PROPERTY, page_properties[PAGE_SCAN_WIDTH_PROPERTY] = g_param_spec_int ("scan-width", "scan-width", "scan-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_SCAN_HEIGHT_PROPERTY, page_properties[PAGE_SCAN_HEIGHT_PROPERTY] = g_param_spec_int ("scan-height", "scan-height", "scan-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_ROWSTRIDE_PROPERTY, page_properties[PAGE_ROWSTRIDE_PROPERTY] = g_param_spec_int ("rowstride", "rowstride", "rowstride", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_N_CHANNELS_PROPERTY, page_properties[PAGE_N_CHANNELS_PROPERTY] = g_param_spec_int ("n-channels", "n-channels", "n-channels", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_IS_SCANNING_PROPERTY, page_properties[PAGE_IS_SCANNING_PROPERTY] = g_param_spec_boolean ("is-scanning", "is-scanning", "is-scanning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_HAS_DATA_PROPERTY, page_properties[PAGE_HAS_DATA_PROPERTY] = g_param_spec_boolean ("has-data", "has-data", "has-data", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_SCAN_LINE_PROPERTY, page_properties[PAGE_SCAN_LINE_PROPERTY] = g_param_spec_int ("scan-line", "scan-line", "scan-line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_IS_COLOR_PROPERTY, page_properties[PAGE_IS_COLOR_PROPERTY] = g_param_spec_boolean ("is-color", "is-color", "is-color", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_SCAN_DIRECTION_PROPERTY, page_properties[PAGE_SCAN_DIRECTION_PROPERTY] = g_param_spec_enum ("scan-direction", "scan-direction", "scan-direction", TYPE_SCAN_DIRECTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_HAS_CROP_PROPERTY, page_properties[PAGE_HAS_CROP_PROPERTY] = g_param_spec_boolean ("has-crop", "has-crop", "has-crop", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_CROP_NAME_PROPERTY, page_properties[PAGE_CROP_NAME_PROPERTY] = g_param_spec_string ("crop-name", "crop-name", "crop-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_CROP_X_PROPERTY, page_properties[PAGE_CROP_X_PROPERTY] = g_param_spec_int ("crop-x", "crop-x", "crop-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_CROP_Y_PROPERTY, page_properties[PAGE_CROP_Y_PROPERTY] = g_param_spec_int ("crop-y", "crop-y", "crop-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_CROP_WIDTH_PROPERTY, page_properties[PAGE_CROP_WIDTH_PROPERTY] = g_param_spec_int ("crop-width", "crop-width", "crop-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_CROP_HEIGHT_PROPERTY, page_properties[PAGE_CROP_HEIGHT_PROPERTY] = g_param_spec_int ("crop-height", "crop-height", "crop-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	page_signals[PAGE_PIXELS_CHANGED_SIGNAL] = g_signal_new ("pixels-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_signals[PAGE_SIZE_CHANGED_SIGNAL] = g_signal_new ("size-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_signals[PAGE_SCAN_LINE_CHANGED_SIGNAL] = g_signal_new ("scan-line-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_signals[PAGE_SCAN_DIRECTION_CHANGED_SIGNAL] = g_signal_new ("scan-direction-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_signals[PAGE_CROP_CHANGED_SIGNAL] = g_signal_new ("crop-changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_signals[PAGE_SCAN_FINISHED_SIGNAL] = g_signal_new ("scan-finished", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
page_instance_init (Page * self,
                    gpointer klass)
{
	self->priv = page_get_instance_private (self);
	self->priv->scan_direction_ = SCAN_DIRECTION_TOP_TO_BOTTOM;
}

static void
page_finalize (GObject * obj)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
	_g_free0 (self->priv->_color_profile);
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
	_g_free0 (self->priv->_crop_name);
	G_OBJECT_CLASS (page_parent_class)->finalize (obj);
}

static GType
page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, NULL };
	GType page_type_id;
	page_type_id = g_type_register_static (G_TYPE_OBJECT, "Page", &g_define_type_info, 0);
	Page_private_offset = g_type_add_instance_private (page_type_id, sizeof (PagePrivate));
	return page_type_id;
}

GType
page_get_type (void)
{
	static volatile gsize page_type_id__once = 0;
	if (g_once_init_enter (&page_type_id__once)) {
		GType page_type_id;
		page_type_id = page_get_type_once ();
		g_once_init_leave (&page_type_id__once, page_type_id);
	}
	return page_type_id__once;
}

static void
_vala_page_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE, Page);
	switch (property_id) {
		case PAGE_WIDTH_PROPERTY:
		g_value_set_int (value, page_get_width (self));
		break;
		case PAGE_HEIGHT_PROPERTY:
		g_value_set_int (value, page_get_height (self));
		break;
		case PAGE_IS_LANDSCAPE_PROPERTY:
		g_value_set_boolean (value, page_get_is_landscape (self));
		break;
		case PAGE_DPI_PROPERTY:
		g_value_set_int (value, page_get_dpi (self));
		break;
		case PAGE_DEPTH_PROPERTY:
		g_value_set_int (value, page_get_depth (self));
		break;
		case PAGE_COLOR_PROFILE_PROPERTY:
		g_value_set_string (value, page_get_color_profile (self));
		break;
		case PAGE_SCAN_WIDTH_PROPERTY:
		g_value_set_int (value, page_get_scan_width (self));
		break;
		case PAGE_SCAN_HEIGHT_PROPERTY:
		g_value_set_int (value, page_get_scan_height (self));
		break;
		case PAGE_ROWSTRIDE_PROPERTY:
		g_value_set_int (value, page_get_rowstride (self));
		break;
		case PAGE_N_CHANNELS_PROPERTY:
		g_value_set_int (value, page_get_n_channels (self));
		break;
		case PAGE_IS_SCANNING_PROPERTY:
		g_value_set_boolean (value, page_get_is_scanning (self));
		break;
		case PAGE_HAS_DATA_PROPERTY:
		g_value_set_boolean (value, page_get_has_data (self));
		break;
		case PAGE_SCAN_LINE_PROPERTY:
		g_value_set_int (value, page_get_scan_line (self));
		break;
		case PAGE_IS_COLOR_PROPERTY:
		g_value_set_boolean (value, page_get_is_color (self));
		break;
		case PAGE_SCAN_DIRECTION_PROPERTY:
		g_value_set_enum (value, page_get_scan_direction (self));
		break;
		case PAGE_HAS_CROP_PROPERTY:
		g_value_set_boolean (value, page_get_has_crop (self));
		break;
		case PAGE_CROP_NAME_PROPERTY:
		g_value_set_string (value, page_get_crop_name (self));
		break;
		case PAGE_CROP_X_PROPERTY:
		g_value_set_int (value, page_get_crop_x (self));
		break;
		case PAGE_CROP_Y_PROPERTY:
		g_value_set_int (value, page_get_crop_y (self));
		break;
		case PAGE_CROP_WIDTH_PROPERTY:
		g_value_set_int (value, page_get_crop_width (self));
		break;
		case PAGE_CROP_HEIGHT_PROPERTY:
		g_value_set_int (value, page_get_crop_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_page_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE, Page);
	switch (property_id) {
		case PAGE_DPI_PROPERTY:
		page_set_dpi (self, g_value_get_int (value));
		break;
		case PAGE_DEPTH_PROPERTY:
		page_set_depth (self, g_value_get_int (value));
		break;
		case PAGE_COLOR_PROFILE_PROPERTY:
		page_set_color_profile (self, g_value_get_string (value));
		break;
		case PAGE_SCAN_WIDTH_PROPERTY:
		page_set_scan_width (self, g_value_get_int (value));
		break;
		case PAGE_SCAN_HEIGHT_PROPERTY:
		page_set_scan_height (self, g_value_get_int (value));
		break;
		case PAGE_ROWSTRIDE_PROPERTY:
		page_set_rowstride (self, g_value_get_int (value));
		break;
		case PAGE_N_CHANNELS_PROPERTY:
		page_set_n_channels (self, g_value_get_int (value));
		break;
		case PAGE_IS_SCANNING_PROPERTY:
		page_set_is_scanning (self, g_value_get_boolean (value));
		break;
		case PAGE_HAS_DATA_PROPERTY:
		page_set_has_data (self, g_value_get_boolean (value));
		break;
		case PAGE_SCAN_LINE_PROPERTY:
		page_set_scan_line (self, g_value_get_int (value));
		break;
		case PAGE_SCAN_DIRECTION_PROPERTY:
		page_set_scan_direction (self, g_value_get_enum (value));
		break;
		case PAGE_HAS_CROP_PROPERTY:
		page_set_has_crop (self, g_value_get_boolean (value));
		break;
		case PAGE_CROP_NAME_PROPERTY:
		page_set_crop_name (self, g_value_get_string (value));
		break;
		case PAGE_CROP_X_PROPERTY:
		page_set_crop_x (self, g_value_get_int (value));
		break;
		case PAGE_CROP_Y_PROPERTY:
		page_set_crop_y (self, g_value_get_int (value));
		break;
		case PAGE_CROP_WIDTH_PROPERTY:
		page_set_crop_width (self, g_value_get_int (value));
		break;
		case PAGE_CROP_HEIGHT_PROPERTY:
		page_set_crop_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

