/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLineCommands;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineLoggingUtility;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import us.fatehi.utility.Utility;

public final class SchemaCrawlerCommandLine {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerCommandLine.class.getName());

    public static void execute(String[] args) {
        ShellState state = new ShellState();
        try {
            Objects.requireNonNull(args, "No arguments provided");
            state.setDeferCatalogLoad(true);
            StateFactory stateFactory = new StateFactory(state);
            SchemaCrawlerCommandLineCommands commands = new SchemaCrawlerCommandLineCommands();
            CommandLine commandLine = CommandLineUtility.newCommandLine(commands, stateFactory);
            CommandLineUtility.addPluginCommands(commandLine, CommandLineUtility.catalogLoaderPluginCommands);
            CommandLineUtility.addPluginCommands(commandLine, CommandLineUtility.commandPluginCommands);
            commandLine.parseArgs(args);
            SchemaCrawlerCommandLine.executeCommandLine(commandLine);
        }
        catch (Throwable throwable) {
            Throwable cause;
            CommandLineLoggingUtility.logSafeArguments(args, state);
            CommandLineLoggingUtility.logFatalStackTrace(throwable);
            String errorMessage = throwable instanceof CommandLine.PicocliException ? ((cause = throwable.getCause()) != null && !Utility.isBlank((CharSequence)cause.getMessage()) ? cause.getMessage() : throwable.getMessage()) : throwable.getMessage();
            CommandLineUtility.printCommandLineErrorMessage(errorMessage, state);
            System.exit(1);
        }
    }

    private static void executeCommandLine(CommandLine commandLine) {
        Map subcommands = commandLine.getMixins();
        for (String commandName : new String[]{"log", "configfile", "connect", "limit", "grep", "filter", "showstate", "load", "execute"}) {
            Runnable command = (Runnable)subcommands.get(commandName);
            LOGGER.log(Level.INFO, "Running command " + command.getClass().getSimpleName());
            command.run();
        }
    }

    private SchemaCrawlerCommandLine() {
    }
}

