#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <libinput.h>

#include <wlr/backend.h>
#include <wlr/backend/headless.h>
#include <wlr/backend/libinput.h>
#include <wlr/render/allocator.h>
#include <wlr/render/wlr_renderer.h>
#include <wlr/types/wlr_cursor.h>
#include <wlr/types/wlr_compositor.h>
#include <wlr/types/wlr_data_control_v1.h>
#include <wlr/types/wlr_data_device.h>
#include <wlr/types/wlr_foreign_toplevel_management_v1.h>
#include <wlr/types/wlr_gamma_control_v1.h>
#include <wlr/types/wlr_idle.h>
#include <wlr/types/wlr_idle_inhibit_v1.h>
#include <wlr/types/wlr_input_inhibitor.h>
#include <wlr/types/wlr_keyboard.h>
#include <wlr/types/wlr_layer_shell_v1.h>
#include <wlr/types/wlr_linux_dmabuf_v1.h>
#include <wlr/types/wlr_matrix.h>
#include <wlr/types/wlr_output.h>
#include <wlr/types/wlr_output_damage.h>
#include <wlr/types/wlr_output_layout.h>
#include <wlr/types/wlr_output_management_v1.h>
#include <wlr/types/wlr_output_power_management_v1.h>
#include <wlr/types/wlr_pointer_constraints_v1.h>
#include <wlr/types/wlr_primary_selection_v1.h>
#include <wlr/types/wlr_relative_pointer_v1.h>
#include <wlr/types/wlr_scene.h>
#include <wlr/types/wlr_screencopy_v1.h>
#include <wlr/types/wlr_surface.h>
#include <wlr/types/wlr_seat.h>
#include <wlr/types/wlr_server_decoration.h>
#include <wlr/types/wlr_virtual_keyboard_v1.h>
#include <wlr/types/wlr_xcursor_manager.h>
#include <wlr/types/wlr_xdg_decoration_v1.h>
#include <wlr/types/wlr_xdg_output_v1.h>
#include <wlr/types/wlr_xdg_shell.h>
#include <wlr/util/log.h>
#include <wlr/util/region.h>
#include <wlr/version.h>

#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>
#include <xkbcommon/xkbcommon-compose.h>

struct wl_listener_container {
    void *handle;
    struct wl_listener destroy_listener;
};

typedef void (*wrapped_log_func_t)(enum wlr_log_importance importance, const char *log_str);

wrapped_log_func_t py_callback = NULL;

void wrapped_log_callback(enum wlr_log_importance importance, const char *fmt, va_list args)
{
    char formatted_str[4096];
    vsnprintf(formatted_str, 4096, fmt, args);
    py_callback(importance, formatted_str);
}

void wrapped_log_init(enum wlr_log_importance verbosity, wrapped_log_func_t callback)
{
    if (callback == NULL)
    {
        wlr_log_init(verbosity, NULL);
    }
    else
    {
        py_callback = callback;
        wlr_log_init(verbosity, wrapped_log_callback);
    }
}

    #include <wlr/xwayland.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, double)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // struct libinput_device *
/*  2 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_accel_profile)
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum libinput_config_accel_profile
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_click_method)
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 10 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum libinput_config_click_method
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_drag_lock_state)
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 14 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum libinput_config_drag_lock_state
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_drag_state)
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 18 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum libinput_config_drag_state
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_dwt_state)
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 22 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum libinput_config_dwt_state
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_middle_emulation_state)
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 26 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum libinput_config_middle_emulation_state
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_scroll_method)
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 30 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum libinput_config_scroll_method
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_tap_button_map)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 34 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum libinput_config_tap_button_map
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, enum libinput_config_tap_state)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 38 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum libinput_config_tap_state
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, int)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // enum libinput_config_status()(struct libinput_device *, uint32_t)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // int()(int, uint32_t, void *)
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 50 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 51 */ _CFFI_OP(_CFFI_OP_POINTER, 335), // void *
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // int()(int, void *)
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // int()(struct libinput_device *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // int()(void *)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // int()(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 64 */ _CFFI_OP(_CFFI_OP_POINTER, 335), // void const *
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 66 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 165), // struct wl_message const *
/* 68 */ _CFFI_OP(_CFFI_OP_POINTER, 325), // union wl_argument *
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(enum wlr_log_importance, char const *)
/* 71 */ _CFFI_OP(_CFFI_OP_ENUM, 22), // enum wlr_log_importance
/* 72 */ _CFFI_OP(_CFFI_OP_POINTER, 102), // char const *
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(struct wl_client *, void *, uint32_t, uint32_t)
/* 75 */ _CFFI_OP(_CFFI_OP_POINTER, 155), // struct wl_client *
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(struct wl_listener *, void *)
/* 81 */ _CFFI_OP(_CFFI_OP_POINTER, 163), // struct wl_listener *
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(struct wl_resource *)
/* 85 */ _CFFI_OP(_CFFI_OP_POINTER, 168), // struct wl_resource *
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(struct wlr_surface *, int, int, void *)
/* 88 */ _CFFI_OP(_CFFI_OP_POINTER, 272), // struct wlr_surface *
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 90 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(struct xkb_keymap *, uint32_t, void *)
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 321), // struct xkb_keymap *
/* 95 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 335), // void()(void *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // FILE
/* 102 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 103 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum libinput_config_status
/* 104 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum wl_data_device_manager_dnd_action
/* 105 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum wl_keyboard_key_state
/* 106 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum wl_output_subpixel
/* 107 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum wl_output_transform
/* 108 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // enum wlr_axis_orientation
/* 109 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // enum wlr_axis_source
/* 110 */ _CFFI_OP(_CFFI_OP_ENUM, 16), // enum wlr_button_state
/* 111 */ _CFFI_OP(_CFFI_OP_ENUM, 17), // enum wlr_drag_grab_type
/* 112 */ _CFFI_OP(_CFFI_OP_ENUM, 18), // enum wlr_edges
/* 113 */ _CFFI_OP(_CFFI_OP_ENUM, 19), // enum wlr_input_device_type
/* 114 */ _CFFI_OP(_CFFI_OP_ENUM, 20), // enum wlr_keyboard_led
/* 115 */ _CFFI_OP(_CFFI_OP_ENUM, 21), // enum wlr_keyboard_modifier
/* 116 */ _CFFI_OP(_CFFI_OP_ENUM, 23), // enum wlr_pointer_constraint_v1_state_field
/* 117 */ _CFFI_OP(_CFFI_OP_ENUM, 24), // enum wlr_pointer_constraint_v1_type
/* 118 */ _CFFI_OP(_CFFI_OP_ENUM, 25), // enum wlr_scene_node_type
/* 119 */ _CFFI_OP(_CFFI_OP_ENUM, 26), // enum wlr_server_decoration_manager_mode
/* 120 */ _CFFI_OP(_CFFI_OP_ENUM, 27), // enum wlr_xdg_surface_role
/* 121 */ _CFFI_OP(_CFFI_OP_ENUM, 28), // enum wlr_xdg_toplevel_decoration_v1_mode
/* 122 */ _CFFI_OP(_CFFI_OP_ENUM, 29), // enum wlr_xwayland_icccm_input_model
/* 123 */ _CFFI_OP(_CFFI_OP_ENUM, 30), // enum wlr_xwayland_surface_decorations
/* 124 */ _CFFI_OP(_CFFI_OP_ENUM, 31), // enum xcb_stack_mode_t
/* 125 */ _CFFI_OP(_CFFI_OP_ENUM, 32), // enum xdg_positioner_anchor
/* 126 */ _CFFI_OP(_CFFI_OP_ENUM, 33), // enum xdg_positioner_constraint_adjustment
/* 127 */ _CFFI_OP(_CFFI_OP_ENUM, 34), // enum xdg_positioner_gravity
/* 128 */ _CFFI_OP(_CFFI_OP_ENUM, 35), // enum xkb_compose_compile_flags
/* 129 */ _CFFI_OP(_CFFI_OP_ENUM, 36), // enum xkb_compose_feed_result
/* 130 */ _CFFI_OP(_CFFI_OP_ENUM, 37), // enum xkb_compose_format
/* 131 */ _CFFI_OP(_CFFI_OP_ENUM, 38), // enum xkb_compose_state_flags
/* 132 */ _CFFI_OP(_CFFI_OP_ENUM, 39), // enum xkb_compose_status
/* 133 */ _CFFI_OP(_CFFI_OP_ENUM, 40), // enum xkb_context_flags
/* 134 */ _CFFI_OP(_CFFI_OP_ENUM, 41), // enum xkb_key_direction
/* 135 */ _CFFI_OP(_CFFI_OP_ENUM, 42), // enum xkb_keymap_compile_flags
/* 136 */ _CFFI_OP(_CFFI_OP_ENUM, 43), // enum xkb_keymap_format
/* 137 */ _CFFI_OP(_CFFI_OP_ENUM, 44), // enum xkb_keysym_flags
/* 138 */ _CFFI_OP(_CFFI_OP_ENUM, 45), // enum xkb_log_level
/* 139 */ _CFFI_OP(_CFFI_OP_ENUM, 46), // enum xkb_state_component
/* 140 */ _CFFI_OP(_CFFI_OP_ENUM, 47), // enum xkb_state_match
/* 141 */ _CFFI_OP(_CFFI_OP_ENUM, 48), // enum zwlr_layer_shell_v1_layer
/* 142 */ _CFFI_OP(_CFFI_OP_ENUM, 49), // enum zwlr_layer_surface_v1_keyboard_interactivity
/* 143 */ _CFFI_OP(_CFFI_OP_ENUM, 50), // enum zwlr_output_power_v1_mode
/* 144 */ _CFFI_OP(_CFFI_OP_ENUM, 51), // enum zwp_pointer_constraints_v1_lifetime
/* 145 */ _CFFI_OP(_CFFI_OP_POINTER, 48), // int(*)(int, uint32_t, void *)
/* 146 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // int(*)(int, void *)
/* 147 */ _CFFI_OP(_CFFI_OP_POINTER, 60), // int(*)(void *)
/* 148 */ _CFFI_OP(_CFFI_OP_POINTER, 63), // int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 149 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 150 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct libinput_device
/* 151 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct pixman_box32
/* 152 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct pixman_region32
/* 153 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct timespec
/* 154 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct wl_array
/* 155 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct wl_client
/* 156 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct wl_display
/* 157 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct wl_event_loop
/* 158 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct wl_event_queue
/* 159 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct wl_event_source
/* 160 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct wl_global
/* 161 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct wl_interface
/* 162 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct wl_list
/* 163 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct wl_listener
/* 164 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct wl_listener_container
/* 165 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct wl_message
/* 166 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct wl_object
/* 167 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct wl_proxy
/* 168 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct wl_resource
/* 169 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct wl_signal
/* 170 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct wlr_allocator
/* 171 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct wlr_backend
/* 172 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // struct wlr_backend_impl
/* 173 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // struct wlr_box
/* 174 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // struct wlr_buffer
/* 175 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // struct wlr_client_buffer
/* 176 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // struct wlr_compositor
/* 177 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // struct wlr_cursor
/* 178 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // struct wlr_cursor_state
/* 179 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // struct wlr_data_control_manager_v1
/* 180 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // struct wlr_data_device_manager
/* 181 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // struct wlr_data_source
/* 182 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // struct wlr_data_source_impl
/* 183 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // struct wlr_drag
/* 184 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // struct wlr_drag_drop_event
/* 185 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // struct wlr_drag_icon
/* 186 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // struct wlr_drag_motion_event
/* 187 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // struct wlr_event_keyboard_key
/* 188 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // struct wlr_event_pointer_axis
/* 189 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // struct wlr_event_pointer_button
/* 190 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // struct wlr_event_pointer_motion
/* 191 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // struct wlr_event_pointer_motion_absolute
/* 192 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // struct wlr_event_pointer_pinch_begin
/* 193 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // struct wlr_event_pointer_pinch_end
/* 194 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // struct wlr_event_pointer_pinch_update
/* 195 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // struct wlr_event_pointer_swipe_begin
/* 196 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // struct wlr_event_pointer_swipe_end
/* 197 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // struct wlr_event_pointer_swipe_update
/* 198 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // struct wlr_fbox
/* 199 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // struct wlr_foreign_toplevel_handle_v1
/* 200 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // struct wlr_foreign_toplevel_handle_v1_activated_event
/* 201 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // struct wlr_foreign_toplevel_handle_v1_fullscreen_event
/* 202 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 58), // struct wlr_foreign_toplevel_handle_v1_maximized_event
/* 203 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 59), // struct wlr_foreign_toplevel_handle_v1_minimized_event
/* 204 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 60), // struct wlr_foreign_toplevel_handle_v1_set_rectangle_event
/* 205 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 61), // struct wlr_foreign_toplevel_manager_v1
/* 206 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 62), // struct wlr_gamma_control_manager_v1
/* 207 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 63), // struct wlr_idle
/* 208 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 64), // struct wlr_idle_inhibit_manager_v1
/* 209 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 65), // struct wlr_idle_inhibitor_v1
/* 210 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 66), // struct wlr_idle_timeout
/* 211 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 67), // struct wlr_input_device
/* 212 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 68), // struct wlr_input_device_impl
/* 213 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 69), // struct wlr_input_inhibit_manager
/* 214 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 70), // struct wlr_keyboard
/* 215 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 71), // struct wlr_keyboard_grab_interface
/* 216 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 72), // struct wlr_keyboard_group
/* 217 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 73), // struct wlr_keyboard_impl
/* 218 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 74), // struct wlr_keyboard_modifiers
/* 219 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 75), // struct wlr_layer_shell_v1
/* 220 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 76), // struct wlr_layer_surface_v1
/* 221 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 77), // struct wlr_layer_surface_v1_state
/* 222 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 78), // struct wlr_linux_dmabuf_v1
/* 223 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 79), // struct wlr_output
/* 224 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 80), // struct wlr_output_configuration_head_v1
/* 225 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 81), // struct wlr_output_configuration_v1
/* 226 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 82), // struct wlr_output_cursor
/* 227 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 83), // struct wlr_output_damage
/* 228 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 84), // struct wlr_output_head_v1_state
/* 229 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 85), // struct wlr_output_impl
/* 230 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 86), // struct wlr_output_layout
/* 231 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 87), // struct wlr_output_layout_state
/* 232 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 88), // struct wlr_output_manager_v1
/* 233 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 89), // struct wlr_output_mode
/* 234 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 90), // struct wlr_output_power_manager_v1
/* 235 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 91), // struct wlr_output_power_v1
/* 236 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 92), // struct wlr_output_power_v1_set_mode_event
/* 237 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 93), // struct wlr_output_state
/* 238 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 94), // struct wlr_pointer
/* 239 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 95), // struct wlr_pointer_constraint_v1
/* 240 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 96), // struct wlr_pointer_constraint_v1_state
/* 241 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 97), // struct wlr_pointer_constraints_v1
/* 242 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 98), // struct wlr_pointer_grab_interface
/* 243 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 99), // struct wlr_pointer_impl
/* 244 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 100), // struct wlr_primary_selection_source
/* 245 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 101), // struct wlr_primary_selection_v1_device_manager
/* 246 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 102), // struct wlr_relative_pointer_manager_v1
/* 247 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 103), // struct wlr_relative_pointer_v1
/* 248 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 104), // struct wlr_renderer
/* 249 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 105), // struct wlr_scene
/* 250 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 106), // struct wlr_scene_node
/* 251 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 107), // struct wlr_scene_node_state
/* 252 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 108), // struct wlr_scene_output
/* 253 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 109), // struct wlr_screencopy_manager_v1
/* 254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 110), // struct wlr_seat
/* 255 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 111), // struct wlr_seat_client
/* 256 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 112), // struct wlr_seat_keyboard_focus_change_event
/* 257 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 113), // struct wlr_seat_keyboard_grab
/* 258 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 114), // struct wlr_seat_keyboard_state
/* 259 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 115), // struct wlr_seat_pointer_focus_change_event
/* 260 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 116), // struct wlr_seat_pointer_grab
/* 261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 117), // struct wlr_seat_pointer_request_set_cursor_event
/* 262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 118), // struct wlr_seat_pointer_state
/* 263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 119), // struct wlr_seat_request_set_selection_event
/* 264 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 120), // struct wlr_seat_request_start_drag_event
/* 265 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 121), // struct wlr_seat_touch_grab
/* 266 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 122), // struct wlr_seat_touch_state
/* 267 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 123), // struct wlr_server_decoration_manager
/* 268 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 124), // struct wlr_session
/* 269 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 125), // struct wlr_subcompositor
/* 270 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 126), // struct wlr_subsurface
/* 271 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 127), // struct wlr_subsurface_parent_state
/* 272 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 128), // struct wlr_surface
/* 273 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 129), // struct wlr_surface_output
/* 274 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 130), // struct wlr_surface_role
/* 275 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 131), // struct wlr_surface_state
/* 276 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 132), // struct wlr_switch
/* 277 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 133), // struct wlr_tablet
/* 278 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 134), // struct wlr_tablet_pad
/* 279 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 135), // struct wlr_texture
/* 280 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 136), // struct wlr_touch
/* 281 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 137), // struct wlr_touch_grab_interface
/* 282 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 138), // struct wlr_virtual_keyboard_manager_v1
/* 283 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 139), // struct wlr_virtual_keyboard_v1
/* 284 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 140), // struct wlr_xcursor_manager
/* 285 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 141), // struct wlr_xdg_client
/* 286 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 142), // struct wlr_xdg_decoration_manager_v1
/* 287 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 143), // struct wlr_xdg_output_manager_v1
/* 288 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 144), // struct wlr_xdg_popup
/* 289 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 145), // struct wlr_xdg_positioner
/* 290 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 146), // struct wlr_xdg_shell
/* 291 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 147), // struct wlr_xdg_surface
/* 292 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 148), // struct wlr_xdg_surface_configure
/* 293 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 149), // struct wlr_xdg_surface_state
/* 294 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 150), // struct wlr_xdg_toplevel
/* 295 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 151), // struct wlr_xdg_toplevel_configure
/* 296 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 152), // struct wlr_xdg_toplevel_decoration_v1
/* 297 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 153), // struct wlr_xdg_toplevel_decoration_v1_configure
/* 298 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 154), // struct wlr_xdg_toplevel_decoration_v1_state
/* 299 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 155), // struct wlr_xdg_toplevel_move_event
/* 300 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 156), // struct wlr_xdg_toplevel_requested
/* 301 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 157), // struct wlr_xdg_toplevel_resize_event
/* 302 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 158), // struct wlr_xdg_toplevel_set_fullscreen_event
/* 303 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 159), // struct wlr_xdg_toplevel_show_window_menu_event
/* 304 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 160), // struct wlr_xdg_toplevel_state
/* 305 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 161), // struct wlr_xwayland
/* 306 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 162), // struct wlr_xwayland_cursor
/* 307 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 163), // struct wlr_xwayland_minimize_event
/* 308 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 164), // struct wlr_xwayland_move_event
/* 309 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 165), // struct wlr_xwayland_remove_startup_info_event
/* 310 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 166), // struct wlr_xwayland_resize_event
/* 311 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 167), // struct wlr_xwayland_server
/* 312 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 168), // struct wlr_xwayland_server_options
/* 313 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 169), // struct wlr_xwayland_surface
/* 314 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 170), // struct wlr_xwayland_surface_configure_event
/* 315 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 171), // struct wlr_xwayland_surface_hints
/* 316 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 172), // struct wlr_xwayland_surface_size_hints
/* 317 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 173), // struct wlr_xwm
/* 318 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 176), // struct xkb_compose_state
/* 319 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 177), // struct xkb_compose_table
/* 320 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 178), // struct xkb_context
/* 321 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 179), // struct xkb_keymap
/* 322 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 180), // struct xkb_rule_names
/* 323 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 181), // struct xkb_state
/* 324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 325 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // union wl_argument
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 327 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // va_list
/* 328 */ _CFFI_OP(_CFFI_OP_POINTER, 70), // void(*)(enum wlr_log_importance, char const *)
/* 329 */ _CFFI_OP(_CFFI_OP_POINTER, 74), // void(*)(struct wl_client *, void *, uint32_t, uint32_t)
/* 330 */ _CFFI_OP(_CFFI_OP_POINTER, 80), // void(*)(struct wl_listener *, void *)
/* 331 */ _CFFI_OP(_CFFI_OP_POINTER, 84), // void(*)(struct wl_resource *)
/* 332 */ _CFFI_OP(_CFFI_OP_POINTER, 87), // void(*)(struct wlr_surface *, int, int, void *)
/* 333 */ _CFFI_OP(_CFFI_OP_POINTER, 93), // void(*)(struct xkb_keymap *, uint32_t, void *)
/* 334 */ _CFFI_OP(_CFFI_OP_POINTER, 98), // void(*)(void *)
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
/* 336 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // xcb_connection_t
/* 337 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // xcb_generic_error_t
/* 338 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // xcb_generic_event_t
/* 339 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 174), // xcb_intern_atom_cookie_t
/* 340 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 175), // xcb_intern_atom_reply_t
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_generic_event_t(xcb_generic_event_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_typedef_xcb_generic_event_t { char x; xcb_generic_event_t y; };

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_NONE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_NONE) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_NONE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_NONE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_NONE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_NONE) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_NONE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DRAG_LOCK_DISABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DRAG_LOCK_DISABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DRAG_LOCK_DISABLED) | 0);  /* check that LIBINPUT_CONFIG_DRAG_LOCK_DISABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DRAG_LOCK_ENABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DRAG_LOCK_ENABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DRAG_LOCK_ENABLED) | 0);  /* check that LIBINPUT_CONFIG_DRAG_LOCK_ENABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DRAG_DISABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DRAG_DISABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DRAG_DISABLED) | 0);  /* check that LIBINPUT_CONFIG_DRAG_DISABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DRAG_ENABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DRAG_ENABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DRAG_ENABLED) | 0);  /* check that LIBINPUT_CONFIG_DRAG_ENABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DWT_DISABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DWT_DISABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DWT_DISABLED) | 0);  /* check that LIBINPUT_CONFIG_DWT_DISABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_DWT_ENABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_DWT_ENABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_DWT_ENABLED) | 0);  /* check that LIBINPUT_CONFIG_DWT_ENABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED) | 0);  /* check that LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED) | 0);  /* check that LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_NO_SCROLL(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_NO_SCROLL) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_NO_SCROLL) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_NO_SCROLL is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_2FG(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_2FG) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_2FG) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_2FG is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_EDGE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_EDGE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_EDGE) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_EDGE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_STATUS_SUCCESS(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_STATUS_SUCCESS) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_STATUS_SUCCESS) | 0);  /* check that LIBINPUT_CONFIG_STATUS_SUCCESS is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_STATUS_UNSUPPORTED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_STATUS_UNSUPPORTED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_STATUS_UNSUPPORTED) | 0);  /* check that LIBINPUT_CONFIG_STATUS_UNSUPPORTED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_STATUS_INVALID(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_STATUS_INVALID) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_STATUS_INVALID) | 0);  /* check that LIBINPUT_CONFIG_STATUS_INVALID is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_MAP_LRM(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_MAP_LRM) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_MAP_LRM) | 0);  /* check that LIBINPUT_CONFIG_TAP_MAP_LRM is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_MAP_LMR(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_MAP_LMR) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_MAP_LMR) | 0);  /* check that LIBINPUT_CONFIG_TAP_MAP_LMR is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_DISABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_DISABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_DISABLED) | 0);  /* check that LIBINPUT_CONFIG_TAP_DISABLED is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_ENABLED(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_ENABLED) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_ENABLED) | 0);  /* check that LIBINPUT_CONFIG_TAP_ENABLED is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_ORIENTATION_VERTICAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_VERTICAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_VERTICAL) | 0);  /* check that WLR_AXIS_ORIENTATION_VERTICAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_HORIZONTAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_HORIZONTAL) | 0);  /* check that WLR_AXIS_ORIENTATION_HORIZONTAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_FINGER(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_FINGER) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_FINGER) | 0);  /* check that WLR_AXIS_SOURCE_FINGER is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_CONTINUOUS(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_CONTINUOUS) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_CONTINUOUS) | 0);  /* check that WLR_AXIS_SOURCE_CONTINUOUS is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL_TILT) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL_TILT) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL_TILT is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_RELEASED(unsigned long long *o)
{
  int n = (WLR_BUTTON_RELEASED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_RELEASED) | 0);  /* check that WLR_BUTTON_RELEASED is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_PRESSED(unsigned long long *o)
{
  int n = (WLR_BUTTON_PRESSED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_PRESSED) | 0);  /* check that WLR_BUTTON_PRESSED is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_NONE(unsigned long long *o)
{
  int n = (WLR_EDGE_NONE) <= 0;
  *o = (unsigned long long)((WLR_EDGE_NONE) | 0);  /* check that WLR_EDGE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_TOP(unsigned long long *o)
{
  int n = (WLR_EDGE_TOP) <= 0;
  *o = (unsigned long long)((WLR_EDGE_TOP) | 0);  /* check that WLR_EDGE_TOP is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_BOTTOM(unsigned long long *o)
{
  int n = (WLR_EDGE_BOTTOM) <= 0;
  *o = (unsigned long long)((WLR_EDGE_BOTTOM) | 0);  /* check that WLR_EDGE_BOTTOM is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_LEFT(unsigned long long *o)
{
  int n = (WLR_EDGE_LEFT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_LEFT) | 0);  /* check that WLR_EDGE_LEFT is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_RIGHT(unsigned long long *o)
{
  int n = (WLR_EDGE_RIGHT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_RIGHT) | 0);  /* check that WLR_EDGE_RIGHT is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_KEYBOARD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_KEYBOARD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_KEYBOARD) | 0);  /* check that WLR_INPUT_DEVICE_KEYBOARD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_POINTER(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_POINTER) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_POINTER) | 0);  /* check that WLR_INPUT_DEVICE_POINTER is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TOUCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TOUCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TOUCH) | 0);  /* check that WLR_INPUT_DEVICE_TOUCH is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_TOOL) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_TOOL) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_TOOL is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_PAD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_PAD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_PAD) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_PAD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_SWITCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_SWITCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_SWITCH) | 0);  /* check that WLR_INPUT_DEVICE_SWITCH is an integer */
  return n;
}

static int _cffi_const_WLR_LED_NUM_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_NUM_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_NUM_LOCK) | 0);  /* check that WLR_LED_NUM_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_CAPS_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_CAPS_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_CAPS_LOCK) | 0);  /* check that WLR_LED_CAPS_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_SCROLL_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_SCROLL_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_SCROLL_LOCK) | 0);  /* check that WLR_LED_SCROLL_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_SHIFT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_SHIFT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_SHIFT) | 0);  /* check that WLR_MODIFIER_SHIFT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CAPS(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CAPS) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CAPS) | 0);  /* check that WLR_MODIFIER_CAPS is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CTRL(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CTRL) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CTRL) | 0);  /* check that WLR_MODIFIER_CTRL is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_ALT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_ALT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_ALT) | 0);  /* check that WLR_MODIFIER_ALT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD2(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD2) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD2) | 0);  /* check that WLR_MODIFIER_MOD2 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD3(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD3) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD3) | 0);  /* check that WLR_MODIFIER_MOD3 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_LOGO(unsigned long long *o)
{
  int n = (WLR_MODIFIER_LOGO) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_LOGO) | 0);  /* check that WLR_MODIFIER_LOGO is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD5(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD5) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD5) | 0);  /* check that WLR_MODIFIER_MOD5 is an integer */
  return n;
}

static int _cffi_const_WLR_SILENT(unsigned long long *o)
{
  int n = (WLR_SILENT) <= 0;
  *o = (unsigned long long)((WLR_SILENT) | 0);  /* check that WLR_SILENT is an integer */
  return n;
}

static int _cffi_const_WLR_ERROR(unsigned long long *o)
{
  int n = (WLR_ERROR) <= 0;
  *o = (unsigned long long)((WLR_ERROR) | 0);  /* check that WLR_ERROR is an integer */
  return n;
}

static int _cffi_const_WLR_INFO(unsigned long long *o)
{
  int n = (WLR_INFO) <= 0;
  *o = (unsigned long long)((WLR_INFO) | 0);  /* check that WLR_INFO is an integer */
  return n;
}

static int _cffi_const_WLR_DEBUG(unsigned long long *o)
{
  int n = (WLR_DEBUG) <= 0;
  *o = (unsigned long long)((WLR_DEBUG) | 0);  /* check that WLR_DEBUG is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_REGION) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_REGION) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_REGION is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_LOCKED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_LOCKED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_LOCKED is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_CONFINED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_CONFINED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_CONFINED is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_NONE) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_SERVER is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_NONE) | 0);  /* check that WLR_XDG_SURFACE_ROLE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_TOPLEVEL) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_TOPLEVEL) | 0);  /* check that WLR_XDG_SURFACE_ROLE_TOPLEVEL is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_POPUP(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_POPUP) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_POPUP) | 0);  /* check that WLR_XDG_SURFACE_ROLE_POPUP is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_NONE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_NONE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_NONE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_PASSIVE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_PASSIVE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_PASSIVE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_LOCAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_LOCAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_LOCAL is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_GLOBAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_GLOBAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_GLOBAL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_ALL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPILE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_IGNORED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_IGNORED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_IGNORED) | 0);  /* check that XKB_COMPOSE_FEED_IGNORED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_ACCEPTED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_ACCEPTED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_ACCEPTED) | 0);  /* check that XKB_COMPOSE_FEED_ACCEPTED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FORMAT_TEXT_V1) | 0);  /* check that XKB_COMPOSE_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_STATE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_STATE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_STATE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_STATE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_NOTHING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_NOTHING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_NOTHING) | 0);  /* check that XKB_COMPOSE_NOTHING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSING) | 0);  /* check that XKB_COMPOSE_COMPOSING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSED) | 0);  /* check that XKB_COMPOSE_COMPOSED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_CANCELLED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_CANCELLED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_CANCELLED) | 0);  /* check that XKB_COMPOSE_CANCELLED is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_FLAGS) | 0);  /* check that XKB_CONTEXT_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_DEFAULT_INCLUDES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_DEFAULT_INCLUDES) | 0);  /* check that XKB_CONTEXT_NO_DEFAULT_INCLUDES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_ENVIRONMENT_NAMES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_ENVIRONMENT_NAMES) | 0);  /* check that XKB_CONTEXT_NO_ENVIRONMENT_NAMES is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_UP(unsigned long long *o)
{
  int n = (XKB_KEY_UP) <= 0;
  *o = (unsigned long long)((XKB_KEY_UP) | 0);  /* check that XKB_KEY_UP is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_DOWN(unsigned long long *o)
{
  int n = (XKB_KEY_DOWN) <= 0;
  *o = (unsigned long long)((XKB_KEY_DOWN) | 0);  /* check that XKB_KEY_DOWN is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYMAP_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_COMPILE_NO_FLAGS) | 0);  /* check that XKB_KEYMAP_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_KEYMAP_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_FORMAT_TEXT_V1) | 0);  /* check that XKB_KEYMAP_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYSYM_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_NO_FLAGS) | 0);  /* check that XKB_KEYSYM_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_CASE_INSENSITIVE(unsigned long long *o)
{
  int n = (XKB_KEYSYM_CASE_INSENSITIVE) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_CASE_INSENSITIVE) | 0);  /* check that XKB_KEYSYM_CASE_INSENSITIVE is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_CRITICAL(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_CRITICAL) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_CRITICAL) | 0);  /* check that XKB_LOG_LEVEL_CRITICAL is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_ERROR(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_ERROR) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_ERROR) | 0);  /* check that XKB_LOG_LEVEL_ERROR is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_WARNING(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_WARNING) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_WARNING) | 0);  /* check that XKB_LOG_LEVEL_WARNING is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_INFO(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_INFO) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_INFO) | 0);  /* check that XKB_LOG_LEVEL_INFO is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_DEBUG(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_DEBUG) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_DEBUG) | 0);  /* check that XKB_LOG_LEVEL_DEBUG is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_DEPRESSED) | 0);  /* check that XKB_STATE_MODS_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LATCHED) | 0);  /* check that XKB_STATE_MODS_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LOCKED) | 0);  /* check that XKB_STATE_MODS_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_EFFECTIVE) | 0);  /* check that XKB_STATE_MODS_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_DEPRESSED) | 0);  /* check that XKB_STATE_LAYOUT_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LATCHED) | 0);  /* check that XKB_STATE_LAYOUT_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LOCKED) | 0);  /* check that XKB_STATE_LAYOUT_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_EFFECTIVE) | 0);  /* check that XKB_STATE_LAYOUT_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LEDS(unsigned long long *o)
{
  int n = (XKB_STATE_LEDS) <= 0;
  *o = (unsigned long long)((XKB_STATE_LEDS) | 0);  /* check that XKB_STATE_LEDS is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ANY(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ANY) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ANY) | 0);  /* check that XKB_STATE_MATCH_ANY is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ALL(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ALL) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ALL) | 0);  /* check that XKB_STATE_MATCH_ALL is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_NON_EXCLUSIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_NON_EXCLUSIVE) | 0);  /* check that XKB_STATE_MATCH_NON_EXCLUSIVE is an integer */
  return n;
}

static int _cffi_d_libinput_device_config_accel_is_available(struct libinput_device * x0)
{
  return libinput_device_config_accel_is_available(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_accel_is_available(PyObject *self, PyObject *arg0)
{
  struct libinput_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_accel_is_available(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_accel_is_available _cffi_d_libinput_device_config_accel_is_available
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_accel_set_profile(struct libinput_device * x0, enum libinput_config_accel_profile x1)
{
  return libinput_device_config_accel_set_profile(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_accel_set_profile(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_accel_profile x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_accel_set_profile", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(6), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_accel_set_profile(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_accel_set_profile _cffi_d_libinput_device_config_accel_set_profile
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_accel_set_speed(struct libinput_device * x0, double x1)
{
  return libinput_device_config_accel_set_speed(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_accel_set_speed(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_accel_set_speed", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_accel_set_speed(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_accel_set_speed _cffi_d_libinput_device_config_accel_set_speed
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_click_set_method(struct libinput_device * x0, enum libinput_config_click_method x1)
{
  return libinput_device_config_click_set_method(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_click_set_method(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_click_method x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_click_set_method", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(10), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_click_set_method(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_click_set_method _cffi_d_libinput_device_config_click_set_method
#endif

static int _cffi_d_libinput_device_config_dwt_is_available(struct libinput_device * x0)
{
  return libinput_device_config_dwt_is_available(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_dwt_is_available(PyObject *self, PyObject *arg0)
{
  struct libinput_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_dwt_is_available(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_dwt_is_available _cffi_d_libinput_device_config_dwt_is_available
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_dwt_set_enabled(struct libinput_device * x0, enum libinput_config_dwt_state x1)
{
  return libinput_device_config_dwt_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_dwt_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_dwt_state x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_dwt_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_dwt_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_dwt_set_enabled _cffi_d_libinput_device_config_dwt_set_enabled
#endif

static int _cffi_d_libinput_device_config_left_handed_is_available(struct libinput_device * x0)
{
  return libinput_device_config_left_handed_is_available(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_left_handed_is_available(PyObject *self, PyObject *arg0)
{
  struct libinput_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_left_handed_is_available(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_left_handed_is_available _cffi_d_libinput_device_config_left_handed_is_available
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_left_handed_set(struct libinput_device * x0, int x1)
{
  return libinput_device_config_left_handed_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_left_handed_set(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_left_handed_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_left_handed_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_left_handed_set _cffi_d_libinput_device_config_left_handed_set
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_middle_emulation_set_enabled(struct libinput_device * x0, enum libinput_config_middle_emulation_state x1)
{
  return libinput_device_config_middle_emulation_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_middle_emulation_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_middle_emulation_state x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_middle_emulation_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(26), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_middle_emulation_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_middle_emulation_set_enabled _cffi_d_libinput_device_config_middle_emulation_set_enabled
#endif

static int _cffi_d_libinput_device_config_scroll_has_natural_scroll(struct libinput_device * x0)
{
  return libinput_device_config_scroll_has_natural_scroll(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_scroll_has_natural_scroll(PyObject *self, PyObject *arg0)
{
  struct libinput_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_scroll_has_natural_scroll(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_scroll_has_natural_scroll _cffi_d_libinput_device_config_scroll_has_natural_scroll
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_scroll_set_button(struct libinput_device * x0, uint32_t x1)
{
  return libinput_device_config_scroll_set_button(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_scroll_set_button(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_scroll_set_button", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_scroll_set_button(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_scroll_set_button _cffi_d_libinput_device_config_scroll_set_button
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_scroll_set_method(struct libinput_device * x0, enum libinput_config_scroll_method x1)
{
  return libinput_device_config_scroll_set_method(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_scroll_set_method(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_scroll_method x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_scroll_set_method", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(30), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_scroll_set_method(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_scroll_set_method _cffi_d_libinput_device_config_scroll_set_method
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_scroll_set_natural_scroll_enabled(struct libinput_device * x0, int x1)
{
  return libinput_device_config_scroll_set_natural_scroll_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_scroll_set_natural_scroll_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_scroll_set_natural_scroll_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_scroll_set_natural_scroll_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_scroll_set_natural_scroll_enabled _cffi_d_libinput_device_config_scroll_set_natural_scroll_enabled
#endif

static int _cffi_d_libinput_device_config_tap_get_finger_count(struct libinput_device * x0)
{
  return libinput_device_config_tap_get_finger_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_tap_get_finger_count(PyObject *self, PyObject *arg0)
{
  struct libinput_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_tap_get_finger_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_tap_get_finger_count _cffi_d_libinput_device_config_tap_get_finger_count
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_tap_set_button_map(struct libinput_device * x0, enum libinput_config_tap_button_map x1)
{
  return libinput_device_config_tap_set_button_map(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_tap_set_button_map(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_tap_button_map x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_tap_set_button_map", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(34), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_tap_set_button_map(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_tap_set_button_map _cffi_d_libinput_device_config_tap_set_button_map
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_tap_set_drag_enabled(struct libinput_device * x0, enum libinput_config_drag_state x1)
{
  return libinput_device_config_tap_set_drag_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_tap_set_drag_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_drag_state x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_tap_set_drag_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(18), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_tap_set_drag_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_tap_set_drag_enabled _cffi_d_libinput_device_config_tap_set_drag_enabled
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_tap_set_drag_lock_enabled(struct libinput_device * x0, enum libinput_config_drag_lock_state x1)
{
  return libinput_device_config_tap_set_drag_lock_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_tap_set_drag_lock_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_drag_lock_state x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_tap_set_drag_lock_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(14), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_tap_set_drag_lock_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_tap_set_drag_lock_enabled _cffi_d_libinput_device_config_tap_set_drag_lock_enabled
#endif

static enum libinput_config_status _cffi_d_libinput_device_config_tap_set_enabled(struct libinput_device * x0, enum libinput_config_tap_state x1)
{
  return libinput_device_config_tap_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_libinput_device_config_tap_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  enum libinput_config_tap_state x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum libinput_config_status result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "libinput_device_config_tap_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(38), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = libinput_device_config_tap_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_libinput_device_config_tap_set_enabled _cffi_d_libinput_device_config_tap_set_enabled
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_box32(struct pixman_box32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x1) | 0);  /* check that 'struct pixman_box32.x1' is an integer */
  (void)((p->y1) | 0);  /* check that 'struct pixman_box32.y1' is an integer */
  (void)((p->x2) | 0);  /* check that 'struct pixman_box32.x2' is an integer */
  (void)((p->y2) | 0);  /* check that 'struct pixman_box32.y2' is an integer */
}
struct _cffi_align_struct_pixman_box32 { char x; struct pixman_box32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_region32(struct pixman_region32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_pixman_region32 { char x; struct pixman_region32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_timespec(struct timespec *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'struct timespec.tv_sec' is an integer */
  (void)((p->tv_nsec) | 0);  /* check that 'struct timespec.tv_nsec' is an integer */
}
struct _cffi_align_struct_timespec { char x; struct timespec y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_array(struct wl_array *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->size) | 0);  /* check that 'struct wl_array.size' is an integer */
  (void)((p->alloc) | 0);  /* check that 'struct wl_array.alloc' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wl_array { char x; struct wl_array y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_interface(struct wl_interface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->version) | 0);  /* check that 'struct wl_interface.version' is an integer */
  (void)((p->method_count) | 0);  /* check that 'struct wl_interface.method_count' is an integer */
  { struct wl_message const * *tmp = &p->methods; (void)tmp; }
  (void)((p->event_count) | 0);  /* check that 'struct wl_interface.event_count' is an integer */
  { struct wl_message const * *tmp = &p->events; (void)tmp; }
}
struct _cffi_align_struct_wl_interface { char x; struct wl_interface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_list(struct wl_list *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list * *tmp = &p->prev; (void)tmp; }
  { struct wl_list * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_wl_list { char x; struct wl_list y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener(struct wl_listener *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { void(* *tmp)(struct wl_listener *, void *) = &p->notify; (void)tmp; }
}
struct _cffi_align_struct_wl_listener { char x; struct wl_listener y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener_container(struct wl_listener_container *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->handle; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy_listener; (void)tmp; }
}
struct _cffi_align_struct_wl_listener_container { char x; struct wl_listener_container y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_message(struct wl_message *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->signature; (void)tmp; }
  { struct wl_interface const * * *tmp = &p->types; (void)tmp; }
}
struct _cffi_align_struct_wl_message { char x; struct wl_message y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_signal(struct wl_signal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->listener_list; (void)tmp; }
}
struct _cffi_align_struct_wl_signal { char x; struct wl_signal y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_allocator(struct wlr_allocator *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_allocator { char x; struct wlr_allocator y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_backend(struct wlr_backend *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_backend_impl const * *tmp = &p->impl; (void)tmp; }
  /* cannot generate 'struct $1' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_backend { char x; struct wlr_backend y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_box(struct wlr_box *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_box.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_box.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_box.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_box.height' is an integer */
}
struct _cffi_align_struct_wlr_box { char x; struct wlr_box y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_compositor(struct wlr_compositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_subcompositor *tmp = &p->subcompositor; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $3' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_compositor { char x; struct wlr_compositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_cursor(struct wlr_cursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_cursor_state * *tmp = &p->state; (void)tmp; }
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  /* cannot generate 'struct $2' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_cursor { char x; struct wlr_cursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_control_manager_v1(struct wlr_data_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  /* cannot generate 'struct $4' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_data_control_manager_v1 { char x; struct wlr_data_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_source(struct wlr_data_source *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wl_array *tmp = &p->mime_types; (void)tmp; }
  (void)((p->actions) | 0);  /* check that 'struct wlr_data_source.actions' is an integer */
  (void)((p->accepted) | 0);  /* check that 'struct wlr_data_source.accepted' is an integer */
  { enum wl_data_device_manager_dnd_action *tmp = &p->current_dnd_action; (void)tmp; }
  (void)((p->compositor_action) | 0);  /* check that 'struct wlr_data_source.compositor_action' is an integer */
  /* cannot generate 'struct $7' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_data_source { char x; struct wlr_data_source y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag(struct wlr_drag *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_drag_grab_type *tmp = &p->grab_type; (void)tmp; }
  { struct wlr_seat_keyboard_grab *tmp = &p->keyboard_grab; (void)tmp; }
  { struct wlr_seat_pointer_grab *tmp = &p->pointer_grab; (void)tmp; }
  { struct wlr_seat_touch_grab *tmp = &p->touch_grab; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focus_client; (void)tmp; }
  { struct wlr_drag_icon * *tmp = &p->icon; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focus; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->started) | 0);  /* check that 'struct wlr_drag.started' is an integer */
  (void)((p->dropped) | 0);  /* check that 'struct wlr_drag.dropped' is an integer */
  (void)((p->cancelling) | 0);  /* check that 'struct wlr_drag.cancelling' is an integer */
  (void)((p->grab_touch_id) | 0);  /* check that 'struct wlr_drag.grab_touch_id' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_drag.touch_id' is an integer */
  /* cannot generate 'struct $6' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->icon_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag { char x; struct wlr_drag y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_drop_event(struct wlr_drag_drop_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_drop_event.time' is an integer */
}
struct _cffi_align_struct_wlr_drag_drop_event { char x; struct wlr_drag_drop_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_icon(struct wlr_drag_icon *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->mapped) | 0);  /* check that 'struct wlr_drag_icon.mapped' is an integer */
  /* cannot generate 'struct $5' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_icon { char x; struct wlr_drag_icon y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_motion_event(struct wlr_drag_motion_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_motion_event.time' is an integer */
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_motion_event { char x; struct wlr_drag_motion_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_keyboard_key(struct wlr_event_keyboard_key *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_keyboard_key.time_msec' is an integer */
  (void)((p->keycode) | 0);  /* check that 'struct wlr_event_keyboard_key.keycode' is an integer */
  (void)((p->update_state) | 0);  /* check that 'struct wlr_event_keyboard_key.update_state' is an integer */
  { enum wl_keyboard_key_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_keyboard_key { char x; struct wlr_event_keyboard_key y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_axis(struct wlr_event_pointer_axis *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_axis.time_msec' is an integer */
  { enum wlr_axis_source *tmp = &p->source; (void)tmp; }
  { enum wlr_axis_orientation *tmp = &p->orientation; (void)tmp; }
  { double *tmp = &p->delta; (void)tmp; }
  (void)((p->delta_discrete) | 0);  /* check that 'struct wlr_event_pointer_axis.delta_discrete' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_axis { char x; struct wlr_event_pointer_axis y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_button(struct wlr_event_pointer_button *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_button.time_msec' is an integer */
  (void)((p->button) | 0);  /* check that 'struct wlr_event_pointer_button.button' is an integer */
  { enum wlr_button_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_button { char x; struct wlr_event_pointer_button y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_motion(struct wlr_event_pointer_motion *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_motion.time_msec' is an integer */
  { double *tmp = &p->delta_x; (void)tmp; }
  { double *tmp = &p->delta_y; (void)tmp; }
  { double *tmp = &p->unaccel_dx; (void)tmp; }
  { double *tmp = &p->unaccel_dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_motion { char x; struct wlr_event_pointer_motion y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_motion_absolute(struct wlr_event_pointer_motion_absolute *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_motion_absolute.time_msec' is an integer */
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_motion_absolute { char x; struct wlr_event_pointer_motion_absolute y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_begin(struct wlr_event_pointer_pinch_begin *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_begin.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_pinch_begin.fingers' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_pinch_begin { char x; struct wlr_event_pointer_pinch_begin y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_end(struct wlr_event_pointer_pinch_end *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_end.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_event_pointer_pinch_end.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_pinch_end { char x; struct wlr_event_pointer_pinch_end y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_update(struct wlr_event_pointer_pinch_update *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_update.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_pinch_update.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
  { double *tmp = &p->scale; (void)tmp; }
  { double *tmp = &p->rotation; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_pinch_update { char x; struct wlr_event_pointer_pinch_update y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_begin(struct wlr_event_pointer_swipe_begin *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_begin.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_swipe_begin.fingers' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_swipe_begin { char x; struct wlr_event_pointer_swipe_begin y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_end(struct wlr_event_pointer_swipe_end *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_end.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_event_pointer_swipe_end.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_swipe_end { char x; struct wlr_event_pointer_swipe_end y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_update(struct wlr_event_pointer_swipe_update *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_update.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_swipe_update.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_swipe_update { char x; struct wlr_event_pointer_swipe_update y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_fbox(struct wlr_fbox *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  { double *tmp = &p->width; (void)tmp; }
  { double *tmp = &p->height; (void)tmp; }
}
struct _cffi_align_struct_wlr_fbox { char x; struct wlr_fbox y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1(struct wlr_foreign_toplevel_handle_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_source; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  (void)((p->state) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1.state' is an integer */
  /* cannot generate 'struct $9' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1 { char x; struct wlr_foreign_toplevel_handle_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_activated_event(struct wlr_foreign_toplevel_handle_v1_activated_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_activated_event { char x; struct wlr_foreign_toplevel_handle_v1_activated_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event(struct wlr_foreign_toplevel_handle_v1_fullscreen_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_fullscreen_event.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event { char x; struct wlr_foreign_toplevel_handle_v1_fullscreen_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_maximized_event(struct wlr_foreign_toplevel_handle_v1_maximized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->maximized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_maximized_event.maximized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_maximized_event { char x; struct wlr_foreign_toplevel_handle_v1_maximized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_minimized_event(struct wlr_foreign_toplevel_handle_v1_minimized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->minimized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_minimized_event.minimized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_minimized_event { char x; struct wlr_foreign_toplevel_handle_v1_minimized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.height' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event { char x; struct wlr_foreign_toplevel_handle_v1_set_rectangle_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_manager_v1(struct wlr_foreign_toplevel_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_event_loop * *tmp = &p->event_loop; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->toplevels; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $8' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_manager_v1 { char x; struct wlr_foreign_toplevel_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_gamma_control_manager_v1(struct wlr_gamma_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->controls; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $10' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_gamma_control_manager_v1 { char x; struct wlr_gamma_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle(struct wlr_idle *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->idle_timers; (void)tmp; }
  { struct wl_event_loop * *tmp = &p->event_loop; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_idle.enabled' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $11' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle { char x; struct wlr_idle y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibit_manager_v1(struct wlr_idle_inhibit_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->inhibitors; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $13' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibit_manager_v1 { char x; struct wlr_idle_inhibit_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibitor_v1(struct wlr_idle_inhibitor_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $14' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibitor_v1 { char x; struct wlr_idle_inhibitor_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_timeout(struct wlr_idle_timeout *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_source; (void)tmp; }
  (void)((p->idle_state) | 0);  /* check that 'struct wlr_idle_timeout.idle_state' is an integer */
  (void)((p->enabled) | 0);  /* check that 'struct wlr_idle_timeout.enabled' is an integer */
  (void)((p->timeout) | 0);  /* check that 'struct wlr_idle_timeout.timeout' is an integer */
  /* cannot generate 'struct $12' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->input_listener; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_timeout { char x; struct wlr_idle_timeout y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_device(struct wlr_input_device *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device_impl const * *tmp = &p->impl; (void)tmp; }
  { enum wlr_input_device_type *tmp = &p->type; (void)tmp; }
  (void)((p->vendor) | 0);  /* check that 'struct wlr_input_device.vendor' is an integer */
  (void)((p->product) | 0);  /* check that 'struct wlr_input_device.product' is an integer */
  { char * *tmp = &p->name; (void)tmp; }
  { double *tmp = &p->width_mm; (void)tmp; }
  { double *tmp = &p->height_mm; (void)tmp; }
  { char * *tmp = &p->output_name; (void)tmp; }
  { void * *tmp = &p->_device; (void)tmp; }
  { struct wlr_keyboard * *tmp = &p->keyboard; (void)tmp; }
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  { struct wlr_switch * *tmp = &p->switch_device; (void)tmp; }
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  { struct wlr_tablet * *tmp = &p->tablet; (void)tmp; }
  { struct wlr_tablet_pad * *tmp = &p->tablet_pad; (void)tmp; }
  /* cannot generate 'struct $16' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_device { char x; struct wlr_input_device y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_inhibit_manager(struct wlr_input_inhibit_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_client * *tmp = &p->active_client; (void)tmp; }
  { struct wl_resource * *tmp = &p->active_inhibitor; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $17' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_inhibit_manager { char x; struct wlr_input_inhibit_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard(struct wlr_keyboard *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_keyboard_group * *tmp = &p->group; (void)tmp; }
  { char * *tmp = &p->keymap_string; (void)tmp; }
  (void)((p->keymap_size) | 0);  /* check that 'struct wlr_keyboard.keymap_size' is an integer */
  { struct xkb_keymap * *tmp = &p->keymap; (void)tmp; }
  { struct xkb_state * *tmp = &p->xkb_state; (void)tmp; }
  { uint32_t(*tmp)[3] = &p->led_indexes; (void)tmp; }
  { uint32_t(*tmp)[8] = &p->mod_indexes; (void)tmp; }
  { uint32_t(*tmp)[32] = &p->keycodes; (void)tmp; }
  (void)((p->num_keycodes) | 0);  /* check that 'struct wlr_keyboard.num_keycodes' is an integer */
  { struct wlr_keyboard_modifiers *tmp = &p->modifiers; (void)tmp; }
  /* cannot generate 'struct $18' in field 'repeat_info': unknown type name */
  /* cannot generate 'struct $19' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_keyboard { char x; struct wlr_keyboard y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard_modifiers(struct wlr_keyboard_modifiers *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->depressed) | 0);  /* check that 'struct wlr_keyboard_modifiers.depressed' is an integer */
  (void)((p->latched) | 0);  /* check that 'struct wlr_keyboard_modifiers.latched' is an integer */
  (void)((p->locked) | 0);  /* check that 'struct wlr_keyboard_modifiers.locked' is an integer */
  (void)((p->group) | 0);  /* check that 'struct wlr_keyboard_modifiers.group' is an integer */
}
struct _cffi_align_struct_wlr_keyboard_modifiers { char x; struct wlr_keyboard_modifiers y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_shell_v1(struct wlr_layer_shell_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $52' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_shell_v1 { char x; struct wlr_layer_shell_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1(struct wlr_layer_surface_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_layer_shell_v1 * *tmp = &p->shell; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  { char * *tmp = &p->namespace; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_layer_surface_v1.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_layer_surface_v1.configured' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_layer_surface_v1.mapped' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  /* cannot generate 'struct $54' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1 { char x; struct wlr_layer_surface_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1_state(struct wlr_layer_surface_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->anchor) | 0);  /* check that 'struct wlr_layer_surface_v1_state.anchor' is an integer */
  (void)((p->exclusive_zone) | 0);  /* check that 'struct wlr_layer_surface_v1_state.exclusive_zone' is an integer */
  /* cannot generate 'struct $53' in field 'margin': unknown type name */
  { enum zwlr_layer_surface_v1_keyboard_interactivity *tmp = &p->keyboard_interactive; (void)tmp; }
  (void)((p->desired_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_width' is an integer */
  (void)((p->desired_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_height' is an integer */
  (void)((p->actual_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_width' is an integer */
  (void)((p->actual_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_height' is an integer */
  { enum zwlr_layer_shell_v1_layer *tmp = &p->layer; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1_state { char x; struct wlr_layer_surface_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output(struct wlr_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_backend * *tmp = &p->backend; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->description; (void)tmp; }
  { char(*tmp)[56] = &p->make; (void)tmp; }
  { char(*tmp)[16] = &p->model; (void)tmp; }
  { char(*tmp)[16] = &p->serial; (void)tmp; }
  (void)((p->phys_width) | 0);  /* check that 'struct wlr_output.phys_width' is an integer */
  (void)((p->phys_height) | 0);  /* check that 'struct wlr_output.phys_height' is an integer */
  { struct wl_list *tmp = &p->modes; (void)tmp; }
  { struct wlr_output_mode * *tmp = &p->current_mode; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_output.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_output.height' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct wlr_output.refresh' is an integer */
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output.enabled' is an integer */
  { float *tmp = &p->scale; (void)tmp; }
  { enum wl_output_subpixel *tmp = &p->subpixel; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->needs_frame) | 0);  /* check that 'struct wlr_output.needs_frame' is an integer */
  (void)((p->frame_pending) | 0);  /* check that 'struct wlr_output.frame_pending' is an integer */
  { float(*tmp)[9] = &p->transform_matrix; (void)tmp; }
  { struct wlr_output_state *tmp = &p->pending; (void)tmp; }
  /* cannot generate 'struct $20' in field 'events': unknown type name */
  { struct wl_event_source * *tmp = &p->idle_frame; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_done; (void)tmp; }
  (void)((p->attach_render_locks) | 0);  /* check that 'struct wlr_output.attach_render_locks' is an integer */
  { struct wl_list *tmp = &p->cursors; (void)tmp; }
  { struct wlr_output_cursor * *tmp = &p->hardware_cursor; (void)tmp; }
  (void)((p->software_cursor_locks) | 0);  /* check that 'struct wlr_output.software_cursor_locks' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output { char x; struct wlr_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_head_v1(struct wlr_output_configuration_head_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_head_v1_state *tmp = &p->state; (void)tmp; }
  { struct wlr_output_configuration_v1 * *tmp = &p->config; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_head_v1 { char x; struct wlr_output_configuration_head_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_v1(struct wlr_output_configuration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  { struct wlr_output_manager_v1 * *tmp = &p->manager; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_configuration_v1.serial' is an integer */
  (void)((p->finalized) | 0);  /* check that 'struct wlr_output_configuration_v1.finalized' is an integer */
  (void)((p->finished) | 0);  /* check that 'struct wlr_output_configuration_v1.finished' is an integer */
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_v1 { char x; struct wlr_output_configuration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_damage(struct wlr_output_damage *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->max_rects) | 0);  /* check that 'struct wlr_output_damage.max_rects' is an integer */
  { struct pixman_region32 *tmp = &p->current; (void)tmp; }
  { struct pixman_region32(*tmp)[2] = &p->previous; (void)tmp; }
  (void)((p->previous_idx) | 0);  /* check that 'struct wlr_output_damage.previous_idx' is an integer */
  (void)((p->pending_attach_render) | 0);  /* check that 'struct wlr_output_damage.pending_attach_render' is an integer */
  /* cannot generate 'struct $21' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->output_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->output_mode; (void)tmp; }
  { struct wl_listener *tmp = &p->output_needs_frame; (void)tmp; }
  { struct wl_listener *tmp = &p->output_damage; (void)tmp; }
  { struct wl_listener *tmp = &p->output_frame; (void)tmp; }
  { struct wl_listener *tmp = &p->output_precommit; (void)tmp; }
  { struct wl_listener *tmp = &p->output_commit; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_damage { char x; struct wlr_output_damage y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_head_v1_state(struct wlr_output_head_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output_head_v1_state.enabled' is an integer */
  { struct wlr_output_mode * *tmp = &p->mode; (void)tmp; }
  /* cannot generate 'struct $24' in field 'custom_mode': unknown type name */
  (void)((p->x) | 0);  /* check that 'struct wlr_output_head_v1_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_output_head_v1_state.y' is an integer */
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  { float *tmp = &p->scale; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_head_v1_state { char x; struct wlr_output_head_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_layout(struct wlr_output_layout *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  { struct wlr_output_layout_state * *tmp = &p->state; (void)tmp; }
  /* cannot generate 'struct $22' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_layout { char x; struct wlr_output_layout y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_manager_v1(struct wlr_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_manager_v1.serial' is an integer */
  (void)((p->current_configuration_dirty) | 0);  /* check that 'struct wlr_output_manager_v1.current_configuration_dirty' is an integer */
  /* cannot generate 'struct $23' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_manager_v1 { char x; struct wlr_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_manager_v1(struct wlr_output_power_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->output_powers; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $25' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_manager_v1 { char x; struct wlr_output_power_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1(struct wlr_output_power_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wlr_output_power_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy_listener; (void)tmp; }
  { struct wl_listener *tmp = &p->output_commit_listener; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1 { char x; struct wlr_output_power_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1_set_mode_event(struct wlr_output_power_v1_set_mode_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { enum zwlr_output_power_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1_set_mode_event { char x; struct wlr_output_power_v1_set_mode_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_state(struct wlr_output_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_output_state { char x; struct wlr_output_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer(struct wlr_pointer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_impl const * *tmp = &p->impl; (void)tmp; }
  /* cannot generate 'struct $26' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer { char x; struct wlr_pointer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1(struct wlr_pointer_constraint_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_constraints_v1 * *tmp = &p->pointer_constraints; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { enum zwp_pointer_constraints_v1_lifetime *tmp = &p->lifetime; (void)tmp; }
  { enum wlr_pointer_constraint_v1_type *tmp = &p->type; (void)tmp; }
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $28' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraint_v1 { char x; struct wlr_pointer_constraint_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1_state(struct wlr_pointer_constraint_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_pointer_constraint_v1_state.committed' is an integer */
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  /* cannot generate 'struct $27' in field 'cursor_hint': unknown type name */
}
struct _cffi_align_struct_wlr_pointer_constraint_v1_state { char x; struct wlr_pointer_constraint_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraints_v1(struct wlr_pointer_constraints_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->constraints; (void)tmp; }
  /* cannot generate 'struct $29' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraints_v1 { char x; struct wlr_pointer_constraints_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_primary_selection_v1_device_manager(struct wlr_primary_selection_v1_device_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $30' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_primary_selection_v1_device_manager { char x; struct wlr_primary_selection_v1_device_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_manager_v1(struct wlr_relative_pointer_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->relative_pointers; (void)tmp; }
  /* cannot generate 'struct $31' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_manager_v1 { char x; struct wlr_relative_pointer_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_v1(struct wlr_relative_pointer_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_resource * *tmp = &p->pointer_resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $32' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_v1 { char x; struct wlr_relative_pointer_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene(struct wlr_scene *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_node *tmp = &p->node; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene { char x; struct wlr_scene y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_node(struct wlr_scene_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_scene_node_type *tmp = &p->type; (void)tmp; }
  { struct wlr_scene_node * *tmp = &p->parent; (void)tmp; }
  { struct wlr_scene_node_state *tmp = &p->state; (void)tmp; }
  /* cannot generate 'struct $33' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_node { char x; struct wlr_scene_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_node_state(struct wlr_scene_node_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_list *tmp = &p->children; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_scene_node_state.enabled' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_scene_node_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_scene_node_state.y' is an integer */
}
struct _cffi_align_struct_wlr_scene_node_state { char x; struct wlr_scene_node_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_screencopy_manager_v1(struct wlr_screencopy_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->frames; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $34' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_screencopy_manager_v1 { char x; struct wlr_screencopy_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat(struct wlr_seat *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  (void)((p->capabilities) | 0);  /* check that 'struct wlr_seat.capabilities' is an integer */
  { struct timespec *tmp = &p->last_event; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->selection_source; (void)tmp; }
  (void)((p->selection_serial) | 0);  /* check that 'struct wlr_seat.selection_serial' is an integer */
  { struct wl_list *tmp = &p->selection_offers; (void)tmp; }
  { struct wlr_primary_selection_source * *tmp = &p->primary_selection_source; (void)tmp; }
  (void)((p->primary_selection_serial) | 0);  /* check that 'struct wlr_seat.primary_selection_serial' is an integer */
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->drag_source; (void)tmp; }
  (void)((p->drag_serial) | 0);  /* check that 'struct wlr_seat.drag_serial' is an integer */
  { struct wl_list *tmp = &p->drag_offers; (void)tmp; }
  { struct wlr_seat_pointer_state *tmp = &p->pointer_state; (void)tmp; }
  { struct wlr_seat_keyboard_state *tmp = &p->keyboard_state; (void)tmp; }
  { struct wlr_seat_touch_state *tmp = &p->touch_state; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->primary_selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->drag_source_destroy; (void)tmp; }
  /* cannot generate 'struct $37' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat { char x; struct wlr_seat y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_focus_change_event(struct wlr_seat_keyboard_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_focus_change_event { char x; struct wlr_seat_keyboard_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_grab(struct wlr_seat_keyboard_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_grab { char x; struct wlr_seat_keyboard_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_state(struct wlr_seat_keyboard_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_keyboard * *tmp = &p->keyboard; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_keymap; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_repeat_info; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->default_grab; (void)tmp; }
  /* cannot generate 'struct $36' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_keyboard_state { char x; struct wlr_seat_keyboard_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_focus_change_event(struct wlr_seat_pointer_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_focus_change_event { char x; struct wlr_seat_pointer_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_grab(struct wlr_seat_pointer_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_grab { char x; struct wlr_seat_pointer_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_request_set_cursor_event(struct wlr_seat_pointer_request_set_cursor_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.serial' is an integer */
  (void)((p->hotspot_x) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_x' is an integer */
  (void)((p->hotspot_y) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_y' is an integer */
}
struct _cffi_align_struct_wlr_seat_pointer_request_set_cursor_event { char x; struct wlr_seat_pointer_request_set_cursor_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_state(struct wlr_seat_pointer_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->default_grab; (void)tmp; }
  { uint32_t(*tmp)[16] = &p->buttons; (void)tmp; }
  (void)((p->button_count) | 0);  /* check that 'struct wlr_seat_pointer_state.button_count' is an integer */
  (void)((p->grab_button) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_button' is an integer */
  (void)((p->grab_serial) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_serial' is an integer */
  (void)((p->grab_time) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_time' is an integer */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  /* cannot generate 'struct $35' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_pointer_state { char x; struct wlr_seat_pointer_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_set_selection_event(struct wlr_seat_request_set_selection_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_set_selection_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_set_selection_event { char x; struct wlr_seat_request_set_selection_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_start_drag_event(struct wlr_seat_request_start_drag_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->origin; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_start_drag_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_start_drag_event { char x; struct wlr_seat_request_start_drag_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_grab(struct wlr_seat_touch_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_touch_grab { char x; struct wlr_seat_touch_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_state(struct wlr_seat_touch_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_seat_touch_state { char x; struct wlr_seat_touch_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_server_decoration_manager(struct wlr_server_decoration_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  (void)((p->default_mode) | 0);  /* check that 'struct wlr_server_decoration_manager.default_mode' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $38' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_server_decoration_manager { char x; struct wlr_server_decoration_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subcompositor(struct wlr_subcompositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
}
struct _cffi_align_struct_wlr_subcompositor { char x; struct wlr_subcompositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface(struct wlr_subsurface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->current; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->pending; (void)tmp; }
  (void)((p->cached_seq) | 0);  /* check that 'struct wlr_subsurface.cached_seq' is an integer */
  (void)((p->has_cache) | 0);  /* check that 'struct wlr_subsurface.has_cache' is an integer */
  (void)((p->synchronized) | 0);  /* check that 'struct wlr_subsurface.synchronized' is an integer */
  (void)((p->reordered) | 0);  /* check that 'struct wlr_subsurface.reordered' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_subsurface.mapped' is an integer */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_destroy; (void)tmp; }
  /* cannot generate 'struct $40' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_subsurface { char x; struct wlr_subsurface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface_parent_state(struct wlr_subsurface_parent_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_subsurface_parent_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_subsurface_parent_state.y' is an integer */
}
struct _cffi_align_struct_wlr_subsurface_parent_state { char x; struct wlr_subsurface_parent_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface(struct wlr_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_client_buffer * *tmp = &p->buffer; (void)tmp; }
  (void)((p->sx) | 0);  /* check that 'struct wlr_surface.sx' is an integer */
  (void)((p->sy) | 0);  /* check that 'struct wlr_surface.sy' is an integer */
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque_region; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input_region; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->pending; (void)tmp; }
  { struct wl_list *tmp = &p->cached; (void)tmp; }
  { struct wlr_surface_role const * *tmp = &p->role; (void)tmp; }
  { void * *tmp = &p->role_data; (void)tmp; }
  /* cannot generate 'struct $39' in field 'events': unknown type name */
  { struct wl_list *tmp = &p->current_outputs; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
  { struct wl_listener *tmp = &p->renderer_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface { char x; struct wlr_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_output(struct wlr_surface_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->bind; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_output { char x; struct wlr_surface_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_role(struct wlr_surface_role *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->commit; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->precommit; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_role { char x; struct wlr_surface_role y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_state(struct wlr_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_surface_state.committed' is an integer */
  (void)((p->seq) | 0);  /* check that 'struct wlr_surface_state.seq' is an integer */
  { struct wlr_buffer * *tmp = &p->buffer; (void)tmp; }
  (void)((p->dx) | 0);  /* check that 'struct wlr_surface_state.dx' is an integer */
  (void)((p->dy) | 0);  /* check that 'struct wlr_surface_state.dy' is an integer */
  { struct pixman_region32 *tmp = &p->surface_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->scale) | 0);  /* check that 'struct wlr_surface_state.scale' is an integer */
  { struct wl_list *tmp = &p->frame_callback_list; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_surface_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_surface_state.height' is an integer */
  (void)((p->buffer_width) | 0);  /* check that 'struct wlr_surface_state.buffer_width' is an integer */
  (void)((p->buffer_height) | 0);  /* check that 'struct wlr_surface_state.buffer_height' is an integer */
  { struct wl_list *tmp = &p->subsurfaces_below; (void)tmp; }
  { struct wl_list *tmp = &p->subsurfaces_above; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_state { char x; struct wlr_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_manager_v1(struct wlr_virtual_keyboard_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->virtual_keyboards; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $41' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_keyboard_manager_v1 { char x; struct wlr_virtual_keyboard_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_v1(struct wlr_virtual_keyboard_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->input_device; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  (void)((p->has_keymap) | 0);  /* check that 'struct wlr_virtual_keyboard_v1.has_keymap' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $42' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_keyboard_v1 { char x; struct wlr_virtual_keyboard_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_client(struct wlr_xdg_client *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_shell * *tmp = &p->shell; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_list *tmp = &p->surfaces; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->ping_serial) | 0);  /* check that 'struct wlr_xdg_client.ping_serial' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_client { char x; struct wlr_xdg_client y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_decoration_manager_v1(struct wlr_xdg_decoration_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $43' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_decoration_manager_v1 { char x; struct wlr_xdg_decoration_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_output_manager_v1(struct wlr_xdg_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_output_layout * *tmp = &p->layout; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  /* cannot generate 'struct $45' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_add; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_change; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_output_manager_v1 { char x; struct wlr_xdg_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_popup(struct wlr_xdg_popup *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  (void)((p->committed) | 0);  /* check that 'struct wlr_xdg_popup.committed' is an integer */
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
  { struct wlr_xdg_positioner *tmp = &p->positioner; (void)tmp; }
  { struct wl_list *tmp = &p->grab_link; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_popup { char x; struct wlr_xdg_popup y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_positioner(struct wlr_xdg_positioner *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_box *tmp = &p->anchor_rect; (void)tmp; }
  { enum xdg_positioner_anchor *tmp = &p->anchor; (void)tmp; }
  { enum xdg_positioner_gravity *tmp = &p->gravity; (void)tmp; }
  { enum xdg_positioner_constraint_adjustment *tmp = &p->constraint_adjustment; (void)tmp; }
  /* cannot generate 'struct $47' in field 'size': unknown type name */
  /* cannot generate 'struct $48' in field 'offset': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_positioner { char x; struct wlr_xdg_positioner y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_shell(struct wlr_xdg_shell *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { struct wl_list *tmp = &p->popup_grabs; (void)tmp; }
  (void)((p->ping_timeout) | 0);  /* check that 'struct wlr_xdg_shell.ping_timeout' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $46' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_shell { char x; struct wlr_xdg_shell y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface(struct wlr_xdg_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_client * *tmp = &p->client; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { enum wlr_xdg_surface_role *tmp = &p->role; (void)tmp; }
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_xdg_popup * *tmp = &p->popup; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_surface.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_xdg_surface.configured' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_xdg_surface.mapped' is an integer */
  { struct wl_event_source * *tmp = &p->configure_idle; (void)tmp; }
  (void)((p->scheduled_serial) | 0);  /* check that 'struct wlr_xdg_surface.scheduled_serial' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  /* cannot generate 'struct $51' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface { char x; struct wlr_xdg_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_configure(struct wlr_xdg_surface_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_surface_configure.serial' is an integer */
  { struct wlr_xdg_toplevel_configure * *tmp = &p->toplevel_configure; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_configure { char x; struct wlr_xdg_surface_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_state(struct wlr_xdg_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->configure_serial) | 0);  /* check that 'struct wlr_xdg_surface_state.configure_serial' is an integer */
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_state { char x; struct wlr_xdg_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel(struct wlr_xdg_toplevel *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_toplevel.added' is an integer */
  { struct wlr_xdg_surface * *tmp = &p->parent; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_unmap; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->pending; (void)tmp; }
  { struct wlr_xdg_toplevel_configure *tmp = &p->scheduled; (void)tmp; }
  { struct wlr_xdg_toplevel_requested *tmp = &p->requested; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  /* cannot generate 'struct $49' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_toplevel { char x; struct wlr_xdg_toplevel y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_configure(struct wlr_xdg_toplevel_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_configure { char x; struct wlr_xdg_toplevel_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1(struct wlr_xdg_toplevel_decoration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_xdg_decoration_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->pending; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->scheduled_mode; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->requested_mode; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_toplevel_decoration_v1.added' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  /* cannot generate 'struct $44' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_ack_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1 { char x; struct wlr_xdg_toplevel_decoration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_configure(struct wlr_xdg_toplevel_decoration_v1_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_surface_configure * *tmp = &p->surface_configure; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_configure { char x; struct wlr_xdg_toplevel_decoration_v1_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_state(struct wlr_xdg_toplevel_decoration_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_state { char x; struct wlr_xdg_toplevel_decoration_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_move_event(struct wlr_xdg_toplevel_move_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_move_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_move_event { char x; struct wlr_xdg_toplevel_move_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_requested(struct wlr_xdg_toplevel_requested *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.maximized' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.minimized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->fullscreen_output; (void)tmp; }
  { struct wl_listener *tmp = &p->fullscreen_output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_requested { char x; struct wlr_xdg_toplevel_requested y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_resize_event(struct wlr_xdg_toplevel_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.serial' is an integer */
  (void)((p->edges) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_resize_event { char x; struct wlr_xdg_toplevel_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_set_fullscreen_event(struct wlr_xdg_toplevel_set_fullscreen_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_set_fullscreen_event.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_set_fullscreen_event { char x; struct wlr_xdg_toplevel_set_fullscreen_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_show_window_menu_event(struct wlr_xdg_toplevel_show_window_menu_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.serial' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.y' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_show_window_menu_event { char x; struct wlr_xdg_toplevel_show_window_menu_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_state(struct wlr_xdg_toplevel_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_state.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_state.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_state.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_state.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_state.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_state { char x; struct wlr_xdg_toplevel_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland(struct wlr_xwayland *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  { struct wlr_xwayland_cursor * *tmp = &p->cursor; (void)tmp; }
  { char const * *tmp = &p->display_name; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  { struct wlr_compositor * *tmp = &p->compositor; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  /* cannot generate 'struct $56' in field 'events': unknown type name */
  { int(* *tmp)(struct wlr_xwm *, xcb_generic_event_t *) = &p->user_event_handler; (void)tmp; }
  { struct wl_listener *tmp = &p->server_ready; (void)tmp; }
  { struct wl_listener *tmp = &p->server_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland { char x; struct wlr_xwayland y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_minimize_event(struct wlr_xwayland_minimize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->minimize) | 0);  /* check that 'struct wlr_xwayland_minimize_event.minimize' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_minimize_event { char x; struct wlr_xwayland_minimize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_move_event(struct wlr_xwayland_move_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_move_event { char x; struct wlr_xwayland_move_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_remove_startup_info_event(struct wlr_xwayland_remove_startup_info_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->id; (void)tmp; }
  (void)((p->window) | 0);  /* check that 'struct wlr_xwayland_remove_startup_info_event.window' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_remove_startup_info_event { char x; struct wlr_xwayland_remove_startup_info_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_resize_event(struct wlr_xwayland_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->edges) | 0);  /* check that 'struct wlr_xwayland_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_resize_event { char x; struct wlr_xwayland_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server(struct wlr_xwayland_server *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_server.pid' is an integer */
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_event_source * *tmp = &p->pipe_source; (void)tmp; }
  { int(*tmp)[2] = &p->wm_fd; (void)tmp; }
  { int(*tmp)[2] = &p->wl_fd; (void)tmp; }
  (void)((p->server_start) | 0);  /* check that 'struct wlr_xwayland_server.server_start' is an integer */
  (void)((p->display) | 0);  /* check that 'struct wlr_xwayland_server.display' is an integer */
  { char(*tmp)[16] = &p->display_name; (void)tmp; }
  { int(*tmp)[2] = &p->x_fd; (void)tmp; }
  { struct wl_event_source *(*tmp)[2] = &p->x_fd_read_event; (void)tmp; }
  { struct wlr_xwayland_server_options *tmp = &p->options; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  /* cannot generate 'struct $55' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_server { char x; struct wlr_xwayland_server y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server_options(struct wlr_xwayland_server_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->lazy) | 0);  /* check that 'struct wlr_xwayland_server_options.lazy' is an integer */
  (void)((p->enable_wm) | 0);  /* check that 'struct wlr_xwayland_server_options.enable_wm' is an integer */
  (void)((p->no_touch_pointer_emulation) | 0);  /* check that 'struct wlr_xwayland_server_options.no_touch_pointer_emulation' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_server_options { char x; struct wlr_xwayland_server_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface(struct wlr_xwayland_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->window_id) | 0);  /* check that 'struct wlr_xwayland_surface.window_id' is an integer */
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  (void)((p->surface_id) | 0);  /* check that 'struct wlr_xwayland_surface.surface_id' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_list *tmp = &p->stack_link; (void)tmp; }
  { struct wl_list *tmp = &p->unpaired_link; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface.height' is an integer */
  (void)((p->saved_width) | 0);  /* check that 'struct wlr_xwayland_surface.saved_width' is an integer */
  (void)((p->saved_height) | 0);  /* check that 'struct wlr_xwayland_surface.saved_height' is an integer */
  (void)((p->override_redirect) | 0);  /* check that 'struct wlr_xwayland_surface.override_redirect' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_xwayland_surface.mapped' is an integer */
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->class; (void)tmp; }
  { char * *tmp = &p->instance; (void)tmp; }
  { char * *tmp = &p->role; (void)tmp; }
  { char * *tmp = &p->startup_id; (void)tmp; }
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_surface.pid' is an integer */
  (void)((p->has_utf8_title) | 0);  /* check that 'struct wlr_xwayland_surface.has_utf8_title' is an integer */
  { struct wl_list *tmp = &p->children; (void)tmp; }
  { struct wlr_xwayland_surface * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->parent_link; (void)tmp; }
  { uint32_t * *tmp = &p->window_type; (void)tmp; }
  (void)((p->window_type_len) | 0);  /* check that 'struct wlr_xwayland_surface.window_type_len' is an integer */
  { uint32_t * *tmp = &p->protocols; (void)tmp; }
  (void)((p->protocols_len) | 0);  /* check that 'struct wlr_xwayland_surface.protocols_len' is an integer */
  (void)((p->decorations) | 0);  /* check that 'struct wlr_xwayland_surface.decorations' is an integer */
  { struct wlr_xwayland_surface_hints * *tmp = &p->hints; (void)tmp; }
  (void)((p->hints_urgency) | 0);  /* check that 'struct wlr_xwayland_surface.hints_urgency' is an integer */
  { struct wlr_xwayland_surface_size_hints * *tmp = &p->size_hints; (void)tmp; }
  (void)((p->pinging) | 0);  /* check that 'struct wlr_xwayland_surface.pinging' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
  (void)((p->modal) | 0);  /* check that 'struct wlr_xwayland_surface.modal' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xwayland_surface.fullscreen' is an integer */
  (void)((p->maximized_vert) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_vert' is an integer */
  (void)((p->maximized_horz) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_horz' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xwayland_surface.minimized' is an integer */
  (void)((p->has_alpha) | 0);  /* check that 'struct wlr_xwayland_surface.has_alpha' is an integer */
  /* cannot generate 'struct $57' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_surface { char x; struct wlr_xwayland_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_configure_event(struct wlr_xwayland_surface_configure_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.height' is an integer */
  (void)((p->mask) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.mask' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_configure_event { char x; struct wlr_xwayland_surface_configure_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_hints(struct wlr_xwayland_surface_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct wlr_xwayland_surface_hints.flags' is an integer */
  (void)((p->input) | 0);  /* check that 'struct wlr_xwayland_surface_hints.input' is an integer */
  (void)((p->initial_state) | 0);  /* check that 'struct wlr_xwayland_surface_hints.initial_state' is an integer */
  (void)((p->icon_pixmap) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_pixmap' is an integer */
  (void)((p->icon_window) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_window' is an integer */
  (void)((p->icon_x) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_x' is an integer */
  (void)((p->icon_y) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_y' is an integer */
  (void)((p->icon_mask) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_mask' is an integer */
  (void)((p->window_group) | 0);  /* check that 'struct wlr_xwayland_surface_hints.window_group' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_hints { char x; struct wlr_xwayland_surface_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_size_hints(struct wlr_xwayland_surface_size_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.flags' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_height' is an integer */
  (void)((p->width_inc) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.width_inc' is an integer */
  (void)((p->height_inc) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.height_inc' is an integer */
  (void)((p->base_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.base_width' is an integer */
  (void)((p->base_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.base_height' is an integer */
  (void)((p->min_aspect_num) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_aspect_num' is an integer */
  (void)((p->min_aspect_den) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_aspect_den' is an integer */
  (void)((p->max_aspect_num) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_aspect_num' is an integer */
  (void)((p->max_aspect_den) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_aspect_den' is an integer */
  (void)((p->win_gravity) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.win_gravity' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_size_hints { char x; struct wlr_xwayland_surface_size_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_cookie_t(xcb_intern_atom_cookie_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align__xcb_intern_atom_cookie_t { char x; xcb_intern_atom_cookie_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_reply_t(xcb_intern_atom_reply_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->response_type) | 0);  /* check that 'xcb_intern_atom_reply_t.response_type' is an integer */
  (void)((p->pad0) | 0);  /* check that 'xcb_intern_atom_reply_t.pad0' is an integer */
  (void)((p->sequence) | 0);  /* check that 'xcb_intern_atom_reply_t.sequence' is an integer */
  (void)((p->length) | 0);  /* check that 'xcb_intern_atom_reply_t.length' is an integer */
  (void)((p->atom) | 0);  /* check that 'xcb_intern_atom_reply_t.atom' is an integer */
}
struct _cffi_align__xcb_intern_atom_reply_t { char x; xcb_intern_atom_reply_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_xkb_rule_names(struct xkb_rule_names *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->rules; (void)tmp; }
  { char const * *tmp = &p->model; (void)tmp; }
  { char const * *tmp = &p->layout; (void)tmp; }
  { char const * *tmp = &p->variant; (void)tmp; }
  { char const * *tmp = &p->options; (void)tmp; }
}
struct _cffi_align_struct_xkb_rule_names { char x; struct xkb_rule_names y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_union_wl_argument(union wl_argument *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->i) | 0);  /* check that 'union wl_argument.i' is an integer */
  (void)((p->u) | 0);  /* check that 'union wl_argument.u' is an integer */
  (void)((p->f) | 0);  /* check that 'union wl_argument.f' is an integer */
  { char const * *tmp = &p->s; (void)tmp; }
  { struct wl_object * *tmp = &p->o; (void)tmp; }
  (void)((p->n) | 0);  /* check that 'union wl_argument.n' is an integer */
  { struct wl_array * *tmp = &p->a; (void)tmp; }
  (void)((p->h) | 0);  /* check that 'union wl_argument.h' is an integer */
}
struct _cffi_align_union_wl_argument { char x; union wl_argument y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_NONE", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_NONE", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DRAG_DISABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DRAG_DISABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DRAG_ENABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DRAG_ENABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DRAG_LOCK_DISABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DRAG_LOCK_DISABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DRAG_LOCK_ENABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DRAG_LOCK_ENABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DWT_DISABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DWT_DISABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_DWT_ENABLED", (void *)_cffi_const_LIBINPUT_CONFIG_DWT_ENABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED", (void *)_cffi_const_LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED", (void *)_cffi_const_LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_2FG", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_2FG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_EDGE", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_EDGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_NO_SCROLL", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_NO_SCROLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_STATUS_INVALID", (void *)_cffi_const_LIBINPUT_CONFIG_STATUS_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_STATUS_SUCCESS", (void *)_cffi_const_LIBINPUT_CONFIG_STATUS_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_STATUS_UNSUPPORTED", (void *)_cffi_const_LIBINPUT_CONFIG_STATUS_UNSUPPORTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_DISABLED", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_DISABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_ENABLED", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_ENABLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_MAP_LMR", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_MAP_LMR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_MAP_LRM", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_MAP_LRM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_HORIZONTAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_VERTICAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_VERTICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_CONTINUOUS", (void *)_cffi_const_WLR_AXIS_SOURCE_CONTINUOUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_FINGER", (void *)_cffi_const_WLR_AXIS_SOURCE_FINGER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL_TILT", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_PRESSED", (void *)_cffi_const_WLR_BUTTON_PRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_RELEASED", (void *)_cffi_const_WLR_BUTTON_RELEASED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_DEBUG", (void *)_cffi_const_WLR_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_BOTTOM", (void *)_cffi_const_WLR_EDGE_BOTTOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_LEFT", (void *)_cffi_const_WLR_EDGE_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_NONE", (void *)_cffi_const_WLR_EDGE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_RIGHT", (void *)_cffi_const_WLR_EDGE_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_TOP", (void *)_cffi_const_WLR_EDGE_TOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ERROR", (void *)_cffi_const_WLR_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_GLOBAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_LOCAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_NONE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_PASSIVE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INFO", (void *)_cffi_const_WLR_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_KEYBOARD", (void *)_cffi_const_WLR_INPUT_DEVICE_KEYBOARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_POINTER", (void *)_cffi_const_WLR_INPUT_DEVICE_POINTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_SWITCH", (void *)_cffi_const_WLR_INPUT_DEVICE_SWITCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_PAD", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_PAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_TOOL", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TOUCH", (void *)_cffi_const_WLR_INPUT_DEVICE_TOUCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_CAPS_LOCK", (void *)_cffi_const_WLR_LED_CAPS_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_NUM_LOCK", (void *)_cffi_const_WLR_LED_NUM_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_SCROLL_LOCK", (void *)_cffi_const_WLR_LED_SCROLL_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_ALT", (void *)_cffi_const_WLR_MODIFIER_ALT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_CAPS", (void *)_cffi_const_WLR_MODIFIER_CAPS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_CTRL", (void *)_cffi_const_WLR_MODIFIER_CTRL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_LOGO", (void *)_cffi_const_WLR_MODIFIER_LOGO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD2", (void *)_cffi_const_WLR_MODIFIER_MOD2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD3", (void *)_cffi_const_WLR_MODIFIER_MOD3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD5", (void *)_cffi_const_WLR_MODIFIER_MOD5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_SHIFT", (void *)_cffi_const_WLR_MODIFIER_SHIFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_CONFINED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_LOCKED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_REGION", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_NONE", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_SERVER", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SILENT", (void *)_cffi_const_WLR_SILENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_NONE", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_POPUP", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_POPUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_TOPLEVEL", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_ALL", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_CANCELLED", (void *)_cffi_const_XKB_COMPOSE_CANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSED", (void *)_cffi_const_XKB_COMPOSE_COMPOSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSING", (void *)_cffi_const_XKB_COMPOSE_COMPOSING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_ACCEPTED", (void *)_cffi_const_XKB_COMPOSE_FEED_ACCEPTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_IGNORED", (void *)_cffi_const_XKB_COMPOSE_FEED_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_NOTHING", (void *)_cffi_const_XKB_COMPOSE_NOTHING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_STATE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_STATE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_DEFAULT_INCLUDES", (void *)_cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_ENVIRONMENT_NAMES", (void *)_cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_FLAGS", (void *)_cffi_const_XKB_CONTEXT_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_CASE_INSENSITIVE", (void *)_cffi_const_XKB_KEYSYM_CASE_INSENSITIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_NO_FLAGS", (void *)_cffi_const_XKB_KEYSYM_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_DOWN", (void *)_cffi_const_XKB_KEY_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_UP", (void *)_cffi_const_XKB_KEY_UP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_CRITICAL", (void *)_cffi_const_XKB_LOG_LEVEL_CRITICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_DEBUG", (void *)_cffi_const_XKB_LOG_LEVEL_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_ERROR", (void *)_cffi_const_XKB_LOG_LEVEL_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_INFO", (void *)_cffi_const_XKB_LOG_LEVEL_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_WARNING", (void *)_cffi_const_XKB_LOG_LEVEL_WARNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_DEPRESSED", (void *)_cffi_const_XKB_STATE_LAYOUT_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_EFFECTIVE", (void *)_cffi_const_XKB_STATE_LAYOUT_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LATCHED", (void *)_cffi_const_XKB_STATE_LAYOUT_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LOCKED", (void *)_cffi_const_XKB_STATE_LAYOUT_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LEDS", (void *)_cffi_const_XKB_STATE_LEDS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ALL", (void *)_cffi_const_XKB_STATE_MATCH_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ANY", (void *)_cffi_const_XKB_STATE_MATCH_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_NON_EXCLUSIVE", (void *)_cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_DEPRESSED", (void *)_cffi_const_XKB_STATE_MODS_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_EFFECTIVE", (void *)_cffi_const_XKB_STATE_MODS_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LATCHED", (void *)_cffi_const_XKB_STATE_MODS_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LOCKED", (void *)_cffi_const_XKB_STATE_MODS_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "libinput_device_config_accel_is_available", (void *)_cffi_f_libinput_device_config_accel_is_available, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_libinput_device_config_accel_is_available },
  { "libinput_device_config_accel_set_profile", (void *)_cffi_f_libinput_device_config_accel_set_profile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_libinput_device_config_accel_set_profile },
  { "libinput_device_config_accel_set_speed", (void *)_cffi_f_libinput_device_config_accel_set_speed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_libinput_device_config_accel_set_speed },
  { "libinput_device_config_click_set_method", (void *)_cffi_f_libinput_device_config_click_set_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_libinput_device_config_click_set_method },
  { "libinput_device_config_dwt_is_available", (void *)_cffi_f_libinput_device_config_dwt_is_available, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_libinput_device_config_dwt_is_available },
  { "libinput_device_config_dwt_set_enabled", (void *)_cffi_f_libinput_device_config_dwt_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 20), (void *)_cffi_d_libinput_device_config_dwt_set_enabled },
  { "libinput_device_config_left_handed_is_available", (void *)_cffi_f_libinput_device_config_left_handed_is_available, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_libinput_device_config_left_handed_is_available },
  { "libinput_device_config_left_handed_set", (void *)_cffi_f_libinput_device_config_left_handed_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_libinput_device_config_left_handed_set },
  { "libinput_device_config_middle_emulation_set_enabled", (void *)_cffi_f_libinput_device_config_middle_emulation_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 24), (void *)_cffi_d_libinput_device_config_middle_emulation_set_enabled },
  { "libinput_device_config_scroll_has_natural_scroll", (void *)_cffi_f_libinput_device_config_scroll_has_natural_scroll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_libinput_device_config_scroll_has_natural_scroll },
  { "libinput_device_config_scroll_set_button", (void *)_cffi_f_libinput_device_config_scroll_set_button, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_libinput_device_config_scroll_set_button },
  { "libinput_device_config_scroll_set_method", (void *)_cffi_f_libinput_device_config_scroll_set_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 28), (void *)_cffi_d_libinput_device_config_scroll_set_method },
  { "libinput_device_config_scroll_set_natural_scroll_enabled", (void *)_cffi_f_libinput_device_config_scroll_set_natural_scroll_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_libinput_device_config_scroll_set_natural_scroll_enabled },
  { "libinput_device_config_tap_get_finger_count", (void *)_cffi_f_libinput_device_config_tap_get_finger_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_libinput_device_config_tap_get_finger_count },
  { "libinput_device_config_tap_set_button_map", (void *)_cffi_f_libinput_device_config_tap_set_button_map, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_libinput_device_config_tap_set_button_map },
  { "libinput_device_config_tap_set_drag_enabled", (void *)_cffi_f_libinput_device_config_tap_set_drag_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 16), (void *)_cffi_d_libinput_device_config_tap_set_drag_enabled },
  { "libinput_device_config_tap_set_drag_lock_enabled", (void *)_cffi_f_libinput_device_config_tap_set_drag_lock_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_libinput_device_config_tap_set_drag_lock_enabled },
  { "libinput_device_config_tap_set_enabled", (void *)_cffi_f_libinput_device_config_tap_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 36), (void *)_cffi_d_libinput_device_config_tap_set_enabled },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$FILE", 101, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$va_list", 327, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$xcb_connection_t", 336, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$xcb_generic_error_t", 337, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$xcb_generic_event_t", 338, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "libinput_device", 150, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "pixman_box32", 151, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "pixman_region32", 152, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "timespec", 153, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_argument", 325, _CFFI_F_UNION|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_array", 154, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_client", 155, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_display", 156, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_loop", 157, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_queue", 158, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_source", 159, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_global", 160, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_interface", 161, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_list", 162, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_listener", 163, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_listener_container", 164, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_message", 165, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_object", 166, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_proxy", 167, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_resource", 168, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_signal", 169, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_allocator", 170, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_backend", 171, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_backend_impl", 172, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_box", 173, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_buffer", 174, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_client_buffer", 175, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_compositor", 176, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_cursor", 177, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_cursor_state", 178, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_data_control_manager_v1", 179, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_data_device_manager", 180, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_data_source", 181, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_data_source_impl", 182, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_drag", 183, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_drag_drop_event", 184, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_drag_icon", 185, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_drag_motion_event", 186, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_keyboard_key", 187, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_axis", 188, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_button", 189, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_motion", 190, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_motion_absolute", 191, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_pinch_begin", 192, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_pinch_end", 193, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_pinch_update", 194, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_swipe_begin", 195, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_swipe_end", 196, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_event_pointer_swipe_update", 197, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_fbox", 198, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1", 199, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1_activated_event", 200, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1_fullscreen_event", 201, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1_maximized_event", 202, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1_minimized_event", 203, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_handle_v1_set_rectangle_event", 204, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_foreign_toplevel_manager_v1", 205, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_gamma_control_manager_v1", 206, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_idle", 207, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_idle_inhibit_manager_v1", 208, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_idle_inhibitor_v1", 209, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_idle_timeout", 210, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_input_device", 211, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_input_device_impl", 212, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_input_inhibit_manager", 213, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_keyboard", 214, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_keyboard_grab_interface", 215, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_keyboard_group", 216, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_keyboard_impl", 217, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_keyboard_modifiers", 218, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_layer_shell_v1", 219, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_layer_surface_v1", 220, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_layer_surface_v1_state", 221, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_linux_dmabuf_v1", 222, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output", 223, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_configuration_head_v1", 224, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_configuration_v1", 225, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_cursor", 226, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_damage", 227, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_head_v1_state", 228, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_impl", 229, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_layout", 230, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_layout_state", 231, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_manager_v1", 232, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_mode", 233, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_power_manager_v1", 234, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_power_v1", 235, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_power_v1_set_mode_event", 236, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_output_state", 237, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer", 238, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer_constraint_v1", 239, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer_constraint_v1_state", 240, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer_constraints_v1", 241, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer_grab_interface", 242, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_pointer_impl", 243, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_primary_selection_source", 244, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_primary_selection_v1_device_manager", 245, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_relative_pointer_manager_v1", 246, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_relative_pointer_v1", 247, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_renderer", 248, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_scene", 249, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_scene_node", 250, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_scene_node_state", 251, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_scene_output", 252, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_screencopy_manager_v1", 253, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat", 254, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_client", 255, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_keyboard_focus_change_event", 256, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_keyboard_grab", 257, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_keyboard_state", 258, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_pointer_focus_change_event", 259, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_pointer_grab", 260, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_pointer_request_set_cursor_event", 261, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_pointer_state", 262, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_request_set_selection_event", 263, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_request_start_drag_event", 264, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_touch_grab", 265, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_seat_touch_state", 266, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_server_decoration_manager", 267, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_session", 268, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_subcompositor", 269, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_subsurface", 270, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_subsurface_parent_state", 271, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_surface", 272, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_surface_output", 273, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_surface_role", 274, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_surface_state", 275, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_switch", 276, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_tablet", 277, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_tablet_pad", 278, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_texture", 279, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_touch", 280, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_touch_grab_interface", 281, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_virtual_keyboard_manager_v1", 282, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_virtual_keyboard_v1", 283, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xcursor_manager", 284, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_client", 285, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_decoration_manager_v1", 286, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_output_manager_v1", 287, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_popup", 288, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_positioner", 289, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_shell", 290, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_surface", 291, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_surface_configure", 292, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_surface_state", 293, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel", 294, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_configure", 295, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_decoration_v1", 296, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_decoration_v1_configure", 297, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_decoration_v1_state", 298, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_move_event", 299, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_requested", 300, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_resize_event", 301, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_set_fullscreen_event", 302, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_show_window_menu_event", 303, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xdg_toplevel_state", 304, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland", 305, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_cursor", 306, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_minimize_event", 307, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_move_event", 308, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_remove_startup_info_event", 309, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_resize_event", 310, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_server", 311, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_server_options", 312, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_surface", 313, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_surface_configure_event", 314, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_surface_hints", 315, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwayland_surface_size_hints", 316, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_xwm", 317, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xcb_intern_atom_cookie_t", 339, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xcb_intern_atom_reply_t", 340, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_compose_state", 318, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_compose_table", 319, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_context", 320, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_keymap", 321, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_rule_names", 322, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_state", 323, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "libinput_config_accel_profile", 6, _cffi_prim_int(sizeof(enum libinput_config_accel_profile), ((enum libinput_config_accel_profile)-1) <= 0),
    "LIBINPUT_CONFIG_ACCEL_PROFILE_NONE,LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT,LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE" },
  { "libinput_config_click_method", 10, _cffi_prim_int(sizeof(enum libinput_config_click_method), ((enum libinput_config_click_method)-1) <= 0),
    "LIBINPUT_CONFIG_CLICK_METHOD_NONE,LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS,LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER" },
  { "libinput_config_drag_lock_state", 14, _cffi_prim_int(sizeof(enum libinput_config_drag_lock_state), ((enum libinput_config_drag_lock_state)-1) <= 0),
    "LIBINPUT_CONFIG_DRAG_LOCK_DISABLED,LIBINPUT_CONFIG_DRAG_LOCK_ENABLED" },
  { "libinput_config_drag_state", 18, _cffi_prim_int(sizeof(enum libinput_config_drag_state), ((enum libinput_config_drag_state)-1) <= 0),
    "LIBINPUT_CONFIG_DRAG_DISABLED,LIBINPUT_CONFIG_DRAG_ENABLED" },
  { "libinput_config_dwt_state", 22, _cffi_prim_int(sizeof(enum libinput_config_dwt_state), ((enum libinput_config_dwt_state)-1) <= 0),
    "LIBINPUT_CONFIG_DWT_DISABLED,LIBINPUT_CONFIG_DWT_ENABLED" },
  { "libinput_config_middle_emulation_state", 26, _cffi_prim_int(sizeof(enum libinput_config_middle_emulation_state), ((enum libinput_config_middle_emulation_state)-1) <= 0),
    "LIBINPUT_CONFIG_MIDDLE_EMULATION_DISABLED,LIBINPUT_CONFIG_MIDDLE_EMULATION_ENABLED" },
  { "libinput_config_scroll_method", 30, _cffi_prim_int(sizeof(enum libinput_config_scroll_method), ((enum libinput_config_scroll_method)-1) <= 0),
    "LIBINPUT_CONFIG_SCROLL_NO_SCROLL,LIBINPUT_CONFIG_SCROLL_2FG,LIBINPUT_CONFIG_SCROLL_EDGE,LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN" },
  { "libinput_config_status", 103, _cffi_prim_int(sizeof(enum libinput_config_status), ((enum libinput_config_status)-1) <= 0),
    "LIBINPUT_CONFIG_STATUS_SUCCESS,LIBINPUT_CONFIG_STATUS_UNSUPPORTED,LIBINPUT_CONFIG_STATUS_INVALID" },
  { "libinput_config_tap_button_map", 34, _cffi_prim_int(sizeof(enum libinput_config_tap_button_map), ((enum libinput_config_tap_button_map)-1) <= 0),
    "LIBINPUT_CONFIG_TAP_MAP_LRM,LIBINPUT_CONFIG_TAP_MAP_LMR" },
  { "libinput_config_tap_state", 38, _cffi_prim_int(sizeof(enum libinput_config_tap_state), ((enum libinput_config_tap_state)-1) <= 0),
    "LIBINPUT_CONFIG_TAP_DISABLED,LIBINPUT_CONFIG_TAP_ENABLED" },
  { "wl_data_device_manager_dnd_action", 104, _cffi_prim_int(sizeof(enum wl_data_device_manager_dnd_action), ((enum wl_data_device_manager_dnd_action)-1) <= 0),
    "" },
  { "wl_keyboard_key_state", 105, _cffi_prim_int(sizeof(enum wl_keyboard_key_state), ((enum wl_keyboard_key_state)-1) <= 0),
    "" },
  { "wl_output_subpixel", 106, _cffi_prim_int(sizeof(enum wl_output_subpixel), ((enum wl_output_subpixel)-1) <= 0),
    "" },
  { "wl_output_transform", 107, _cffi_prim_int(sizeof(enum wl_output_transform), ((enum wl_output_transform)-1) <= 0),
    "" },
  { "wlr_axis_orientation", 108, _cffi_prim_int(sizeof(enum wlr_axis_orientation), ((enum wlr_axis_orientation)-1) <= 0),
    "WLR_AXIS_ORIENTATION_VERTICAL,WLR_AXIS_ORIENTATION_HORIZONTAL" },
  { "wlr_axis_source", 109, _cffi_prim_int(sizeof(enum wlr_axis_source), ((enum wlr_axis_source)-1) <= 0),
    "WLR_AXIS_SOURCE_WHEEL,WLR_AXIS_SOURCE_FINGER,WLR_AXIS_SOURCE_CONTINUOUS,WLR_AXIS_SOURCE_WHEEL_TILT" },
  { "wlr_button_state", 110, _cffi_prim_int(sizeof(enum wlr_button_state), ((enum wlr_button_state)-1) <= 0),
    "WLR_BUTTON_RELEASED,WLR_BUTTON_PRESSED" },
  { "wlr_drag_grab_type", 111, _cffi_prim_int(sizeof(enum wlr_drag_grab_type), ((enum wlr_drag_grab_type)-1) <= 0),
    "" },
  { "wlr_edges", 112, _cffi_prim_int(sizeof(enum wlr_edges), ((enum wlr_edges)-1) <= 0),
    "WLR_EDGE_NONE,WLR_EDGE_TOP,WLR_EDGE_BOTTOM,WLR_EDGE_LEFT,WLR_EDGE_RIGHT" },
  { "wlr_input_device_type", 113, _cffi_prim_int(sizeof(enum wlr_input_device_type), ((enum wlr_input_device_type)-1) <= 0),
    "WLR_INPUT_DEVICE_KEYBOARD,WLR_INPUT_DEVICE_POINTER,WLR_INPUT_DEVICE_TOUCH,WLR_INPUT_DEVICE_TABLET_TOOL,WLR_INPUT_DEVICE_TABLET_PAD,WLR_INPUT_DEVICE_SWITCH" },
  { "wlr_keyboard_led", 114, _cffi_prim_int(sizeof(enum wlr_keyboard_led), ((enum wlr_keyboard_led)-1) <= 0),
    "WLR_LED_NUM_LOCK,WLR_LED_CAPS_LOCK,WLR_LED_SCROLL_LOCK" },
  { "wlr_keyboard_modifier", 115, _cffi_prim_int(sizeof(enum wlr_keyboard_modifier), ((enum wlr_keyboard_modifier)-1) <= 0),
    "WLR_MODIFIER_SHIFT,WLR_MODIFIER_CAPS,WLR_MODIFIER_CTRL,WLR_MODIFIER_ALT,WLR_MODIFIER_MOD2,WLR_MODIFIER_MOD3,WLR_MODIFIER_LOGO,WLR_MODIFIER_MOD5" },
  { "wlr_log_importance", 71, _cffi_prim_int(sizeof(enum wlr_log_importance), ((enum wlr_log_importance)-1) <= 0),
    "WLR_SILENT,WLR_ERROR,WLR_INFO,WLR_DEBUG" },
  { "wlr_pointer_constraint_v1_state_field", 116, _cffi_prim_int(sizeof(enum wlr_pointer_constraint_v1_state_field), ((enum wlr_pointer_constraint_v1_state_field)-1) <= 0),
    "WLR_POINTER_CONSTRAINT_V1_STATE_REGION,WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT" },
  { "wlr_pointer_constraint_v1_type", 117, _cffi_prim_int(sizeof(enum wlr_pointer_constraint_v1_type), ((enum wlr_pointer_constraint_v1_type)-1) <= 0),
    "WLR_POINTER_CONSTRAINT_V1_LOCKED,WLR_POINTER_CONSTRAINT_V1_CONFINED" },
  { "wlr_scene_node_type", 118, _cffi_prim_int(sizeof(enum wlr_scene_node_type), ((enum wlr_scene_node_type)-1) <= 0),
    "" },
  { "wlr_server_decoration_manager_mode", 119, _cffi_prim_int(sizeof(enum wlr_server_decoration_manager_mode), ((enum wlr_server_decoration_manager_mode)-1) <= 0),
    "WLR_SERVER_DECORATION_MANAGER_MODE_NONE,WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT,WLR_SERVER_DECORATION_MANAGER_MODE_SERVER" },
  { "wlr_xdg_surface_role", 120, _cffi_prim_int(sizeof(enum wlr_xdg_surface_role), ((enum wlr_xdg_surface_role)-1) <= 0),
    "WLR_XDG_SURFACE_ROLE_NONE,WLR_XDG_SURFACE_ROLE_TOPLEVEL,WLR_XDG_SURFACE_ROLE_POPUP" },
  { "wlr_xdg_toplevel_decoration_v1_mode", 121, _cffi_prim_int(sizeof(enum wlr_xdg_toplevel_decoration_v1_mode), ((enum wlr_xdg_toplevel_decoration_v1_mode)-1) <= 0),
    "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE,WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE,WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE" },
  { "wlr_xwayland_icccm_input_model", 122, _cffi_prim_int(sizeof(enum wlr_xwayland_icccm_input_model), ((enum wlr_xwayland_icccm_input_model)-1) <= 0),
    "WLR_ICCCM_INPUT_MODEL_NONE,WLR_ICCCM_INPUT_MODEL_PASSIVE,WLR_ICCCM_INPUT_MODEL_LOCAL,WLR_ICCCM_INPUT_MODEL_GLOBAL" },
  { "wlr_xwayland_surface_decorations", 123, _cffi_prim_int(sizeof(enum wlr_xwayland_surface_decorations), ((enum wlr_xwayland_surface_decorations)-1) <= 0),
    "WLR_XWAYLAND_SURFACE_DECORATIONS_ALL,WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER,WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE" },
  { "xcb_stack_mode_t", 124, _cffi_prim_int(sizeof(enum xcb_stack_mode_t), ((enum xcb_stack_mode_t)-1) <= 0),
    "" },
  { "xdg_positioner_anchor", 125, _cffi_prim_int(sizeof(enum xdg_positioner_anchor), ((enum xdg_positioner_anchor)-1) <= 0),
    "" },
  { "xdg_positioner_constraint_adjustment", 126, _cffi_prim_int(sizeof(enum xdg_positioner_constraint_adjustment), ((enum xdg_positioner_constraint_adjustment)-1) <= 0),
    "" },
  { "xdg_positioner_gravity", 127, _cffi_prim_int(sizeof(enum xdg_positioner_gravity), ((enum xdg_positioner_gravity)-1) <= 0),
    "" },
  { "xkb_compose_compile_flags", 128, _cffi_prim_int(sizeof(enum xkb_compose_compile_flags), ((enum xkb_compose_compile_flags)-1) <= 0),
    "XKB_COMPOSE_COMPILE_NO_FLAGS" },
  { "xkb_compose_feed_result", 129, _cffi_prim_int(sizeof(enum xkb_compose_feed_result), ((enum xkb_compose_feed_result)-1) <= 0),
    "XKB_COMPOSE_FEED_IGNORED,XKB_COMPOSE_FEED_ACCEPTED" },
  { "xkb_compose_format", 130, _cffi_prim_int(sizeof(enum xkb_compose_format), ((enum xkb_compose_format)-1) <= 0),
    "XKB_COMPOSE_FORMAT_TEXT_V1" },
  { "xkb_compose_state_flags", 131, _cffi_prim_int(sizeof(enum xkb_compose_state_flags), ((enum xkb_compose_state_flags)-1) <= 0),
    "XKB_COMPOSE_STATE_NO_FLAGS" },
  { "xkb_compose_status", 132, _cffi_prim_int(sizeof(enum xkb_compose_status), ((enum xkb_compose_status)-1) <= 0),
    "XKB_COMPOSE_NOTHING,XKB_COMPOSE_COMPOSING,XKB_COMPOSE_COMPOSED,XKB_COMPOSE_CANCELLED" },
  { "xkb_context_flags", 133, _cffi_prim_int(sizeof(enum xkb_context_flags), ((enum xkb_context_flags)-1) <= 0),
    "XKB_CONTEXT_NO_FLAGS,XKB_CONTEXT_NO_DEFAULT_INCLUDES,XKB_CONTEXT_NO_ENVIRONMENT_NAMES" },
  { "xkb_key_direction", 134, _cffi_prim_int(sizeof(enum xkb_key_direction), ((enum xkb_key_direction)-1) <= 0),
    "XKB_KEY_UP,XKB_KEY_DOWN" },
  { "xkb_keymap_compile_flags", 135, _cffi_prim_int(sizeof(enum xkb_keymap_compile_flags), ((enum xkb_keymap_compile_flags)-1) <= 0),
    "XKB_KEYMAP_COMPILE_NO_FLAGS" },
  { "xkb_keymap_format", 136, _cffi_prim_int(sizeof(enum xkb_keymap_format), ((enum xkb_keymap_format)-1) <= 0),
    "XKB_KEYMAP_FORMAT_TEXT_V1" },
  { "xkb_keysym_flags", 137, _cffi_prim_int(sizeof(enum xkb_keysym_flags), ((enum xkb_keysym_flags)-1) <= 0),
    "XKB_KEYSYM_NO_FLAGS,XKB_KEYSYM_CASE_INSENSITIVE" },
  { "xkb_log_level", 138, _cffi_prim_int(sizeof(enum xkb_log_level), ((enum xkb_log_level)-1) <= 0),
    "XKB_LOG_LEVEL_CRITICAL,XKB_LOG_LEVEL_ERROR,XKB_LOG_LEVEL_WARNING,XKB_LOG_LEVEL_INFO,XKB_LOG_LEVEL_DEBUG" },
  { "xkb_state_component", 139, _cffi_prim_int(sizeof(enum xkb_state_component), ((enum xkb_state_component)-1) <= 0),
    "XKB_STATE_MODS_DEPRESSED,XKB_STATE_MODS_LATCHED,XKB_STATE_MODS_LOCKED,XKB_STATE_MODS_EFFECTIVE,XKB_STATE_LAYOUT_DEPRESSED,XKB_STATE_LAYOUT_LATCHED,XKB_STATE_LAYOUT_LOCKED,XKB_STATE_LAYOUT_EFFECTIVE,XKB_STATE_LEDS" },
  { "xkb_state_match", 140, _cffi_prim_int(sizeof(enum xkb_state_match), ((enum xkb_state_match)-1) <= 0),
    "XKB_STATE_MATCH_ANY,XKB_STATE_MATCH_ALL,XKB_STATE_MATCH_NON_EXCLUSIVE" },
  { "zwlr_layer_shell_v1_layer", 141, _cffi_prim_int(sizeof(enum zwlr_layer_shell_v1_layer), ((enum zwlr_layer_shell_v1_layer)-1) <= 0),
    "" },
  { "zwlr_layer_surface_v1_keyboard_interactivity", 142, _cffi_prim_int(sizeof(enum zwlr_layer_surface_v1_keyboard_interactivity), ((enum zwlr_layer_surface_v1_keyboard_interactivity)-1) <= 0),
    "" },
  { "zwlr_output_power_v1_mode", 143, _cffi_prim_int(sizeof(enum zwlr_output_power_v1_mode), ((enum zwlr_output_power_v1_mode)-1) <= 0),
    "" },
  { "zwp_pointer_constraints_v1_lifetime", 144, _cffi_prim_int(sizeof(enum zwp_pointer_constraints_v1_lifetime), ((enum zwp_pointer_constraints_v1_lifetime)-1) <= 0),
    "" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "FILE", 101 },
  { "clockid_t", 149 },
  { "gid_t", 326 },
  { "pid_t", 42 },
  { "time_t", 324 },
  { "uid_t", 326 },
  { "va_list", 327 },
  { "wl_dispatcher_func_t", 148 },
  { "wl_event_loop_fd_func_t", 145 },
  { "wl_event_loop_idle_func_t", 334 },
  { "wl_event_loop_signal_func_t", 146 },
  { "wl_event_loop_timer_func_t", 147 },
  { "wl_fixed_t", 149 },
  { "wl_global_bind_func_t", 329 },
  { "wl_notify_func_t", 330 },
  { "wl_resource_destroy_func_t", 331 },
  { "wlr_surface_iterator_func_t", 332 },
  { "wrapped_log_func_t", 328 },
  { "xcb_atom_t", 46 },
  { "xcb_connection_t", 336 },
  { "xcb_generic_error_t", 337 },
  { "xcb_generic_event_t", 338 },
  { "xcb_intern_atom_cookie_t", 339 },
  { "xcb_intern_atom_reply_t", 340 },
  { "xcb_pixmap_t", 46 },
  { "xcb_window_t", 46 },
  { "xkb_keycode_t", 46 },
  { "xkb_keymap_key_iter_t", 333 },
  { "xkb_keysym_t", 46 },
  { "xkb_layout_index_t", 46 },
  { "xkb_layout_mask_t", 46 },
  { "xkb_led_index_t", 46 },
  { "xkb_led_mask_t", 46 },
  { "xkb_level_index_t", 46 },
  { "xkb_mod_index_t", 46 },
  { "xkb_mod_mask_t", 46 },
};

static const char * const _cffi_includes[] = {
  "wlroots._ffi",
  NULL
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  132,  /* num_globals */
  182,  /* num_struct_unions */
  52,  /* num_enums */
  36,  /* num_typenames */
  _cffi_includes,
  341,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__libinput(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__libinput(void) { return NULL; }
#  else
     init_libinput(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__libinput(void)
{
  return _cffi_init("libqtile.backend.wayland._libinput", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_libinput(void)
{
  _cffi_init("libqtile.backend.wayland._libinput", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
