# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
TopoDS module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_topods.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _TopoDS
else:
    import _TopoDS

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _TopoDS.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _TopoDS.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TopoDS.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TopoDS.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _TopoDS.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _TopoDS.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _TopoDS.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _TopoDS.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _TopoDS.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _TopoDS.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TopoDS.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _TopoDS.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _TopoDS.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TopoDS.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TopoDS.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TopoDS.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _TopoDS.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _TopoDS:
_TopoDS.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _TopoDS.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_TopoDS_HShape_Create() -> "opencascade::handle< TopoDS_HShape >":
    return _TopoDS.Handle_TopoDS_HShape_Create()

def Handle_TopoDS_HShape_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_HShape >":
    return _TopoDS.Handle_TopoDS_HShape_DownCast(t)

def Handle_TopoDS_HShape_IsNull(t: "opencascade::handle< TopoDS_HShape > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_HShape_IsNull(t)

def Handle_TopoDS_TShape_Create() -> "opencascade::handle< TopoDS_TShape >":
    return _TopoDS.Handle_TopoDS_TShape_Create()

def Handle_TopoDS_TShape_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TShape >":
    return _TopoDS.Handle_TopoDS_TShape_DownCast(t)

def Handle_TopoDS_TShape_IsNull(t: "opencascade::handle< TopoDS_TShape > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TShape_IsNull(t)

def Handle_TopoDS_TCompSolid_Create() -> "opencascade::handle< TopoDS_TCompSolid >":
    return _TopoDS.Handle_TopoDS_TCompSolid_Create()

def Handle_TopoDS_TCompSolid_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TCompSolid >":
    return _TopoDS.Handle_TopoDS_TCompSolid_DownCast(t)

def Handle_TopoDS_TCompSolid_IsNull(t: "opencascade::handle< TopoDS_TCompSolid > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TCompSolid_IsNull(t)

def Handle_TopoDS_TCompound_Create() -> "opencascade::handle< TopoDS_TCompound >":
    return _TopoDS.Handle_TopoDS_TCompound_Create()

def Handle_TopoDS_TCompound_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TCompound >":
    return _TopoDS.Handle_TopoDS_TCompound_DownCast(t)

def Handle_TopoDS_TCompound_IsNull(t: "opencascade::handle< TopoDS_TCompound > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TCompound_IsNull(t)

def Handle_TopoDS_TEdge_Create() -> "opencascade::handle< TopoDS_TEdge >":
    return _TopoDS.Handle_TopoDS_TEdge_Create()

def Handle_TopoDS_TEdge_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TEdge >":
    return _TopoDS.Handle_TopoDS_TEdge_DownCast(t)

def Handle_TopoDS_TEdge_IsNull(t: "opencascade::handle< TopoDS_TEdge > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TEdge_IsNull(t)

def Handle_TopoDS_TFace_Create() -> "opencascade::handle< TopoDS_TFace >":
    return _TopoDS.Handle_TopoDS_TFace_Create()

def Handle_TopoDS_TFace_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TFace >":
    return _TopoDS.Handle_TopoDS_TFace_DownCast(t)

def Handle_TopoDS_TFace_IsNull(t: "opencascade::handle< TopoDS_TFace > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TFace_IsNull(t)

def Handle_TopoDS_TShell_Create() -> "opencascade::handle< TopoDS_TShell >":
    return _TopoDS.Handle_TopoDS_TShell_Create()

def Handle_TopoDS_TShell_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TShell >":
    return _TopoDS.Handle_TopoDS_TShell_DownCast(t)

def Handle_TopoDS_TShell_IsNull(t: "opencascade::handle< TopoDS_TShell > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TShell_IsNull(t)

def Handle_TopoDS_TSolid_Create() -> "opencascade::handle< TopoDS_TSolid >":
    return _TopoDS.Handle_TopoDS_TSolid_Create()

def Handle_TopoDS_TSolid_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TSolid >":
    return _TopoDS.Handle_TopoDS_TSolid_DownCast(t)

def Handle_TopoDS_TSolid_IsNull(t: "opencascade::handle< TopoDS_TSolid > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TSolid_IsNull(t)

def Handle_TopoDS_TVertex_Create() -> "opencascade::handle< TopoDS_TVertex >":
    return _TopoDS.Handle_TopoDS_TVertex_Create()

def Handle_TopoDS_TVertex_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TVertex >":
    return _TopoDS.Handle_TopoDS_TVertex_DownCast(t)

def Handle_TopoDS_TVertex_IsNull(t: "opencascade::handle< TopoDS_TVertex > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TVertex_IsNull(t)

def Handle_TopoDS_TWire_Create() -> "opencascade::handle< TopoDS_TWire >":
    return _TopoDS.Handle_TopoDS_TWire_Create()

def Handle_TopoDS_TWire_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TopoDS_TWire >":
    return _TopoDS.Handle_TopoDS_TWire_DownCast(t)

def Handle_TopoDS_TWire_IsNull(t: "opencascade::handle< TopoDS_TWire > const &") -> "bool":
    return _TopoDS.Handle_TopoDS_TWire_IsNull(t)
class TopoDS_ListIteratorOfListOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _TopoDS.TopoDS_ListIteratorOfListOfShape_swiginit(self, _TopoDS.new_TopoDS_ListIteratorOfListOfShape(*args))

    def More(self) -> "Standard_Boolean":
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_More(self)

    def Next(self) -> "void":
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_Next(self)

    def Value(self) -> "TopoDS_Shape const &":
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_Value(self)

    def ChangeValue(self) -> "TopoDS_Shape &":
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_ChangeValue(self)
    __swig_destroy__ = _TopoDS.delete_TopoDS_ListIteratorOfListOfShape

# Register TopoDS_ListIteratorOfListOfShape in _TopoDS:
_TopoDS.TopoDS_ListIteratorOfListOfShape_swigregister(TopoDS_ListIteratorOfListOfShape)

class TopoDS_ListOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_List< TopoDS_Shape >::iterator":
        return _TopoDS.TopoDS_ListOfShape_begin(self)

    def end(self) -> "NCollection_List< TopoDS_Shape >::iterator":
        return _TopoDS.TopoDS_ListOfShape_end(self)

    def cbegin(self) -> "NCollection_List< TopoDS_Shape >::const_iterator":
        return _TopoDS.TopoDS_ListOfShape_cbegin(self)

    def cend(self) -> "NCollection_List< TopoDS_Shape >::const_iterator":
        return _TopoDS.TopoDS_ListOfShape_cend(self)

    def __init__(self, *args):
        _TopoDS.TopoDS_ListOfShape_swiginit(self, _TopoDS.new_TopoDS_ListOfShape(*args))

    def Size(self) -> "Standard_Integer":
        return _TopoDS.TopoDS_ListOfShape_Size(self)

    def Assign(self, theOther: "TopoDS_ListOfShape") -> "NCollection_List< TopoDS_Shape > &":
        return _TopoDS.TopoDS_ListOfShape_Assign(self, theOther)

    def Set(self, theOther: "TopoDS_ListOfShape") -> "NCollection_List< TopoDS_Shape > &":
        return _TopoDS.TopoDS_ListOfShape_Set(self, theOther)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _TopoDS.TopoDS_ListOfShape_Clear(self, theAllocator)

    def First(self) -> "TopoDS_Shape const &":
        return _TopoDS.TopoDS_ListOfShape_First(self)

    def Last(self) -> "TopoDS_Shape const &":
        return _TopoDS.TopoDS_ListOfShape_Last(self)

    def Append(self, *args) -> "void":
        return _TopoDS.TopoDS_ListOfShape_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _TopoDS.TopoDS_ListOfShape_Prepend(self, *args)

    def RemoveFirst(self) -> "void":
        return _TopoDS.TopoDS_ListOfShape_RemoveFirst(self)

    def Remove(self, theIter: "TopoDS_ListIteratorOfListOfShape") -> "void":
        return _TopoDS.TopoDS_ListOfShape_Remove(self, theIter)

    def InsertBefore(self, *args) -> "void":
        return _TopoDS.TopoDS_ListOfShape_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _TopoDS.TopoDS_ListOfShape_InsertAfter(self, *args)

    def Reverse(self) -> "void":
        return _TopoDS.TopoDS_ListOfShape_Reverse(self)
    __swig_destroy__ = _TopoDS.delete_TopoDS_ListOfShape

    def __len__(self):
        return self.Size()


# Register TopoDS_ListOfShape in _TopoDS:
_TopoDS.TopoDS_ListOfShape_swigregister(TopoDS_ListOfShape)

class topods(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def CompSolid(*args) -> "TopoDS_CompSolid":
        r"""
        Casts shape s to the more specialized return type, compsolid. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_CompSolid
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_CompSolid

        """
        return _TopoDS.topods_CompSolid(*args)

    @staticmethod
    def Compound(*args) -> "TopoDS_Compound":
        r"""
        Casts shape s to the more specialized return type, compound. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Compound
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Compound

        """
        return _TopoDS.topods_Compound(*args)

    @staticmethod
    def Edge(*args) -> "TopoDS_Edge":
        r"""
        Casts shape s to the more specialized return type, edge exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Edge
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Edge

        """
        return _TopoDS.topods_Edge(*args)

    @staticmethod
    def Face(*args) -> "TopoDS_Face":
        r"""
        Casts shape s to the more specialized return type, face. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Face
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Face

        """
        return _TopoDS.topods_Face(*args)

    @staticmethod
    def Shell(*args) -> "TopoDS_Shell":
        r"""
        Casts shape s to the more specialized return type, shell. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Shell
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Shell

        """
        return _TopoDS.topods_Shell(*args)

    @staticmethod
    def Solid(*args) -> "TopoDS_Solid":
        r"""
        Casts shape s to the more specialized return type, solid. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Solid
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Solid

        """
        return _TopoDS.topods_Solid(*args)

    @staticmethod
    def Vertex(*args) -> "TopoDS_Vertex":
        r"""
        Basic tool to access the data structure. casts shape s to the more specialized return type, vertex. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Vertex
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Vertex

        """
        return _TopoDS.topods_Vertex(*args)

    @staticmethod
    def Wire(*args) -> "TopoDS_Wire":
        r"""
        Casts shape s to the more specialized return type, wire. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Wire
        No available documentation.

        Parameters
        ----------
        &: TopoDS_Shape

        Returns
        -------
        TopoDS_Wire

        """
        return _TopoDS.topods_Wire(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _TopoDS.topods_swiginit(self, _TopoDS.new_topods())
    __swig_destroy__ = _TopoDS.delete_topods

# Register topods in _TopoDS:
_TopoDS.topods_swigregister(topods)

def topods_CompSolid(*args) -> "TopoDS_CompSolid":
    r"""
    Casts shape s to the more specialized return type, compsolid. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_CompSolid
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_CompSolid

    """
    return _TopoDS.topods_CompSolid(*args)

def topods_Compound(*args) -> "TopoDS_Compound":
    r"""
    Casts shape s to the more specialized return type, compound. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Compound
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Compound

    """
    return _TopoDS.topods_Compound(*args)

def topods_Edge(*args) -> "TopoDS_Edge":
    r"""
    Casts shape s to the more specialized return type, edge exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Edge
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Edge

    """
    return _TopoDS.topods_Edge(*args)

def topods_Face(*args) -> "TopoDS_Face":
    r"""
    Casts shape s to the more specialized return type, face. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Face
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Face

    """
    return _TopoDS.topods_Face(*args)

def topods_Shell(*args) -> "TopoDS_Shell":
    r"""
    Casts shape s to the more specialized return type, shell. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Shell
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Shell

    """
    return _TopoDS.topods_Shell(*args)

def topods_Solid(*args) -> "TopoDS_Solid":
    r"""
    Casts shape s to the more specialized return type, solid. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Solid
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Solid

    """
    return _TopoDS.topods_Solid(*args)

def topods_Vertex(*args) -> "TopoDS_Vertex":
    r"""
    Basic tool to access the data structure. casts shape s to the more specialized return type, vertex. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Vertex
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Vertex

    """
    return _TopoDS.topods_Vertex(*args)

def topods_Wire(*args) -> "TopoDS_Wire":
    r"""
    Casts shape s to the more specialized return type, wire. exceptions standard_typemismatch if s cannot be cast to this return type.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    TopoDS_Wire
    No available documentation.

    Parameters
    ----------
    &: TopoDS_Shape

    Returns
    -------
    TopoDS_Wire

    """
    return _TopoDS.topods_Wire(*args)

class TopoDS_AlertAttribute(OCC.Core.Message.Message_AttributeStream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor with shape argument.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theName: TCollection_AsciiString,optional
        	default value is TCollection_AsciiString()

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_AlertAttribute_swiginit(self, _TopoDS.new_TopoDS_AlertAttribute(*args))

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(TopoDS_AlertAttribute self, int depth=-1) -> std::string"""
        return _TopoDS.TopoDS_AlertAttribute_DumpJsonToString(self, depth)

    def GetShape(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns contained shape.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_AlertAttribute_GetShape(self, *args)

    @staticmethod
    def Send(*args) -> "void":
        r"""
        Push shape information into messenger.

        Parameters
        ----------
        theMessenger: Message_Messenger
        theShape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_AlertAttribute_Send(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_AlertAttribute

# Register TopoDS_AlertAttribute in _TopoDS:
_TopoDS.TopoDS_AlertAttribute_swigregister(TopoDS_AlertAttribute)

def TopoDS_AlertAttribute_Send(*args) -> "void":
    r"""
    Push shape information into messenger.

    Parameters
    ----------
    theMessenger: Message_Messenger
    theShape: TopoDS_Shape

    Returns
    -------
    None

    """
    return _TopoDS.TopoDS_AlertAttribute_Send(*args)

class TopoDS_AlertWithShape(OCC.Core.Message.Message_Alert):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor with shape argument.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_AlertWithShape_swiginit(self, _TopoDS.new_TopoDS_AlertWithShape(*args))

    def GetShape(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns contained shape.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_AlertWithShape_GetShape(self, *args)

    def SetShape(self, *args) -> "void":
        r"""
        Sets the shape.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_AlertWithShape_SetShape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_AlertWithShape

# Register TopoDS_AlertWithShape in _TopoDS:
_TopoDS.TopoDS_AlertWithShape_swigregister(TopoDS_AlertWithShape)

class TopoDS_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Add(self, *args) -> "void":
        r"""
        Add the shape c in the shape s. exceptions - topods_frozenshape if s is not free and cannot be modified. - topods__uncompatibleshapes if s and c are not compatible.

        Parameters
        ----------
        S: TopoDS_Shape
        C: TopoDS_Shape

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_Add(self, *args)

    def MakeCompSolid(self, *args) -> "void":
        r"""
        Make an empty composite solid.

        Parameters
        ----------
        C: TopoDS_CompSolid

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_MakeCompSolid(self, *args)

    def MakeCompound(self, *args) -> "void":
        r"""
        Make an empty compound.

        Parameters
        ----------
        C: TopoDS_Compound

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_MakeCompound(self, *args)

    def MakeShell(self, *args) -> "void":
        r"""
        Make an empty shell.

        Parameters
        ----------
        S: TopoDS_Shell

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_MakeShell(self, *args)

    def MakeSolid(self, *args) -> "void":
        r"""
        Make a solid covering the whole 3d space.

        Parameters
        ----------
        S: TopoDS_Solid

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_MakeSolid(self, *args)

    def MakeWire(self, *args) -> "void":
        r"""
        Make an empty wire.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_MakeWire(self, *args)

    def Remove(self, *args) -> "void":
        r"""
        Remove the shape c from the shape s. exceptions topods_frozenshape if s is frozen and cannot be modified.

        Parameters
        ----------
        S: TopoDS_Shape
        C: TopoDS_Shape

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Builder_Remove(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _TopoDS.TopoDS_Builder_swiginit(self, _TopoDS.new_TopoDS_Builder())
    __swig_destroy__ = _TopoDS.delete_TopoDS_Builder

# Register TopoDS_Builder in _TopoDS:
_TopoDS.TopoDS_Builder_swigregister(TopoDS_Builder)

class TopoDS_HShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty shape object.

        Returns
        -------
        None
        Constructs a shape object defined by the shape ashape.

        Parameters
        ----------
        aShape: TopoDS_Shape

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_HShape_swiginit(self, _TopoDS.new_TopoDS_HShape(*args))

    def ChangeShape(self, *args) -> "TopoDS_Shape":
        r"""
        Exchanges the topods_shape object defining this shape for another one referencing the same underlying shape accesses the list of shapes within the underlying shape referenced by the topods_shape object. returns a reference to a topods_shape based on this shape. the topods_shape can be modified.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_HShape_ChangeShape(self, *args)

    def Shape(self, *args) -> "TopoDS_Shape const":
        r"""
        Loads this shape with the shape ashape.

        Parameters
        ----------
        aShape: TopoDS_Shape

        Returns
        -------
        None
        Returns a reference to a constant topods_shape based on this shape.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_HShape_Shape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_HShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_HShape

# Register TopoDS_HShape in _TopoDS:
_TopoDS.TopoDS_HShape_swigregister(TopoDS_HShape)

class TopoDS_Iterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty iterator.

        Returns
        -------
        None
        Creates an iterator on <s> sub-shapes. note: - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        Parameters
        ----------
        S: TopoDS_Shape
        cumOri: bool,optional
        	default value is Standard_True
        cumLoc: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Iterator_swiginit(self, _TopoDS.new_TopoDS_Iterator(*args))

    def Initialize(self, *args) -> "void":
        r"""
        Initializes this iterator with shape s. note: - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        Parameters
        ----------
        S: TopoDS_Shape
        cumOri: bool,optional
        	default value is Standard_True
        cumLoc: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Iterator_Initialize(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there is another sub-shape in the shape which this iterator is scanning.

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Iterator_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Moves on to the next sub-shape in the shape which this iterator is scanning. exceptions standard_nomoreobject if there are no more sub-shapes in the shape.

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Iterator_Next(self, *args)

    def Value(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns the current sub-shape in the shape which this iterator is scanning. exceptions standard_nosuchobject if there is no current sub-shape.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Iterator_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Iterator

# Register TopoDS_Iterator in _TopoDS:
_TopoDS.TopoDS_Iterator_swigregister(TopoDS_Iterator)

class TopoDS_Shape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TopoDS_Shape self, TopoDS_Shape arg0) -> TopoDS_ShapeCreates a null shape referring to nothing.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Shape_swiginit(self, _TopoDS.new_TopoDS_Shape(*args))

    def Checked(self, *args) -> "void":
        r"""
        Returns the checked flag.

        Returns
        -------
        bool
        Sets the checked flag.

        Parameters
        ----------
        theIsChecked: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Checked(self, *args)

    def Closed(self, *args) -> "void":
        r"""
        Returns the closedness flag.

        Returns
        -------
        bool
        Sets the closedness flag.

        Parameters
        ----------
        theIsClosed: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Closed(self, *args)

    def Complement(self, *args) -> "void":
        r"""
        Complements the orientation, using the complement method from the topabs package.

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Complement(self, *args)

    def Complemented(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with the orientation complemented, using the complement method from the topabs package.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Complemented(self, *args)

    def Compose(self, *args) -> "void":
        r"""
        Updates the shape orientation by composition with theorient, using the compose method from the topabs package.

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Compose(self, *args)

    def Composed(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with the orientation composed with theorient, using the compose method from the topabs package.

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Composed(self, *args)

    def Convex(self, *args) -> "void":
        r"""
        Returns the convexness flag.

        Returns
        -------
        bool
        Sets the convexness flag.

        Parameters
        ----------
        theIsConvex: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Convex(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(TopoDS_Shape self, int depth=-1) -> std::string"""
        return _TopoDS.TopoDS_Shape_DumpJsonToString(self, depth)

    def EmptyCopied(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a new shape with the same orientation and location and a new tshape with the same geometry and no sub-shapes.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_EmptyCopied(self, *args)

    def EmptyCopy(self, *args) -> "void":
        r"""
        Replace <self> by a new shape with the same orientation and location and a new tshape with the same geometry and no sub-shapes.

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_EmptyCopy(self, *args)

    def Free(self, *args) -> "void":
        r"""
        Returns the free flag.

        Returns
        -------
        bool
        Sets the free flag.

        Parameters
        ----------
        theIsFree: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Free(self, *args)

    def HashCode(self, *args) -> "Standard_Integer":
        r"""
        Returns a hashed value denoting <self>. this value is in the range [1, theupperbound]. it is computed from the tshape and the location. the orientation is not used. @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theUpperBound: int

        Returns
        -------
        int

        """
        return _TopoDS.TopoDS_Shape_HashCode(self, *args)

    def __hash__(self) -> "Standard_Integer":
        r"""__hash__(TopoDS_Shape self) -> Standard_Integer"""
        return _TopoDS.TopoDS_Shape___hash__(self)

    def Infinite(self, *args) -> "void":
        r"""
        Returns the infinity flag.

        Returns
        -------
        bool
        Sets the infinity flag.

        Parameters
        ----------
        theIsInfinite: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Infinite(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if two shapes are equal, i.e. if they share the same tshape with the same locations and orientations.

        Parameters
        ----------
        theOther: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Shape_IsEqual(self, *args)

    def IsNotEqual(self, *args) -> "Standard_Boolean":
        r"""
        Negation of the isequal method.

        Parameters
        ----------
        theOther: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Shape_IsNotEqual(self, *args)

    def IsNull(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this shape is null. in other words, it references no underlying shape with the potential to be given a location and an orientation.

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Shape_IsNull(self, *args)

    def IsPartner(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if two shapes are partners, i.e. if they share the same tshape. locations and orientations may differ.

        Parameters
        ----------
        theOther: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Shape_IsPartner(self, *args)

    def IsSame(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if two shapes are same, i.e. if they share the same tshape with the same locations. orientations may differ.

        Parameters
        ----------
        theOther: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _TopoDS.TopoDS_Shape_IsSame(self, *args)

    def Located(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with the local coordinate system set to <loc>.

        Parameters
        ----------
        theLoc: TopLoc_Location

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Located(self, *args)

    def Location(self, *args) -> "void":
        r"""
        Returns the shape local coordinate system.

        Returns
        -------
        TopLoc_Location
        Sets the shape local coordinate system.

        Parameters
        ----------
        theLoc: TopLoc_Location

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Location(self, *args)

    def Locked(self, *args) -> "void":
        r"""
        Returns the locked flag.

        Returns
        -------
        bool
        Sets the locked flag.

        Parameters
        ----------
        theIsLocked: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Locked(self, *args)

    def Modified(self, *args) -> "void":
        r"""
        Returns the modification flag.

        Returns
        -------
        bool
        Sets the modification flag.

        Parameters
        ----------
        theIsModified: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Modified(self, *args)

    def Move(self, *args) -> "void":
        r"""
        Multiplies the shape location by theposition.

        Parameters
        ----------
        thePosition: TopLoc_Location

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Move(self, *args)

    def Moved(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with a location multiplied by theposition.

        Parameters
        ----------
        thePosition: TopLoc_Location

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Moved(self, *args)

    def NbChildren(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of direct sub-shapes (children). @sa topods_iterator for accessing sub-shapes.

        Returns
        -------
        int

        """
        return _TopoDS.TopoDS_Shape_NbChildren(self, *args)

    def Nullify(self, *args) -> "void":
        r"""
        Destroys the reference to the underlying shape stored in this shape. as a result, this shape becomes null.

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Nullify(self, *args)

    def Orientable(self, *args) -> "void":
        r"""
        Returns the orientability flag.

        Returns
        -------
        bool
        Sets the orientability flag.

        Parameters
        ----------
        theIsOrientable: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Orientable(self, *args)

    def Orientation(self, *args) -> "void":
        r"""
        Returns the shape orientation.

        Returns
        -------
        TopAbs_Orientation
        Sets the shape orientation.

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Orientation(self, *args)

    def Oriented(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with the orientation set to <or>.

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Oriented(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the orientation, using the reverse method from the topabs package.

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_Reverse(self, *args)

    def Reversed(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a shape similar to <self> with the orientation reversed, using the reverse method from the topabs package.

        Returns
        -------
        TopoDS_Shape

        """
        return _TopoDS.TopoDS_Shape_Reversed(self, *args)

    def ShapeType(self, *args) -> "TopAbs_ShapeEnum":
        r"""
        Returns the value of the topabs_shapeenum enumeration that corresponds to this shape, for example vertex, edge, and so on. exceptions standard_nullobject if this shape is null.

        Returns
        -------
        TopAbs_ShapeEnum

        """
        return _TopoDS.TopoDS_Shape_ShapeType(self, *args)

    def TShape(self, *args) -> "void":
        r"""
        Returns a handle to the actual shape implementation.

        Returns
        -------
        opencascade::handle<TopoDS_TShape>
        No available documentation.

        Parameters
        ----------
        theTShape: TopoDS_TShape

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_Shape_TShape(self, *args)

    def __ne_wrapper__(self, other: "TopoDS_Shape") -> "bool":
        r"""__ne_wrapper__(TopoDS_Shape self, TopoDS_Shape other) -> bool"""
        return _TopoDS.TopoDS_Shape___ne_wrapper__(self, other)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __eq_wrapper__(self, other: "TopoDS_Shape") -> "bool":
        r"""__eq_wrapper__(TopoDS_Shape self, TopoDS_Shape other) -> bool"""
        return _TopoDS.TopoDS_Shape___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    def __getstate__(self):
    	from .BRepTools import breptools_WriteToString
    	str_shape = breptools_WriteToString(self, True)
    	return str_shape
    def __setstate__(self, state):
    	from .BRepTools import breptools_ReadFromString
    	the_shape = breptools_ReadFromString(state)
    	self.this = the_shape.this


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Shape

# Register TopoDS_Shape in _TopoDS:
_TopoDS.TopoDS_Shape_swigregister(TopoDS_Shape)

class TopoDS_TShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Checked(self, *args) -> "void":
        r"""
        Returns the checked flag.

        Returns
        -------
        bool
        Sets the checked flag.

        Parameters
        ----------
        theIsChecked: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Checked(self, *args)

    def Closed(self, *args) -> "void":
        r"""
        Returns the closedness flag.

        Returns
        -------
        bool
        Sets the closedness flag.

        Parameters
        ----------
        theIsClosed: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Closed(self, *args)

    def Convex(self, *args) -> "void":
        r"""
        Returns the convexness flag.

        Returns
        -------
        bool
        Sets the convexness flag.

        Parameters
        ----------
        theIsConvex: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Convex(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(TopoDS_TShape self, int depth=-1) -> std::string"""
        return _TopoDS.TopoDS_TShape_DumpJsonToString(self, depth)

    def EmptyCopy(self, *args) -> "opencascade::handle< TopoDS_TShape >":
        r"""
        Returns a copy of the tshape with no sub-shapes.

        Returns
        -------
        opencascade::handle<TopoDS_TShape>

        """
        return _TopoDS.TopoDS_TShape_EmptyCopy(self, *args)

    def Free(self, *args) -> "void":
        r"""
        Returns the free flag.

        Returns
        -------
        bool
        Sets the free flag.

        Parameters
        ----------
        theIsFree: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Free(self, *args)

    def Infinite(self, *args) -> "void":
        r"""
        Returns the infinity flag.

        Returns
        -------
        bool
        Sets the infinity flag.

        Parameters
        ----------
        theIsInfinite: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Infinite(self, *args)

    def Locked(self, *args) -> "void":
        r"""
        Returns the locked flag.

        Returns
        -------
        bool
        Sets the locked flag.

        Parameters
        ----------
        theIsLocked: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Locked(self, *args)

    def Modified(self, *args) -> "void":
        r"""
        Returns the modification flag.

        Returns
        -------
        bool
        Sets the modification flag.

        Parameters
        ----------
        theIsModified: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Modified(self, *args)

    def NbChildren(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of direct sub-shapes (children). @sa topods_iterator for accessing sub-shapes.

        Returns
        -------
        int

        """
        return _TopoDS.TopoDS_TShape_NbChildren(self, *args)

    def Orientable(self, *args) -> "void":
        r"""
        Returns the orientability flag.

        Returns
        -------
        bool
        Sets the orientability flag.

        Parameters
        ----------
        theIsOrientable: bool

        Returns
        -------
        None

        """
        return _TopoDS.TopoDS_TShape_Orientable(self, *args)

    def ShapeType(self, *args) -> "TopAbs_ShapeEnum":
        r"""
        Returns the type as a term of the shapeenum enum : vertex, edge, wire, face, ....

        Returns
        -------
        TopAbs_ShapeEnum

        """
        return _TopoDS.TopoDS_TShape_ShapeType(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TShape

# Register TopoDS_TShape in _TopoDS:
_TopoDS.TopoDS_TShape_swigregister(TopoDS_TShape)

class TopoDS_CompSolid(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an undefined compsolid.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_CompSolid_swiginit(self, _TopoDS.new_TopoDS_CompSolid(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_CompSolid

# Register TopoDS_CompSolid in _TopoDS:
_TopoDS.TopoDS_CompSolid_swigregister(TopoDS_CompSolid)

class TopoDS_Compound(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an undefined compound.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Compound_swiginit(self, _TopoDS.new_TopoDS_Compound(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Compound

# Register TopoDS_Compound in _TopoDS:
_TopoDS.TopoDS_Compound_swigregister(TopoDS_Compound)

class TopoDS_Edge(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined edge.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Edge_swiginit(self, _TopoDS.new_TopoDS_Edge(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Edge

# Register TopoDS_Edge in _TopoDS:
_TopoDS.TopoDS_Edge_swigregister(TopoDS_Edge)

class TopoDS_Face(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined face.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Face_swiginit(self, _TopoDS.new_TopoDS_Face(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Face

# Register TopoDS_Face in _TopoDS:
_TopoDS.TopoDS_Face_swigregister(TopoDS_Face)

class TopoDS_Shell(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an undefined shell.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Shell_swiginit(self, _TopoDS.new_TopoDS_Shell(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Shell

# Register TopoDS_Shell in _TopoDS:
_TopoDS.TopoDS_Shell_swigregister(TopoDS_Shell)

class TopoDS_Solid(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an undefined solid.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Solid_swiginit(self, _TopoDS.new_TopoDS_Solid(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Solid

# Register TopoDS_Solid in _TopoDS:
_TopoDS.TopoDS_Solid_swigregister(TopoDS_Solid)

class TopoDS_TCompSolid(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tcompsolid.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TCompSolid_swiginit(self, _TopoDS.new_TopoDS_TCompSolid(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TCompSolid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TCompSolid

# Register TopoDS_TCompSolid in _TopoDS:
_TopoDS.TopoDS_TCompSolid_swigregister(TopoDS_TCompSolid)

class TopoDS_TCompound(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tcompound.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TCompound_swiginit(self, _TopoDS.new_TopoDS_TCompound(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TCompound_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TCompound

# Register TopoDS_TCompound in _TopoDS:
_TopoDS.TopoDS_TCompound_swigregister(TopoDS_TCompound)

class TopoDS_TEdge(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TEdge_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TEdge

# Register TopoDS_TEdge in _TopoDS:
_TopoDS.TopoDS_TEdge_swigregister(TopoDS_TEdge)

class TopoDS_TFace(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tface.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TFace_swiginit(self, _TopoDS.new_TopoDS_TFace(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TFace_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TFace

# Register TopoDS_TFace in _TopoDS:
_TopoDS.TopoDS_TFace_swigregister(TopoDS_TFace)

class TopoDS_TShell(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tshell.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TShell_swiginit(self, _TopoDS.new_TopoDS_TShell(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TShell_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TShell

# Register TopoDS_TShell in _TopoDS:
_TopoDS.TopoDS_TShell_swigregister(TopoDS_TShell)

class TopoDS_TSolid(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty tsolid.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TSolid_swiginit(self, _TopoDS.new_TopoDS_TSolid(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TSolid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TSolid

# Register TopoDS_TSolid in _TopoDS:
_TopoDS.TopoDS_TSolid_swigregister(TopoDS_TSolid)

class TopoDS_TVertex(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TVertex_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TVertex

# Register TopoDS_TVertex in _TopoDS:
_TopoDS.TopoDS_TVertex_swigregister(TopoDS_TVertex)

class TopoDS_TWire(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty twire.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_TWire_swiginit(self, _TopoDS.new_TopoDS_TWire(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TWire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TWire

# Register TopoDS_TWire in _TopoDS:
_TopoDS.TopoDS_TWire_swigregister(TopoDS_TWire)

class TopoDS_Vertex(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TopoDS_Vertex self, TopoDS_Vertex arg0) -> TopoDS_VertexUndefined vertex.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Vertex_swiginit(self, _TopoDS.new_TopoDS_Vertex(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Vertex

# Register TopoDS_Vertex in _TopoDS:
_TopoDS.TopoDS_Vertex_swigregister(TopoDS_Vertex)

class TopoDS_Wire(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined wire.

        Returns
        -------
        None

        """
        _TopoDS.TopoDS_Wire_swiginit(self, _TopoDS.new_TopoDS_Wire(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Wire

# Register TopoDS_Wire in _TopoDS:
_TopoDS.TopoDS_Wire_swigregister(TopoDS_Wire)





