# Function API Reference

This page is a reference for the functions available in Promscale.

A description of the usage of these functions, and examples can be found in
[our description of the sql schema](sql_schema.md)

<!--
SQL To generate

\pset border 1
\pset format aligned
\pset linestyle ascii
\o funcs.txt
SELECT
  n.nspname as "Schema",
  p.proname as "Name",
  pg_catalog.pg_get_function_arguments(p.oid) as "Argument data types",
  pg_catalog.pg_get_function_result(p.oid) as "Result data type",
  p.proname || ' ' || pg_catalog.obj_description(p.oid, 'pg_proc') || '.' as "Description"
FROM pg_catalog.pg_proc p
     LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
     LEFT JOIN pg_catalog.pg_language l ON l.oid = p.prolang
WHERE n.nspname like 'prom_%' or n.nspname = 'ps_trace'
ORDER BY 1, 2, 3;
-->

 Schema | Name | Argument data types | Result data type | Description
--- | --- | --- | --- | ---
prom_api | add_prom_node                    | node_name text, attach_to_existing_metrics boolean DEFAULT true                           |                                                                                                                                          |
prom_api | config_maintenance_jobs          | number_jobs integer, new_schedule_interval interval, new_config jsonb DEFAULT NULL::jsonb | boolean                                                                                                                                  | config_maintenance_jobs Configure the number of maintence jobs run by the job scheduler, as well as their scheduled interval.
prom_api | drop_metric                      | metric_name_to_be_dropped text                                                            | void                                                                                                                                     |
prom_api | eq                               | labels label_array, json_labels jsonb                                                     | boolean                                                                                                                                  | eq returns true if the labels and jsonb are equal, ignoring the metric name.
prom_api | eq                               | labels1 label_array, labels2 label_array                                                  | boolean                                                                                                                                  | eq returns true if two label arrays are equal, ignoring the metric name.
prom_api | eq                               | labels1 label_array, matchers matcher_positive                                            | boolean                                                                                                                                  | eq returns true if the label array and matchers are equal, there should not be a matcher for the metric name.
prom_api | execute_maintenance              | log_verbose boolean DEFAULT false                                                         |                                                                                                                                          | execute_maintenance Execute maintenance tasks like dropping data according to retention policy. This procedure should be run regularly in a cron job.
prom_api | get_metric_metadata              | metric_family_name text                                                                   | TABLE(metric_family text, type text, unit text, help text)                                                                               |
prom_api | get_multiple_metric_metadata     | metric_families text[]                                                                    | TABLE(metric_family text, type text, unit text, help text)                                                                               |
prom_api | is_normal_nan                    | value double precision                                                                    | boolean                                                                                                                                  | is_normal_nan returns true if the value is a NaN.
prom_api | is_stale_marker                  | value double precision                                                                    | boolean                                                                                                                                  | is_stale_marker returns true if the value is a Prometheus stale marker.
prom_api | jsonb                            | labels label_array                                                                        | jsonb                                                                                                                                    | jsonb converts a labels array to a JSONB object.
prom_api | key_value_array                  | labels label_array, OUT keys text[], OUT vals text[]                                      | record                                                                                                                                   | key_value_array converts a labels array to two arrays: one for keys and another for values.
prom_api | label_cardinality                | label_id integer                                                                          | integer                                                                                                                                  |
prom_api | label_key_position               | metric_name text, key text                                                                | integer                                                                                                                                  |
prom_api | labels                           | series_id bigint                                                                          | label_array                                                                                                                              | labels fetches labels array for the given series id.
prom_api | labels_info                      | INOUT labels integer[], OUT keys text[], OUT vals text[]                                  | record                                                                                                                                   | labels_info converts an array of label ids to three arrays: one for ids, one for keys and another for values.
prom_api | matcher                          | labels jsonb                                                                              | matcher_positive                                                                                                                         | matcher returns a matcher for the JSONB, __name__ is ignored. The matcher can be used to match against a label array using @> or ? operators.
prom_api | register_metric_view             | schema_name name, view_name name, if_not_exists boolean DEFAULT false                     | boolean                                                                                                                                  |
prom_api | reset_metric_chunk_interval      | metric_name text                                                                          | boolean                                                                                                                                  | reset_metric_chunk_interval resets the chunk interval for a specific metric to using the default.
prom_api | reset_metric_compression_setting | metric_name text                                                                          | boolean                                                                                                                                  | reset_metric_compression_setting resets the compression setting for a specific metric to using the default.
prom_api | reset_metric_retention_period    | metric_name text                                                                          | boolean                                                                                                                                  | reset_metric_retention_period resets the retention period for a specific raw metric in the default schema to using the default retention period.
prom_api | reset_metric_retention_period    | schema_name text, metric_name text                                                        | boolean                                                                                                                                  | reset_metric_retention_period resets the retention period for a specific metric to using the default.
prom_api | set_compression_on_metric_table  | metric_table_name text, compression_setting boolean                                       | void                                                                                                                                     | set_compression_on_metric_table set a compression for a specific metric table.
prom_api | set_default_chunk_interval       | chunk_interval interval                                                                   | boolean                                                                                                                                  | set_default_chunk_interval set the chunk interval for any metrics (existing and new) without an explicit override.
prom_api | set_default_compression_setting  | compression_setting boolean                                                               | boolean                                                                                                                                  | set_default_compression_setting set the compression setting for any metrics (existing and new) without an explicit override.
prom_api | set_default_retention_period     | retention_period interval                                                                 | boolean                                                                                                                                  | set_default_retention_period set the retention period for any metrics (existing and new) without an explicit override.
prom_api | set_metric_chunk_interval        | metric_name text, chunk_interval interval                                                 | boolean                                                                                                                                  | set_metric_chunk_interval set a chunk interval for a specific metric (this overrides the default).
prom_api | set_metric_compression_setting   | metric_name text, new_compression_setting boolean                                         | boolean                                                                                                                                  | set_metric_compression_setting set a compression setting for a specific metric (this overrides the default).
prom_api | set_metric_retention_period      | metric_name text, new_retention_period interval                                           | boolean                                                                                                                                  | set_metric_retention_period set a retention period for a specific raw metric in default schema (this overrides the default).
prom_api | set_metric_retention_period      | schema_name text, metric_name text, new_retention_period interval                         | boolean                                                                                                                                  | set_metric_retention_period set a retention period for a specific metric (this overrides the default).
prom_api | unregister_metric_view           | schema_name name, view_name name, if_exists boolean DEFAULT false                         | boolean                                                                                                                                  |
prom_api | val                              | label_id integer                                                                          | text                                                                                                                                     | val returns the label value from a label id.
ps_trace | delete_all_traces                |                                                                                           | void                                                                                                                                     | delete_all_traces WARNING: this function deletes all spans and related tracing data in the system and restores it to a "just installed" state..
ps_trace | downstream_spans                 | _trace_id trace_id, _span_id bigint, _max_dist integer DEFAULT NULL::integer              | TABLE(trace_id trace_id, parent_span_id bigint, span_id bigint, dist integer, path bigint[])                                             |
ps_trace | event_tag_type                   |                                                                                           | tag_type                                                                                                                                 |
ps_trace | get_tag_map                      | _tags jsonb                                                                               | tag_map                                                                                                                                  |
ps_trace | get_trace_retention_period       |                                                                                           | interval                                                                                                                                 | get_trace_retention_period get the retention period for trace data.
ps_trace | is_event_tag_type                | _tag_type tag_type                                                                        | boolean                                                                                                                                  |
ps_trace | is_link_tag_type                 | _tag_type tag_type                                                                        | boolean                                                                                                                                  |
ps_trace | is_resource_tag_type             | _tag_type tag_type                                                                        | boolean                                                                                                                                  |
ps_trace | is_span_tag_type                 | _tag_type tag_type                                                                        | boolean                                                                                                                                  |
ps_trace | jsonb                            | _tag_map tag_map                                                                          | jsonb                                                                                                                                    |
ps_trace | jsonb                            | _tag_map tag_map, VARIADIC _keys tag_k[]                                                  | jsonb                                                                                                                                    |
ps_trace | link_tag_type                    |                                                                                           | tag_type                                                                                                                                 |
ps_trace | operation_calls                  | _start_time_min timestamp with time zone, _start_time_max timestamp with time zone        | TABLE(parent_operation_id bigint, child_operation_id bigint, cnt bigint)                                                                 |
ps_trace | put_instrumentation_lib          | _name text, _version text, _schema_url_id bigint                                          | bigint                                                                                                                                   |
ps_trace | put_operation                    | _service_name text, _span_name text, _span_kind span_kind                                 | bigint                                                                                                                                   |
ps_trace | put_schema_url                   | _schema_url text                                                                          | bigint                                                                                                                                   |
ps_trace | put_tag                          | _key tag_k, _value tag_v, _tag_type tag_type                                              | bigint                                                                                                                                   |
ps_trace | put_tag_key                      | _key tag_k, _tag_type tag_type                                                            | bigint                                                                                                                                   |
ps_trace | resource_tag_type                |                                                                                           | tag_type                                                                                                                                 |
ps_trace | set_trace_retention_period       | _trace_retention_period interval                                                          | boolean                                                                                                                                  | set_trace_retention_period set the retention period for trace data.
ps_trace | sibling_spans                    | _trace_id trace_id, _span_id bigint                                                       | TABLE(trace_id trace_id, parent_span_id bigint, span_id bigint)                                                                          |
ps_trace | span_tag_type                    |                                                                                           | tag_type                                                                                                                                 |
ps_trace | span_tree                        | _trace_id trace_id, _span_id bigint, _max_dist integer DEFAULT NULL::integer              | TABLE(trace_id trace_id, parent_span_id bigint, span_id bigint, dist integer, is_upstream boolean, is_downstream boolean, path bigint[]) |
ps_trace | trace_tree                       | _trace_id trace_id                                                                        | TABLE(trace_id trace_id, parent_span_id bigint, span_id bigint, lvl integer, path bigint[])                                              |
ps_trace | upstream_spans                   | _trace_id trace_id, _span_id bigint, _max_dist integer DEFAULT NULL::integer              | TABLE(trace_id trace_id, parent_span_id bigint, span_id bigint, dist integer, path bigint[])                                             |
ps_trace | val                              | _tag_map tag_map, _key tag_k                                                              | tag_v                                                                                                                                    |
ps_trace | val_text                         | _tag_map tag_map, _key tag_k                                                              | text                                                                                                                                     |
