/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.time.Day;

public class ComplementDates
implements Something {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexOr(this.toRegexB(suffix), this.toRegexE(suffix));
    }

    private IRegex toRegexB(String suffix) {
        return new RegexConcat(new RegexLeaf("BYEAR1" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH1" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY1" + suffix, "([\\d]{1,2})"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("to"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("BYEAR2" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH2" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY2" + suffix, "([\\d]{1,2})"));
    }

    private IRegex toRegexE(String suffix) {
        return new RegexConcat(new RegexLeaf("[dD]\\+"), new RegexLeaf("ECOUNT1" + suffix, "([\\d]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("to"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("[dD]\\+"), new RegexLeaf("ECOUNT2" + suffix, "([\\d]+)"));
    }

    public Failable<DaysAsDates> getMe(GanttDiagram project, RegexResult arg, String suffix) {
        if (arg.get("BDAY1" + suffix, 0) != null) {
            return Failable.ok(this.resultB(arg, suffix));
        }
        if (arg.get("ECOUNT1" + suffix, 0) != null) {
            return Failable.ok(this.resultE(project, arg, suffix));
        }
        throw new IllegalStateException();
    }

    private DaysAsDates resultB(RegexResult arg, String suffix) {
        int day1 = Integer.parseInt(arg.get("BDAY1" + suffix, 0));
        int month1 = Integer.parseInt(arg.get("BMONTH1" + suffix, 0));
        int year1 = Integer.parseInt(arg.get("BYEAR1" + suffix, 0));
        Day date1 = Day.create(year1, month1, day1);
        int day2 = Integer.parseInt(arg.get("BDAY2" + suffix, 0));
        int month2 = Integer.parseInt(arg.get("BMONTH2" + suffix, 0));
        int year2 = Integer.parseInt(arg.get("BYEAR2" + suffix, 0));
        Day date2 = Day.create(year2, month2, day2);
        return new DaysAsDates(date1, date2);
    }

    private DaysAsDates resultE(GanttDiagram project, RegexResult arg, String suffix) {
        int day1 = Integer.parseInt(arg.get("ECOUNT1" + suffix, 0));
        Day date1 = project.getStartingDate().addDays(day1);
        int day2 = Integer.parseInt(arg.get("ECOUNT2" + suffix, 0));
        Day date2 = project.getStartingDate().addDays(day2);
        return new DaysAsDates(date1, date2);
    }
}

