/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.code.Base64Coder;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.atom.AtomImgSvg;
import net.sourceforge.plantuml.creole.legacy.AtomTextUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TileImageSvg;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class AtomImg
extends AbstractAtom
implements Atom {
    private static final String DATA_IMAGE_PNG_BASE64 = "data:image/png;base64,";
    private static final String DATA_IMAGE_SVG_BASE64 = "data:image/svg+xml;base64,";
    private final BufferedImage image;
    private final double scale;
    private final Url url;
    private final String rawFileName;

    private AtomImg(BufferedImage image, double scale, Url url, String rawFileName) {
        this.image = image;
        this.scale = scale;
        this.url = url;
        this.rawFileName = rawFileName;
    }

    public static Atom createQrcode(String flash, double scale) {
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        BufferedImage im = utils.exportFlashcode(flash, Color.BLACK, Color.WHITE);
        if (im == null) {
            im = new BufferedImage(10, 10, 1);
        }
        return new AtomImg(new UImage(new PixelImage(im, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(scale).getImage(1.0), 1.0, null, null);
    }

    public static Atom create(String src, ImgValign valign, int vspace, double scale, Url url) {
        UFont font = UFont.monospaced(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        if (src.startsWith(DATA_IMAGE_PNG_BASE64)) {
            String data = src.substring(DATA_IMAGE_PNG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                return AtomImg.buildRasterFromData(src, fc, bytes, scale, url);
            }
            catch (Exception e) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
        }
        if (src.startsWith(DATA_IMAGE_SVG_BASE64)) {
            String data = src.substring(DATA_IMAGE_SVG_BASE64.length(), src.length());
            try {
                byte[] bytes = Base64Coder.decode(data);
                String tmp = new String(bytes);
                return new AtomImgSvg(new TileImageSvg(tmp));
            }
            catch (Exception e) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
        }
        try {
            if (src.startsWith("http:") || src.startsWith("https:")) {
                if (src.endsWith(".svg")) {
                    return AtomImg.buildSvgFromUrl(src, fc, SURL.create(src), scale, url);
                }
                return AtomImg.buildRasterFromUrl(src, fc, SURL.create(src), scale, url);
            }
            SFile f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                    return AtomTextUtils.createLegacy("(File not found: " + f.getPrintablePath() + ")", fc);
                }
                return AtomTextUtils.createLegacy("(Cannot decode)", fc);
            }
            if (f.getName().endsWith(".svg")) {
                String tmp = FileUtils.readSvg(f);
                if (tmp == null) {
                    return AtomTextUtils.createLegacy("(Cannot decode)", fc);
                }
                return new AtomImgSvg(new TileImageSvg(tmp));
            }
            BufferedImage read = f.readRasterImageFromFile();
            if (read == null) {
                if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                    return AtomTextUtils.createLegacy("(Cannot decode: " + f.getPrintablePath() + ")", fc);
                }
                return AtomTextUtils.createLegacy("(Cannot decode)", fc);
            }
            return new AtomImg(f.readRasterImageFromFile(), scale, url, src);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                return AtomTextUtils.createLegacy("ERROR " + e.toString(), fc);
            }
            return AtomTextUtils.createLegacy("ERROR", fc);
        }
    }

    private static Atom buildRasterFromData(String source, FontConfiguration fc, byte[] data, double scale, Url url) throws IOException {
        BufferedImage read = SImageIO.read(data);
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + source + ")", fc);
        }
        return new AtomImg(read, scale, url, null);
    }

    private static Atom buildRasterFromUrl(String text, FontConfiguration fc, SURL source, double scale, Url url) throws IOException {
        if (source == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + text + ")", fc);
        }
        BufferedImage read = source.readRasterImageFromURL();
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode: " + text + ")", fc);
        }
        return new AtomImg(read, scale, url, "http");
    }

    private static Atom buildSvgFromUrl(String text, FontConfiguration fc, SURL source, double scale, Url url) throws IOException {
        if (source == null) {
            return AtomTextUtils.createLegacy("(Cannot decode SVG: " + text + ")", fc);
        }
        byte[] read = source.getBytes();
        if (read == null) {
            return AtomTextUtils.createLegacy("(Cannot decode SVG: " + text + ")", fc);
        }
        return new AtomImgSvg(new TileImageSvg(new String(read, StandardCharsets.UTF_8)));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble((double)this.image.getWidth() * this.scale, (double)this.image.getHeight() * this.scale);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug.draw(new UImage(new PixelImage(this.image, AffineTransformType.TYPE_BILINEAR)).withRawFileName(this.rawFileName).scale(this.scale));
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

