/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.activitydiagram3.gtile.GtileHexagonInside;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithMargin;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileHexagonInsideLabelled
extends GtileWithMargin {
    private final TextBlock southLabel;
    private final TextBlock eastLabel;
    private final TextBlock westLabel;

    public GtileHexagonInsideLabelled(GtileHexagonInside diamond, TextBlock southLabel, TextBlock eastLabel, TextBlock westLabel) {
        super(diamond, GtileHexagonInsideLabelled.getNorthMargin(diamond, eastLabel, westLabel), GtileHexagonInsideLabelled.getSouthMargin(diamond, southLabel), 0.0);
        this.eastLabel = eastLabel;
        this.westLabel = westLabel;
        this.southLabel = southLabel;
    }

    public GtileHexagonInsideLabelled withSouthLabel(TextBlock eastLabel) {
        return new GtileHexagonInsideLabelled((GtileHexagonInside)this.orig, this.southLabel, eastLabel, this.westLabel);
    }

    public GtileHexagonInsideLabelled withEastLabel(TextBlock eastLabel) {
        return new GtileHexagonInsideLabelled((GtileHexagonInside)this.orig, this.southLabel, eastLabel, this.westLabel);
    }

    public GtileHexagonInsideLabelled withWestLabel(TextBlock westLabel) {
        return new GtileHexagonInsideLabelled((GtileHexagonInside)this.orig, this.southLabel, this.eastLabel, westLabel);
    }

    private static double getNorthMargin(GtileHexagonInside diamond, TextBlock eastLabel, TextBlock westLabel) {
        Dimension2D dimWest = westLabel.calculateDimension(diamond.getStringBounder());
        Dimension2D dimEast = eastLabel.calculateDimension(diamond.getStringBounder());
        UTranslate east = diamond.getCoord("EAST_HOOK");
        UTranslate west = diamond.getCoord("WEST_HOOK");
        return MathUtils.max(0.0, dimWest.getHeight() - west.getDy(), dimEast.getHeight() - east.getDy());
    }

    private static double getSouthMargin(GtileHexagonInside diamond, TextBlock southLabel) {
        Dimension2D dimSouth = southLabel.calculateDimension(diamond.getStringBounder());
        return dimSouth.getHeight();
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        super.drawUInternal(ug);
        UTranslate south = this.getCoord("SOUTH_HOOK");
        this.southLabel.drawU(ug.apply(south));
        UTranslate east = this.getCoord("EAST_HOOK");
        this.eastLabel.drawU(ug.apply(east.compose(UTranslate.dy(-this.eastLabel.calculateDimension(this.getStringBounder()).getHeight()))));
        Dimension2D tmp = this.westLabel.calculateDimension(this.getStringBounder());
        UTranslate west = this.getCoord("WEST_HOOK");
        this.westLabel.drawU(ug.apply(west.compose(new UTranslate(-tmp.getWidth(), -tmp.getHeight()))));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D tmp = super.calculateDimension(stringBounder);
        UTranslate south = this.getCoord("SOUTH_HOOK");
        Dimension2D southCorner = south.getTranslated(this.southLabel.calculateDimension(stringBounder));
        UTranslate east = this.getCoord("EAST_HOOK");
        Dimension2D eastCorner = east.getTranslated(this.eastLabel.calculateDimension(stringBounder));
        return MathUtils.max(tmp, southCorner, eastCorner);
    }
}

