/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import javax.swing.JDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Konstanten;
import mediathek.gui.actions.DisposeDialogAction;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.ButtonFlowPanel;
import mediathek.gui.dialog.ButtonPanel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Version;
import mediathek.update.UpdateNotificationPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmediathek/update/UpdateNotificationDialog;", "Ljavax/swing/JDialog;", "owner", "Ljava/awt/Frame;", "title", "", "version", "Lmediathek/tool/Version;", "(Ljava/awt/Frame;Ljava/lang/String;Lmediathek/tool/Version;)V", "browser", "Ljavafx/scene/web/WebView;", "panel", "Lmediathek/update/UpdateNotificationPanel;", "webEngine", "Ljavafx/scene/web/WebEngine;", "createButtonPanel", "Lmediathek/gui/dialog/ButtonFlowPanel;", "setupDialogInformation", "", "setupFxWebView", "Companion", "MediathekView"})
public final class UpdateNotificationDialog
extends JDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version version;
    @NotNull
    private final UpdateNotificationPanel panel;
    @Nullable
    private WebView browser;
    private WebEngine webEngine;
    private static final Logger logger = LogManager.getLogger();

    public UpdateNotificationDialog(@Nullable Frame owner, @Nullable String title, @NotNull Version version) {
        Intrinsics.checkNotNullParameter(version, "version");
        super(owner, title, true);
        this.version = version;
        this.panel = new UpdateNotificationPanel();
        this.setDefaultCloseOperation(2);
        EscapeKeyHandler.installHandler(this, () -> UpdateNotificationDialog._init_$lambda-2(this));
        this.setupDialogInformation();
        this.setupFxWebView();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.panel, "Center");
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.add((Component)this.createButtonPanel(), "East");
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        GuiFunktionen.centerOnScreen(this, false);
    }

    private final ButtonFlowPanel createButtonPanel() {
        ButtonFlowPanel pnl = new ButtonFlowPanel();
        JButton dlBtn = new JButton("Download");
        dlBtn.addActionListener(arg_0 -> UpdateNotificationDialog.createButtonPanel$lambda-0(this, arg_0));
        JButton btn = new JButton(new DisposeDialogAction(this, "Schlie\u00dfen", "Dialog schlie\u00dfen"));
        this.getRootPane().setDefaultButton(btn);
        pnl.add(dlBtn);
        pnl.add(btn);
        return pnl;
    }

    private final void setupFxWebView() {
        Platform.runLater(() -> UpdateNotificationDialog.setupFxWebView$lambda-1(this));
    }

    private final void setupDialogInformation() {
        String label = "MediathekView " + this.version + " ist verf\u00fcgbar - Sie haben Version " + Konstanten.MVVERSION;
        this.panel.getReleaseInfoLabel().setText(label);
    }

    private static final void createButtonPanel$lambda-0(UpdateNotificationDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            URI uri = new URI("https://mediathekview.de/download/");
            UrlHyperlinkAction.openURL(MediathekGui.ui(), uri.toString());
            this$0.dispose();
        }
        catch (URISyntaxException e) {
            logger.error(e);
        }
    }

    private static final void setupFxWebView$lambda-1(UpdateNotificationDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.browser = new WebView();
        Scene scene = new Scene(this$0.browser);
        WebView webView = this$0.browser;
        Intrinsics.checkNotNull(webView);
        WebEngine webEngine = webView.getEngine();
        Intrinsics.checkNotNullExpressionValue(webEngine, "browser!!.engine");
        webEngine = this$0.webEngine = webEngine;
        if (webEngine == null) {
            Intrinsics.throwUninitializedPropertyAccessException("webEngine");
            throw null;
        }
        webEngine.load(String.valueOf(Objects.requireNonNull(Konstanten.WEBSITE_BASE_URL.resolve("changelogs"))));
        this$0.panel.getFxPanel().setScene(scene);
    }

    private static final void _init_$lambda-2(UpdateNotificationDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.dispose();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/update/UpdateNotificationDialog$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

