/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.tools.ImageParticle;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.animation.AnimationTimer;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;

public class Smoke
extends Canvas {
    private static final Random RND = new Random();
    private static final Image IMAGE = new Image(Tile.class.getResourceAsStream("smoke.png"));
    private static final double HALF_WIDTH = IMAGE.getWidth() * 0.5;
    private static final double HALF_HEIGHT = IMAGE.getHeight() * 0.5;
    private static final long GENERATION_RATE = 20000000L;
    private static final int NO_OF_PARTICLES = 150;
    private double width;
    private double height;
    private boolean running = false;
    private GraphicsContext ctx = this.getGraphicsContext2D();
    private List<ImageParticle> particles;
    private long lastTimerCall;
    private AnimationTimer timer;

    public Smoke() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.particles = new CopyOnWriteArrayList<ImageParticle>();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            @Override
            public void handle(long NOW) {
                if (NOW > Smoke.this.lastTimerCall + 20000000L) {
                    if (Smoke.this.running && Smoke.this.particles.size() < 150) {
                        Smoke.this.particles.add(new ImageParticle(IMAGE, Smoke.this.width, Smoke.this.height));
                    }
                    if (Smoke.this.particles.isEmpty()) {
                        Smoke.this.timer.stop();
                    }
                    Smoke.this.lastTimerCall = NOW;
                }
                Smoke.this.draw();
            }
        };
        this.setMouseTransparent(true);
        this.registerListeners();
    }

    private void registerListeners() {
        this.widthProperty().addListener((o, ov, nv) -> {
            this.width = nv.doubleValue();
        });
        this.heightProperty().addListener((o, ov, nv) -> {
            this.height = nv.doubleValue();
        });
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.timer.start();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void draw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        for (ImageParticle p : this.particles) {
            p.opacity = p.remainingLife / p.life * 0.5;
            this.ctx.save();
            this.ctx.translate(p.x, p.y);
            this.ctx.scale(p.size, p.size);
            this.ctx.translate(-HALF_WIDTH, -HALF_HEIGHT);
            this.ctx.setGlobalAlpha(p.opacity);
            this.ctx.drawImage(p.image, 0.0, 0.0);
            this.ctx.restore();
            p.remainingLife *= 0.98;
            p.x += p.vX;
            p.y += p.vY;
            if (!(p.remainingLife < 0.0) && !(p.size < 0.0) && !(p.opacity < 0.01)) continue;
            if (this.running) {
                p.reInit(this.width, this.height);
                continue;
            }
            this.particles.remove(p);
        }
    }
}

